/*
 * Decompiled with CFR 0.152.
 */
package mathematics.fitting;

import org.apache.commons.math3.fitting.GaussianFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoint;
import org.apache.commons.math3.optim.nonlinear.vector.MultivariateVectorOptimizer;
import org.apache.commons.math3.optim.nonlinear.vector.jacobian.LevenbergMarquardtOptimizer;

public class Gaussian1DFitter {
    private double Normalization;
    private double Sigma;
    private double Mean;
    private double Error;
    private GaussianFitter fitter = new GaussianFitter((MultivariateVectorOptimizer)new LevenbergMarquardtOptimizer());

    public void Compute(int[] data) {
        for (int x = 0; x < data.length; ++x) {
            this.fitter.addObservedPoint((double)x, (double)data[x]);
        }
        this.ComputeAndSave();
    }

    public void Compute(int[] data, int ForbiddenValue) {
        for (int x = 0; x < data.length; ++x) {
            if (data[x] == ForbiddenValue) continue;
            this.fitter.addObservedPoint((double)x, (double)data[x]);
        }
        this.ComputeAndSave();
    }

    public void Compute(double[] data) {
        for (int x = 0; x < data.length; ++x) {
            this.fitter.addObservedPoint((double)x, data[x]);
        }
        this.ComputeAndSave();
    }

    public void Compute(double[][] data) {
        for (int x = 0; x < data.length; ++x) {
            this.fitter.addObservedPoint(data[x][0], data[x][1]);
        }
        this.ComputeAndSave();
    }

    public void Compute(double[] abscissas, double[] ordinates) {
        for (int x = 0; x < abscissas.length; ++x) {
            this.fitter.addObservedPoint(abscissas[x], ordinates[x]);
        }
        this.ComputeAndSave();
    }

    private void ComputeAndSave() {
        double[] result = this.fitter.fit();
        this.Normalization = result[0];
        this.Mean = result[1];
        this.Sigma = result[2];
        result = null;
        this.Error = 0.0;
        double sigma2 = this.Sigma * this.Sigma;
        WeightedObservedPoint[] wops = this.fitter.getObservations();
        for (int i2 = 0; i2 < wops.length; ++i2) {
            WeightedObservedPoint wop = wops[i2];
            double r = Math.abs(wops[i2].getX() - this.Mean);
            double arg = 0.5 * r * r / sigma2;
            double gauss = this.Normalization * Math.exp(-arg) / (Math.PI * 2 * sigma2);
            r = wop.getY() - gauss;
            this.Error += r * r;
        }
        this.Error /= (double)wops.length;
        this.fitter.clearObservations();
    }

    public double Normalization() {
        return this.Normalization;
    }

    public double Mean() {
        return this.Mean;
    }

    public double Sigma() {
        return this.Sigma;
    }

    public double Error() {
        return this.Error;
    }
}

