/*
 * Decompiled with CFR 0.152.
 */
package mathematics.complex;

import mathematics.complex.Complex;

public class ComplexTools {
    public static double Epsilon = 1.0E-5;

    public static void Fill(Complex[] tab, double re) {
        ComplexTools.Fill(tab, re, 0.0);
    }

    public static void Fill(Complex[] tab, double re, double im) {
        for (int i2 = 0; i2 < tab.length; ++i2) {
            tab[i2].Init(re, im);
        }
    }

    public static void Fill(Complex[][] tab, double re) {
        ComplexTools.Fill(tab, re, 0.0);
    }

    public static void Fill(Complex[][] tab, double re, double im) {
        int width = tab[0].length;
        for (int y = 0; y < tab.length; ++y) {
            for (int x = 0; x < width; ++x) {
                tab[y][x].Init(re, im);
            }
        }
    }

    public static void Fill(Complex[][][] tab, double re, double im) {
        int width = tab[0][0].length;
        int height = tab[0].length;
        int depth = tab.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    tab[z][y][x].Init(re, im);
                }
            }
        }
    }

    public static Complex[] Clone(Complex[] tab) {
        Complex[] clone = new Complex[tab.length];
        for (int x = 0; x < tab.length; ++x) {
            clone[x] = new Complex(tab[x]);
        }
        return clone;
    }

    public static Complex[][] Clone(Complex[][] tab) {
        Complex[][] clone = new Complex[tab.length][tab[0].length];
        int width = tab[0].length;
        for (int y = 0; y < tab.length; ++y) {
            for (int x = 0; x < width; ++x) {
                clone[y][x] = new Complex(tab[y][x]);
            }
        }
        return clone;
    }

    public static boolean areEqual(Complex[] array1, Complex[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i2 = 0; i2 < array1.length; ++i2) {
            if (Double.compare(array1[i2].re, array2[i2].re) != 0) {
                return false;
            }
            if (Double.compare(array1[i2].im, array2[i2].im) == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(Complex[][] array1, Complex[][] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        if (array1[0].length != array2[0].length) {
            return false;
        }
        int width = array1[0].length;
        for (int y = 0; y < array1.length; ++y) {
            for (int x = 0; x < width; ++x) {
                if (Double.compare(array1[y][x].re, array2[y][x].re) != 0) {
                    return false;
                }
                if (Double.compare(array1[y][x].im, array2[y][x].im) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean areEqual(Complex[][][] array1, Complex[][][] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        if (array1[0].length != array2[0].length) {
            return false;
        }
        if (array1[0][0].length != array2[0][0].length) {
            return false;
        }
        int width = array1[0][0].length;
        int height = array1[0].length;
        int depth = array1.length;
        for (int z = 0; z < depth; ++z) {
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (Double.compare(array1[z][y][x].re, array2[z][y][x].re) != 0) {
                        return false;
                    }
                    if (Double.compare(array1[z][y][x].im, array2[z][y][x].im) == 0) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

