/*
 * Decompiled with CFR 0.152.
 */
package mathematics.complex;

import mathematics.complex.Complex;

public class ComplexConverter {
    public static double[] ComplexReToDouble(Complex[] data) {
        int size = data.length;
        double[] result = new double[size];
        for (int y = 0; y < size; ++y) {
            result[y] = data[y].re;
        }
        return result;
    }

    public static double[][] ComplexReToDouble(Complex[][] data) {
        int width = data[0].length;
        int height = data.length;
        double[][] result = new double[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = data[y][x].re;
            }
        }
        return result;
    }

    public static double[] ComplexReToDouble1D(Complex[][] data) {
        int width = data[0].length;
        int height = data.length;
        double[] result = new double[height * width];
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                result[pos] = data[y][x].re;
                ++x;
                ++pos;
            }
        }
        return result;
    }

    public static void DoubleToComplex2D(double[] tab, Complex[][] c) {
        int width = c[0].length;
        int height = c.length;
        if (tab.length != width * height) {
            throw new IllegalArgumentException("Double array and complex array have different dimensions.");
        }
        int pos = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                c[y][x].re = tab[pos];
                ++x;
                ++pos;
            }
        }
    }

    public static double[] ComplexImToDouble(Complex[] data) {
        int size = data.length;
        double[] result = new double[size];
        for (int y = 0; y < size; ++y) {
            result[y] = data[y].im;
        }
        return result;
    }

    public static double[][] ComplexImToDouble(Complex[][] data) {
        int width = data[0].length;
        int height = data.length;
        double[][] result = new double[height][width];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                result[y][x] = data[y][x].im;
            }
        }
        return result;
    }
}

