/*
 * Decompiled with CFR 0.152.
 */
package mathematics.complex;

import mathematics.complex.Complex;

public class ComplexArithmetic {
    public static Complex Add(Complex z1, Complex z2) {
        Complex z = new Complex();
        ComplexArithmetic.Add(z1, z2, z);
        return z;
    }

    public static void Add(Complex z1, Complex z2, Complex z) {
        z.Init(z1.re + z2.re, z1.im + z2.im);
    }

    public static Complex Add(Complex z, double a) {
        Complex res = new Complex();
        ComplexArithmetic.Add(z, a, res);
        return res;
    }

    public static void Add(Complex z, double a, Complex res) {
        res.Init(z.re + a, z.im);
    }

    public static Complex Sub(Complex z1, Complex z2) {
        Complex z = new Complex();
        ComplexArithmetic.Sub(z1, z2, z);
        return z;
    }

    public static void Sub(Complex z1, Complex z2, Complex z) {
        z.Init(z1.re - z2.re, z1.im - z2.im);
    }

    public static Complex Sub(Complex z, double a) {
        Complex res = new Complex();
        ComplexArithmetic.Sub(z, a, res);
        return res;
    }

    public static void Sub(Complex z, double a, Complex res) {
        res.Init(z.re - a, z.im);
    }

    public static Complex Mult(Complex z1, Complex z2) {
        Complex z = new Complex();
        ComplexArithmetic.Mult(z1, z2, z);
        return z;
    }

    public static void Mult(Complex z1, Complex z2, Complex z) {
        z.Init(z1.re * z2.re - z1.im * z2.im, z1.re * z2.im + z1.im * z2.re);
    }

    public static Complex Mult(Complex z, double a) {
        Complex res = new Complex();
        ComplexArithmetic.Mult(z, a, res);
        return res;
    }

    public static void Mult(Complex z, double a, Complex res) {
        res.Init(z.re * a, z.im * a);
    }

    public static Complex Div(Complex z1, Complex z2) {
        Complex z = new Complex();
        ComplexArithmetic.Div(z1, z2, z);
        return z;
    }

    public static void Div(Complex z1, Complex z2, Complex z) {
        double D = z2.re * z2.re + z2.im * z2.im;
        z.Init((z1.re * z2.re + z1.im * z2.im) / D, (z1.im * z2.re - z1.re * z2.im) / D);
    }

    public static Complex Div(Complex z, double a) {
        Complex res = new Complex();
        ComplexArithmetic.Div(z, a, res);
        return res;
    }

    public static void Div(Complex z, double a, Complex res) {
        res.Init(z.re / a, z.im / a);
    }

    public static double Mod(Complex z) {
        return Math.sqrt(z.re * z.re + z.im * z.im);
    }

    public static double Modulo(Complex z) {
        return Math.sqrt(z.re * z.re + z.im * z.im);
    }

    public static double Arg(Complex z) {
        if (z.re != 0.0) {
            return Math.atan(z.im / z.re);
        }
        return 1.5707963267948966;
    }

    public static double Argument(Complex z) {
        if (z.re != 0.0) {
            return Math.atan(z.im / z.re);
        }
        return 1.5707963267948966;
    }

    public static Complex Cong(Complex z) {
        Complex res = new Complex();
        ComplexArithmetic.Cong(z, res);
        return res;
    }

    public static void Cong(Complex z, Complex res) {
        res.Init(z.re, -z.im);
    }

    public static Complex Congruence(Complex z) {
        Complex res = new Complex();
        ComplexArithmetic.Congruence(z, res);
        return res;
    }

    public static void Congruence(Complex z, Complex res) {
        res.Init(z.re, -z.im);
    }

    public static Complex Rac3(Complex z) {
        Complex res = new Complex();
        ComplexArithmetic.Rac3(z, res);
        return res;
    }

    public static void Rac3(Complex z, Complex res) {
        double Mod = ComplexArithmetic.Mod(z);
        double Arg = ComplexArithmetic.Arg(z);
        Mod = Math.exp(Math.log(Mod) / 3.0);
        res.Init(Mod * Math.cos(Arg /= 3.0), Mod * Math.sin(Arg));
    }

    public static Complex Power(Complex z, double n) {
        Complex res = new Complex();
        ComplexArithmetic.Power(z, n, res);
        return res;
    }

    public static void Power(Complex z, double n, Complex res) {
        double M = ComplexArithmetic.Mod(z);
        double argu = ComplexArithmetic.Arg(z);
        M = Math.pow(M, n);
        res.Init(M * Math.cos(argu *= n), M * Math.sin(argu));
    }
}

