/*
 * Decompiled with CFR 0.152.
 */
package mathematics;

public class Interpolations {
    public static double CubicCoeff = 0.5;
    public static int LanczosOrder = 2;
    private static int LanczosOrder2m1 = 3;
    private static final double PI2 = Math.PI * Math.PI;
    public static double SplineA = 0.5;
    public static double SplineB = 0.0;

    public static byte Dispatch(double x, double y, Methods2D method, byte[] pixels, int width, int height) {
        switch (method) {
            case Bicubic: {
                return Interpolations.Bicubic(x, y, pixels, width, height);
            }
            case Bilinear: {
                return Interpolations.Bilinear(x, y, pixels, width, height);
            }
            case BilinearPlus: {
                return Interpolations.BilinearPlus(x, y, pixels, width, height);
            }
            case Lanczos: {
                return Interpolations.Lanczos(x, y, pixels, width, height);
            }
            case Spline: {
                return Interpolations.Spline(x, y, pixels, width, height);
            }
        }
        throw new IllegalArgumentException("Interpolation method unknown.");
    }

    public static short Dispatch(double x, double y, Methods2D method, short[] pixels, int width, int height) {
        switch (method) {
            case Bicubic: {
                return Interpolations.Bicubic(x, y, pixels, width, height);
            }
            case Bilinear: {
                return Interpolations.Bilinear(x, y, pixels, width, height);
            }
            case BilinearPlus: {
                return Interpolations.BilinearPlus(x, y, pixels, width, height);
            }
            case Lanczos: {
                return Interpolations.Lanczos(x, y, pixels, width, height);
            }
            case Spline: {
                return Interpolations.Spline(x, y, pixels, width, height);
            }
        }
        throw new IllegalArgumentException("Interpolation method unknown.");
    }

    public static int Dispatch(double x, double y, Methods2D method, int[] pixels, int width, int height) {
        switch (method) {
            case Bicubic: {
                return Interpolations.Bicubic(x, y, pixels, width, height);
            }
            case Bilinear: {
                return Interpolations.Bilinear(x, y, pixels, width, height);
            }
            case BilinearPlus: {
                return Interpolations.BilinearPlus(x, y, pixels, width, height);
            }
            case Lanczos: {
                return Interpolations.Lanczos(x, y, pixels, width, height);
            }
            case Spline: {
                return Interpolations.Spline(x, y, pixels, width, height);
            }
        }
        throw new IllegalArgumentException("Interpolation method unknown.");
    }

    public static float Dispatch(double x, double y, Methods2D method, float[] pixels, int width, int height) {
        switch (method) {
            case Bicubic: {
                return Interpolations.Bicubic(x, y, pixels, width, height);
            }
            case Bilinear: {
                return Interpolations.Bilinear(x, y, pixels, width, height);
            }
            case BilinearPlus: {
                return Interpolations.BilinearPlus(x, y, pixels, width, height);
            }
            case Lanczos: {
                return Interpolations.Lanczos(x, y, pixels, width, height);
            }
            case Spline: {
                return Interpolations.Spline(x, y, pixels, width, height);
            }
        }
        throw new IllegalArgumentException("Interpolation method unknown.");
    }

    public static double Dispatch(double x, double y, Methods2D method, double[] pixels, int width, int height) {
        switch (method) {
            case Bicubic: {
                return Interpolations.Bicubic(x, y, pixels, width, height);
            }
            case Bilinear: {
                return Interpolations.Bilinear(x, y, pixels, width, height);
            }
            case BilinearPlus: {
                return Interpolations.BilinearPlus(x, y, pixels, width, height);
            }
            case Lanczos: {
                return Interpolations.Lanczos(x, y, pixels, width, height);
            }
            case Spline: {
                return Interpolations.Spline(x, y, pixels, width, height);
            }
        }
        throw new IllegalArgumentException("Interpolation method unknown.");
    }

    public static byte Dispatch(double x, double y, double z, Methods3D method, byte[] voxels, int width, int height, int depth, int layer) {
        switch (method) {
            case Tricubic: {
                return Interpolations.Tricubic(x, y, z, voxels, width, height, depth, layer);
            }
            case Trilinear: {
                return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
            }
            case Lanczos: {
                return Interpolations.Lanczos3D(x, y, z, voxels, width, height, depth, layer);
            }
            case Spline: {
                return Interpolations.Spline3D(x, y, z, voxels, width, height, depth, layer);
            }
        }
        throw new IllegalArgumentException("Interpolation method unknown.");
    }

    public static short Dispatch(double x, double y, double z, Methods3D method, short[] voxels, int width, int height, int depth, int layer) {
        switch (method) {
            case Tricubic: {
                return Interpolations.Tricubic(x, y, z, voxels, width, height, depth, layer);
            }
            case Trilinear: {
                return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
            }
            case Lanczos: {
                return Interpolations.Lanczos3D(x, y, z, voxels, width, height, depth, layer);
            }
            case Spline: {
                return Interpolations.Spline3D(x, y, z, voxels, width, height, depth, layer);
            }
        }
        throw new IllegalArgumentException("Interpolation method unknown.");
    }

    public static int Dispatch(double x, double y, double z, Methods3D method, int[] voxels, int width, int height, int depth, int layer) {
        switch (method) {
            case Tricubic: {
                return Interpolations.Tricubic(x, y, z, voxels, width, height, depth, layer);
            }
            case Trilinear: {
                return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
            }
            case Lanczos: {
                return Interpolations.Lanczos3D(x, y, z, voxels, width, height, depth, layer);
            }
            case Spline: {
                return Interpolations.Spline3D(x, y, z, voxels, width, height, depth, layer);
            }
        }
        throw new IllegalArgumentException("Interpolation method unknown.");
    }

    public static float Dispatch(double x, double y, double z, Methods3D method, float[] voxels, int width, int height, int depth, int layer) {
        switch (method) {
            case Tricubic: {
                return Interpolations.Tricubic(x, y, z, voxels, width, height, depth, layer);
            }
            case Trilinear: {
                return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
            }
            case Lanczos: {
                return Interpolations.Lanczos3D(x, y, z, voxels, width, height, depth, layer);
            }
            case Spline: {
                return Interpolations.Spline3D(x, y, z, voxels, width, height, depth, layer);
            }
        }
        throw new IllegalArgumentException("Interpolation method unknown.");
    }

    public static double Dispatch(double x, double y, double z, Methods3D method, double[] voxels, int width, int height, int depth, int layer) {
        switch (method) {
            case Tricubic: {
                return Interpolations.Tricubic(x, y, z, voxels, width, height, depth, layer);
            }
            case Trilinear: {
                return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
            }
            case Lanczos: {
                return Interpolations.Lanczos3D(x, y, z, voxels, width, height, depth, layer);
            }
            case Spline: {
                return Interpolations.Spline3D(x, y, z, voxels, width, height, depth, layer);
            }
        }
        throw new IllegalArgumentException("Interpolation method unknown.");
    }

    public static byte Bilinear(double x, double y, byte[] pixels, int width, int height) {
        int xbase;
        int ybase;
        int offset;
        double v;
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        if ((v = Interpolations.Bilinear(x, y, pixels[offset = (ybase = (int)y) * width + (xbase = (int)x)] & 0xFF, pixels[offset + 1] & 0xFF, pixels[offset + width + 1] & 0xFF, pixels[offset + width] & 0xFF)) < 0.0) {
            return 0;
        }
        if (255.0 <= v) {
            return -1;
        }
        return (byte)Math.floor(v);
    }

    public static short Bilinear(double x, double y, short[] pixels, int width, int height) {
        int xbase;
        int ybase;
        int offset;
        double v;
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        if ((v = Interpolations.Bilinear(x, y, pixels[offset = (ybase = (int)y) * width + (xbase = (int)x)] & 0xFFFF, pixels[offset + 1] & 0xFFFF, pixels[offset + width + 1] & 0xFFFF, pixels[offset + width] & 0xFFFF)) < 0.0) {
            return 0;
        }
        if (65535.0 <= v) {
            return -1;
        }
        return (short)Math.floor(v);
    }

    public static int Bilinear(double x, double y, int[] pixels, int width, int height) {
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        int offset = ybase * width + xbase;
        return (int)Math.floor(Interpolations.Bilinear(x, y, pixels[offset], pixels[offset + 1], pixels[offset + width + 1], pixels[offset + width]));
    }

    public static float Bilinear(double x, double y, float[] pixels, int width, int height) {
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        int offset = ybase * width + xbase;
        return (float)Interpolations.Bilinear(x, y, pixels[offset], pixels[offset + 1], pixels[offset + width + 1], pixels[offset + width]);
    }

    public static double Bilinear(double x, double y, double[] pixels, int width, int height) {
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        int offset = ybase * width + xbase;
        return Interpolations.Bilinear(x, y, pixels[offset], pixels[offset + 1], pixels[offset + width + 1], pixels[offset + width]);
    }

    public static byte BilinearPlus(double x, double y, byte[] pixels, int width, int height) {
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        int offset = ybase * width + xbase;
        double xfrac = x - (double)xbase;
        double yfrac = y - (double)ybase;
        double v = xbase != 0 && (xfrac < 0.5 || xbase == width - 1) ? (ybase != 0 && (yfrac < 0.5 || ybase == height - 1) ? Interpolations.Bilinear(x, y, pixels[offset - width - 1] & 0xFF, pixels[offset - width] & 0xFF, pixels[offset] & 0xFF, pixels[offset - 1] & 0xFF) : Interpolations.Bilinear(x, y, pixels[offset - 1] & 0xFF, pixels[offset] & 0xFF, pixels[offset + width] & 0xFF, pixels[offset + width - 1] & 0xFF)) : (ybase != 0 && (yfrac < 0.5 || ybase == height - 1) ? Interpolations.Bilinear(x, y, pixels[offset - width] & 0xFF, pixels[offset - width + 1] & 0xFF, pixels[offset + 1] & 0xFF, pixels[offset] & 0xFF) : Interpolations.Bilinear(x, y, pixels[offset] & 0xFF, pixels[offset + 1] & 0xFF, pixels[offset + width + 1] & 0xFF, pixels[offset + width] & 0xFF));
        if (v < 0.0) {
            return 0;
        }
        if (255.0 <= v) {
            return -1;
        }
        return (byte)Math.floor(v);
    }

    public static short BilinearPlus(double x, double y, short[] pixels, int width, int height) {
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        int offset = ybase * width + xbase;
        double xfrac = x - (double)xbase;
        double yfrac = y - (double)ybase;
        double v = xbase != 0 && (xfrac < 0.5 || xbase == width - 1) ? (ybase != 0 && (yfrac < 0.5 || ybase == height - 1) ? Interpolations.Bilinear(x, y, pixels[offset - width - 1] & 0xFFFF, pixels[offset - width] & 0xFFFF, pixels[offset] & 0xFFFF, pixels[offset - 1] & 0xFFFF) : Interpolations.Bilinear(x, y, pixels[offset - 1] & 0xFFFF, pixels[offset] & 0xFFFF, pixels[offset + width] & 0xFFFF, pixels[offset + width - 1] & 0xFFFF)) : (ybase != 0 && (yfrac < 0.5 || ybase == height - 1) ? Interpolations.Bilinear(x, y, pixels[offset - width] & 0xFFFF, pixels[offset - width + 1] & 0xFFFF, pixels[offset + 1] & 0xFFFF, pixels[offset] & 0xFFFF) : Interpolations.Bilinear(x, y, pixels[offset] & 0xFFFF, pixels[offset + 1] & 0xFFFF, pixels[offset + width + 1] & 0xFFFF, pixels[offset + width] & 0xFFFF));
        if (v < 0.0) {
            return 0;
        }
        if (65535.0 <= v) {
            return -1;
        }
        return (short)Math.floor(v);
    }

    public static int BilinearPlus(double x, double y, int[] pixels, int width, int height) {
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        int offset = ybase * width + xbase;
        double xfrac = x - (double)xbase;
        double yfrac = y - (double)ybase;
        if (xbase != 0 && (xfrac < 0.5 || xbase == width - 1)) {
            if (ybase != 0 && (yfrac < 0.5 || ybase == height - 1)) {
                return (int)Math.floor(Interpolations.Bilinear(x, y, pixels[offset - width - 1], pixels[offset - width], pixels[offset], pixels[offset - 1]));
            }
            return (int)Math.floor(Interpolations.Bilinear(x, y, pixels[offset - 1], pixels[offset], pixels[offset + width], pixels[offset + width - 1]));
        }
        if (ybase != 0 && (yfrac < 0.5 || ybase == height - 1)) {
            return (int)Math.floor(Interpolations.Bilinear(x, y, pixels[offset - width], pixels[offset - width + 1], pixels[offset + 1], pixels[offset]));
        }
        return (int)Math.floor(Interpolations.Bilinear(x, y, pixels[offset], pixels[offset + 1], pixels[offset + width + 1], pixels[offset + width]));
    }

    public static float BilinearPlus(double x, double y, float[] pixels, int width, int height) {
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        int offset = ybase * width + xbase;
        double xfrac = x - (double)xbase;
        double yfrac = y - (double)ybase;
        if (xbase != 0 && (xfrac < 0.5 || xbase == width - 1)) {
            if (ybase != 0 && (yfrac < 0.5 || ybase == height - 1)) {
                return (float)Interpolations.Bilinear(x, y, pixels[offset - width - 1], pixels[offset - width], pixels[offset], pixels[offset - 1]);
            }
            return (float)Interpolations.Bilinear(x, y, pixels[offset - 1], pixels[offset], pixels[offset + width], pixels[offset + width - 1]);
        }
        if (ybase != 0 && (yfrac < 0.5 || ybase == height - 1)) {
            return (float)Interpolations.Bilinear(x, y, pixels[offset - width], pixels[offset - width + 1], pixels[offset + 1], pixels[offset]);
        }
        return (float)Interpolations.Bilinear(x, y, pixels[offset], pixels[offset + 1], pixels[offset + width + 1], pixels[offset + width]);
    }

    public static double BilinearPlus(double x, double y, double[] pixels, int width, int height) {
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        int offset = ybase * width + xbase;
        double xfrac = x - (double)xbase;
        double yfrac = y - (double)ybase;
        if (xbase != 0 && (xfrac < 0.5 || xbase == width - 1)) {
            if (ybase != 0 && (yfrac < 0.5 || ybase == height - 1)) {
                return Interpolations.Bilinear(x, y, pixels[offset - width - 1], pixels[offset - width], pixels[offset], pixels[offset - 1]);
            }
            return Interpolations.Bilinear(x, y, pixels[offset - 1], pixels[offset], pixels[offset + width], pixels[offset + width - 1]);
        }
        if (ybase != 0 && (yfrac < 0.5 || ybase == height - 1)) {
            return Interpolations.Bilinear(x, y, pixels[offset - width], pixels[offset - width + 1], pixels[offset + 1], pixels[offset]);
        }
        return Interpolations.Bilinear(x, y, pixels[offset], pixels[offset + 1], pixels[offset + width + 1], pixels[offset + width]);
    }

    public static double Bilinear(double x, double y, int lowerLeft, int lowerRight, int upperRight, int upperLeft) {
        double xFraction = x - (double)((int)x);
        double yFraction = y - (double)((int)y);
        if (xFraction < 0.0) {
            xFraction = 0.0;
        }
        if (yFraction < 0.0) {
            yFraction = 0.0;
        }
        double upperAverage = (double)upperLeft + xFraction * (double)(upperRight - upperLeft);
        double lowerAverage = (double)lowerLeft + xFraction * (double)(lowerRight - lowerLeft);
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    public static double Bilinear(double x, double y, double lowerLeft, double lowerRight, double upperRight, double upperLeft) {
        double xFraction = x - (double)((int)x);
        double yFraction = y - (double)((int)y);
        if (xFraction < 0.0) {
            xFraction = 0.0;
        }
        if (yFraction < 0.0) {
            yFraction = 0.0;
        }
        double upperAverage = upperLeft + xFraction * (upperRight - upperLeft);
        double lowerAverage = lowerLeft + xFraction * (lowerRight - lowerLeft);
        return lowerAverage + yFraction * (upperAverage - lowerAverage);
    }

    public static byte Trilinear(double x, double y, double z, byte[] voxels, int width, int height, int depth, int layer) {
        int xbase;
        int ybase;
        int zbase;
        int offset;
        double v;
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        if (z < 0.0) {
            z = 0.0;
        }
        if ((double)depth - 1.0 <= z) {
            z = (double)depth - 1.00001;
        }
        if ((v = Interpolations.Trilinear(x, y, z, voxels[offset = (zbase = (int)z) * layer + (ybase = (int)y) * width + (xbase = (int)x)] & 0xFF, voxels[offset + 1] & 0xFF, voxels[offset + width + 1] & 0xFF, voxels[offset + width] & 0xFF, voxels[offset + layer] & 0xFF, voxels[offset + layer + 1] & 0xFF, voxels[offset + layer + width + 1] & 0xFF, voxels[offset + layer + width] & 0xFF)) < 0.0) {
            return 0;
        }
        if (255.0 <= v) {
            return -1;
        }
        return (byte)Math.floor(v);
    }

    public static short Trilinear(double x, double y, double z, short[] voxels, int width, int height, int depth, int layer) {
        int xbase;
        int ybase;
        int zbase;
        int offset;
        double v;
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        if (z < 0.0) {
            z = 0.0;
        }
        if ((double)depth - 1.0 <= z) {
            z = (double)depth - 1.00001;
        }
        if ((v = Interpolations.Trilinear(x, y, z, voxels[offset = ((zbase = (int)z) * height + (ybase = (int)y)) * width + (xbase = (int)x)] & 0xFFFF, voxels[offset + 1] & 0xFFFF, voxels[offset + width + 1] & 0xFFFF, voxels[offset + width] & 0xFFFF, voxels[offset + layer] & 0xFFFF, voxels[offset + layer + 1] & 0xFFFF, voxels[offset + layer + width + 1] & 0xFFFF, voxels[offset + layer + width] & 0xFFFF)) < 0.0) {
            return 0;
        }
        if (65535.0 <= v) {
            return -1;
        }
        return (short)Math.floor(v);
    }

    public static int Trilinear(double x, double y, double z, int[] voxels, int width, int height, int depth, int layer) {
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        if (z < 0.0) {
            z = 0.0;
        }
        if ((double)depth - 1.0 <= z) {
            z = (double)depth - 1.00001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        int zbase = (int)z;
        int offset = (zbase * height + ybase) * width + xbase;
        return (int)Math.floor(Interpolations.Trilinear(x, y, z, voxels[offset], voxels[offset + 1], voxels[offset + width + 1], voxels[offset + width], voxels[offset + layer], voxels[offset + layer + 1], voxels[offset + layer + width + 1], voxels[offset + layer + width]));
    }

    public static float Trilinear(double x, double y, double z, float[] voxels, int width, int height, int depth, int layer) {
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        if (z < 0.0) {
            z = 0.0;
        }
        if ((double)depth - 1.0 <= z) {
            z = (double)depth - 1.00001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        int zbase = (int)z;
        int offset = (zbase * height + ybase) * width + xbase;
        return (float)Interpolations.Trilinear(x, y, z, voxels[offset], voxels[offset + 1], voxels[offset + width + 1], voxels[offset + width], voxels[offset + layer], voxels[offset + layer + 1], voxels[offset + layer + width + 1], voxels[offset + layer + width]);
    }

    public static double Trilinear(double x, double y, double z, double[] voxels, int width, int height, int depth, int layer) {
        if (x < 0.0) {
            x = 0.0;
        }
        if ((double)width - 1.0 <= x) {
            x = (double)width - 1.00001;
        }
        if (y < 0.0) {
            y = 0.0;
        }
        if ((double)height - 1.0 <= y) {
            y = (double)height - 1.00001;
        }
        if (z < 0.0) {
            z = 0.0;
        }
        if ((double)depth - 1.0 <= z) {
            z = (double)depth - 1.00001;
        }
        int xbase = (int)x;
        int ybase = (int)y;
        int zbase = (int)z;
        int offset = (zbase * height + ybase) * width + xbase;
        return Interpolations.Trilinear(x, y, z, voxels[offset], voxels[offset + 1], voxels[offset + width + 1], voxels[offset + width], voxels[offset + layer], voxels[offset + layer + 1], voxels[offset + layer + width + 1], voxels[offset + layer + width]);
    }

    public static double Trilinear(double x, double y, double z, int lowerLeft, int lowerRight, int upperRight, int upperLeft, int TopLowerLeft, int TopLowerRight, int TopUpperRight, int TopUpperLeft) {
        double xFraction = x - (double)((int)x);
        double yFraction = y - (double)((int)y);
        double zFraction = z - (double)((int)z);
        if (xFraction < 0.0) {
            xFraction = 0.0;
        }
        if (yFraction < 0.0) {
            yFraction = 0.0;
        }
        if (zFraction < 0.0) {
            zFraction = 0.0;
        }
        double upperAverage = (double)upperLeft + xFraction * (double)(upperRight - upperLeft);
        double lowerAverage = (double)lowerLeft + xFraction * (double)(lowerRight - lowerLeft);
        lowerAverage += yFraction * (upperAverage - lowerAverage);
        double TopUpperAverage = (double)TopUpperLeft + xFraction * (double)(TopUpperRight - TopUpperLeft);
        double TopLowerAverage = (double)TopLowerLeft + xFraction * (double)(TopLowerRight - TopLowerLeft);
        TopLowerAverage += yFraction * (TopUpperAverage - TopLowerAverage);
        return lowerAverage + zFraction * (TopLowerAverage - lowerAverage);
    }

    public static double Trilinear(double x, double y, double z, double lowerLeft, double lowerRight, double upperRight, double upperLeft, double TopLowerLeft, double TopLowerRight, double TopUpperRight, double TopUpperLeft) {
        double xFraction = x - (double)((int)x);
        double yFraction = y - (double)((int)y);
        double zFraction = z - (double)((int)z);
        if (xFraction < 0.0) {
            xFraction = 0.0;
        }
        if (yFraction < 0.0) {
            yFraction = 0.0;
        }
        if (zFraction < 0.0) {
            zFraction = 0.0;
        }
        double upperAverage = upperLeft + xFraction * (upperRight - upperLeft);
        double lowerAverage = lowerLeft + xFraction * (lowerRight - lowerLeft);
        lowerAverage += yFraction * (upperAverage - lowerAverage);
        double TopUpperAverage = TopUpperLeft + xFraction * (TopUpperRight - TopUpperLeft);
        double TopLowerAverage = TopLowerLeft + xFraction * (TopLowerRight - TopLowerLeft);
        TopLowerAverage += yFraction * (TopUpperAverage - TopLowerAverage);
        return lowerAverage + zFraction * (TopLowerAverage - lowerAverage);
    }

    public static int Bicubic(double x, double y, int[] pixels, int width, int height) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        if (x0 <= 0 || width - 2 <= x0 || y0 <= 0 || height - 2 <= y0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int yy = 0; yy <= 3; ++yy) {
            int Y = y0 - 1 + yy;
            double p = 0.0;
            for (int xx = 0; xx <= 3; ++xx) {
                int X = x0 - 1 + xx;
                p += Interpolations.Cubic(x - (double)X) * (double)pixels[X + Y * width];
            }
            q += Interpolations.Cubic(y - (double)Y) * p;
        }
        return (int)Math.round(q);
    }

    public static byte Bicubic(double x, double y, byte[] pixels, int width, int height) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        if (x0 <= 0 || width - 2 <= x0 || y0 <= 0 || height - 2 <= y0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int yy = 0; yy <= 3; ++yy) {
            int Y = y0 - 1 + yy;
            double p = 0.0;
            for (int xx = 0; xx <= 3; ++xx) {
                int X = x0 - 1 + xx;
                p += Interpolations.Cubic(x - (double)X) * (double)(pixels[X + Y * width] & 0xFF);
            }
            q += Interpolations.Cubic(y - (double)Y) * p;
        }
        if (q < 0.0) {
            return 0;
        }
        if (255.0 <= q) {
            return -1;
        }
        return (byte)Math.round(q);
    }

    public static short Bicubic(double x, double y, short[] pixels, int width, int height) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        if (x0 <= 0 || width - 2 <= x0 || y0 <= 0 || height - 2 <= y0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int yy = 0; yy <= 3; ++yy) {
            int Y = y0 - 1 + yy;
            double p = 0.0;
            for (int xx = 0; xx <= 3; ++xx) {
                int X = x0 - 1 + xx;
                p += Interpolations.Cubic(x - (double)X) * (double)(pixels[X + Y * width] & 0xFFFF);
            }
            q += Interpolations.Cubic(y - (double)Y) * p;
        }
        if (q < 0.0) {
            return 0;
        }
        if (65535.0 <= q) {
            return -1;
        }
        return (short)Math.round(q);
    }

    public static double Bicubic(double x, double y, double[] pixels, int width, int height) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        if (x0 <= 0 || width - 2 <= x0 || y0 <= 0 || height - 2 <= y0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int yy = 0; yy <= 3; ++yy) {
            int Y = y0 - 1 + yy;
            double p = 0.0;
            for (int xx = 0; xx <= 3; ++xx) {
                int X = x0 - 1 + xx;
                p += Interpolations.Cubic(x - (double)X) * pixels[X + Y * width];
            }
            q += Interpolations.Cubic(y - (double)Y) * p;
        }
        return q;
    }

    public static float Bicubic(double x, double y, float[] pixels, int width, int height) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        if (x0 <= 0 || width - 2 <= x0 || y0 <= 0 || height - 2 <= y0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int yy = 0; yy <= 3; ++yy) {
            int Y = y0 - 1 + yy;
            double p = 0.0;
            for (int xx = 0; xx <= 3; ++xx) {
                int X = x0 - 1 + xx;
                p += Interpolations.Cubic(x - (double)X) * (double)pixels[X + Y * width];
            }
            q += Interpolations.Cubic(y - (double)Y) * p;
        }
        return (float)q;
    }

    private static double Cubic(double x) {
        if (x < 0.0) {
            x = -x;
        }
        double z = 0.0;
        if (x < 1.0) {
            z = x * x * (x * (2.0 - CubicCoeff) + CubicCoeff - 3.0) + 1.0;
        } else if (x < 2.0) {
            z = CubicCoeff * (-x * x * x + 5.0 * x * x - 8.0 * x + 4.0);
        }
        return z;
    }

    public static void SetCubic() {
        CubicCoeff = 1.0;
    }

    public static void SetCubicSmooth() {
        CubicCoeff = 0.25;
    }

    public static void SetCubicCR() {
        CubicCoeff = 0.5;
    }

    public static int Tricubic(double x, double y, double z, int[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 <= 0 || width - 2 <= x0 || y0 <= 0 || height - 2 <= y0 || z0 <= 0 || depth - 2 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        for (int zz = 0; zz <= 3; ++zz) {
            int Z = z0 - 1 + zz;
            double q = 0.0;
            for (int yy = 0; yy <= 3; ++yy) {
                int Y = y0 - 1 + yy;
                double p = 0.0;
                for (int xx = 0; xx <= 3; ++xx) {
                    int X = x0 - 1 + xx;
                    p += Interpolations.Cubic(x - (double)X) * (double)voxels[X + Y * width + Z * layer];
                }
                q += Interpolations.Cubic(y - (double)Y) * p;
            }
            r += Interpolations.Cubic(z - (double)Z) * q;
        }
        return (int)Math.round(r);
    }

    public static byte Tricubic(double x, double y, double z, byte[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 <= 0 || width - 2 <= x0 || y0 <= 0 || height - 2 <= y0 || z0 <= 0 || depth - 2 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        for (int zz = 0; zz <= 3; ++zz) {
            int Z = z0 - 1 + zz;
            double q = 0.0;
            for (int yy = 0; yy <= 3; ++yy) {
                int Y = y0 - 1 + yy;
                double p = 0.0;
                for (int xx = 0; xx <= 3; ++xx) {
                    int X = x0 - 1 + xx;
                    p += Interpolations.Cubic(x - (double)X) * (double)(voxels[X + Y * width + Z * layer] & 0xFF);
                }
                q += Interpolations.Cubic(y - (double)Y) * p;
            }
            r += Interpolations.Cubic(z - (double)Z) * q;
        }
        if (r < 0.0) {
            return 0;
        }
        if (255.0 <= r) {
            return -1;
        }
        return (byte)Math.round(r);
    }

    public static short Tricubic(double x, double y, double z, short[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 <= 0 || width - 2 <= x0 || y0 <= 0 || height - 2 <= y0 || z0 <= 0 || depth - 2 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        for (int zz = 0; zz <= 3; ++zz) {
            int Z = z0 - 1 + zz;
            double q = 0.0;
            for (int yy = 0; yy <= 3; ++yy) {
                int Y = y0 - 1 + yy;
                double p = 0.0;
                for (int xx = 0; xx <= 3; ++xx) {
                    int X = x0 - 1 + xx;
                    p += Interpolations.Cubic(x - (double)X) * (double)(voxels[X + Y * width + Z * layer] & 0xFFFF);
                }
                q += Interpolations.Cubic(y - (double)Y) * p;
            }
            r += Interpolations.Cubic(z - (double)Z) * q;
        }
        if (r < 0.0) {
            return 0;
        }
        if (65535.0 <= r) {
            return -1;
        }
        return (short)Math.round(r);
    }

    public static double Tricubic(double x, double y, double z, double[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 <= 0 || width - 2 <= x0 || y0 <= 0 || height - 2 <= y0 || z0 <= 0 || depth - 2 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        for (int zz = 0; zz <= 3; ++zz) {
            int Z = z0 - 1 + zz;
            double q = 0.0;
            for (int yy = 0; yy <= 3; ++yy) {
                int Y = y0 - 1 + yy;
                double p = 0.0;
                for (int xx = 0; xx <= 3; ++xx) {
                    int X = x0 - 1 + xx;
                    p += Interpolations.Cubic(x - (double)X) * voxels[X + Y * width + Z * layer];
                }
                q += Interpolations.Cubic(y - (double)Y) * p;
            }
            r += Interpolations.Cubic(z - (double)Z) * q;
        }
        return r;
    }

    public static float Tricubic(double x, double y, double z, float[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 <= 0 || width - 2 <= x0 || y0 <= 0 || height - 2 <= y0 || z0 <= 0 || depth - 2 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        for (int zz = 0; zz <= 3; ++zz) {
            int Z = z0 - 1 + zz;
            double q = 0.0;
            for (int yy = 0; yy <= 3; ++yy) {
                int Y = y0 - 1 + yy;
                double p = 0.0;
                for (int xx = 0; xx <= 3; ++xx) {
                    int X = x0 - 1 + xx;
                    p += Interpolations.Cubic(x - (double)X) * (double)voxels[X + Y * width + Z * layer];
                }
                q += Interpolations.Cubic(y - (double)Y) * p;
            }
            r += Interpolations.Cubic(z - (double)Z) * q;
        }
        return (float)r;
    }

    public static byte Lanczos(double x, double y, byte[] pixels, int width, int height) {
        int u0 = (int)Math.floor(x);
        int v0 = (int)Math.floor(y);
        if (u0 < LanczosOrder - 1 || width - LanczosOrder - 1 <= u0 || v0 <= LanczosOrder - 1 || height - LanczosOrder - 1 <= v0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int j = 0; j <= LanczosOrder2m1; ++j) {
            int v = v0 + j - LanczosOrder + 1;
            double p = 0.0;
            for (int i2 = 0; i2 <= LanczosOrder2m1; ++i2) {
                int u = u0 + i2 - LanczosOrder + 1;
                p += (double)(pixels[u + v * width] & 0xFF) * Interpolations.LanczosCoefficient(x - (double)u);
            }
            q += p * Interpolations.LanczosCoefficient(y - (double)v);
        }
        if (q < 0.0) {
            return 0;
        }
        if (255.0 <= q) {
            return -1;
        }
        return (byte)Math.round(q);
    }

    public static short Lanczos(double x, double y, short[] pixels, int width, int height) {
        int u0 = (int)Math.floor(x);
        int v0 = (int)Math.floor(y);
        if (u0 < LanczosOrder - 1 || width - LanczosOrder - 1 <= u0 || v0 <= LanczosOrder - 1 || height - LanczosOrder - 1 <= v0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int j = 0; j <= LanczosOrder2m1; ++j) {
            int v = v0 + j - LanczosOrder + 1;
            double p = 0.0;
            for (int i2 = 0; i2 <= LanczosOrder2m1; ++i2) {
                int u = u0 + i2 - LanczosOrder + 1;
                p += (double)(pixels[u + v * width] & 0xFFFF) * Interpolations.LanczosCoefficient(x - (double)u);
            }
            q += p * Interpolations.LanczosCoefficient(y - (double)v);
        }
        if (q < 0.0) {
            return 0;
        }
        if (65535.0 <= q) {
            return -1;
        }
        return (short)Math.round(q);
    }

    public static int Lanczos(double x, double y, int[] pixels, int width, int height) {
        int u0 = (int)Math.floor(x);
        int v0 = (int)Math.floor(y);
        if (u0 < LanczosOrder - 1 || width - LanczosOrder - 1 <= u0 || v0 <= LanczosOrder - 1 || height - LanczosOrder - 1 <= v0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int j = 0; j <= LanczosOrder2m1; ++j) {
            int v = v0 + j - LanczosOrder + 1;
            double p = 0.0;
            for (int i2 = 0; i2 <= LanczosOrder2m1; ++i2) {
                int u = u0 + i2 - LanczosOrder + 1;
                p += (double)pixels[u + v * width] * Interpolations.LanczosCoefficient(x - (double)u);
            }
            q += p * Interpolations.LanczosCoefficient(y - (double)v);
        }
        return (int)Math.round(q);
    }

    public static float Lanczos(double x, double y, float[] pixels, int width, int height) {
        int u0 = (int)Math.floor(x);
        int v0 = (int)Math.floor(y);
        if (u0 < LanczosOrder - 1 || width - LanczosOrder - 1 <= u0 || v0 <= LanczosOrder - 1 || height - LanczosOrder - 1 <= v0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int j = 0; j <= LanczosOrder2m1; ++j) {
            int v = v0 + j - LanczosOrder + 1;
            double p = 0.0;
            for (int i2 = 0; i2 <= LanczosOrder2m1; ++i2) {
                int u = u0 + i2 - LanczosOrder + 1;
                p += (double)pixels[u + v * width] * Interpolations.LanczosCoefficient(x - (double)u);
            }
            q += p * Interpolations.LanczosCoefficient(y - (double)v);
        }
        return (float)q;
    }

    public static double Lanczos(double x, double y, double[] pixels, int width, int height) {
        int u0 = (int)Math.floor(x);
        int v0 = (int)Math.floor(y);
        if (u0 < LanczosOrder - 1 || width - LanczosOrder - 1 <= u0 || v0 <= LanczosOrder - 1 || height - LanczosOrder - 1 <= v0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int j = 0; j <= LanczosOrder2m1; ++j) {
            int v = v0 + j - LanczosOrder + 1;
            double p = 0.0;
            for (int i2 = 0; i2 <= LanczosOrder2m1; ++i2) {
                int u = u0 + i2 - LanczosOrder + 1;
                p += pixels[u + v * width] * Interpolations.LanczosCoefficient(x - (double)u);
            }
            q += p * Interpolations.LanczosCoefficient(y - (double)v);
        }
        return q;
    }

    private static double LanczosCoefficient(double x) {
        if ((x = Math.abs(x)) < 0.001) {
            return 1.0;
        }
        if (x < (double)LanczosOrder) {
            return (double)LanczosOrder * Math.sin(Math.PI * x / (double)LanczosOrder) * Math.sin(Math.PI * x) / (Math.PI * Math.PI * x * x);
        }
        return 0.0;
    }

    public static void SetLanczosOrder(int order) {
        if (order <= 1) {
            throw new IllegalArgumentException("order <= 1.");
        }
        LanczosOrder = order;
        LanczosOrder2m1 = (LanczosOrder << 1) - 1;
    }

    public static byte Lanczos3D(double x, double y, double z, byte[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 < LanczosOrder - 1 || width - LanczosOrder - 1 <= x0 || y0 <= LanczosOrder - 1 || height - LanczosOrder - 1 <= y0 || z0 <= LanczosOrder - 1 || depth - LanczosOrder - 1 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        int zz = 0;
        while (z <= (double)LanczosOrder2m1) {
            int Z = z0 + zz - LanczosOrder + 1;
            double q = 0.0;
            for (int yy = 0; yy <= LanczosOrder2m1; ++yy) {
                int Y = y0 + yy - LanczosOrder + 1;
                double p = 0.0;
                for (int xx = 0; xx <= LanczosOrder2m1; ++xx) {
                    int X = x0 + xx - LanczosOrder + 1;
                    p += (double)(voxels[X + Y * width + Z * layer] & 0xFF) * Interpolations.LanczosCoefficient(x - (double)X);
                }
                q += p * Interpolations.LanczosCoefficient(y - (double)Y);
            }
            r += q * Interpolations.LanczosCoefficient(z - (double)Z);
            ++zz;
        }
        if (r < 0.0) {
            return 0;
        }
        if (255.0 <= r) {
            return -1;
        }
        return (byte)Math.round(r);
    }

    public static short Lanczos3D(double x, double y, double z, short[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 < LanczosOrder - 1 || width - LanczosOrder - 1 <= x0 || y0 <= LanczosOrder - 1 || height - LanczosOrder - 1 <= y0 || z0 <= LanczosOrder - 1 || depth - LanczosOrder - 1 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        int zz = 0;
        while (z <= (double)LanczosOrder2m1) {
            int Z = z0 + zz - LanczosOrder + 1;
            double q = 0.0;
            for (int yy = 0; yy <= LanczosOrder2m1; ++yy) {
                int Y = y0 + yy - LanczosOrder + 1;
                double p = 0.0;
                for (int xx = 0; xx <= LanczosOrder2m1; ++xx) {
                    int X = x0 + xx - LanczosOrder + 1;
                    p += (double)(voxels[X + Y * width + Z * layer] & 0xFFFF) * Interpolations.LanczosCoefficient(x - (double)X);
                }
                q += p * Interpolations.LanczosCoefficient(y - (double)Y);
            }
            r += q * Interpolations.LanczosCoefficient(z - (double)Z);
            ++zz;
        }
        if (r < 0.0) {
            return 0;
        }
        if (65535.0 <= r) {
            return -1;
        }
        return (short)Math.round(r);
    }

    public static int Lanczos3D(double x, double y, double z, int[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 < LanczosOrder - 1 || width - LanczosOrder - 1 <= x0 || y0 <= LanczosOrder - 1 || height - LanczosOrder - 1 <= y0 || z0 <= LanczosOrder - 1 || depth - LanczosOrder - 1 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        int zz = 0;
        while (z <= (double)LanczosOrder2m1) {
            int Z = z0 + zz - LanczosOrder + 1;
            double q = 0.0;
            for (int yy = 0; yy <= LanczosOrder2m1; ++yy) {
                int Y = y0 + yy - LanczosOrder + 1;
                double p = 0.0;
                for (int xx = 0; xx <= LanczosOrder2m1; ++xx) {
                    int X = x0 + xx - LanczosOrder + 1;
                    p += (double)voxels[X + Y * width + Z * layer] * Interpolations.LanczosCoefficient(x - (double)X);
                }
                q += p * Interpolations.LanczosCoefficient(y - (double)Y);
            }
            r += q * Interpolations.LanczosCoefficient(z - (double)Z);
            ++zz;
        }
        return (int)Math.round(r);
    }

    public static float Lanczos3D(double x, double y, double z, float[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 < LanczosOrder - 1 || width - LanczosOrder - 1 <= x0 || y0 <= LanczosOrder - 1 || height - LanczosOrder - 1 <= y0 || z0 <= LanczosOrder - 1 || depth - LanczosOrder - 1 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        int zz = 0;
        while (z <= (double)LanczosOrder2m1) {
            int Z = z0 + zz - LanczosOrder + 1;
            double q = 0.0;
            for (int yy = 0; yy <= LanczosOrder2m1; ++yy) {
                int Y = y0 + yy - LanczosOrder + 1;
                double p = 0.0;
                for (int xx = 0; xx <= LanczosOrder2m1; ++xx) {
                    int X = x0 + xx - LanczosOrder + 1;
                    p += (double)voxels[X + Y * width + Z * layer] * Interpolations.LanczosCoefficient(x - (double)X);
                }
                q += p * Interpolations.LanczosCoefficient(y - (double)Y);
            }
            r += q * Interpolations.LanczosCoefficient(z - (double)Z);
            ++zz;
        }
        return (float)r;
    }

    public static double Lanczos3D(double x, double y, double z, double[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 < LanczosOrder - 1 || width - LanczosOrder - 1 <= x0 || y0 <= LanczosOrder - 1 || height - LanczosOrder - 1 <= y0 || z0 <= LanczosOrder - 1 || depth - LanczosOrder - 1 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        int zz = 0;
        while (z <= (double)LanczosOrder2m1) {
            int Z = z0 + zz - LanczosOrder + 1;
            double q = 0.0;
            for (int yy = 0; yy <= LanczosOrder2m1; ++yy) {
                int Y = y0 + yy - LanczosOrder + 1;
                double p = 0.0;
                for (int xx = 0; xx <= LanczosOrder2m1; ++xx) {
                    int X = x0 + xx - LanczosOrder + 1;
                    p += voxels[X + Y * width + Z * layer] * Interpolations.LanczosCoefficient(x - (double)X);
                }
                q += p * Interpolations.LanczosCoefficient(y - (double)Y);
            }
            r += q * Interpolations.LanczosCoefficient(z - (double)Z);
            ++zz;
        }
        return r;
    }

    public static byte Spline(double x, double y, byte[] pixels, int width, int height) {
        int u0 = (int)Math.floor(x);
        int v0 = (int)Math.floor(y);
        if (u0 < 1 || width - 2 <= u0 || v0 < 1 || height - 2 <= v0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int j = 0; j <= 3; ++j) {
            int v = v0 + j - 1;
            double p = 0.0;
            for (int i2 = 0; i2 <= 3; ++i2) {
                int u = u0 + i2 - 1;
                p += (double)(pixels[u + v * width] & 0xFF) * Interpolations.Spline(x - (double)u);
            }
            q += p * Interpolations.Spline(y - (double)v);
        }
        if (q < 0.0) {
            return 0;
        }
        if (255.0 <= q) {
            return -1;
        }
        return (byte)Math.round(q);
    }

    public static short Spline(double x, double y, short[] pixels, int width, int height) {
        int u0 = (int)Math.floor(x);
        int v0 = (int)Math.floor(y);
        if (u0 < 1 || width - 2 <= u0 || v0 < 1 || height - 2 <= v0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int j = 0; j <= 3; ++j) {
            int v = v0 + j - 1;
            double p = 0.0;
            for (int i2 = 0; i2 <= 3; ++i2) {
                int u = u0 + i2 - 1;
                p += (double)(pixels[u + v * width] & 0xFFFF) * Interpolations.Spline(x - (double)u);
            }
            q += p * Interpolations.Spline(y - (double)v);
        }
        if (q < 0.0) {
            return 0;
        }
        if (65535.0 <= q) {
            return -1;
        }
        return (short)Math.round(q);
    }

    public static int Spline(double x, double y, int[] pixels, int width, int height) {
        int u0 = (int)Math.floor(x);
        int v0 = (int)Math.floor(y);
        if (u0 < 1 || width - 2 <= u0 || v0 < 1 || height - 2 <= v0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int j = 0; j <= 3; ++j) {
            int v = v0 + j - 1;
            double p = 0.0;
            for (int i2 = 0; i2 <= 3; ++i2) {
                int u = u0 + i2 - 1;
                p += (double)pixels[u + v * width] * Interpolations.Spline(x - (double)u);
            }
            q += p * Interpolations.Spline(y - (double)v);
        }
        return (int)Math.round(q);
    }

    public static float Spline(double x, double y, float[] pixels, int width, int height) {
        int u0 = (int)Math.floor(x);
        int v0 = (int)Math.floor(y);
        if (u0 < 1 || width - 2 <= u0 || v0 < 1 || height - 2 <= v0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int j = 0; j <= 3; ++j) {
            int v = v0 + j - 1;
            double p = 0.0;
            for (int i2 = 0; i2 <= 3; ++i2) {
                int u = u0 + i2 - 1;
                p += (double)pixels[u + v * width] * Interpolations.Spline(x - (double)u);
            }
            q += p * Interpolations.Spline(y - (double)v);
        }
        return (float)q;
    }

    public static double Spline(double x, double y, double[] pixels, int width, int height) {
        int u0 = (int)Math.floor(x);
        int v0 = (int)Math.floor(y);
        if (u0 < 1 || width - 2 <= u0 || v0 < 1 || height - 2 <= v0) {
            return Interpolations.Bilinear(x, y, pixels, width, height);
        }
        double q = 0.0;
        for (int j = 0; j <= 3; ++j) {
            int v = v0 + j - 1;
            double p = 0.0;
            for (int i2 = 0; i2 <= 3; ++i2) {
                int u = u0 + i2 - 1;
                p += pixels[u + v * width] * Interpolations.Spline(x - (double)u);
            }
            q += p * Interpolations.Spline(y - (double)v);
        }
        return q;
    }

    private static double Spline(double x) {
        if (x < 0.0) {
            x = -x;
        }
        double w = 0.0;
        if (x < 1.0) {
            w = (-6.0 * SplineA - 9.0 * SplineB + 12.0) * x * x * x + (6.0 * SplineA + 12.0 * SplineB - 18.0) * x * x - 2.0 * SplineB + 6.0;
        } else if (x < 2.0) {
            w = (-6.0 * SplineA - SplineB) * x * x * x + (30.0 * SplineA + 6.0 * SplineB) * x * x + (-48.0 * SplineA - 12.0 * SplineB) * x + 24.0 * SplineA + 8.0 * SplineB;
        }
        return w / 6.0;
    }

    public static void SetSpline(double a, double b) {
        if (a < 0.0 || 1.0 < a) {
            throw new IllegalArgumentException("a < 0.0 or 1.0 < a");
        }
        if (b < 0.0 || 1.0 < b) {
            throw new IllegalArgumentException("b < 0.0 or 1.0 < b");
        }
        SplineA = a;
        SplineB = b;
    }

    public static byte Spline3D(double x, double y, double z, byte[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 < 1 || width - 2 <= x0 || y0 < 1 || height - 2 <= y0 || z0 < 1 || depth - 2 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        for (int zz = 0; zz <= 3; ++zz) {
            int Z = z0 + zz - 1;
            double q = 0.0;
            for (int yy = 0; yy <= 3; ++yy) {
                int Y = y0 + yy - 1;
                double p = 0.0;
                for (int xx = 0; xx <= 3; ++xx) {
                    int X = x0 + xx - 1;
                    p += (double)(voxels[X + Y * width + Z * layer] & 0xFF) * Interpolations.Spline(x - (double)X);
                }
                q += p * Interpolations.Spline(y - (double)Y);
            }
            r += q * Interpolations.Spline(z - (double)Z);
        }
        if (r < 0.0) {
            return 0;
        }
        if (255.0 <= r) {
            return -1;
        }
        return (byte)Math.round(r);
    }

    public static short Spline3D(double x, double y, double z, short[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 < 1 || width - 2 <= x0 || y0 < 1 || height - 2 <= y0 || z0 < 1 || depth - 2 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        for (int zz = 0; zz <= 3; ++zz) {
            int Z = z0 + zz - 1;
            double q = 0.0;
            for (int yy = 0; yy <= 3; ++yy) {
                int Y = y0 + yy - 1;
                double p = 0.0;
                for (int xx = 0; xx <= 3; ++xx) {
                    int X = x0 + xx - 1;
                    p += (double)(voxels[X + Y * width + Z * layer] & 0xFFFF) * Interpolations.Spline(x - (double)X);
                }
                q += p * Interpolations.Spline(y - (double)Y);
            }
            r += q * Interpolations.Spline(z - (double)Z);
        }
        if (r < 0.0) {
            return 0;
        }
        if (65535.0 <= r) {
            return -1;
        }
        return (short)Math.round(r);
    }

    public static int Spline3D(double x, double y, double z, int[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 < 1 || width - 2 <= x0 || y0 < 1 || height - 2 <= y0 || z0 < 1 || depth - 2 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        for (int zz = 0; zz <= 3; ++zz) {
            int Z = z0 + zz - 1;
            double q = 0.0;
            for (int yy = 0; yy <= 3; ++yy) {
                int Y = y0 + yy - 1;
                double p = 0.0;
                for (int xx = 0; xx <= 3; ++xx) {
                    int X = x0 + xx - 1;
                    p += (double)voxels[X + Y * width + Z * layer] * Interpolations.Spline(x - (double)X);
                }
                q += p * Interpolations.Spline(y - (double)Y);
            }
            r += q * Interpolations.Spline(z - (double)Z);
        }
        return (int)Math.round(r);
    }

    public static float Spline3D(double x, double y, double z, float[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 < 1 || width - 2 <= x0 || y0 < 1 || height - 2 <= y0 || z0 < 1 || depth - 2 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        for (int zz = 0; zz <= 3; ++zz) {
            int Z = z0 + zz - 1;
            double q = 0.0;
            for (int yy = 0; yy <= 3; ++yy) {
                int Y = y0 + yy - 1;
                double p = 0.0;
                for (int xx = 0; xx <= 3; ++xx) {
                    int X = x0 + xx - 1;
                    p += (double)voxels[X + Y * width + Z * layer] * Interpolations.Spline(x - (double)X);
                }
                q += p * Interpolations.Spline(y - (double)Y);
            }
            r += q * Interpolations.Spline(z - (double)Z);
        }
        return (float)r;
    }

    public static double Spline3D(double x, double y, double z, double[] voxels, int width, int height, int depth, int layer) {
        int x0 = (int)Math.floor(x);
        int y0 = (int)Math.floor(y);
        int z0 = (int)Math.floor(z);
        if (x0 < 1 || width - 2 <= x0 || y0 < 1 || height - 2 <= y0 || z0 < 1 || depth - 2 <= z0) {
            return Interpolations.Trilinear(x, y, z, voxels, width, height, depth, layer);
        }
        double r = 0.0;
        for (int zz = 0; zz <= 3; ++zz) {
            int Z = z0 + zz - 1;
            double q = 0.0;
            for (int yy = 0; yy <= 3; ++yy) {
                int Y = y0 + yy - 1;
                double p = 0.0;
                for (int xx = 0; xx <= 3; ++xx) {
                    int X = x0 + xx - 1;
                    p += voxels[X + Y * width + Z * layer] * Interpolations.Spline(x - (double)X);
                }
                q += p * Interpolations.Spline(y - (double)Y);
            }
            r += q * Interpolations.Spline(z - (double)Z);
        }
        return r;
    }

    public static enum Methods3D {
        Lanczos,
        Spline,
        Tricubic,
        Trilinear;

    }

    public static enum Methods2D {
        Bicubic,
        Bilinear,
        BilinearPlus,
        Lanczos,
        Spline;

    }
}

