/*
 * Decompiled with CFR 0.152.
 */
package mathematics;

import mathematics.matriciel.Vector;
import mathematics.metrics.Euclidian;
import mathematics.primitives.LineSegment;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DI;
import mathematics.primitives.pointsTiTi.PointI;
import mathematics.primitives.pointsTiTi.PointND;

public final class Geometry2D {
    public static double AngleBAC(Point B, Point A, Point C, boolean Degres) {
        Euclidian distances = new Euclidian();
        double AB = distances.Distance(A, B);
        double AC = distances.Distance(A, C);
        distances = null;
        double angle = Math.acos(((B.getX() - A.getX()) * (C.getX() - A.getX()) + (B.getY() - A.getY()) * (C.getY() - A.getY())) / (AB * AC));
        if ((B.getY() - A.getY()) / (B.getX() - A.getX()) * (C.getX() - A.getX()) + A.getY() <= C.getY()) {
            angle = Math.PI * 2 - angle;
        }
        if (Degres) {
            return 360.0 - angle * 180.0 / Math.PI;
        }
        return Math.PI * 2 - angle;
    }

    public static double AngleBAC(PointI B, PointI A, PointI C, boolean Degres) {
        Euclidian distances = new Euclidian();
        double AB = distances.Distance(A, B);
        double AC = distances.Distance(A, C);
        distances = null;
        double angle = Math.acos(((double)(B.getX() - A.getX()) * (double)(C.getX() - A.getX()) + (double)(B.getY() - A.getY()) * (double)(C.getY() - A.getY())) / (AB * AC));
        if ((double)(B.getY() - A.getY()) / (double)(B.getX() - A.getX()) * (double)(C.getX() - A.getX()) + (double)A.getY() <= (double)C.getY()) {
            angle = Math.PI * 2 - angle;
        }
        if (Degres) {
            return 360.0 - angle * 180.0 / Math.PI;
        }
        return Math.PI * 2 - angle;
    }

    public static double AngleBAC(PointI B, Point A, PointI C, boolean Degres) {
        Euclidian distances = new Euclidian();
        double AB = distances.Distance((double)B.getX(), (double)B.getY(), 0.0, A.getX(), A.getY(), 0.0);
        double AC = distances.Distance((double)C.getX(), (double)C.getY(), 0.0, A.getX(), A.getY(), 0.0);
        distances = null;
        double[] VAB = new double[2];
        double[] VAC = new double[2];
        VAB[0] = (double)B.getX() - A.getX();
        VAB[1] = (double)B.getY() - A.getY();
        VAC[0] = (double)C.getX() - A.getX();
        VAC[1] = (double)C.getY() - A.getY();
        double angle = Math.acos((VAB[0] * VAC[0] + VAB[1] * VAC[1]) / (AB * AC));
        if (VAB[1] / VAB[0] * ((double)C.getX() - A.getX()) + A.getY() <= (double)C.getY()) {
            angle = Math.PI * 2 - angle;
        }
        if (Degres) {
            return 360.0 - angle * 180.0 / Math.PI;
        }
        return Math.PI * 2 - angle;
    }

    public static double AngleBAC(Coordinate B, Coordinate A, Coordinate C, boolean Degres) {
        Euclidian distances = new Euclidian();
        double AB = distances.Distance(A, B);
        double AC = distances.Distance(A, C);
        distances = null;
        double angle = Math.acos(((B.X - A.X) * (C.X - A.X) + (B.Y - A.Y) * (C.Y - A.Y)) / (AB * AC));
        if ((B.Y - A.Y) / (B.X - A.X) * (C.X - A.X) + A.Y <= C.Y) {
            angle = Math.PI * 2 - angle;
        }
        if (Degres) {
            return 360.0 - angle * 180.0 / Math.PI;
        }
        return Math.PI * 2 - angle;
    }

    public static double AngleBAC(Coordinates B, Coordinates A, Coordinates C, boolean Degres) {
        Euclidian distances = new Euclidian();
        double AB = distances.Distance(A, B);
        double AC = distances.Distance(A, C);
        distances = null;
        double angle = Math.acos(((double)(B.X - A.X) * (double)(C.X - A.X) + (double)(B.Y - A.Y) * (double)(C.Y - A.Y)) / (AB * AC));
        if ((double)(B.Y - A.Y) / (double)(B.X - A.X) * (double)(C.X - A.X) + (double)A.Y <= (double)C.Y) {
            angle = Math.PI * 2 - angle;
        }
        if (Degres) {
            return 360.0 - angle * 180.0 / Math.PI;
        }
        return Math.PI * 2 - angle;
    }

    public static double AngleBAC(Coordinates B, Coordinate A, Coordinates C, boolean Degres) {
        Euclidian distances = new Euclidian();
        double AB = distances.Distance((double)B.X, (double)B.Y, 0.0, A.X, A.Y, 0.0);
        double AC = distances.Distance((double)C.X, (double)C.Y, 0.0, A.X, A.Y, 0.0);
        distances = null;
        double[] VAB = new double[2];
        double[] VAC = new double[2];
        VAB[0] = (double)B.X - A.X;
        VAB[1] = (double)B.Y - A.Y;
        VAC[0] = (double)C.X - A.X;
        VAC[1] = (double)C.Y - A.Y;
        double angle = Math.acos((VAB[0] * VAC[0] + VAB[1] * VAC[1]) / (AB * AC));
        if (VAB[1] / VAB[0] * ((double)C.X - A.X) + A.Y <= (double)C.Y) {
            angle = Math.PI * 2 - angle;
        }
        if (Degres) {
            return 360.0 - angle * 180.0 / Math.PI;
        }
        return Math.PI * 2 - angle;
    }

    public static int Determinant(PointI O, PointI P, PointI Q) {
        int x = P.getX() - O.getX();
        int y = P.getY() - O.getY();
        int z = Q.getX() - O.getX();
        int t = Q.getY() - O.getY();
        return x * t - y * z;
    }

    public static int Determinant(PointI p1, PointI p2, PointI p3, PointI p4) {
        Point3DI v1 = new Point3DI(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        Point3DI v2 = new Point3DI(p4.getX() - p3.getX(), p4.getY() - p3.getY());
        return v1.getX() * v2.getY() - v1.getY() * v2.getX();
    }

    public static int Determinant(Coordinates O, Coordinates P, Coordinates Q) {
        int x = P.X - O.X;
        int y = P.Y - O.Y;
        int z = Q.X - O.X;
        int t = Q.Y - O.Y;
        return x * t - y * z;
    }

    public static int Determinant(Coordinates p1, Coordinates p2, Coordinates p3, Coordinates p4) {
        Point3DI v1 = new Point3DI(p2.X - p1.X, p2.Y - p1.Y);
        Point3DI v2 = new Point3DI(p4.X - p3.X, p4.Y - p3.Y);
        return v1.getX() * v2.getY() - v1.getY() * v2.getX();
    }

    public static boolean TurnLeft(PointI O, PointI P, PointI Q) {
        return Geometry2D.Determinant(O, P, Q) > 0;
    }

    public static boolean TurnLeft(Coordinates O, Coordinates P, Coordinates Q) {
        return Geometry2D.Determinant(O, P, Q) > 0;
    }

    public static boolean TurnRight(PointI O, PointI P, PointI Q) {
        return Geometry2D.Determinant(O, P, Q) < 0;
    }

    public static boolean TurnRight(Coordinates O, Coordinates P, Coordinates Q) {
        return Geometry2D.Determinant(O, P, Q) < 0;
    }

    public static Point IntersectionDroites(LineSegment d1, LineSegment d2) {
        if (d1.Dimension != 2 || d2.Dimension != 2) {
            throw new IllegalArgumentException("Lines are not dimension 2.");
        }
        PointND p = new PointND(2);
        double d1A = d1.A();
        double d1B = d1.B();
        double d2A = d2.A();
        double d2B = d2.B();
        p.setX((d2B - d1B) / (d1A - d2A));
        p.setY(p.getX() * d1A + d1B);
        return p;
    }

    public static Point ProjectionPointOnLine(LineSegment D, PointI P) {
        PointND I = new PointND(2);
        double DA = D.A();
        double DB = D.B();
        I.setX(((double)P.getY() + (double)P.getX() / DA - DB) / (DA + 1.0 / DA));
        I.setY(DA * I.getX() + DB);
        return I;
    }

    public static Point ProjectionPointOnLine(LineSegment D, Coordinates P) {
        PointND I = new PointND(2);
        double DA = D.A();
        double DB = D.B();
        I.setX(((double)P.Y + (double)P.X / DA - DB) / (DA + 1.0 / DA));
        I.setY(DA * I.getX() + DB);
        return I;
    }

    public static boolean isInField(Coordinates B, Coordinates A, Coordinates C, Coordinates P) {
        return Geometry2D.TurnLeft(B, A, P) && Geometry2D.TurnLeft(P, A, C);
    }

    public static double AngleFromVector(Vector v, boolean degres) {
        if (v.Dimension() != 2) {
            throw new IllegalArgumentException("Vector is not dimension 2.");
        }
        double theta = 0.0;
        theta = v.get(1) == 0.0 ? (v.get(0) >= 0.0 ? 0.0 : Math.PI) : Math.atan2(v.get(1), v.get(0));
        return degres ? Math.toDegrees(theta) : theta;
    }

    public static void FindCenter(Coordinates p1, Coordinates p2, Coordinates p3, Coordinate Center2) throws ArithmeticException {
        if (p1.X == p2.X) {
            throw new ArithmeticException("p1.X = p2.X");
        }
        if (p2.X == p3.X) {
            throw new ArithmeticException("p2.X = p3.X");
        }
        if (p1.Y == p2.Y) {
            throw new ArithmeticException("p1.Y = p2.Y");
        }
        if (p2.Y == p3.Y) {
            throw new ArithmeticException("p2.Y = p3.Y");
        }
        double xM0 = (double)(p1.X + p2.X) / 2.0;
        double yM0 = (double)(p1.Y + p2.Y) / 2.0;
        double xM1 = (double)(p2.X + p3.X) / 2.0;
        double yM1 = (double)(p2.Y + p3.Y) / 2.0;
        double a0 = (double)(p2.Y - p1.Y) / (double)(p2.X - p1.X);
        double a1 = (double)(p3.Y - p2.Y) / (double)(p3.X - p2.X);
        if (Double.compare(a0, a1) == 0) {
            throw new ArithmeticException("Collinear coordinates.");
        }
        Center2.X = 1.0 / (1.0 / a0 - 1.0 / a1) * (xM0 / a0 - xM1 / a1 + yM0 - yM1);
        Center2.Y = (xM0 - Center2.X) / a0 + yM0;
    }

    public static void FindCenter(Coordinate p1, Coordinate p2, Coordinate p3, Coordinate Center2) throws ArithmeticException {
        if (Double.compare(p1.X, p2.X) == 0) {
            throw new ArithmeticException("p1.X = p2.X");
        }
        if (Double.compare(p2.X, p3.X) == 0) {
            throw new ArithmeticException("p2.X = p3.X");
        }
        if (p1.Y == p2.Y) {
            throw new ArithmeticException("p1.Y = p2.Y");
        }
        if (p2.Y == p3.Y) {
            throw new ArithmeticException("p2.Y = p3.Y");
        }
        double xM0 = (p1.X + p2.X) / 2.0;
        double yM0 = (p1.Y + p2.Y) / 2.0;
        double xM1 = (p2.X + p3.X) / 2.0;
        double yM1 = (p2.Y + p3.Y) / 2.0;
        double a0 = (p2.Y - p1.Y) / (p2.X - p1.X);
        double a1 = (p3.Y - p2.Y) / (p3.X - p2.X);
        if (Double.compare(a0, a1) == 0) {
            throw new ArithmeticException("Collinear coordinates.");
        }
        Center2.X = 1.0 / (1.0 / a0 - 1.0 / a1) * (xM0 / a0 - xM1 / a1 + yM0 - yM1);
        Center2.Y = (xM0 - Center2.X) / a0 + yM0;
    }

    public static Coordinates SymmetricPointPoint(Coordinates P, Coordinates M) {
        Coordinates R = new Coordinates(P);
        Geometry2D.SymmetricPointPoint(P, M, R);
        return R;
    }

    public static void SymmetricPointPoint(Coordinates P, Coordinates M, Coordinates R) {
        R.X = (M.X << 1) - P.X;
        R.Y = (M.Y << 1) - P.Y;
        R.Z = (M.Z << 1) - P.Z;
    }

    public static Coordinate SymmetricPointPoint(Coordinate P, Coordinate M) {
        Coordinate R = new Coordinate(P);
        Geometry2D.SymmetricPointPoint(P, M, R);
        return R;
    }

    public static void SymmetricPointPoint(Coordinate P, Coordinate M, Coordinate R) {
        R.X = 2.0 * M.X - P.X;
        R.Y = 2.0 * M.Y - P.Y;
        R.Z = 2.0 * M.Z - P.Z;
    }

    public static Coordinate SymmetricPointPoint(Coordinates P, Coordinate M) {
        Coordinate R = new Coordinate(M);
        Geometry2D.SymmetricPointPoint(P, M, R);
        return R;
    }

    public static void SymmetricPointPoint(Coordinates P, Coordinate M, Coordinate R) {
        R.X = 2.0 * M.X - (double)P.X;
        R.Y = 2.0 * M.Y - (double)P.Y;
        R.Z = 2.0 * M.Z - (double)P.Z;
    }

    public static Coordinates SymmetricPointLine(LineSegment L, Coordinates P) {
        Coordinates R = new Coordinates(P);
        Geometry2D.SymmetricPointLine(L, P, R);
        return R;
    }

    public static void SymmetricPointLine(LineSegment L, Coordinates P, Coordinates R) {
        Coordinate M = new Coordinate();
        double DA = L.A();
        double DB = L.B();
        M.X = ((double)P.Y + (double)P.X / DA - DB) / (DA + 1.0 / DA);
        M.Y = DA * M.X + DB;
        R.X = (int)(2.0 * M.X - (double)P.X + 0.5);
        R.Y = (int)(2.0 * M.Y - (double)P.Y + 0.5);
        M = null;
    }

    public static Coordinate SymmetricPointLine(LineSegment L, Coordinate P) {
        Coordinate R = new Coordinate(P);
        Geometry2D.SymmetricPointLine(L, P, R);
        return R;
    }

    public static void SymmetricPointLine(LineSegment L, Coordinate P, Coordinate R) {
        Coordinate M = new Coordinate();
        double DA = L.A();
        double DB = L.B();
        M.X = (P.Y + P.X / DA - DB) / (DA + 1.0 / DA);
        M.Y = DA * M.X + DB;
        R.X = 2.0 * M.X - P.X;
        R.Y = 2.0 * M.Y - P.Y;
        M = null;
    }

    public static Coordinates SymmetricPointPoint(Coordinates P, Coordinates M, double Ratio) {
        Coordinates R = new Coordinates(P);
        Geometry2D.SymmetricPointPoint(P, M, Ratio, R);
        return R;
    }

    public static void SymmetricPointPoint(Coordinates P, Coordinates M, double Ratio, Coordinates R) {
        if (Ratio < 0.0) {
            throw new IllegalArgumentException("Ratio < 0.0");
        }
        int X = (M.X << 1) - P.X;
        int Y = (M.Y << 1) - P.Y;
        int Z = (M.Z << 1) - P.Z;
        R.X = M.X + (int)(Ratio * (double)(X - M.X) + 0.5);
        R.Y = M.Y + (int)(Ratio * (double)(Y - M.Y) + 0.5);
        R.Z = M.Z + (int)(Ratio * (double)(Z - M.Z) + 0.5);
    }

    public static Coordinate SymmetricPointPoint(Coordinate P, Coordinate M, double Ratio) {
        Coordinate R = new Coordinate(P);
        Geometry2D.SymmetricPointPoint(P, M, Ratio, R);
        return R;
    }

    public static void SymmetricPointPoint(Coordinate P, Coordinate M, double Ratio, Coordinate R) {
        if (Ratio < 0.0) {
            throw new IllegalArgumentException("Ratio < 0.0");
        }
        double X = 2.0 * M.X - P.X;
        double Y = 2.0 * M.Y - P.Y;
        double Z = 2.0 * M.Z - P.Z;
        R.X = M.X + Ratio * (X - M.X);
        R.Y = M.Y + Ratio * (Y - M.Y);
        R.Z = M.Z + Ratio * (Z - M.Z);
    }
}

