/*
 * Decompiled with CFR 0.152.
 */
package mathematics;

import mathematics.matriciel.Vector;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.PointND;

public class Geometry {
    public static double Epsilon = 1.0E-4;

    public static Point Intersection(Point X, Vector V, Point P) {
        double a = Geometry.IntersectionCoef(X, V, P);
        Vector v = V.Clone();
        v.Times(a);
        PointND M = new PointND(X.get());
        M.Add(v.get());
        v = null;
        return M;
    }

    public static double IntersectionCoef(Point X, Vector V, Point P) {
        if (X.Size() != P.Size() || P.Size() != V.Dimension()) {
            throw new IllegalArgumentException("Gap dimensions between parameters.");
        }
        int Size = V.Dimension();
        double num = 0.0;
        double den = 0.0;
        for (int i2 = 0; i2 < Size; ++i2) {
            num += V.get(i2) * (P.get(i2) - X.get(i2));
            den += Math.pow(V.get(i2), 2.0);
        }
        if (Math.abs(den) < Epsilon) {
            throw new ArithmeticException("Denominator equal to zero => Vector V is a vector null.");
        }
        return num / den;
    }
}

