/*
 * Decompiled with CFR 0.152.
 */
package mathematics;

import dv.DV;
import java.util.ArrayList;
import java.util.List;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.Point3DI;
import mathematics.primitives.pointsTiTi.PointI;

public class Bresenham3D {
    public static void Draw(DV dv, int x1, int y1, int z1, int x2, int y2, int z2, int color) {
        int vx = x1;
        int vy = y1;
        int vz = z1;
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int x_inc = dx < 0 ? -1 : 1;
        int l = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int m = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int n = Math.abs(dz);
        int dx2 = l << 1;
        int dy2 = m << 1;
        int dz2 = n << 1;
        if (l >= m && l >= n) {
            int err_1 = dy2 - l;
            int err_2 = dz2 - l;
            for (int i2 = 0; i2 < l; ++i2) {
                dv.setVoxelUniversal(vx, vy, vz, 0, color);
                if (err_1 > 0) {
                    vy += y_inc;
                    err_1 -= dx2;
                }
                if (err_2 > 0) {
                    vz += z_inc;
                    err_2 -= dx2;
                }
                err_1 += dy2;
                err_2 += dz2;
                vx += x_inc;
            }
        } else if (m >= l && m >= n) {
            int err_1 = dx2 - m;
            int err_2 = dz2 - m;
            for (int i3 = 0; i3 < m; ++i3) {
                dv.setVoxelUniversal(vx, vy, vz, 0, color);
                if (err_1 > 0) {
                    vx += x_inc;
                    err_1 -= dy2;
                }
                if (err_2 > 0) {
                    vz += z_inc;
                    err_2 -= dy2;
                }
                err_1 += dx2;
                err_2 += dz2;
                vy += y_inc;
            }
        } else {
            int err_1 = dy2 - n;
            int err_2 = dx2 - n;
            for (int i4 = 0; i4 < n; ++i4) {
                dv.setVoxelUniversal(vx, vy, vz, 0, color);
                if (err_1 > 0) {
                    vy += y_inc;
                    err_1 -= dz2;
                }
                if (err_2 > 0) {
                    vx += x_inc;
                    err_2 -= dz2;
                }
                err_1 += dy2;
                err_2 += dx2;
                vz += z_inc;
            }
        }
        dv.setVoxelUniversal(vx, vy, vz, 0, color);
    }

    public static List<PointI> DrawList(int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<PointI> Liste = new ArrayList<PointI>(Math.max(x2 - x1, Math.max(y2 - y1, z2 - z1)));
        int vx = x1;
        int vy = y1;
        int vz = z1;
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int x_inc = dx < 0 ? -1 : 1;
        int l = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int m = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int n = Math.abs(dz);
        int dx2 = l << 1;
        int dy2 = m << 1;
        int dz2 = n << 1;
        if (l >= m && l >= n) {
            int err_1 = dy2 - l;
            int err_2 = dz2 - l;
            for (int i2 = 0; i2 < l; ++i2) {
                Liste.add(new Point3DI(vx, vy, vz));
                if (err_1 > 0) {
                    vy += y_inc;
                    err_1 -= dx2;
                }
                if (err_2 > 0) {
                    vz += z_inc;
                    err_2 -= dx2;
                }
                err_1 += dy2;
                err_2 += dz2;
                vx += x_inc;
            }
        } else if (m >= l && m >= n) {
            int err_1 = dx2 - m;
            int err_2 = dz2 - m;
            for (int i3 = 0; i3 < m; ++i3) {
                Liste.add(new Point3DI(vx, vy, vz));
                if (err_1 > 0) {
                    vx += x_inc;
                    err_1 -= dy2;
                }
                if (err_2 > 0) {
                    vz += z_inc;
                    err_2 -= dy2;
                }
                err_1 += dx2;
                err_2 += dz2;
                vy += y_inc;
            }
        } else {
            int err_1 = dy2 - n;
            int err_2 = dx2 - n;
            for (int i4 = 0; i4 < n; ++i4) {
                Liste.add(new Point3DI(vx, vy, vz));
                if (err_1 > 0) {
                    vy += y_inc;
                    err_1 -= dz2;
                }
                if (err_2 > 0) {
                    vx += x_inc;
                    err_2 -= dz2;
                }
                err_1 += dy2;
                err_2 += dx2;
                vz += z_inc;
            }
        }
        Liste.add(new Point3DI(vx, vy, vz));
        return Liste;
    }

    public static List<Coordinates> Coordinates(int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<Coordinates> list = new ArrayList<Coordinates>((int)(1.13 * (double)Math.max(Math.abs(x2 - x1), Math.max(Math.abs(y2 - y1), Math.abs(z2 - z1)))));
        int vx = x1;
        int vy = y1;
        int vz = z1;
        int dx = x2 - x1;
        int dy = y2 - y1;
        int dz = z2 - z1;
        int x_inc = dx < 0 ? -1 : 1;
        int l = Math.abs(dx);
        int y_inc = dy < 0 ? -1 : 1;
        int m = Math.abs(dy);
        int z_inc = dz < 0 ? -1 : 1;
        int n = Math.abs(dz);
        int dx2 = l << 1;
        int dy2 = m << 1;
        int dz2 = n << 1;
        if (l >= m && l >= n) {
            int err_1 = dy2 - l;
            int err_2 = dz2 - l;
            for (int i2 = 0; i2 < l; ++i2) {
                list.add(new Coordinates(vx, vy, vz));
                if (err_1 > 0) {
                    vy += y_inc;
                    err_1 -= dx2;
                }
                if (err_2 > 0) {
                    vz += z_inc;
                    err_2 -= dx2;
                }
                err_1 += dy2;
                err_2 += dz2;
                vx += x_inc;
            }
        } else if (m >= l && m >= n) {
            int err_1 = dx2 - m;
            int err_2 = dz2 - m;
            for (int i3 = 0; i3 < m; ++i3) {
                list.add(new Coordinates(vx, vy, vz));
                if (err_1 > 0) {
                    vx += x_inc;
                    err_1 -= dy2;
                }
                if (err_2 > 0) {
                    vz += z_inc;
                    err_2 -= dy2;
                }
                err_1 += dx2;
                err_2 += dz2;
                vy += y_inc;
            }
        } else {
            int err_1 = dy2 - n;
            int err_2 = dx2 - n;
            for (int i4 = 0; i4 < n; ++i4) {
                list.add(new Coordinates(vx, vy, vz));
                if (err_1 > 0) {
                    vy += y_inc;
                    err_1 -= dz2;
                }
                if (err_2 > 0) {
                    vx += x_inc;
                    err_2 -= dz2;
                }
                err_1 += dy2;
                err_2 += dx2;
                vz += z_inc;
            }
        }
        list.add(new Coordinates(vx, vy, vz));
        return list;
    }
}

