/*
 * Decompiled with CFR 0.152.
 */
package init;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public final class Native {
    private static final String jnicoreosx = "libFiReTiTiCoreNative";
    private static final String jnilib = "libFiReTiTiNative";
    public static String LibPath = null;
    private static boolean CallNativeCore = false;
    private static boolean CallNative = false;

    public static void Start() throws MalformedURLException, IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        Native.Core(os, arch);
    }

    private static void Core(String os, String architecture) throws MalformedURLException, IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String jar;
        System.out.println("\u001b[34mCore: \u001b[32mto be or not to be... native?\u001b[0m");
        System.out.flush();
        File file = new File(LibPath == null ? "" : LibPath);
        try {
            if (architecture.contains("32")) {
                throw new IllegalAccessException("64 bits architecture required.");
            }
            String ext = null;
            switch (os) {
                case "Mac OS X": {
                    ext = "jnilib";
                    break;
                }
                case "Linux": {
                    ext = "so";
                    break;
                }
                default: {
                    System.out.println("\u001b[32mOS not natively supported (yet), no native core available.\u001b[0m");
                }
            }
            if (ext != null) {
                System.load(file.getAbsolutePath() + "/lib/libFiReTiTiCoreNative." + ext);
                System.out.println("\u001b[32mNative core found and successfully loaded.\u001b[0m");
                CallNativeCore = true;
            } else {
                CallNativeCore = false;
            }
        }
        catch (NullPointerException | SecurityException | UnsatisfiedLinkError e) {
            System.out.println("\u001b[32m" + e.getClass().getSimpleName() + ": No native core found (" + e.getMessage() + ").\u001b[0m");
        }
        catch (IllegalAccessException ex) {
            System.out.println(ex.getMessage());
        }
        System.out.flush();
        while (true) {
            if (new File(jar = file.getAbsolutePath() + "/lib/FiReTiTiCore" + (CallNativeCore ? "Native" : "Java") + ".jar").exists()) break;
            if (!CallNativeCore) {
                throw new IOException("Impossible to load the Core jar.");
            }
            System.out.println("\u001b[32mMatching core jar missing!");
            CallNativeCore = false;
            System.out.flush();
        }
        URL[] path = new URL[]{new URL("file", "", jar)};
        ClassLoader parent = ClassLoader.getPlatformClassLoader();
        URLClassLoader ucl = new URLClassLoader(path, parent);
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        Method method = sysclass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)ucl, path[0]);
        System.out.println("\u001b[32mJava Core (" + (CallNativeCore ? "native" : "pure java") + " jar) successfully loaded!");
        System.out.flush();
        System.out.println("\u001b[32mUse native core: \u001b[34m" + CallNativeCore + "\u001b[0m");
        System.out.flush();
    }

    private static void NativeLib(String os) throws MalformedURLException, IOException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        System.out.println("\u001b[34mLibrary:\u001b[32m to be or not to be... native?\u001b[0m");
        System.out.flush();
        CallNative = true;
        File file = new File(LibPath == null ? "" : LibPath);
        try {
            String ext = null;
            switch (os) {
                case "Mac OS X": {
                    ext = "jnilib";
                    break;
                }
                case "Linux": {
                    ext = "so";
                    break;
                }
                default: {
                    throw new IllegalAccessException("OS not supported (yet).");
                }
            }
            System.load(file.getAbsolutePath() + "/lib/libFiReTiTiNative." + ext);
        }
        catch (NullPointerException | SecurityException | UnsatisfiedLinkError e) {
            System.out.println("\u001b[32mNo native library found (" + e.getMessage() + ").\u001b[0m");
            CallNative = false;
        }
        System.out.println("\u001b[32mUse native libary \"libFiReTiTiNative\": \u001b[34m" + CallNative + "\u001b[0m");
        System.out.flush();
    }

    public static boolean CallNativeCore() {
        return CallNativeCore;
    }

    public static boolean CallNative() {
        return CallNative;
    }
}

