/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import io.FileInputStreamTiTi;
import io.FileOutputStreamTiTi;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;

public class PgmTools {
    public static final String MAGIC_PGM = "P5\n";

    public static BufferedImage Read(String FileName) throws IOException {
        System.out.print("Reading image (PgmTools) '" + FileName + "'");
        System.out.flush();
        FileInputStreamTiTi reader = new FileInputStreamTiTi(FileName);
        if (!reader.MagicNumber(MAGIC_PGM)) {
            throw new IOException(FileName + ": wrong magic number");
        }
        reader.skipComment('#');
        int width = reader.ReadInt();
        int height = reader.ReadInt();
        reader.skipLine();
        reader.skipComment('#');
        reader.skipLine();
        System.out.print(" (" + width + "x" + height + " <=> " + width * height + " pixels, 8 bits BYTE_GRAY)...");
        System.out.flush();
        byte[] transfert = reader.LoadData(width * height);
        BufferedImage image = new BufferedImage(width, height, 10);
        System.arraycopy(transfert, 0, ((DataBufferByte)image.getRaster().getDataBuffer()).getData(), 0, transfert.length);
        transfert = null;
        System.out.println(" successfully.");
        System.out.flush();
        return image;
    }

    public static void Write(String FileName, BufferedImage image) throws IOException {
        int width = image.getWidth();
        int height = image.getHeight();
        FileOutputStreamTiTi writer = new FileOutputStreamTiTi(FileName);
        writer.Put(MAGIC_PGM);
        writer.Put("#BufferedImage wrote with FiReTiTi Lib\n");
        writer.Put(width + " " + height + "\n255\n");
        writer.write(((DataBufferByte)image.getRaster().getDataBuffer()).getData());
        writer.close();
        writer = null;
    }
}

