/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayFeatures;
import imageTiTi.ImageTools;
import imageTiTi.colorSpace.FloatCS;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferUShort;

public class IntegralImage
extends BufferedImage {
    private Object data = null;
    private int dbtype;
    private int Width;
    private int Height;
    private int WidthMinus1;
    private int HeightMinus1;
    private ArrayFeatures AF = new ArrayFeatures();

    public IntegralImage(int width, int height, int DataBufferType) {
        super(new ComponentColorModel((ColorSpace)new FloatCS(6, 1), null, false, false, 1, DataBufferType == 4 ? 4 : 5), new ComponentColorModel((ColorSpace)new FloatCS(6, 1), null, false, false, 1, DataBufferType == 4 ? 4 : 5).createCompatibleWritableRaster(width, height), false, null);
        switch (DataBufferType) {
            case 5: {
                this.dbtype = DataBufferType;
                this.data = ((DataBufferDouble)this.getRaster().getDataBuffer()).getData();
                break;
            }
            case 4: {
                this.dbtype = DataBufferType;
                this.data = ((DataBufferFloat)this.getRaster().getDataBuffer()).getData();
                break;
            }
            default: {
                throw new IllegalArgumentException("DataBuffer type not available for integral image.");
            }
        }
    }

    public IntegralImage(BufferedImage image, int DataBufferType, boolean normalize) {
        this(image.getWidth(), image.getHeight(), DataBufferType);
        this.Width = image.getWidth();
        this.Height = image.getHeight();
        this.WidthMinus1 = this.Width - 1;
        this.HeightMinus1 = this.Height - 1;
        this.Compute(image, normalize);
    }

    public void Compute(BufferedImage image, boolean normalize) {
        if (!ImageTools.areDimensionsEqual((BufferedImage)image, (BufferedImage)this)) {
            throw new IllegalArgumentException("This image and the image provided in parameter have different dimensions.");
        }
        switch (this.dbtype) {
            case 5: {
                double[] DataDouble = (double[])this.data;
                switch (image.getType()) {
                    case 10: {
                        byte[] srcbyte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (int y = 0; y < this.Height; ++y) {
                            int x = 0;
                            while (x < this.Width) {
                                DataDouble[pos] = srcbyte[pos] & 0xFF;
                                ++x;
                                ++pos;
                            }
                        }
                        srcbyte = null;
                        break;
                    }
                    case 11: {
                        short[] srcshort = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (int y = 0; y < this.Height; ++y) {
                            int x = 0;
                            while (x < this.Width) {
                                DataDouble[pos] = srcshort[pos] & 0xFFFF;
                                ++x;
                                ++pos;
                            }
                        }
                        srcshort = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported.");
                    }
                }
                if (normalize) {
                    double min = this.AF.Minimum(DataDouble);
                    double max = this.AF.Maximum(DataDouble);
                    double scale = 1.0 / (max - min);
                    ArrayArithmetic.Subtract((double[])DataDouble, (double)min, (double[])DataDouble);
                    ArrayComparator.Compare((double[])DataDouble, (String)">=", (double)0.0, (double[])DataDouble, (double)0.0, (double[])DataDouble);
                    ArrayArithmetic.Multiply((double[])DataDouble, (double)scale, (double[])DataDouble);
                    ArrayComparator.Compare((double[])DataDouble, (String)"<=", (double)1.0, (double[])DataDouble, (double)1.0, (double[])DataDouble);
                }
                DataDouble = null;
                break;
            }
            case 4: {
                float[] DataFloat = (float[])this.data;
                switch (image.getType()) {
                    case 10: {
                        byte[] srcbyte = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (int y = 0; y < this.Height; ++y) {
                            int x = 0;
                            while (x < this.Width) {
                                DataFloat[pos] = srcbyte[pos] & 0xFF;
                                ++x;
                                ++pos;
                            }
                        }
                        srcbyte = null;
                        break;
                    }
                    case 11: {
                        short[] srcshort = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        for (int y = 0; y < this.Height; ++y) {
                            int x = 0;
                            while (x < this.Width) {
                                DataFloat[pos] = srcshort[pos] & 0xFFFF;
                                ++x;
                                ++pos;
                            }
                        }
                        srcshort = null;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Image type not supported.");
                    }
                }
                if (normalize) {
                    float min = (float)this.AF.Minimum(DataFloat);
                    float max = (float)this.AF.Maximum(DataFloat);
                    float scale = 1.0f / (max - min);
                    ArrayArithmetic.Subtract((float[])DataFloat, (float)min, (float[])DataFloat);
                    ArrayComparator.Compare((float[])DataFloat, (String)">=", (float)0.0f, (float[])DataFloat, (float)0.0f, (float[])DataFloat);
                    ArrayArithmetic.Multiply((float[])DataFloat, (float)scale, (float[])DataFloat);
                    ArrayComparator.Compare((float[])DataFloat, (String)"<=", (float)1.0f, (float[])DataFloat, (float)1.0f, (float[])DataFloat);
                }
                DataFloat = null;
            }
        }
        this.ComputeIntegralImage();
    }

    private void ComputeIntegralImage() {
        switch (this.dbtype) {
            case 5: {
                int pos;
                double[] DataDouble = (double[])this.data;
                double rowSumDouble = DataDouble[0];
                for (pos = 1; pos < this.Width; ++pos) {
                    DataDouble[pos] = rowSumDouble += DataDouble[pos];
                }
                int posprev = 0;
                for (int y = 1; y < this.Height; ++y) {
                    rowSumDouble = 0.0;
                    int x = 0;
                    while (x < this.Width) {
                        DataDouble[pos] = (rowSumDouble += DataDouble[pos]) + DataDouble[posprev];
                        ++x;
                        ++pos;
                        ++posprev;
                    }
                }
                break;
            }
            case 4: {
                int pos;
                float[] DataFloat = (float[])this.data;
                float rowSumFloat = DataFloat[0];
                for (pos = 1; pos < this.Width; ++pos) {
                    DataFloat[pos] = rowSumFloat += DataFloat[pos];
                }
                int posprev = 0;
                for (int y = 1; y < this.Height; ++y) {
                    rowSumFloat = 0.0f;
                    int x = 0;
                    while (x < this.Width) {
                        DataFloat[pos] = (rowSumFloat += DataFloat[pos]) + DataFloat[posprev];
                        ++x;
                        ++pos;
                        ++posprev;
                    }
                }
                break;
            }
        }
    }

    public double AreaDouble(int x, int y, int width, int height) {
        int x2 = --x + width;
        int y2 = --y + height;
        if (this.WidthMinus1 < x) {
            x = this.WidthMinus1;
        }
        if (this.HeightMinus1 < y) {
            y = this.HeightMinus1;
        }
        if (this.WidthMinus1 < x2) {
            x2 = this.WidthMinus1;
        }
        if (this.HeightMinus1 < y2) {
            y2 = this.HeightMinus1;
        }
        double[] DataDouble = (double[])this.data;
        double A = x < 0 || y < 0 ? 0.0 : DataDouble[x + y * this.Width];
        double B = x2 < 0 || y < 0 ? 0.0 : DataDouble[x2 + y * this.Width];
        double C = x < 0 || y2 < 0 ? 0.0 : DataDouble[x + y2 * this.Width];
        double D = x2 < 0 || y2 < 0 ? 0.0 : DataDouble[x2 + y2 * this.Width];
        return D - B - C + A;
    }

    public double AreaFastDouble(int x, int y, int width, int height) {
        int x2 = --x + width;
        int y2 = --y + height;
        double[] DataDouble = (double[])this.data;
        double A = DataDouble[x + y * this.Width];
        double B = DataDouble[x2 + y * this.Width];
        double C = DataDouble[x + y2 * this.Width];
        double D = DataDouble[x2 + y2 * this.Width];
        return D - B - C + A;
    }

    public float AreaFloat(int x, int y, int width, int height) {
        int x2 = --x + width;
        int y2 = --y + height;
        if (this.WidthMinus1 < x) {
            x = this.WidthMinus1;
        }
        if (this.HeightMinus1 < y) {
            y = this.HeightMinus1;
        }
        if (this.WidthMinus1 < x2) {
            x2 = this.WidthMinus1;
        }
        if (this.HeightMinus1 < y2) {
            y2 = this.HeightMinus1;
        }
        float[] DataFloat = (float[])this.data;
        float A = x < 0 || y < 0 ? 0.0f : DataFloat[x + y * this.Width];
        float B = x2 < 0 || y < 0 ? 0.0f : DataFloat[x2 + y * this.Width];
        float C = x < 0 || y2 < 0 ? 0.0f : DataFloat[x + y2 * this.Width];
        float D = x2 < 0 || y2 < 0 ? 0.0f : DataFloat[x2 + y2 * this.Width];
        return D - B - C + A;
    }

    public float AreaFastFloat(int x, int y, int width, int height) {
        int x2 = --x + width;
        int y2 = --y + height;
        float[] DataFloat = (float[])this.data;
        float A = DataFloat[x + y * this.Width];
        float B = DataFloat[x2 + y * this.Width];
        float C = DataFloat[x + y2 * this.Width];
        float D = DataFloat[x2 + y2 * this.Width];
        return D - B - C + A;
    }

    public Object Data() {
        return this.data;
    }

    public int DataBufferType() {
        return this.dbtype;
    }
}

