/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import arrayTiTi.ArrayTransformations;
import ij.ImagePlus;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import imageJ.IJInterfacor;
import imageTiTi.ImageConverter;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import imagescience.image.Aspects;
import imagescience.image.Image;
import imagescience.transform.Scale;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;

public class ImageTransformations {
    public static BufferedImage Rotate(BufferedImage image, double angle, ArrayTransformations.Interpolation inter) {
        int max = Math.max(image.getWidth(), image.getHeight());
        BufferedImage result = new BufferedImage(max, max, image.getType());
        ImageTransformations.Rotate(image, angle, inter, result);
        return result;
    }

    public static void Rotate(BufferedImage image, double angle, ArrayTransformations.Interpolation inter, BufferedImage result) {
        if (image.getType() != result.getType()) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        block0 : switch (image.getType()) {
            case 10: {
                ArrayTransformations.Rotations(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), angle, inter, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), result.getWidth(), result.getHeight());
                break;
            }
            case 11: {
                ArrayTransformations.Rotations(((DataBufferShort)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), angle, inter, ((DataBufferShort)result.getRaster().getDataBuffer()).getData(), result.getWidth(), result.getHeight());
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        ArrayTransformations.Rotations(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), angle, inter, ((DataBufferDouble)result.getRaster().getDataBuffer()).getData(), result.getWidth(), result.getHeight());
                        break block0;
                    }
                    case 4: {
                        ArrayTransformations.Rotations(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), angle, inter, ((DataBufferFloat)result.getRaster().getDataBuffer()).getData(), result.getWidth(), result.getHeight());
                        break block0;
                    }
                    case 3: {
                        ArrayTransformations.Rotations(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), angle, inter, ((DataBufferInt)result.getRaster().getDataBuffer()).getData(), result.getWidth(), result.getHeight());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage Rotate90(BufferedImage image) {
        BufferedImage result = new BufferedImage(image.getHeight(), image.getWidth(), image.getType());
        ImageTransformations.Rotate90(image, result);
        return result;
    }

    public static void Rotate90(BufferedImage image, BufferedImage result) {
        if (image.getType() != result.getType()) {
            throw new IllegalArgumentException("Images have different types.");
        }
        if (image.getWidth() != result.getHeight() || image.getHeight() != result.getWidth()) {
            throw new IllegalArgumentException("Dimensions do not match.");
        }
        switch (image.getType()) {
            case 10: {
                ArrayTransformations.Rotate90(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                ArrayTransformations.Rotate90(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 5: 
            case 6: {
                int channel = image.getRaster().getNumBands();
                BufferedImage imchan = ImageNew.Same((BufferedImage)result, (int)10);
                BufferedImage imrot = ImageNew.Same((BufferedImage)imchan);
                for (int c = 0; c < channel; ++c) {
                    ImageConverter.Channel((BufferedImage)image, (int)c, (BufferedImage)imchan);
                    ArrayTransformations.Rotate90(((DataBufferByte)imchan.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), ((DataBufferByte)imrot.getRaster().getDataBuffer()).getData());
                    ImageConverter.SetChannel((BufferedImage)imrot, (int)c, (BufferedImage)result);
                }
                imrot = null;
                imchan = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage Rotate180(BufferedImage image) {
        BufferedImage result = ImageNew.Same((BufferedImage)image);
        ImageTransformations.Rotate180(image, result);
        return result;
    }

    public static void Rotate180(BufferedImage image, BufferedImage result) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        switch (image.getType()) {
            case 10: {
                ArrayTransformations.Rotate180(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                ArrayTransformations.Rotate180(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 5: 
            case 6: {
                int channel = image.getRaster().getNumBands();
                BufferedImage imchan = ImageNew.Same((BufferedImage)result, (int)10);
                BufferedImage imrot = ImageNew.Same((BufferedImage)imchan);
                for (int c = 0; c < channel; ++c) {
                    ImageConverter.Channel((BufferedImage)image, (int)c, (BufferedImage)imchan);
                    ArrayTransformations.Rotate180(((DataBufferByte)imchan.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), ((DataBufferByte)imrot.getRaster().getDataBuffer()).getData());
                    ImageConverter.SetChannel((BufferedImage)imrot, (int)c, (BufferedImage)result);
                }
                imrot = null;
                imchan = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage Rotate270(BufferedImage image) {
        BufferedImage result = new BufferedImage(image.getHeight(), image.getWidth(), image.getType());
        ImageTransformations.Rotate270(image, result);
        return result;
    }

    public static void Rotate270(BufferedImage image, BufferedImage result) {
        if (image.getType() != result.getType()) {
            throw new IllegalArgumentException("Images have different types.");
        }
        if (image.getWidth() != result.getHeight() || image.getHeight() != result.getWidth()) {
            throw new IllegalArgumentException("Dimensions do not match.");
        }
        switch (image.getType()) {
            case 10: {
                ArrayTransformations.Rotate270(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                ArrayTransformations.Rotate270(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 5: 
            case 6: {
                int channel = image.getRaster().getNumBands();
                BufferedImage imchan = ImageNew.Same((BufferedImage)result, (int)10);
                BufferedImage imrot = ImageNew.Same((BufferedImage)imchan);
                for (int c = 0; c < channel; ++c) {
                    ImageConverter.Channel((BufferedImage)image, (int)c, (BufferedImage)imchan);
                    ArrayTransformations.Rotate270(((DataBufferByte)imchan.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), ((DataBufferByte)imrot.getRaster().getDataBuffer()).getData());
                    ImageConverter.SetChannel((BufferedImage)imrot, (int)c, (BufferedImage)result);
                }
                imrot = null;
                imchan = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static BufferedImage FlipX(BufferedImage image) {
        BufferedImage result = ImageNew.Same((BufferedImage)image);
        ImageTransformations.FlipX(image, result);
        return result;
    }

    public static void FlipX(BufferedImage image, BufferedImage result) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int channel = image.getRaster().getNumBands();
        switch (image.getType()) {
            case 5: 
            case 6: 
            case 10: {
                ArrayTransformations.FlipX(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), width * channel, height, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                ArrayTransformations.FlipX(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), width, height, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                ArrayTransformations.FlipX(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), width, height, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        ArrayTransformations.FlipX(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), width * channel, height, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                        break;
                    }
                    case 4: {
                        ArrayTransformations.FlipX(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), width * channel, height, ((DataBufferFloat)result.getRaster().getDataBuffer()).getData());
                        break;
                    }
                    case 5: {
                        ArrayTransformations.FlipX(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), width * channel, height, ((DataBufferDouble)result.getRaster().getDataBuffer()).getData());
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static BufferedImage FlipY(BufferedImage image) {
        BufferedImage result = ImageNew.Same((BufferedImage)image);
        ImageTransformations.FlipY(image, result);
        return result;
    }

    public static void FlipY(BufferedImage image, BufferedImage result) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image, (BufferedImage)result)) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        switch (image.getType()) {
            case 10: {
                ArrayTransformations.FlipY(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), width, height, ((DataBufferByte)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                ArrayTransformations.FlipY(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), width, height, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                ArrayTransformations.FlipX(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), width, height, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                if (image.getRaster().getNumBands() != 1) {
                    throw new IllegalArgumentException("Images with a single channel required.");
                }
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        ArrayTransformations.FlipX(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), width, height, ((DataBufferInt)result.getRaster().getDataBuffer()).getData());
                        break;
                    }
                    case 4: {
                        ArrayTransformations.FlipX(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), width, height, ((DataBufferFloat)result.getRaster().getDataBuffer()).getData());
                        break;
                    }
                    case 5: {
                        ArrayTransformations.FlipX(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), width, height, ((DataBufferDouble)result.getRaster().getDataBuffer()).getData());
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static BufferedImage Homothetic(BufferedImage source, double xfactor, double yfactor, double zfactor, HomotheticInterpolation Interpolation2) {
        int inter;
        switch (Interpolation2) {
            case NEAREST: {
                inter = 0;
                break;
            }
            case LINEAR: {
                inter = 1;
                break;
            }
            case CUBIC: {
                inter = 2;
                break;
            }
            case BSPLINE3: {
                inter = 3;
                break;
            }
            case OMOMS3: {
                inter = 4;
                break;
            }
            case BSPLINE5: {
                inter = 5;
                break;
            }
            default: {
                throw new Error("Unknown interpolation : " + Interpolation2);
            }
        }
        ImagePlus imp = IJInterfacor.BufferedImageToImagePlus(source);
        Image img = Image.wrap((ImagePlus)imp);
        Scale scaler = new Scale();
        Image newimg = scaler.run(img, xfactor, yfactor, zfactor, 1.0, 1.0, inter);
        ImagePlus newimp = newimg.imageplus();
        Aspects newasps = newimg.aspects();
        Calibration cal = imp.getCalibration().copy();
        scaler = null;
        cal.pixelWidth = newasps.x;
        cal.pixelHeight = newasps.y;
        cal.pixelDepth = newasps.z;
        cal.frameInterval = newasps.t;
        newimp.setCalibration(cal);
        ImageProcessor ip = imp.getProcessor();
        ImageProcessor newip = newimp.getProcessor();
        ColorModel cm = ip.getColorModel();
        newip.setColorModel(cm);
        newimp.getStack().setColorModel(cm);
        newip.setMinAndMax(ip.getMin(), ip.getMax());
        return IJInterfacor.ImageProcessorToBufferedImage(newimp.getProcessor());
    }

    public static enum HomotheticInterpolation {
        NEAREST,
        LINEAR,
        CUBIC,
        BSPLINE3,
        OMOMS3,
        BSPLINE5;

    }
}

