/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import com.mortennobel.imagescaling.ResampleFilter;
import com.mortennobel.imagescaling.ResampleFilters;
import com.mortennobel.imagescaling.ResampleOp;
import imageTiTi.IntegralImage;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;

public class ImageResampler {
    public static final int BASIC = -1;
    public static final int RANDOM = -2;
    public static final int AVERAGE = -3;
    public static final int MEDIAN = -4;
    public static final int MAXIMUM = -5;
    public static final int MINIMUM = -6;

    public static BufferedImage SubSampling(BufferedImage image, int factor, int method) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(width / factor + (width % factor != 0 ? 1 : 0), height / factor + (height % factor != 0 ? 1 : 0), image.getType());
        ImageResampler.SubSampling(image, factor, method, result);
        return result;
    }

    public static void SubSampling(BufferedImage image, int factor, int method, BufferedImage result) {
        switch (method) {
            case -1: {
                ImageResampler.SubSamplingBasic(image, factor, result);
                break;
            }
            case -2: {
                ImageResampler.SubSamplingRandom(image, factor, result);
                break;
            }
            case -3: {
                ImageResampler.SubSamplingAverage(image, factor, result);
                break;
            }
            case -4: {
                ImageResampler.SubSamplingMedian(image, factor, result);
                break;
            }
            case -5: {
                ImageResampler.SubSamplingMaximum(image, factor, result);
                break;
            }
            case -6: {
                ImageResampler.SubSamplingMinimum(image, factor, result);
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: unknown type of method (see constants).");
            }
        }
    }

    public static BufferedImage SubSamplingBasic(BufferedImage image, int factor) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(width / factor + (width % factor != 0 ? 1 : 0), height / factor + (height % factor != 0 ? 1 : 0), image.getType());
        ImageResampler.SubSamplingBasic(image, factor, result);
        return result;
    }

    public static void SubSamplingBasic(BufferedImage image, int factor, BufferedImage result) {
        if (factor <= 1) {
            throw new IllegalArgumentException("factor <= 1.");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (result.getWidth() != width / factor + (width % factor != 0 ? 1 : 0) || result.getHeight() != height / factor + (height % factor != 0 ? 1 : 0)) {
            throw new IllegalArgumentException("Wrong dimensions in result image.");
        }
        switch (image.getType()) {
            case 10: {
                byte[] bbin = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int i2 = 0;
                for (int y = 0; y < height; y += factor) {
                    int x = 0;
                    int pos = y * width;
                    while (x < width) {
                        bbout[i2] = bbin[pos];
                        x += factor;
                        ++i2;
                        pos += factor;
                    }
                }
                bbout = null;
                bbin = null;
                break;
            }
            case 11: {
                short[] sbin = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                short[] sbout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int i3 = 0;
                for (int y = 0; y < height; y += factor) {
                    int x = 0;
                    int pos = y * width;
                    while (x < width) {
                        sbout[i3] = sbin[pos];
                        x += factor;
                        ++i3;
                        pos += factor;
                    }
                }
                sbout = null;
                sbin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static BufferedImage SubSamplingRandom(BufferedImage image, int factor) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(width / factor + (width % factor != 0 ? 1 : 0), height / factor + (height % factor != 0 ? 1 : 0), image.getType());
        ImageResampler.SubSamplingRandom(image, factor, result);
        return result;
    }

    public static void SubSamplingRandom(BufferedImage image, int factor, BufferedImage result) {
        if (factor <= 1) {
            throw new IllegalArgumentException("factor <= 1.");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (result.getWidth() != width / factor + (width % factor != 0 ? 1 : 0) || result.getHeight() != height / factor + (height % factor != 0 ? 1 : 0)) {
            throw new IllegalArgumentException("Wrong dimensions in result image.");
        }
        switch (image.getType()) {
            case 10: {
                byte[] bbin = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int i2 = 0;
                for (int y = 0; y < height; y += factor) {
                    int x = 0;
                    while (x < width) {
                        int xr = x + (int)(Math.random() * (double)factor);
                        int yr = y + (int)(Math.random() * (double)factor);
                        if (width <= xr) {
                            xr = width - 1;
                        }
                        if (height <= yr) {
                            yr = height - 1;
                        }
                        bbout[i2] = bbin[yr * width + xr];
                        x += factor;
                        ++i2;
                    }
                }
                bbout = null;
                bbin = null;
                break;
            }
            case 11: {
                short[] sbin = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                short[] sbout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int i3 = 0;
                for (int y = 0; y < height; y += factor) {
                    int x = 0;
                    while (x < width) {
                        int xr = x + (int)(Math.random() * (double)factor);
                        int yr = y + (int)(Math.random() * (double)factor);
                        if (width <= xr) {
                            xr = width - 1;
                        }
                        if (height <= yr) {
                            yr = height - 1;
                        }
                        sbout[i3] = sbin[yr * width + xr];
                        x += factor;
                        ++i3;
                    }
                }
                sbout = null;
                sbin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static BufferedImage SubSamplingAverage(BufferedImage image, int factor) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(width / factor + (width % factor != 0 ? 1 : 0), height / factor + (height % factor != 0 ? 1 : 0), image.getType());
        ImageResampler.SubSamplingAverage(image, factor, result);
        return result;
    }

    public static void SubSamplingAverage(BufferedImage image, int factor, BufferedImage result) {
        if (factor <= 1) {
            throw new IllegalArgumentException("factor <= 1.");
        }
        int f2 = factor * factor;
        int width = image.getWidth();
        int height = image.getHeight();
        IntegralImage intimg = new IntegralImage(image, 5, false);
        switch (image.getType()) {
            case 10: {
                byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int i2 = 0;
                for (int y = 0; y < height; y += factor) {
                    int x = 0;
                    while (x < width) {
                        bbout[i2] = (byte)(intimg.AreaDouble(x, y, factor, factor) / (double)f2 + 0.5);
                        x += factor;
                        ++i2;
                    }
                }
                bbout = null;
                break;
            }
            case 11: {
                short[] sbout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int i3 = 0;
                for (int y = 0; y < height; y += factor) {
                    int x = 0;
                    while (x < width) {
                        sbout[i3] = (short)(intimg.AreaDouble(x, y, factor, factor) / (double)f2 + 0.5);
                        x += factor;
                        ++i3;
                    }
                }
                sbout = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static BufferedImage SubSamplingMedian(BufferedImage image, int factor) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(width / factor + (width % factor != 0 ? 1 : 0), height / factor + (height % factor != 0 ? 1 : 0), image.getType());
        ImageResampler.SubSamplingMedian(image, factor, result);
        return result;
    }

    public static void SubSamplingMedian(BufferedImage image, int factor, BufferedImage result) {
        if (factor <= 1) {
            throw new IllegalArgumentException("factor <= 1.");
        }
        int f2 = factor * factor;
        int median = f2 >> 1;
        int width = image.getWidth();
        int height = image.getHeight();
        int wf = width - factor;
        int hf = height - factor;
        int[] buffer = new int[f2];
        switch (image.getType()) {
            case 10: {
                byte[] bbin = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int i2 = 0;
                for (int y = 0; y < height; y += factor) {
                    int x = 0;
                    int pos = y * width;
                    while (x < width) {
                        int p;
                        int n;
                        int m;
                        int b;
                        if (x < wf && y < hf) {
                            b = 0;
                            for (m = 0; m < factor; ++m) {
                                n = 0;
                                p = pos + m * width;
                                while (n < factor) {
                                    buffer[b++] = bbin[p] & 0xFF;
                                    ++n;
                                    ++p;
                                }
                            }
                        } else {
                            b = 0;
                            for (m = 0; m < factor && y + m < height; ++m) {
                                n = 0;
                                p = pos + m * width;
                                while (n < factor && x + n < width) {
                                    buffer[b++] = bbin[p] & 0xFF;
                                    ++n;
                                    ++p;
                                }
                            }
                        }
                        Arrays.sort(buffer, 0, b);
                        bbout[i2] = (byte)buffer[median];
                        x += factor;
                        ++i2;
                        pos += factor;
                    }
                }
                bbout = null;
                bbin = null;
                break;
            }
            case 11: {
                short[] sbin = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                short[] sbout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int i3 = 0;
                for (int y = 0; y < height; y += factor) {
                    int x = 0;
                    int pos = y * width;
                    while (x < width) {
                        int p;
                        int n;
                        int m;
                        int b;
                        if (x < wf && y < hf) {
                            b = 0;
                            for (m = 0; m < factor; ++m) {
                                n = 0;
                                p = pos + m * width;
                                while (n < factor) {
                                    buffer[b++] = sbin[p] & 0xFFFF;
                                    ++n;
                                    ++p;
                                }
                            }
                        } else {
                            b = 0;
                            for (m = 0; m < factor && y + m < height; ++m) {
                                n = 0;
                                p = pos + m * width;
                                while (n < factor && x + n < width) {
                                    buffer[b++] = sbin[p] & 0xFFFF;
                                    ++n;
                                    ++p;
                                }
                            }
                        }
                        Arrays.sort(buffer, 0, b);
                        sbout[i3] = (short)buffer[median];
                        x += factor;
                        ++i3;
                        pos += factor;
                    }
                }
                sbout = null;
                sbin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        buffer = null;
    }

    public static BufferedImage SubSamplingMinimum(BufferedImage image, int factor) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(width / factor + (width % factor != 0 ? 1 : 0), height / factor + (height % factor != 0 ? 1 : 0), image.getType());
        ImageResampler.SubSamplingMinimum(image, factor, result);
        return result;
    }

    public static void SubSamplingMinimum(BufferedImage image, int factor, BufferedImage result) {
        if (factor <= 1) {
            throw new IllegalArgumentException("factor <= 1.");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int wf = width - factor;
        int hf = height - factor;
        switch (image.getType()) {
            case 10: {
                byte[] bbin = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int i2 = 0;
                for (int y = 0; y < height; y += factor) {
                    int x = 0;
                    int pos = y * width;
                    while (x < width) {
                        int p;
                        int n;
                        int m;
                        int min = 255;
                        if (x < wf && y < hf) {
                            for (m = 0; m < factor; ++m) {
                                n = 0;
                                p = pos + m * width;
                                while (n < factor) {
                                    if ((bbin[p] & 0xFF) < min) {
                                        min = bbin[p] & 0xFF;
                                    }
                                    ++n;
                                    ++p;
                                }
                            }
                        } else {
                            for (m = 0; m < factor && y + m < height; ++m) {
                                n = 0;
                                p = pos + m * width;
                                while (n < factor && x + n < width) {
                                    if ((bbin[p] & 0xFF) < min) {
                                        min = bbin[p] & 0xFF;
                                    }
                                    ++n;
                                    ++p;
                                }
                            }
                        }
                        bbout[i2] = (byte)min;
                        x += factor;
                        ++i2;
                        pos += factor;
                    }
                }
                bbout = null;
                bbin = null;
                break;
            }
            case 11: {
                short[] sbin = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                short[] sbout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int i3 = 0;
                for (int y = 0; y < height; y += factor) {
                    int x = 0;
                    int pos = y * width;
                    while (x < width) {
                        int p;
                        int n;
                        int m;
                        int min = 65535;
                        if (x < wf && y < hf) {
                            for (m = 0; m < factor; ++m) {
                                n = 0;
                                p = pos + m * width;
                                while (n < factor) {
                                    if ((sbin[p] & 0xFFFF) < min) {
                                        min = sbin[p] & 0xFFFF;
                                    }
                                    ++n;
                                    ++p;
                                }
                            }
                        } else {
                            for (m = 0; m < factor && y + m < height; ++m) {
                                n = 0;
                                p = pos + m * width;
                                while (n < factor && x + n < width) {
                                    if ((sbin[p] & 0xFFFF) < min) {
                                        min = sbin[p] & 0xFFFF;
                                    }
                                    ++n;
                                    ++p;
                                }
                            }
                        }
                        sbout[i3] = (short)min;
                        x += factor;
                        ++i3;
                        pos += factor;
                    }
                }
                sbout = null;
                sbin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static BufferedImage SubSamplingMaximum(BufferedImage image, int factor) {
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage result = new BufferedImage(width / factor + (width % factor != 0 ? 1 : 0), height / factor + (height % factor != 0 ? 1 : 0), image.getType());
        ImageResampler.SubSamplingMaximum(image, factor, result);
        return result;
    }

    public static void SubSamplingMaximum(BufferedImage image, int factor, BufferedImage result) {
        if (factor <= 1) {
            throw new IllegalArgumentException("factor <= 1.");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int wf = width - factor;
        int hf = height - factor;
        switch (image.getType()) {
            case 10: {
                byte[] bbin = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                byte[] bbout = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int i2 = 0;
                for (int y = 0; y < height; y += factor) {
                    int x = 0;
                    int pos = y * width;
                    while (x < width) {
                        int p;
                        int n;
                        int m;
                        int max = 0;
                        if (x < wf && y < hf) {
                            for (m = 0; m < factor; ++m) {
                                n = 0;
                                p = pos + m * width;
                                while (n < factor) {
                                    if (max < (bbin[p] & 0xFF)) {
                                        max = bbin[p] & 0xFF;
                                    }
                                    ++n;
                                    ++p;
                                }
                            }
                        } else {
                            for (m = 0; m < factor && y + m < height; ++m) {
                                n = 0;
                                p = pos + m * width;
                                while (n < factor && x + n < width) {
                                    if (max < (bbin[p] & 0xFF)) {
                                        max = bbin[p] & 0xFF;
                                    }
                                    ++n;
                                    ++p;
                                }
                            }
                        }
                        bbout[i2] = (byte)max;
                        x += factor;
                        ++i2;
                        pos += factor;
                    }
                }
                bbout = null;
                bbin = null;
                break;
            }
            case 11: {
                short[] sbin = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                short[] sbout = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                int i3 = 0;
                for (int y = 0; y < height; y += factor) {
                    int x = 0;
                    int pos = y * width;
                    while (x < width) {
                        int p;
                        int n;
                        int m;
                        int max = 0;
                        if (x < wf && y < hf) {
                            for (m = 0; m < factor; ++m) {
                                n = 0;
                                p = pos + m * width;
                                while (n < factor) {
                                    if (max < (sbin[p] & 0xFFFF)) {
                                        max = sbin[p] & 0xFFFF;
                                    }
                                    ++n;
                                    ++p;
                                }
                            }
                        } else {
                            for (m = 0; m < factor && y + m < height; ++m) {
                                n = 0;
                                p = pos + m * width;
                                while (n < factor && x + n < width) {
                                    if (max < (sbin[p] & 0xFFFF)) {
                                        max = sbin[p] & 0xFFFF;
                                    }
                                    ++n;
                                    ++p;
                                }
                            }
                        }
                        sbout[i3] = (short)max;
                        x += factor;
                        ++i3;
                        pos += factor;
                    }
                }
                sbout = null;
                sbin = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static BufferedImage Resampling(BufferedImage source, Resampler resampler, double xfactor, double yfactor) {
        BufferedImage result = new BufferedImage((int)((double)source.getWidth() * xfactor + 0.5), (int)((double)source.getHeight() * yfactor + 0.5), source.getType());
        ImageResampler.Resampling(source, resampler, result);
        return result;
    }

    public static BufferedImage Resampling(BufferedImage source, Resampler resampler, int newWidth, int newHeight) {
        BufferedImage result = new BufferedImage(newWidth, newHeight, source.getType());
        ImageResampler.Resampling(source, resampler, result);
        return result;
    }

    public static void Resampling(BufferedImage source, Resampler resampler, BufferedImage result) {
        ResampleOp op = new ResampleOp(result.getWidth(), result.getHeight());
        ResampleFilter filter = null;
        switch (resampler) {
            case BSpline: {
                filter = ResampleFilters.getBSplineFilter();
                break;
            }
            case Bell: {
                filter = ResampleFilters.getBellFilter();
                break;
            }
            case BiCubic: {
                filter = ResampleFilters.getBiCubicFilter();
                break;
            }
            case Box: {
                filter = ResampleFilters.getBoxFilter();
                break;
            }
            case Hermite: {
                filter = ResampleFilters.getHermiteFilter();
                break;
            }
            case Lanczos3: {
                filter = ResampleFilters.getLanczos3Filter();
                break;
            }
            case Mitchell: {
                filter = ResampleFilters.getMitchellFilter();
                break;
            }
            case Triangle: {
                filter = ResampleFilters.getTriangleFilter();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown resampler. Must not occur!");
            }
        }
        op.setFilter(filter);
        op.filter(source, result);
        op = null;
    }

    public static enum Resampler {
        BSpline,
        Bell,
        BiCubic,
        Box,
        Hermite,
        Lanczos3,
        Mitchell,
        Triangle;

    }
}

