/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import arrayTiTi.ArrayIO;
import displays.Display;
import ij.ImagePlus;
import ij.io.Opener;
import imageJ.IJInterfacor;
import imageJ.plugins.Converter;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import imageTiTi.ImageNew;
import imageTiTi.PgmTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import loci.common.DebugTools;
import loci.formats.FormatException;
import loci.plugins.BF;
import loci.plugins.in.ImporterOptions;
import utils.Tag;
import utils.memory.Allocator;
import utils.strings.StringTools;
import utils.strings.StringToolsImageDV;
import utils.times.Dates;

public class ImageIO {
    public static Allocator allocator = Allocator.Instance();
    public static final int FAILURE = -1;
    public static final int BMP = 0;
    public static final int EPS = 1;
    public static final int GIF = 2;
    public static final int JPG = 3;
    public static final int JPEG = 3;
    public static final int JP2 = 4;
    public static final int PGM = 5;
    public static final int PNG = 6;
    public static final int PNM = 7;
    public static final int TIFF = 8;
    public static final int TIF = 8;
    public static final int PPM = 9;
    public static final int SER = 10;
    public static final int IFF = 13;
    public static final int BigTIFF = 17;
    public static boolean verbose = true;
    public static boolean DisplayDate = true;
    public static int tag = 0;
    public static final int[][] Tag01 = new int[][]{{1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1}, {1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0}, {0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0}, {1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1}, {1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1}, {0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1}, {1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0}, {1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1}, {1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1}, {1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1}, {1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0}, {1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1}, {1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1}, {1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1}};
    public static final int[][] Tag02 = new int[][]{{1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 1}, {1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 0, 1}, {0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 1}, {1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1}, {0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1}, {0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1}, {1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1}, {0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1}, {1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0}, {1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0}, {0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1}, {1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1}, {1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0}, {0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0}, {1, 0, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0}, {1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1}, {0, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0}, {0, 1, 1, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 0}, {0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1}, {1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1}, {1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 0}, {0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0}, {0, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1}, {1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1}, {0, 1, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0}, {0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0}, {0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1}, {0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 0, 1}, {1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0, 0}, {0, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 0, 0, 1}, {1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1}, {0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 0, 0, 1}, {0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0}, {1, 1, 1, 0, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1}, {1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1}, {1, 0, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1}, {1, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0}, {1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 0, 1, 1}};

    public static BufferedImage ReadJAI(String FileName) throws IOException {
        if (FileName == null) {
            throw new NullPointerException("Empty FileName");
        }
        String Extension2 = StringToolsImageDV.FindExtension((String)FileName);
        if (Extension2 == null) {
            Extension2 = "000";
        }
        BufferedImage read = null;
        String date = DisplayDate ? Dates.DateAAAAMMJJ("/") + " " + Dates.Time(":") + " - " : "";
        switch (ImageIO.ExtensionToType(Extension2)) {
            case 0: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    if (verbose) {
                        System.out.print(date + "Reading image (JAI) '" + FileName + "'");
                        System.out.flush();
                    }
                    RenderedOp ro = JAI.create((String)"fileload", (Object)FileName);
                    BufferedImage buf = ro.getAsBufferedImage();
                    if (verbose) {
                        System.out.print(" (" + buf.getWidth() + "x" + buf.getHeight() + " <=> " + buf.getWidth() * buf.getHeight() + " pixels on " + buf.getRaster().getNumBands() + " channel" + (1 < buf.getRaster().getNumBands() ? "s" : "") + ", Type " + StringToolsImageDV.NameOfType((int)buf.getType()) + ", DataBuffer" + StringToolsImageDV.NameOfDataBufferType((int)buf.getRaster().getDataBuffer().getDataType()) + " on " + buf.getColorModel().getPixelSize() + " bits)...");
                        System.out.flush();
                    }
                    if (buf.getType() == 0 && buf.getRaster().getDataBuffer().getDataType() == 0) {
                        switch (buf.getColorModel().getPixelSize()) {
                            case 24: {
                                read = new BufferedImage(buf.getWidth(), buf.getHeight(), 5);
                                if (!verbose) break;
                                System.out.print(" converting in type 3BYTE_BGR...");
                                break;
                            }
                            case 32: {
                                read = new BufferedImage(buf.getWidth(), buf.getHeight(), 6);
                                if (!verbose) break;
                                System.out.print(" converting in type 4BYTE_ABGR...");
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Pixel size not supported (yet).");
                            }
                        }
                        read.setData(buf.getData());
                        if (verbose) {
                            System.out.println(" successfully.");
                            System.out.flush();
                        }
                        return read;
                    }
                    if (verbose) {
                        System.out.println(" successfully.");
                        System.out.flush();
                    }
                    ro.dispose();
                    ro = null;
                    return buf;
                }
                catch (Exception e) {
                    if (verbose) {
                        System.out.println("\u001b[31m FAILED! New try using BioFormat.\u001b[0m");
                        System.out.flush();
                    }
                    return ImageIO.ReadBioFormat(FileName);
                }
            }
            case 5: {
                return PgmTools.Read(FileName);
            }
            case 10: {
                return ImageIO.ReadWithImageJ(FileName);
            }
        }
        return ImageIO.ReadBioFormat(FileName);
    }

    public static BufferedImage Read(String FileName) throws IOException {
        return ImageIO.Read(new File(FileName));
    }

    public static BufferedImage Read(File FileName) throws IOException, Error {
        String date;
        if (FileName == null) {
            throw new NullPointerException();
        }
        ImageIO.CheckExistence(FileName, true);
        String Extension2 = StringToolsImageDV.FindExtension((String)FileName.getName());
        if (ImageIO.ExtensionToType(Extension2) == 5) {
            return PgmTools.Read(FileName.getAbsolutePath());
        }
        String string = date = DisplayDate ? Dates.DateAAAAMMJJ("/") + " " + Dates.Time(":") + " - " : "";
        if (verbose) {
            System.out.print(date + "Reading image '" + FileName + "'");
            System.out.flush();
        }
        BufferedImage buf = null;
        try {
            buf = javax.imageio.ImageIO.read(FileName);
        }
        catch (IIOException e) {
            if (verbose) {
                System.out.println("\u001b[31m FAILED! New try using ReadJAI.\u001b[0m");
                System.out.flush();
            }
            return ImageIO.ReadJAI(FileName.getAbsolutePath());
        }
        if (buf == null) {
            if (verbose) {
                System.out.println("\u001b[31m FAILED! New try using ReadJAI.\u001b[0m");
                System.out.flush();
            }
            return ImageIO.ReadJAI(FileName.getAbsolutePath());
        }
        if (verbose) {
            System.out.print(" (" + buf.getWidth() + "x" + buf.getHeight() + " <=> " + buf.getWidth() * buf.getHeight() + " pixels on " + buf.getRaster().getNumBands() + " channel" + (1 < buf.getRaster().getNumBands() ? "s" : "") + ", Type " + StringToolsImageDV.NameOfType((int)buf.getType()) + ", DataBuffer" + StringToolsImageDV.NameOfDataBufferType((int)buf.getRaster().getDataBuffer().getDataType()) + " on " + buf.getColorModel().getPixelSize() + " bits)...");
            System.out.flush();
        }
        if (buf.getType() == 0) {
            if (buf.getRaster().getDataBuffer().getDataType() == 4) {
                if (verbose) {
                    System.out.println("\u001b[31m Float encoding image cannot be read correctly. New try using ReadJAI.\u001b[0m");
                    System.out.flush();
                }
                return ImageIO.ReadJAI(FileName.getAbsolutePath());
            }
            if (buf.getRaster().getDataBuffer().getDataType() != 3) {
                BufferedImage read = null;
                switch (buf.getColorModel().getPixelSize()) {
                    case 24: {
                        read = new BufferedImage(buf.getWidth(), buf.getHeight(), 5);
                        if (!verbose) break;
                        System.out.print(" converting in type 3BYTE_BGR...");
                        break;
                    }
                    case 32: {
                        read = new BufferedImage(buf.getWidth(), buf.getHeight(), 6);
                        if (!verbose) break;
                        System.out.print(" converting in type 4BYTE_ABGR...");
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Pixel size not supported (yet).");
                    }
                }
                read.setData(buf.getData());
                if (verbose) {
                    System.out.println(" successfully.");
                    System.out.flush();
                }
                buf = null;
                return read;
            }
        }
        if (verbose) {
            System.out.println(" successfully.");
            System.out.flush();
        }
        return buf;
    }

    public static BufferedImage Read16BitsSpecial(String FileName) throws IOException {
        String date;
        ImageIO.CheckExistence(FileName, true);
        String string = date = DisplayDate ? Dates.DateAAAAMMJJ("/") + " " + Dates.Time(":") + " - " : "";
        if (verbose) {
            System.out.print(date + "Reading from 16BitsSpecial '" + FileName + "'");
            System.out.flush();
        }
        Opener opener = new Opener();
        ImagePlus imp = opener.openImage(FileName);
        if (verbose) {
            System.out.print(" (" + imp.getWidth() + "x" + imp.getHeight() + " <=> " + imp.getWidth() * imp.getHeight() + " pixels, Type " + StringToolsImageDV.NameOfType((int)imp.getBufferedImage().getType()) + " on " + imp.getBufferedImage().getColorModel().getPixelSize() + " bits)... converting on 8 bits...");
            System.out.flush();
        }
        Converter converter = new Converter();
        converter.convert(imp, "8-bit");
        int width = imp.getWidth();
        int height = imp.getHeight();
        BufferedImage read = new BufferedImage(width, height, 10);
        WritableRaster wr = read.getRaster();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                wr.setSample(x, y, 0, imp.getProcessor().getPixel(x, y));
            }
        }
        if (verbose) {
            System.out.println(" successfully.");
            System.out.flush();
        }
        imp = null;
        converter = null;
        opener = null;
        return read;
    }

    public static BufferedImage ReadWithImageJ(String FileName, String format) throws IOException {
        ImagePlus imp = ImageIO.ReadImagePlus(FileName);
        Converter converter = new Converter();
        converter.convert(imp, format);
        BufferedImage image = imp.getBufferedImage();
        imp = null;
        converter = null;
        return image;
    }

    public static BufferedImage ReadWithImageJ(String FileName) throws IOException {
        ImagePlus imp = ImageIO.ReadImagePlus(FileName);
        BufferedImage image = imp.getBufferedImage();
        imp = null;
        return image;
    }

    public static ImagePlus ReadImagePlus(String FileName) throws IOException {
        String date;
        ImageIO.CheckExistence(FileName, true);
        String string = date = DisplayDate ? Dates.DateAAAAMMJJ("/") + " " + Dates.Time(":") + " - " : "";
        if (verbose) {
            System.out.print(date + "Reading image (ImageJ) '" + FileName + "'");
            System.out.flush();
        }
        ImagePlus imp = null;
        if (ImageIO.ExtensionToType(StringToolsImageDV.FindExtension((String)FileName)) == 10) {
            throw new IOException("SER files not supported (yet).");
        }
        Opener opener = new Opener();
        imp = opener.openImage(FileName);
        Object var3_3 = null;
        if (imp == null) {
            throw new IOException("Unable to read '" + FileName + "'");
        }
        if (verbose) {
            System.out.println(" (" + imp.getWidth() + "x" + imp.getHeight() + " <=> " + imp.getWidth() * imp.getHeight() + " pixels on " + imp.getNChannels() + " channel" + (1 < imp.getNChannels() ? "s" : "") + ", Type " + StringToolsImageDV.NameOfType((int)imp.getBufferedImage().getType()) + ", DataBuffer" + StringToolsImageDV.NameOfDataBufferType((int)imp.getBufferedImage().getRaster().getDataBuffer().getDataType()) + " on " + imp.getBufferedImage().getColorModel().getPixelSize() + " bits)... successfully.");
            System.out.flush();
        }
        return imp;
    }

    public static BufferedImage ReadBioFormat(String FileName) throws IOException {
        String date;
        ImageIO.CheckExistence(FileName, true);
        if (ImageIO.ExtensionToType(StringToolsImageDV.FindExtension((String)FileName)) == 5) {
            return PgmTools.Read(FileName);
        }
        String string = date = DisplayDate ? Dates.DateAAAAMMJJ("/") + " " + Dates.Time(":") + " - " : "";
        if (verbose) {
            System.out.print(date + "Reading image (Bio-Format) '" + FileName + "'");
            System.out.flush();
        }
        DebugTools.enableLogging((String)"OFF");
        ImporterOptions io = new ImporterOptions();
        io.setWindowless(true);
        io.setQuiet(true);
        io.setId(FileName);
        io.setShowMetadata(false);
        ImagePlus[] images = null;
        try {
            images = BF.openImagePlus((ImporterOptions)io);
        }
        catch (FormatException e) {
            throw new IOException(e.getMessage());
        }
        if (images == null) {
            throw new IOException("Cannot read the file.");
        }
        if (images.length != 1) {
            throw new IOException("More than 1 image detected.");
        }
        int channel = images[0].getNChannels();
        BufferedImage image = IJInterfacor.ImageProcessorToBufferedImage(images[0].getProcessor());
        io = null;
        if (verbose) {
            System.out.print(" (" + image.getWidth() + "x" + image.getHeight() + " <=> " + image.getWidth() * image.getHeight() + " pixels, " + channel + " channel" + (1 < channel ? "s" : "") + " encoded with DataBuffer" + StringToolsImageDV.NameOfDataBufferType((int)image.getRaster().getDataBuffer().getDataType()) + " on " + image.getColorModel().getPixelSize() + " bits, type " + StringToolsImageDV.NameOfType((int)image.getType()) + ")...");
        }
        BufferedImage copy = null;
        block1 : switch (image.getType()) {
            case 10: {
                switch (channel) {
                    case 1: {
                        if (image.getColorModel().getColorSpace().getMaxValue(0) == 1.0f) {
                            if (verbose) {
                                System.out.print(" converting to type TYPE_BYTE_BINARY...");
                            }
                            copy = ImageNew.Same((BufferedImage)image, (int)12);
                            ImageConverter.Universal((BufferedImage)image, (BufferedImage)copy);
                            break block1;
                        }
                        copy = image;
                        break block1;
                    }
                    case 3: {
                        if (verbose) {
                            System.out.print(" merging into type 3BYTE_BGR...");
                        }
                        copy = new BufferedImage(image.getWidth(), image.getHeight(), 5);
                        byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                        byte[] bbcopy = ((DataBufferByte)copy.getRaster().getDataBuffer()).getData();
                        int x = 0;
                        int pos = 2;
                        while (x < bb.length) {
                            bbcopy[pos] = bb[x];
                            ++x;
                            pos += channel;
                        }
                        bb = (byte[])images[0].getStack().getProcessor(2).getPixels();
                        x = 0;
                        pos = 1;
                        while (x < bb.length) {
                            bbcopy[pos] = bb[x];
                            ++x;
                            pos += channel;
                        }
                        bb = (byte[])images[0].getStack().getProcessor(3).getPixels();
                        x = 0;
                        pos = 0;
                        while (x < bb.length) {
                            bbcopy[pos] = bb[x];
                            ++x;
                            pos += channel;
                        }
                        bbcopy = null;
                        bb = null;
                        break block1;
                    }
                    case 4: {
                        if (verbose) {
                            System.out.print(" merging into type 4BYTE_ABGR...");
                        }
                        copy = new BufferedImage(image.getWidth(), image.getHeight(), 6);
                        byte[] bb4 = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                        byte[] bbcopy4 = ((DataBufferByte)copy.getRaster().getDataBuffer()).getData();
                        int x = 0;
                        int pos = 3;
                        while (x < bb4.length) {
                            bbcopy4[pos] = bb4[x];
                            ++x;
                            pos += channel;
                        }
                        bb4 = (byte[])images[0].getStack().getProcessor(2).getPixels();
                        x = 0;
                        pos = 2;
                        while (x < bb4.length) {
                            bbcopy4[pos] = bb4[x];
                            ++x;
                            pos += channel;
                        }
                        bb4 = (byte[])images[0].getStack().getProcessor(3).getPixels();
                        x = 0;
                        pos = 1;
                        while (x < bb4.length) {
                            bbcopy4[pos] = bb4[x];
                            ++x;
                            pos += channel;
                        }
                        bb4 = (byte[])images[0].getStack().getProcessor(4).getPixels();
                        x = 0;
                        pos = 0;
                        while (x < bb4.length) {
                            bbcopy4[pos] = bb4[x];
                            ++x;
                            pos += channel;
                        }
                        bbcopy4 = null;
                        bb4 = null;
                        break block1;
                    }
                }
                throw new IllegalStateException("Number of channel not supported.");
            }
            case 11: {
                switch (channel) {
                    case 1: {
                        if (image.getColorModel().getColorSpace().getMaxValue(0) == 1.0f) {
                            if (verbose) {
                                System.out.print(" converting to type TYPE_USHORT_GRAY...");
                            }
                            copy = ImageNew.Same((BufferedImage)image, (int)11);
                            ImageConverter.Universal((BufferedImage)image, (BufferedImage)copy);
                            break block1;
                        }
                        copy = image;
                        break block1;
                    }
                }
                copy = ImageNew.Short((int)image.getWidth(), (int)image.getHeight(), (int)channel, (boolean)true);
                for (int c = 0; c < channel; ++c) {
                    ImageNew.Copy((BufferedImage)IJInterfacor.ImageProcessorToBufferedImage(images[0].getImageStack().getProcessor(c + 1)), (BufferedImage)copy, (int)c);
                }
                break;
            }
            case 2: {
                if (verbose) {
                    System.out.print(" converting to type 4BYTE_ABGR...");
                }
                copy = ImageNew.Same((BufferedImage)image, (int)6);
                ImageConverter.IntToByte((BufferedImage)image, (BufferedImage)copy);
                break;
            }
            case 1: 
            case 4: {
                if (verbose) {
                    System.out.print(" converting to type 3BYTE_BGR...");
                }
                copy = ImageNew.Same((BufferedImage)image, (int)5);
                ImageConverter.IntToByte((BufferedImage)image, (BufferedImage)copy);
                break;
            }
            case 13: {
                channel = image.getRaster().getNumBands();
                switch (channel) {
                    case 1: {
                        float max = 0.0f;
                        for (int i2 = 0; i2 < image.getColorModel().getColorSpace().getNumComponents(); ++i2) {
                            max = Math.max(max, image.getColorModel().getColorSpace().getMaxValue(i2));
                        }
                        if (max == 1.0f) {
                            if (verbose) {
                                System.out.print(" converting to type TYPE_BYTE_BINARY...");
                            }
                            copy = ImageNew.Same((BufferedImage)image, (int)12);
                            break;
                        }
                        if (verbose) {
                            System.out.print(" converting to type TYPE_BYTE_GRAY...");
                        }
                        copy = ImageNew.Same((BufferedImage)image, (int)10);
                        break;
                    }
                    case 3: {
                        if (verbose) {
                            System.out.print(" converting to type 3BYTE_BGR...");
                        }
                        copy = ImageNew.Same((BufferedImage)image, (int)5);
                        break;
                    }
                    case 4: {
                        if (verbose) {
                            System.out.print(" converting to type TYPE_4BYTE_ABGR...");
                        }
                        copy = ImageNew.Same((BufferedImage)image, (int)6);
                        break;
                    }
                    default: {
                        throw new IOException("TYPE_BYTE_INDEXED image, and number of channels/bands not supported.");
                    }
                }
                ImageConverter.Universal((BufferedImage)image, (BufferedImage)copy);
                break;
            }
            default: {
                copy = image;
            }
        }
        if (verbose) {
            System.out.println(" successfully.");
            System.out.flush();
        }
        images[0] = null;
        image = null;
        return copy;
    }

    public static void WriteJAI(BufferedImage image, String FileName, int Format2) throws IOException {
        String Extension2 = null;
        switch (Format2) {
            case 0: {
                Extension2 = "BMP";
                break;
            }
            case 3: {
                Extension2 = "JPEG";
                break;
            }
            case 5: {
                Extension2 = "PGM";
                break;
            }
            case 6: {
                Extension2 = "PNG";
                break;
            }
            case 7: {
                Extension2 = "PNM";
                break;
            }
            case 8: {
                Extension2 = "TIFF";
                break;
            }
            default: {
                throw new IllegalArgumentException("Format not supported.");
            }
        }
        ImageIO.WriteJAI(image, FileName, Extension2);
    }

    public static void WriteJAI(BufferedImage image, String FileName, String Format2) throws IOException {
        if (verbose) {
            String date = DisplayDate ? Dates.DateAAAAMMJJ("/") + " " + Dates.Time(":") + " - " : "";
            System.out.print(date + "Writing image (JAI) '" + FileName + "'... (" + image.getWidth() + "x" + image.getHeight() + " <=> " + image.getWidth() * image.getHeight() + " pixels on " + image.getRaster().getNumBands() + " channel" + (1 < image.getRaster().getNumBands() ? "s" : "") + ", Type " + StringToolsImageDV.NameOfType((int)image.getType()) + ", DataBuffer" + StringToolsImageDV.NameOfDataBufferType((int)image.getRaster().getDataBuffer().getDataType()) + " on " + image.getColorModel().getPixelSize() + " bits)...");
            System.out.flush();
        }
        switch (Format2) {
            case "BMP": 
            case "JPG": 
            case "PNG": 
            case "PNM": 
            case "TIFF": {
                JAI.create((String)"filestore", (RenderedImage)image, (Object)FileName, (Object)Format2);
                break;
            }
            case "bmp": 
            case "jpg": 
            case "png": 
            case "pnm": 
            case "tiff": {
                JAI.create((String)"filestore", (RenderedImage)image, (Object)FileName, (Object)Format2.toUpperCase());
                break;
            }
            case "tif": 
            case "TIF": {
                JAI.create((String)"filestore", (RenderedImage)image, (Object)FileName, (Object)"TIFF");
                break;
            }
            case "pgm": 
            case "PGM": {
                PgmTools.Write(FileName, image);
                break;
            }
            default: {
                throw new IllegalArgumentException("Format not supported.");
            }
        }
        if (verbose) {
            System.out.println(" successfully.");
            System.out.flush();
        }
    }

    public static void Write(BufferedImage image, String FileName, int Format2) throws IOException {
        String Extension2;
        switch (Format2) {
            case 17: {
                Extension2 = "BigTIFF";
                break;
            }
            case 0: {
                Extension2 = "BMP";
                break;
            }
            case 2: {
                Extension2 = "GIF";
                break;
            }
            case 13: {
                Extension2 = "IFF";
                break;
            }
            case 3: {
                Extension2 = "JPEG";
                break;
            }
            case 5: {
                Extension2 = "PGM";
                break;
            }
            case 6: {
                Extension2 = "PNG";
                break;
            }
            case 7: {
                Extension2 = "PNM";
                break;
            }
            case 8: {
                Extension2 = "TIFF";
                break;
            }
            default: {
                throw new IllegalArgumentException("Format not supported.");
            }
        }
        File filename = new File(FileName);
        ImageIO.Write(image, filename, Extension2);
        filename = null;
    }

    public static void Write(BufferedImage image, File FileName, String Format2) throws IOException {
        System.out.flush();
        if (0 < tag) {
            boolean success = Tag.Tag(image, Tag02, tag, true);
            if (!(success &= Tag.Tag(image, Tag01, tag, false))) {
                System.out.println("\u001b[31mFailed tagging '" + FileName.getAbsolutePath() + "'\u001b[0m");
            }
        }
        if (verbose) {
            String date = DisplayDate ? Dates.DateAAAAMMJJ("/") + " " + Dates.Time(":") + " - " : "";
            System.out.print(date + "Writing image '" + FileName + "' (" + image.getWidth() + "x" + image.getHeight() + " <=> " + image.getWidth() * image.getHeight() + " pixels on " + image.getRaster().getNumBands() + " channel" + (1 < image.getRaster().getNumBands() ? "s" : "") + ", Type " + StringToolsImageDV.NameOfType((int)image.getType()) + ", DataBuffer" + StringToolsImageDV.NameOfDataBufferType((int)image.getRaster().getDataBuffer().getDataType()) + " on " + image.getColorModel().getPixelSize() + " bits)...");
            System.out.flush();
        }
        boolean ok = true;
        try {
            if (StringTools.StrCmp(Format2, "pgm") || StringTools.StrCmp(Format2, "PGM")) {
                PgmTools.Write(FileName.getAbsolutePath(), image);
            } else {
                ok = javax.imageio.ImageIO.write((RenderedImage)image, Format2, FileName);
            }
        }
        catch (IllegalArgumentException e) {
            System.out.println("\u001b[31m failed! New try using JAI.\u001b[0m");
            System.out.flush();
            ImageIO.WriteJAI(image, FileName.getAbsolutePath(), Format2);
            return;
        }
        if (!ok) {
            System.out.println("\u001b[31m failed! New try using JAI.\u001b[0m");
            System.out.flush();
            ImageIO.WriteJAI(image, FileName.getAbsolutePath(), Format2);
            return;
        }
        if (verbose) {
            System.out.println(" successfully.");
            System.out.flush();
        }
    }

    public static BufferedImage LoadLabels(String path) throws IOException {
        Allocator allocator = Allocator.Instance();
        if (path.endsWith(".png") || path.endsWith(".PNG") || path.endsWith(".tif") || path.endsWith(".tiff") || path.endsWith(".TIF") || path.endsWith(".TIFF")) {
            throw new IllegalArgumentException("Do not add image extension in path.");
        }
        File png = new File(path + ".png");
        File tif = new File(path + ".tif");
        File tiff = new File(path + ".tiff");
        int count = (png.exists() ? 1 : 0) + (tif.exists() ? 1 : 0) + (tiff.exists() ? 1 : 0);
        switch (count) {
            case 0: {
                throw new IOException("No label image found (neither PNG nor TIF/TIFF) for: '" + path + "'.");
            }
            case 1: {
                break;
            }
            default: {
                throw new IOException("Ambiguous: more than one labels image (PNG, TIF, and TIFF) have been found for: '" + path + "'.");
            }
        }
        if (png.exists()) {
            BufferedImage image = ImageIO.Read(png);
            BufferedImage custom = ImageConverter.ToCustomInt((BufferedImage)image);
            image = allocator.Release(image);
            return custom;
        }
        BufferedImage image = ImageIO.Read(tif.exists() ? tif : tiff);
        switch (image.getType()) {
            case 10: 
            case 11: {
                BufferedImage custom = ImageConverter.ToCustomInt((BufferedImage)image);
                image = allocator.Release(image);
                return custom;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        return image;
                    }
                    case 4: {
                        BufferedImage custom = ImageConverter.ToCustomInt((BufferedImage)image);
                        image = allocator.Release(image);
                        return custom;
                    }
                }
                throw new IOException("DataBuffer encoding not supported for label image.");
            }
        }
        throw new IOException("Image type not supported (yet) for label image.");
    }

    public static void SaveLabels(BufferedImage image, String path) throws IOException {
        ImageFeatures IF = new ImageFeatures();
        int max = (int)IF.Maximum(image);
        ImageIO.SaveLabels(image, max, path);
    }

    public static void SaveLabels(BufferedImage image, int max, String path) throws IOException {
        if (path.endsWith(".png") || path.endsWith(".PNG") || path.endsWith(".tif") || path.endsWith(".tiff") || path.endsWith(".TIF") || path.endsWith(".TIFF")) {
            throw new IllegalArgumentException("Do not add image extension in path.");
        }
        if (max < 256) {
            BufferedImage converted = ImageConverter.IntToByte((BufferedImage)image);
            ImageIO.Write(converted, path + ".png", 6);
            converted = allocator.Release(converted);
        } else if (max < 65536) {
            BufferedImage converted = ImageConverter.IntToShort((BufferedImage)image);
            ImageIO.Write(converted, path + ".png", 6);
            BufferedImage bufferedImage = allocator.Release(converted);
        } else if (9.61E8 < (double)(image.getWidth() * image.getHeight())) {
            ImageIO.Write(image, path + ".tiff", 17);
        } else {
            ImageIO.Write(image, path + ".tif", 8);
        }
    }

    public static void Display(String imagesfolder, Display display, FilenameFilter fnf) throws IOException {
        File[] images = new File(imagesfolder).listFiles();
        for (int i2 = 0; i2 < images.length; ++i2) {
            if (fnf != null && !fnf.accept(null, images[i2].getName())) continue;
            if (images[i2].getName().contains(".ser")) {
                display.Image(ImageIO.ReadImagePlus(images[i2].getAbsolutePath()).getBufferedImage(), images[i2].getName(), 1.0);
                continue;
            }
            display.Image(ImageIO.Read(images[i2].getAbsolutePath()), images[i2].getName(), 1.0);
        }
    }

    public static void Display(BufferedImage image, String name, String separator) {
        block0 : switch (image.getType()) {
            case 10: {
                ArrayIO.DisplayUnsigned(((DataBufferByte)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), name, separator);
                break;
            }
            case 11: {
                ArrayIO.DisplayUnsigned(((DataBufferUShort)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), name, separator);
                break;
            }
            case 5: {
                byte[] bb3 = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < image.getHeight(); ++y) {
                    for (int x = 0; x < image.getWidth(); ++x) {
                        System.out.print("(" + (bb3[pos++] & 0xFF) + ",");
                        System.out.print((bb3[pos++] & 0xFF) + ",");
                        System.out.print((bb3[pos++] & 0xFF) + ")" + separator);
                    }
                    System.out.println();
                }
                bb3 = null;
                break;
            }
            case 6: {
                byte[] bb4 = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                for (int y = 0; y < image.getHeight(); ++y) {
                    for (int x = 0; x < image.getWidth(); ++x) {
                        System.out.print("(" + (bb4[pos++] & 0xFF) + ",");
                        System.out.print((bb4[pos++] & 0xFF) + ",");
                        System.out.print((bb4[pos++] & 0xFF) + ",");
                        System.out.print((bb4[pos++] & 0xFF) + ")" + separator);
                    }
                    System.out.println();
                }
                bb4 = null;
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        ArrayIO.Display(((DataBufferInt)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), name, separator);
                        break block0;
                    }
                    case 4: {
                        ArrayIO.Display(((DataBufferFloat)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), name, separator);
                        break block0;
                    }
                    case 5: {
                        ArrayIO.Display(((DataBufferDouble)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), name, separator);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static void Crop(String dirsrc, FilenameFilter fnf, int sx, int sy, int width, int height, String dirdest) throws IOException {
        Object[] images = new File(dirsrc).listFiles(fnf);
        if (images == null) {
            throw new IllegalArgumentException("No images found.");
        }
        Arrays.sort(images);
        File out = new File(dirdest);
        if (!out.exists()) {
            out.mkdirs();
        } else if (!out.isDirectory()) {
            throw new IllegalArgumentException("The destination file is not a directory.");
        }
        for (Object image : images) {
            BufferedImage im = ImageIO.Read(((File)image).getAbsoluteFile());
            BufferedImage crop = ImageNew.SubImageWH((BufferedImage)im, (int)sx, (int)sy, (int)width, (int)height);
            String ext = StringToolsImageDV.FindExtension((String)((File)image).getName());
            ImageIO.Write(crop, out.getAbsolutePath() + "/" + ((File)image).getName(), ImageIO.ExtensionToType(ext));
            im = null;
            crop = null;
            ext = null;
        }
        images = null;
        out = null;
    }

    public static FilenameFilter ReadableImages() {
        return (arg0, name) -> ImageIO.ReadableImage(name);
    }

    public static boolean ReadableImage(String name) {
        String ext = StringToolsImageDV.FindExtension((String)name);
        if (ext == null) {
            throw new IllegalArgumentException("Any extension found.");
        }
        switch (ImageIO.ExtensionToType(ext)) {
            case 0: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public static int ExtensionToType(String s) {
        if (StringTools.StrCmp(s, "bmp") || StringTools.StrCmp(s, "BMP")) {
            return 0;
        }
        if (StringTools.StrCmp(s, "eps") || StringTools.StrCmp(s, "EPS")) {
            return 1;
        }
        if (StringTools.StrCmp(s, "gif") || StringTools.StrCmp(s, "GIF")) {
            return 2;
        }
        if (StringTools.StrCmp(s, "jpg") || StringTools.StrCmp(s, "JPG")) {
            return 3;
        }
        if (StringTools.StrCmp(s, "jpeg") || StringTools.StrCmp(s, "JPEG")) {
            return 3;
        }
        if (StringTools.StrCmp(s, "jp2") || StringTools.StrCmp(s, "JP2")) {
            return 4;
        }
        if (StringTools.StrCmp(s, "pgm") || StringTools.StrCmp(s, "PGM")) {
            return 5;
        }
        if (StringTools.StrCmp(s, "ppm") || StringTools.StrCmp(s, "PPM")) {
            return 9;
        }
        if (StringTools.StrCmp(s, "png") || StringTools.StrCmp(s, "PNG")) {
            return 6;
        }
        if (StringTools.StrCmp(s, "pnm") || StringTools.StrCmp(s, "PNM")) {
            return 7;
        }
        if (StringTools.StrCmp(s, "tiff") || StringTools.StrCmp(s, "TIFF")) {
            return 8;
        }
        if (StringTools.StrCmp(s, "tif") || StringTools.StrCmp(s, "TIF")) {
            return 8;
        }
        if (StringTools.StrCmp(s, "ser") || StringTools.StrCmp(s, "SER")) {
            return 10;
        }
        return -1;
    }

    public static String TypeToExtension(int Type2) {
        switch (Type2) {
            case 0: {
                return "bmp";
            }
            case 1: {
                return "eps";
            }
            case 2: {
                return "gif";
            }
            case 13: {
                return "iff";
            }
            case 3: {
                return "jpg";
            }
            case 4: {
                return "jp2";
            }
            case 5: {
                return "pgm";
            }
            case 9: {
                return "ppm";
            }
            case 6: {
                return "png";
            }
            case 7: {
                return "pnm";
            }
            case 8: {
                return "tif";
            }
            case 10: {
                return "ser";
            }
        }
        throw new IllegalArgumentException("Default: undefined type.");
    }

    public static String Description(BufferedImage image) {
        return image.getWidth() + "x" + image.getHeight() + " <=> " + image.getWidth() * image.getHeight() + " pixels on " + image.getRaster().getNumBands() + " channel" + (1 < image.getRaster().getNumBands() ? "s" : "") + ", Type " + StringToolsImageDV.NameOfType((int)image.getType()) + ", DataBuffer" + StringToolsImageDV.NameOfDataBufferType((int)image.getRaster().getDataBuffer().getDataType()) + " on " + image.getColorModel().getPixelSize() + " bits";
    }

    private static boolean CheckExistence(String path, boolean Throw) throws IOException {
        return ImageIO.CheckExistence(new File(path), Throw);
    }

    private static boolean CheckExistence(File file, boolean Throw) throws IOException {
        if (file.exists()) {
            return true;
        }
        if (Throw) {
            throw new IOException("File '" + file.getAbsolutePath() + "' does not exists.");
        }
        return false;
    }
}

