/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import filesAndFolders.FilesFolders;
import ij.ImagePlus;
import ij.io.FileSaver;
import imageTiTi.ImageIO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import listTiTi.ListTools;
import utils.strings.StringToolsImageDV;

public class ImageFileConverter {
    FileSaver fs = null;

    public boolean Convert(String source, String destination, String Type2) throws FileNotFoundException, IOException {
        return this.Convert(source, destination, ImageIO.ExtensionToType(Type2));
    }

    public boolean Convert(String source, String destination, int Type2) throws FileNotFoundException, IOException {
        String dest = null;
        System.out.print(source + " " + destination + " => ");
        String path = StringToolsImageDV.FindPath((String)source);
        String name = StringToolsImageDV.FindName((String)source);
        String ext = ImageIO.TypeToExtension(Type2);
        System.out.println(path == null || name == null || ext == null);
        if (path == null || name == null || ext == null) {
            return false;
        }
        dest = destination == null ? path : destination;
        ImageIO.Write(ImageIO.Read(source), dest + "/" + name + "." + ext, Type2);
        ext = null;
        name = null;
        path = null;
        return true;
    }

    public boolean ConvertFrom16BitsSpecial(String source, String destination, String Type2) throws FileNotFoundException, IOException {
        return this.ConvertFrom16BitsSpecial(source, destination, ImageIO.ExtensionToType(Type2));
    }

    public boolean ConvertFrom16BitsSpecial(String source, String destination, int Type2) throws FileNotFoundException, IOException {
        String dest = null;
        String path = StringToolsImageDV.FindPath((String)source);
        String name = StringToolsImageDV.FindName((String)source);
        String ext = ImageIO.TypeToExtension(Type2);
        if (path == null || name == null || ext == null) {
            return false;
        }
        dest = destination == null ? path : destination;
        ImageIO.Write(ImageIO.Read16BitsSpecial(source), dest + "/" + name + "." + ext, Type2);
        ext = null;
        name = null;
        path = null;
        return true;
    }

    public boolean ConvertUsingImageJ(String source, String destination, String Type2) throws FileNotFoundException, IOException {
        return this.ConvertUsingImageJ(source, destination, ImageIO.ExtensionToType(Type2));
    }

    public boolean ConvertUsingImageJ(String source, String destination, int Type2) throws FileNotFoundException, IOException {
        String dest = null;
        String path = StringToolsImageDV.FindPath((String)source);
        String name = StringToolsImageDV.FindName2((String)source);
        String ext = ImageIO.TypeToExtension(Type2);
        dest = destination == null ? path : destination;
        ImagePlus imp = ImageIO.ReadImagePlus(source);
        if (this.fs == null) {
            this.fs = new FileSaver(imp);
        }
        this.fs.saveAsPng(dest + "/" + name + "." + ext);
        ext = null;
        name = null;
        path = null;
        return true;
    }

    public boolean ConvertFolder(String source, String destination, List<String> extensions, int Type2) throws FileNotFoundException, IOException {
        boolean res = true;
        File[] folder = new File(source).listFiles();
        for (int i2 = 0; i2 < folder.length; ++i2) {
            String ext = StringToolsImageDV.FindExtension((String)folder[i2].getName());
            if (ext == null || !ListTools.isInList(extensions, (String)ext)) continue;
            res &= this.Convert(folder[i2].getAbsolutePath(), destination, Type2);
        }
        folder = null;
        return res;
    }

    public boolean ConvertFolderUsingImageJ(String source, String destination, List<String> extensions, int Type2) throws FileNotFoundException, IOException {
        boolean res = true;
        File[] folder = new File(source).listFiles();
        for (int i2 = 0; i2 < folder.length; ++i2) {
            String ext = StringToolsImageDV.FindExtension((String)folder[i2].getName());
            if (ext == null || !ListTools.isInList(extensions, (String)ext)) continue;
            res &= this.ConvertUsingImageJ(folder[i2].getAbsolutePath(), destination, Type2);
        }
        folder = null;
        return res;
    }

    public boolean ConvertFolderUsingImageJ(String source, String destination, FilenameFilter fnf, int Type2) throws FileNotFoundException, IOException {
        boolean res = true;
        File[] folder = new File(source).listFiles(fnf);
        if (folder == null) {
            return false;
        }
        for (int i2 = 0; i2 < folder.length; ++i2) {
            res &= this.ConvertUsingImageJ(folder[i2].getAbsolutePath(), destination, Type2);
        }
        folder = null;
        return res;
    }

    public boolean ConvertAndDelete(String source, String destination, String Type2) throws FileNotFoundException, IOException {
        return this.ConvertAndDelete(source, destination, ImageIO.ExtensionToType(Type2));
    }

    public boolean ConvertAndDelete(String source, String destination, int Type2) throws FileNotFoundException, IOException {
        String dest = null;
        dest = destination == null ? "" : destination;
        ImageIO.Write(ImageIO.Read(source), StringToolsImageDV.FindPath((String)source) + "/" + dest + "/" + StringToolsImageDV.FindName((String)source) + "." + ImageIO.TypeToExtension(Type2), Type2);
        FilesFolders.Delete(new File(source));
        return true;
    }
}

