/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import arrayTiTi.ArrayFeatures;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import mathematics.metrics.Euclidian;

public class ImageFeaturesWindow {
    public static int Integral = 0;
    public static int Size = 0;
    public static double Average = 0.0;
    public static double Variance = 0.0;
    public static double StandardDeviation = 0.0;
    public static double Kurtosis = 0.0;
    public static double Skewness = 0.0;

    public static int Counter(BufferedImage source, int minx, int miny, int maxx, int maxy, int ForbiddenValue) {
        int width = source.getWidth();
        Size = 0;
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                for (int y = miny; y <= maxy; ++y) {
                    for (int x = minx; x <= maxx; ++x) {
                        if (wr.getSample(x, y, 0) == ForbiddenValue) continue;
                        ++Size;
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx;
                    while (x <= maxx) {
                        if ((bytebuffer[pos] & 0xFF) != ForbiddenValue) {
                            ++Size;
                        }
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx;
                    while (x <= maxx) {
                        if ((shortbuffer[pos] & 0xFFFF) != ForbiddenValue) {
                            ++Size;
                        }
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not yet implemented for this type of image.");
            }
        }
        return Size;
    }

    public static int Integral(BufferedImage source, int minx, int miny, int maxx, int maxy) {
        return ImageFeaturesWindow.Sum(source, minx, miny, maxx, maxy);
    }

    public static int Sum(BufferedImage source, int minx, int miny, int maxx, int maxy) {
        int width = source.getWidth();
        Integral = 0;
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                for (int y = miny; y <= maxy; ++y) {
                    for (int x = minx; x <= maxx; ++x) {
                        Integral += wr.getSample(x, y, 0);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx;
                    while (x <= maxx) {
                        Integral += bytebuffer[pos] & 0xFF;
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int pos = posori;
                    int x = minx;
                    while (x <= maxx) {
                        Integral += shortbuffer[pos] & 0xFFFF;
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                shortbuffer = null;
                break;
            }
            case 5: 
            case 6: {
                int channel = source.getRaster().getNumBands();
                int widthchannel = width * channel;
                byte[] bytebuffercolor = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int y = miny;
                int posori = miny * widthchannel;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx * channel;
                    while (x <= maxx) {
                        for (int c = 0; c < channel; ++c) {
                            Integral += bytebuffercolor[pos + c] & 0xFF;
                        }
                        ++x;
                        pos += channel;
                    }
                    ++y;
                    posori += widthchannel;
                }
                bytebuffercolor = null;
                break;
            }
            case 1: 
            case 4: {
                WritableRaster wr = source.getRaster();
                for (int y = miny; y <= maxy; ++y) {
                    for (int x = minx; x <= maxx; ++x) {
                        Integral += wr.getSample(x, y, 0) + wr.getSample(x, y, 1) + wr.getSample(x, y, 2);
                    }
                }
                wr = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not yet implemented for this type of image.");
            }
        }
        return Integral;
    }

    public static int Integral(BufferedImage source, int minx, int miny, int maxx, int maxy, int ForbiddenValue) {
        return ImageFeaturesWindow.Sum(source, minx, miny, maxx, maxy, ForbiddenValue);
    }

    public static int Sum(BufferedImage source, int minx, int miny, int maxx, int maxy, int ForbiddenValue) {
        int width = source.getWidth();
        Integral = 0;
        switch (source.getType()) {
            case 12: {
                WritableRaster wr = source.getRaster();
                for (int y = miny; y <= maxy; ++y) {
                    for (int x = minx; x <= maxx; ++x) {
                        if (wr.getSample(x, y, 0) == ForbiddenValue) continue;
                        Integral += wr.getSample(x, y, 0);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx;
                    while (x <= maxx) {
                        if ((bytebuffer[pos] & 0xFF) != ForbiddenValue) {
                            Integral += bytebuffer[pos] & 0xFF;
                        }
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int pos = posori;
                    int x = minx;
                    while (x <= maxx) {
                        if ((shortbuffer[pos] & 0xFFFF) != ForbiddenValue) {
                            Integral += shortbuffer[pos] & 0xFFFF;
                        }
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                shortbuffer = null;
                break;
            }
            case 5: 
            case 6: {
                int channel = source.getRaster().getNumBands();
                int widthchannel = width * channel;
                byte[] bytebuffercolor = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int y = miny;
                int posori = miny * widthchannel;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx * channel;
                    while (x <= maxx) {
                        for (int c = 0; c < channel; ++c) {
                            if ((bytebuffercolor[pos + c] & 0xFF) == ForbiddenValue) continue;
                            Integral += bytebuffercolor[pos + c] & 0xFF;
                        }
                        ++x;
                        pos += channel;
                    }
                    ++y;
                    posori += widthchannel;
                }
                bytebuffercolor = null;
                break;
            }
            case 1: 
            case 4: {
                WritableRaster wr = source.getRaster();
                for (int y = miny; y <= maxy; ++y) {
                    for (int x = minx; x <= maxx; ++x) {
                        Integral += wr.getSample(x, y, 0) + wr.getSample(x, y, 1) + wr.getSample(x, y, 2);
                    }
                }
                wr = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not yet implemented for this type of image.");
            }
        }
        return Integral;
    }

    public static double Average(BufferedImage image, int minx, int miny, int maxx, int maxy) {
        Integral = ImageFeaturesWindow.Sum(image, minx, miny, maxx, maxy);
        Size = image.getWidth() * image.getHeight();
        return (double)Integral / (double)Size;
    }

    public static double Average(BufferedImage image, int minx, int miny, int maxx, int maxy, int ForbiddenValue) {
        Integral = ImageFeaturesWindow.Integral(image, minx, miny, maxx, maxy, ForbiddenValue);
        Size = ImageFeaturesWindow.Counter(image, minx, miny, maxx, maxy, ForbiddenValue);
        return (double)Integral / (double)Size;
    }

    public static void Compute(BufferedImage source, int minx, int miny, int maxx, int maxy, int ForbiddenValue) {
        if (!ImageTools.isGrayLevel((BufferedImage)source)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        Average = ImageFeaturesWindow.Average(source, minx, miny, maxx, maxy, ForbiddenValue);
        int width = source.getWidth();
        Variance = 0.0;
        Kurtosis = 0.0;
        Skewness = 0.0;
        switch (source.getType()) {
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx;
                    while (x <= maxx) {
                        int v = bytebuffer[pos] & 0xFF;
                        if (v != ForbiddenValue) {
                            Variance += Math.pow((double)v - Average, 2.0);
                            Skewness += Math.pow((double)v - Average, 3.0);
                            Kurtosis += Math.pow((double)v - Average, 4.0);
                        }
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx;
                    while (x <= maxx) {
                        int v = shortbuffer[pos] & 0xFFFF;
                        if (v != ForbiddenValue) {
                            Variance += Math.pow((double)v - Average, 2.0);
                            Skewness += Math.pow((double)v - Average, 3.0);
                            Kurtosis += Math.pow((double)v - Average, 4.0);
                        }
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not yet implemented for this type of image.");
            }
        }
        Skewness /= (double)Size;
        Kurtosis /= (double)Size;
        Skewness /= Math.pow(Variance /= (double)Size, 3.0);
        Kurtosis /= Math.pow(Variance, 4.0);
        StandardDeviation = Math.sqrt(Variance);
    }

    public static void Compute(BufferedImage source, int minx, int miny, int maxx, int maxy) {
        if (!ImageTools.isGrayLevel((BufferedImage)source)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        Average = ImageFeaturesWindow.Average(source, minx, miny, maxx, maxy);
        int width = source.getWidth();
        Variance = 0.0;
        Kurtosis = 0.0;
        Skewness = 0.0;
        switch (source.getType()) {
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx;
                    while (x <= maxx) {
                        int v = bytebuffer[pos] & 0xFF;
                        Variance += Math.pow((double)v - Average, 2.0);
                        Skewness += Math.pow((double)v - Average, 3.0);
                        Kurtosis += Math.pow((double)v - Average, 4.0);
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx;
                    while (x <= maxx) {
                        int v = shortbuffer[pos] & 0xFFFF;
                        Variance += Math.pow((double)v - Average, 2.0);
                        Skewness += Math.pow((double)v - Average, 3.0);
                        Kurtosis += Math.pow((double)v - Average, 4.0);
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not yet implemented for this type of image.");
            }
        }
        Skewness /= (double)Size;
        Kurtosis /= (double)Size;
        Skewness /= Math.pow(Variance /= (double)Size, 3.0);
        Kurtosis /= Math.pow(Variance, 4.0);
    }

    public static int Minimum(BufferedImage source, int minx, int miny, int maxx, int maxy) {
        int min;
        if (!ImageTools.isGrayLevel((BufferedImage)source)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        int width = source.getWidth();
        switch (source.getType()) {
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                min = bytebuffer[miny * width + minx] & 0xFF;
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx;
                    while (x <= maxx) {
                        if ((bytebuffer[pos] & 0xFF) < min) {
                            min = bytebuffer[pos] & 0xFF;
                        }
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                min = shortbuffer[miny * width + minx] & 0xFFFF;
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx;
                    while (x <= maxx) {
                        if ((shortbuffer[pos] & 0xFFFF) < min) {
                            min = shortbuffer[pos] & 0xFFFF;
                        }
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not yet implemented for this type of image.");
            }
        }
        return min;
    }

    public static int Minimum(BufferedImage image, int X, int Y, double radius) {
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        Euclidian metric = new Euclidian();
        WritableRaster wr = image.getRaster();
        int rad = (int)(radius + 0.5);
        int minx = X - rad;
        int maxx = X + rad;
        int miny = Y - rad;
        int maxy = Y + rad;
        int[] buffer = new int[2 * rad + 1 + (2 * rad + 1)];
        int n = 0;
        for (int y = miny; y <= maxy; ++y) {
            for (int x = minx; x <= maxx; ++x) {
                if (!(metric.Distance((double)x, (double)y, 0.0, (double)X, (double)Y, 0.0) <= radius)) continue;
                buffer[n++] = wr.getSample(x, y, 0);
            }
        }
        ArrayFeatures AF = new ArrayFeatures();
        int min = AF.Minimum(buffer);
        metric = null;
        buffer = null;
        wr = null;
        return min;
    }

    public static int Maximum(BufferedImage source, int minx, int miny, int maxx, int maxy) {
        int max;
        if (!ImageTools.isGrayLevel((BufferedImage)source)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        int width = source.getWidth();
        switch (source.getType()) {
            case 10: {
                byte[] bytebuffer = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                max = bytebuffer[miny * width + minx] & 0xFF;
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx;
                    while (x <= maxx) {
                        if ((bytebuffer[pos] & 0xFF) > max) {
                            max = bytebuffer[pos] & 0xFF;
                        }
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                bytebuffer = null;
                break;
            }
            case 11: {
                short[] shortbuffer = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                max = shortbuffer[miny * width + minx] & 0xFFFF;
                int y = miny;
                int posori = miny * width;
                while (y <= maxy) {
                    int x = minx;
                    int pos = posori + minx;
                    while (x <= maxx) {
                        if ((shortbuffer[pos] & 0xFFFF) > max) {
                            max = shortbuffer[pos] & 0xFFFF;
                        }
                        ++x;
                        ++pos;
                    }
                    ++y;
                    posori += width;
                }
                shortbuffer = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Not yet implemented for this type of image.");
            }
        }
        return max;
    }

    public static int Maximum(BufferedImage image, int X, int Y, double radius) {
        if (!ImageTools.isGrayLevel((BufferedImage)image)) {
            throw new IllegalArgumentException("Gray level image required.");
        }
        Euclidian metric = new Euclidian();
        WritableRaster wr = image.getRaster();
        int rad = (int)(radius + 0.5);
        int minx = X - rad;
        int maxx = X + rad;
        int miny = Y - rad;
        int maxy = Y + rad;
        int[] buffer = new int[2 * rad + 1 + (2 * rad + 1)];
        int n = 0;
        for (int y = miny; y <= maxy; ++y) {
            for (int x = minx; x <= maxx; ++x) {
                if (!(metric.Distance((double)x, (double)y, 0.0, (double)X, (double)Y, 0.0) <= radius)) continue;
                buffer[n++] = wr.getSample(x, y, 0);
            }
        }
        ArrayFeatures AF = new ArrayFeatures();
        int max = AF.Maximum(buffer);
        metric = null;
        buffer = null;
        wr = null;
        return max;
    }

    public static double Contrast(BufferedImage image, int minx, int miny, int maxx, int maxy) {
        return (double)(ImageFeaturesWindow.Maximum(image, minx, miny, maxx, maxy) - ImageFeaturesWindow.Minimum(image, minx, miny, maxx, maxy)) / ImageFeaturesWindow.Average(image, minx, miny, maxx, maxy);
    }

    public static double Michelson(BufferedImage image, int minx, int miny, int maxx, int maxy) {
        double min = ImageFeaturesWindow.Minimum(image, minx, miny, maxx, maxy);
        double max = ImageFeaturesWindow.Maximum(image, minx, miny, maxx, maxy);
        return (max - min) / (max + min);
    }
}

