/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import arrayTiTi.ArrayIO;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import measures.histogram.Histogram;

public class ImageFeaturesComparator {
    private int channel = 0;
    private int nbgap = 0;
    private int size = 0;
    private double[] sums = null;
    private double[] averages = null;
    private double[] variances = null;
    private double[] histsums = null;
    private double[] histaverages = null;
    private double[] histvariances = null;
    private final Histogram histogram = new Histogram();

    public void Compute(BufferedImage im1, BufferedImage im2) {
        int c;
        int x;
        int y;
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)im1, (BufferedImage)im2)) {
            throw new IllegalArgumentException("Image have different type or dimension.");
        }
        int width = im1.getWidth();
        int height = im1.getHeight();
        WritableRaster wr1 = im1.getRaster();
        WritableRaster wr2 = im2.getRaster();
        switch (im1.getType()) {
            case 10: 
            case 11: 
            case 12: {
                if (this.channel == 1) break;
                this.Allocations(1);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                if (this.channel == 3) break;
                this.Allocations(3);
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        this.Initialize();
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                boolean gap = false;
                for (c = 0; c < this.channel; ++c) {
                    int n = c;
                    this.sums[n] = this.sums[n] + (double)Math.abs(wr1.getSample(x, y, c) - wr2.getSample(x, y, c));
                    if (wr1.getSample(x, y, c) == wr2.getSample(x, y, c)) continue;
                    gap = true;
                }
                if (!gap) continue;
                ++this.nbgap;
            }
        }
        this.size = width * height;
        for (c = 0; c < this.channel; ++c) {
            this.averages[c] = this.sums[c] / (double)this.size;
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                for (c = 0; c < this.channel; ++c) {
                    int n = c;
                    this.variances[n] = this.variances[n] + Math.pow((double)Math.abs(wr1.getSample(x, y, c) - wr2.getSample(x, y, c)) - this.averages[c], 2.0);
                }
            }
        }
        for (c = 0; c < this.channel; ++c) {
            this.variances[c] = Math.sqrt(this.variances[c] / (double)this.size);
        }
        this.histogram.Fill(im1);
        int[][] hist1 = this.histogram.getValues();
        this.histogram.Fill(im2);
        int[][] hist2 = this.histogram.getValues();
        this.size = hist1[0].length;
        for (c = 0; c < this.channel; ++c) {
            for (x = 0; x < this.size; ++x) {
                int n = c;
                this.histsums[n] = this.histsums[n] + (double)Math.abs(hist1[c][x] - hist2[c][x]);
            }
        }
        for (c = 0; c < this.channel; ++c) {
            this.histaverages[c] = this.histsums[c] / (double)this.size;
        }
        for (c = 0; c < this.channel; ++c) {
            for (x = 0; x < this.size; ++x) {
                int n = c;
                this.histvariances[n] = this.histvariances[n] + Math.pow((double)Math.abs(hist1[c][x] - hist2[c][x]) - this.histaverages[c], 2.0);
            }
        }
        for (c = 0; c < this.channel; ++c) {
            this.histvariances[c] = Math.sqrt(this.histvariances[c] / (double)this.size);
        }
        this.size = width * height;
    }

    private void Initialize() {
        this.nbgap = 0;
        Arrays.fill(this.sums, 0.0);
        Arrays.fill(this.variances, 0.0);
        Arrays.fill(this.histsums, 0.0);
        Arrays.fill(this.histvariances, 0.0);
    }

    private void Allocations(int size) {
        this.channel = 1;
        this.variances = null;
        this.sums = null;
        this.averages = null;
        this.histvariances = null;
        this.histsums = null;
        this.histaverages = null;
        this.averages = new double[this.channel];
        this.sums = new double[this.channel];
        this.variances = new double[this.channel];
        this.histaverages = new double[this.channel];
        this.histsums = new double[this.channel];
        this.histvariances = new double[this.channel];
    }

    public int getChannel() {
        return this.channel;
    }

    public int getNbgap() {
        return this.nbgap;
    }

    public double[] getSums() {
        return this.sums;
    }

    public double[] getAverages() {
        return this.averages;
    }

    public double[] getVariances() {
        return this.variances;
    }

    public double[] getHistSums() {
        return this.histsums;
    }

    public double[] getHistAverages() {
        return this.histaverages;
    }

    public double[] getHistVariances() {
        return this.histvariances;
    }

    public void Display(String separator) {
        System.out.println("Gap: " + this.nbgap + " (" + (double)this.nbgap / (double)this.size * 100.0 + "%)");
        ArrayIO.Display(this.sums, "Sums", separator);
        ArrayIO.Display(this.averages, "Averages", separator);
        ArrayIO.Display(this.variances, "Variances", separator);
        System.out.println();
    }
}

