/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mathematics.metrics.Euclidian;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Coordinates;
import mathematics.primitives.pointsTiTi.CoordinatesManager;
import mathematics.primitives.pointsTiTi.CoordinatesWeighted;
import mathematics.primitives.pointsTiTi.PointI;
import mathematics.primitives.pointsTiTi.PointIManager;

public final class ImageDrawer {
    private static final boolean[][][] digits = new boolean[][][]{new boolean[][]{{true, true, true}, {true, false, true}, {true, false, true}, {true, false, true}, {true, true, true}}, new boolean[][]{{false, true, false}, {false, true, false}, {false, true, false}, {false, true, false}, {false, true, false}}, new boolean[][]{{true, true, true}, {false, false, true}, {true, true, true}, {true, false, false}, {true, true, true}}, new boolean[][]{{true, true, true}, {false, false, true}, {true, true, true}, {false, false, true}, {true, true, true}}, new boolean[][]{{true, false, true}, {true, false, true}, {true, true, true}, {false, false, true}, {false, false, true}}, new boolean[][]{{true, true, true}, {true, false, false}, {true, true, true}, {false, false, true}, {true, true, true}}, new boolean[][]{{true, true, true}, {true, false, false}, {true, true, true}, {true, false, true}, {true, true, true}}, new boolean[][]{{true, true, true}, {true, false, true}, {false, false, true}, {false, false, true}, {false, false, true}}, new boolean[][]{{true, true, true}, {true, false, true}, {true, true, true}, {true, false, true}, {true, true, true}}, new boolean[][]{{true, true, true}, {true, false, true}, {true, true, true}, {false, false, true}, {true, true, true}}};

    public static void Point(BufferedImage image, int x, int y, int order, float[] color) {
        WritableRaster wr = image.getRaster();
        switch (image.getType()) {
            case 12: {
                for (int i2 = y - order; i2 <= y + order; ++i2) {
                    for (int j = x - order; j <= x + order; ++j) {
                        if (i2 < 0 || j < 0 || i2 >= image.getHeight() || j >= image.getWidth()) continue;
                        wr.setSample(j, i2, 0, (int)color[0]);
                    }
                }
                break;
            }
            case 10: {
                byte bv = (byte)((double)color[0] * 255.0);
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int i3 = y - order; i3 <= y + order; ++i3) {
                    int j = x - order;
                    int pos = i3 * image.getWidth() + j;
                    while (j <= x + order) {
                        if (i3 >= 0 && j >= 0 && i3 < image.getHeight() && j < image.getWidth()) {
                            bb[pos] = bv;
                        }
                        ++j;
                        ++pos;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short sv = (short)((double)color[0] * 65535.0);
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                for (int i4 = y - order; i4 <= y + order; ++i4) {
                    int j = x - order;
                    int pos = i4 * image.getWidth() + j;
                    while (j <= x + order) {
                        if (i4 >= 0 && j >= 0 && i4 < image.getHeight() && j < image.getWidth()) {
                            sb[pos] = sv;
                        }
                        ++j;
                        ++pos;
                    }
                }
                sb = null;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                for (int i5 = y - order; i5 <= y + order; ++i5) {
                    for (int j = x - order; j <= x + order; ++j) {
                        if (i5 < 0 || j < 0 || i5 >= image.getHeight() || j >= image.getWidth()) continue;
                        for (int k = 0; k <= 2; ++k) {
                            wr.setSample(j, i5, k, (int)((double)color[k] * 255.0));
                        }
                    }
                }
                break;
            }
            case 2: 
            case 6: {
                for (int i6 = y - order; i6 <= y + order; ++i6) {
                    for (int j = x - order; j <= x + order; ++j) {
                        if (i6 < 0 || j < 0 || i6 >= image.getHeight() || j >= image.getWidth()) continue;
                        for (int k = 0; k <= 3; ++k) {
                            wr.setSample(j, i6, k, (int)((double)color[k] * 255.0));
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Type of image not supported.");
            }
        }
        wr = null;
    }

    public static void Point(BufferedImage image, PointI point, int order, float[] color) {
        ImageDrawer.Point(image, point.getX(), point.getY(), order, color);
    }

    public static void Point(BufferedImage image, Coordinates point, int order, float[] color) {
        ImageDrawer.Point(image, point.X, point.Y, order, color);
    }

    public static void Point(BufferedImage image, Coordinate point, int order, float[] color) {
        ImageDrawer.Point(image, (int)point.X, (int)point.Y, order, color);
    }

    public static void Points(BufferedImage image, List<PointI> list, int order, float[] color) {
        Iterator<PointI> points = list.iterator();
        while (points.hasNext()) {
            ImageDrawer.Point(image, points.next(), order, color);
        }
        points = null;
    }

    public static void Points(BufferedImage image, PointIManager manager, int order, float[] color) {
        ImageDrawer.Points(image, manager.Points(), order, color);
    }

    public static void Coordinates(BufferedImage image, Coordinates point, int order, float[] color) {
        ImageDrawer.Point(image, point.X, point.Y, order, color);
    }

    public static void Coordinates(BufferedImage image, CoordinatesWeighted point, int order, float[] color) {
        ImageDrawer.Point(image, point.X, point.Y, order, color);
    }

    public static void Coordinates(BufferedImage image, List<Coordinates> list, int order, float[] color) {
        Iterator<Coordinates> points = list.iterator();
        while (points.hasNext()) {
            ImageDrawer.Coordinates(image, points.next(), order, color);
        }
        points = null;
    }

    public static void CoordinatesWeighted(BufferedImage image, List<CoordinatesWeighted> list, int order, float[] color) {
        Iterator<CoordinatesWeighted> points = list.iterator();
        while (points.hasNext()) {
            ImageDrawer.Coordinates(image, points.next(), order, color);
        }
        points = null;
    }

    public static void Coordinates(BufferedImage image, CoordinatesManager manager, int order, float[] color) {
        ImageDrawer.Coordinates(image, manager.Points(), order, color);
    }

    public static void Line(BufferedImage image, int xi, int yi, int xf, int yf, int order, float[] color) {
        int x = xi;
        int y = yi;
        int dx = xf - xi;
        int dy = yf - yi;
        int xinc = dx > 0 ? 1 : -1;
        int yinc = dy > 0 ? 1 : -1;
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        ImageDrawer.Point(image, x, y, order, color);
        if (dx > dy) {
            int cumul = dx >> 1;
            for (int i2 = 1; i2 <= dx; ++i2) {
                x += xinc;
                if ((cumul += dy) >= dx) {
                    cumul -= dx;
                    y += yinc;
                }
                ImageDrawer.Point(image, x, y, order, color);
            }
        } else {
            int cumul = dy >> 1;
            for (int i3 = 1; i3 <= dy; ++i3) {
                y += yinc;
                if ((cumul += dx) >= dy) {
                    cumul -= dy;
                    x += xinc;
                }
                ImageDrawer.Point(image, x, y, order, color);
            }
        }
    }

    public static void HorizontalLine(BufferedImage image, int x, int y, int length, int order, float[] color) {
        for (int i2 = 0; i2 < length; ++i2) {
            ImageDrawer.Point(image, x + i2, y, order, color);
        }
    }

    public static void HorizontalLine(BufferedImage image, int x, int y, int length, float[] color) {
        WritableRaster wr = image.getRaster();
        switch (image.getType()) {
            case 12: {
                for (int i2 = 0; i2 < length; ++i2) {
                    wr.setSample(x + i2, y, 0, (int)color[0]);
                }
                break;
            }
            case 10: {
                byte bv = (byte)((double)color[0] * 255.0);
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int i3 = 0;
                int pos = y * image.getWidth() + x;
                while (i3 < length) {
                    bb[pos] = bv;
                    ++i3;
                    ++pos;
                }
                bb = null;
                break;
            }
            case 11: {
                short sv = (short)((double)color[0] * 65535.0);
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                int i4 = 0;
                int pos = y * image.getWidth() + x;
                while (i4 < length) {
                    sb[pos] = sv;
                    ++i4;
                    ++pos;
                }
                sb = null;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                for (int i5 = 0; i5 < length; ++i5) {
                    for (int k = 0; k <= 2; ++k) {
                        wr.setSample(x + i5, y, k, (int)((double)color[k] * 255.0));
                    }
                }
                break;
            }
            case 2: 
            case 6: {
                for (int i6 = 0; i6 < length; ++i6) {
                    for (int k = 0; k <= 3; ++k) {
                        wr.setSample(x + i6, y, k, (int)((double)color[k] * 255.0));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Type of image not supported.");
            }
        }
        wr = null;
    }

    public static void Circle(BufferedImage image, int xc, int yc, double radius, int order, float[] color) {
        ImageDrawer.Circle(image, xc, yc, radius, order, color, 1.0);
    }

    public static void Circle(BufferedImage image, int xc, int yc, double radius, int order, float[] color, double step) {
        for (double i2 = 0.0; i2 < 360.0; i2 += step) {
            ImageDrawer.Point(image, (int)((double)xc + radius * Math.cos(Math.toRadians(i2))), (int)((double)yc + radius * Math.sin(Math.toRadians(i2))), order, color);
        }
    }

    public static void Disk(BufferedImage image, int xc, int yc, double radius, int order, float[] color) {
        Euclidian metric = new Euclidian();
        int r = (int)Math.round(radius);
        for (int y = yc - r; y <= yc + r; ++y) {
            for (int x = xc - r; x <= xc + r; ++x) {
                if (!(metric.Distance((double)xc, (double)yc, 0.0, (double)x, (double)y, 0.0) <= (double)r)) continue;
                ImageDrawer.Point(image, x, y, order, color);
            }
        }
    }

    public static void Rectangle(BufferedImage image, int xi, int yi, int xf, int yf, int order, float[] color) {
        ImageDrawer.Line(image, xi, yi, xi, yf, order, color);
        ImageDrawer.Line(image, xi, yf, xf, yf, order, color);
        ImageDrawer.Line(image, xf, yf, xf, yi, order, color);
        ImageDrawer.Line(image, xf, yi, xi, yi, order, color);
    }

    public static void RectangleFull(BufferedImage image, int xi, int yi, int xf, int yf, float[] color) {
        int n;
        if (xf < xi) {
            n = xf;
            xf = xi;
            xi = n;
        }
        if (yf < yi) {
            n = yf;
            yf = yi;
            yi = n;
        }
        xi = Math.max(0, xi);
        yi = Math.max(0, yi);
        int length = xf - xi + 1;
        if (image.getWidth() <= xi + length) {
            length = image.getWidth() - xi;
        }
        if (image.getHeight() <= yf) {
            yf = image.getHeight() - 1;
        }
        for (n = yi; n <= yf; ++n) {
            ImageDrawer.HorizontalLine(image, xi, n, length, color);
        }
    }

    public static void Square(BufferedImage image, int x, int y, int length, int order, float[] color) {
        ImageDrawer.Line(image, x, y, x, y + length, order, color);
        ImageDrawer.Line(image, x, y + length, x + length, y + length, order, color);
        ImageDrawer.Line(image, x + length, y + length, x + length, y, order, color);
        ImageDrawer.Line(image, x + length, y, x, y, order, color);
    }

    public static void Polygon(BufferedImage image, int order, float[] color, int orderpoints, float[] colorpoints, Coordinates ... coordinates) {
        Coordinates p;
        int i2;
        Coordinates q = null;
        for (i2 = 0; i2 < coordinates.length - 1; ++i2) {
            p = coordinates[i2];
            q = coordinates[i2 + 1];
            ImageDrawer.Line(image, p.X, p.Y, q.X, q.Y, order, color);
        }
        p = coordinates[0];
        ImageDrawer.Line(image, p.X, p.Y, q.X, q.Y, order, color);
        if (0 <= orderpoints && colorpoints != null) {
            for (i2 = 0; i2 < coordinates.length; ++i2) {
                ImageDrawer.Point(image, coordinates[i2], orderpoints, colorpoints);
            }
        }
    }

    public static void Polygon(BufferedImage image, List<Coordinates> list, int order, float[] color, int orderpoints, float[] colorpoints) {
        Coordinates p;
        int i2;
        Coordinates q = null;
        for (i2 = 0; i2 < list.size() - 1; ++i2) {
            p = list.get(i2);
            q = list.get(i2 + 1);
            ImageDrawer.Line(image, p.X, p.Y, q.X, q.Y, order, color);
        }
        p = list.get(0);
        ImageDrawer.Line(image, p.X, p.Y, q.X, q.Y, order, color);
        if (0 <= orderpoints && colorpoints != null) {
            for (i2 = 0; i2 < list.size(); ++i2) {
                ImageDrawer.Point(image, list.get(i2), orderpoints, colorpoints);
            }
        }
    }

    public static void PolygonD(BufferedImage image, List<Coordinate> list, int order, float[] color, int orderpoints, float[] colorpoints) {
        Coordinate p;
        int i2;
        Coordinate q = null;
        for (i2 = 0; i2 < list.size() - 1; ++i2) {
            p = list.get(i2);
            q = list.get(i2 + 1);
            ImageDrawer.Line(image, (int)p.X, (int)p.Y, (int)q.X, (int)q.Y, order, color);
        }
        p = list.get(0);
        ImageDrawer.Line(image, (int)p.X, (int)p.Y, (int)q.X, (int)q.Y, order, color);
        if (0 <= orderpoints && colorpoints != null) {
            for (i2 = 0; i2 < list.size(); ++i2) {
                ImageDrawer.Point(image, list.get(i2), orderpoints, colorpoints);
            }
        }
    }

    public static void Crosses(BufferedImage image, List<Coordinate> list, int branchlength, int order, float[] color) {
        list.stream().forEach(coord -> ImageDrawer.Cross(image, (int)coord.X, (int)coord.Y, branchlength, order, color));
    }

    public static void Cross(BufferedImage image, int X, int Y, int branchlength, int order, float[] color) {
        int start = X - branchlength;
        if (start < 0) {
            start = 0;
        }
        int end = X + branchlength;
        if (image.getWidth() <= end) {
            end = image.getWidth();
        }
        ImageDrawer.Line(image, start, Y, end, Y, order, color);
        start = Y - branchlength;
        if (start < 0) {
            start = 0;
        }
        end = Y + branchlength;
        if (image.getHeight() <= end) {
            end = image.getHeight();
        }
        ImageDrawer.Line(image, X, start, X, end, order, color);
    }

    public static void Draw(BufferedImage image, BufferedImage reference, float[] color) {
        WritableRaster wr = image.getRaster();
        WritableRaster wrref = reference.getRaster();
        int channel = image.getRaster().getNumBands();
        int[] colors = new int[color.length];
        for (int i2 = 0; i2 < colors.length; ++i2) {
            colors[i2] = (int)(color[i2] * 255.0f + 0.5f);
        }
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                if (wrref.getSample(x, y, 0) == 0) continue;
                for (int i3 = 0; i3 < channel; ++i3) {
                    wr.setSample(x, y, i3, colors[i3]);
                }
            }
        }
        wrref = null;
        wr = null;
    }

    public static void Contour(BufferedImage image, BufferedImage labels, float[] color) {
        if (image.getType() != 5) {
            throw new IllegalArgumentException("Image 'image' type must be TYPE_3BYTE_BGR.");
        }
        byte[] bbrgb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int width = image.getWidth();
        int height = image.getHeight();
        int[] colors = new int[color.length];
        for (int i2 = 0; i2 < colors.length; ++i2) {
            colors[i2] = (int)(color[i2] * 255.0f + 0.5f);
        }
        switch (labels.getType()) {
            case 10: {
                byte[] bb = ((DataBufferByte)labels.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int posrgb = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (bb[pos] != 0) {
                            int label = bb[pos] & 0xFF;
                            if (x == 0 || (bb[pos - 1] & 0xFF) < label || x == width - 1 || (bb[pos + 1] & 0xFF) < label || y == 0 || (bb[pos - width] & 0xFF) < label || y == height - 1 || (bb[pos + width] & 0xFF) < label) {
                                bbrgb[posrgb] = (byte)colors[2];
                                bbrgb[posrgb + 1] = (byte)colors[1];
                                bbrgb[posrgb + 2] = (byte)colors[0];
                            }
                        }
                        ++x;
                        ++pos;
                        posrgb += 3;
                    }
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)labels.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int posrgb = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (sb[pos] != 0) {
                            int label = sb[pos] & 0xFFFF;
                            if (x == 0 || (sb[pos - 1] & 0xFFFF) < label || x == width - 1 || (sb[pos + 1] & 0xFFFF) < label || y == 0 || (sb[pos - width] & 0xFFFF) < label || y == height - 1 || (sb[pos + width] & 0xFFFF) < label) {
                                bbrgb[posrgb] = (byte)colors[2];
                                bbrgb[posrgb + 1] = (byte)colors[1];
                                bbrgb[posrgb + 2] = (byte)colors[0];
                            }
                        }
                        ++x;
                        ++pos;
                        posrgb += 3;
                    }
                }
                sb = null;
                break;
            }
            case 0: {
                int[] ib = ((DataBufferInt)labels.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int posrgb = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        if (ib[pos] != 0) {
                            int label = ib[pos];
                            if (x == 0 || ib[pos - 1] < label || x == width - 1 || ib[pos + 1] < label || y == 0 || ib[pos - width] < label || y == height - 1 || ib[pos + width] < label) {
                                bbrgb[posrgb] = (byte)colors[2];
                                bbrgb[posrgb + 1] = (byte)colors[1];
                                bbrgb[posrgb + 2] = (byte)colors[0];
                            }
                        }
                        ++x;
                        ++pos;
                        posrgb += 3;
                    }
                }
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public static void Number(BufferedImage image, String number, int X, int Y, float[] color) {
        int i2 = 0;
        int pos = 0;
        while (i2 < number.length()) {
            switch (number.charAt(i2) - 48) {
                case 1: {
                    ImageDrawer.Digit(image, 1, X + --pos, Y, color);
                    --pos;
                    break;
                }
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    ImageDrawer.Digit(image, number.charAt(i2) - 48, X + pos, Y, color);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Ony digits supported.");
                }
            }
            ++i2;
            pos += digits[0][0].length + 1;
        }
    }

    public static void Digit(BufferedImage image, int digit, int X, int Y, float[] color) {
        boolean[][] shape = digits[digit];
        int width = shape[0].length;
        int height = shape.length;
        WritableRaster wr = image.getRaster();
        switch (image.getType()) {
            case 10: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (!shape[y][x]) continue;
                        wr.setSample(X + x, Y + y, 0, color[0]);
                    }
                }
                break;
            }
            case 5: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (!shape[y][x] || X + x >= image.getWidth() || Y + y >= image.getHeight()) continue;
                        for (int c = 0; c < 3; ++c) {
                            wr.setSample(X + x, Y + y, c, 255.0f * color[c]);
                        }
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
        shape = null;
        wr = null;
    }

    public static void Border(BufferedImage image, int value, int size) {
        ImageDrawer.Borders(image, value, size, size, size, size);
    }

    public static void Borders(BufferedImage image, int value, int top, int bottom, int left, int right) {
        if (0 < top) {
            ImageDrawer.BorderTop(image, value, top);
        }
        if (0 < bottom) {
            ImageDrawer.BorderBottom(image, value, bottom);
        }
        if (0 < left) {
            ImageDrawer.BorderLeft(image, value, left);
        }
        if (0 < right) {
            ImageDrawer.BorderRight(image, value, right);
        }
    }

    public static void BorderBottom(BufferedImage image, int value, int size) {
        int width = image.getWidth();
        int height = image.getHeight();
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                for (int y = height - size; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wr.setSample(x, y, 0, value);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                Arrays.fill(bb, width * (height - size), bb.length, (byte)value);
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                Arrays.fill(sb, width * (height - size), sb.length, (short)value);
                sb = null;
                break;
            }
            case 0: {
                if (image.getRaster().getDataBuffer().getDataType() != 3) {
                    throw new IllegalArgumentException("DataBuffer type not supported (yet)");
                }
                if (image.getRaster().getNumBands() != 1) {
                    throw new IllegalArgumentException("Number of channel/band not supported (yet)");
                }
                int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                Arrays.fill(ib, width * (height - size), ib.length, value);
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void BorderTop(BufferedImage image, int value, int size) {
        int width = image.getWidth();
        int dim = size * width;
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                for (int y = 0; y < size; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wr.setSample(x, y, 0, value);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                Arrays.fill(bb, 0, dim, (byte)value);
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                Arrays.fill(sb, 0, dim, (short)value);
                sb = null;
                break;
            }
            case 0: {
                if (image.getRaster().getDataBuffer().getDataType() != 3) {
                    throw new IllegalArgumentException("DataBuffer type not supported (yet)");
                }
                if (image.getRaster().getNumBands() != 1) {
                    throw new IllegalArgumentException("Number of channel/band not supported (yet)");
                }
                int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                Arrays.fill(ib, 0, dim, value);
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void BorderLeft(BufferedImage image, int value, int size) {
        int width = image.getWidth();
        int height = image.getHeight();
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < size; ++x) {
                        wr.setSample(x, y, 0, value);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int y = 0;
                while (y < height) {
                    Arrays.fill(bb, pos, pos + size, (byte)value);
                    ++y;
                    pos += width;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int y = 0;
                while (y < height) {
                    Arrays.fill(sb, pos, pos + size, (short)value);
                    ++y;
                    pos += width;
                }
                sb = null;
                break;
            }
            case 0: {
                if (image.getRaster().getDataBuffer().getDataType() != 3) {
                    throw new IllegalArgumentException("DataBuffer type not supported (yet)");
                }
                if (image.getRaster().getNumBands() != 1) {
                    throw new IllegalArgumentException("Number of channel/band not supported (yet)");
                }
                int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int y = 0;
                while (y < height) {
                    Arrays.fill(ib, pos, pos + size, value);
                    ++y;
                    pos += width;
                }
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void BorderRight(BufferedImage image, int value, int size) {
        int width = image.getWidth();
        int height = image.getHeight();
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                int pos = width - size;
                for (int y = 0; y < height; ++y) {
                    for (int x = pos; x < width; ++x) {
                        wr.setSample(x, y, 0, value);
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int y = 0;
                int pos = width - size;
                while (y < height) {
                    Arrays.fill(bb, pos, pos + size, (byte)value);
                    ++y;
                    pos += width;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                int y = 0;
                int pos = width - size;
                while (y < height) {
                    Arrays.fill(sb, pos, pos + size, (short)value);
                    ++y;
                    pos += width;
                }
                sb = null;
                break;
            }
            case 0: {
                if (image.getRaster().getDataBuffer().getDataType() != 3) {
                    throw new IllegalArgumentException("DataBuffer type not supported (yet).");
                }
                if (image.getRaster().getNumBands() != 1) {
                    throw new IllegalArgumentException("Number of channel/band not supported (yet)");
                }
                int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                int y = 0;
                int pos = width - size;
                while (y < height) {
                    Arrays.fill(ib, pos, pos + size, value);
                    ++y;
                    pos += width;
                }
                ib = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void Border(BufferedImage image, double value, int size) {
        ImageDrawer.Borders(image, value, size, size, size, size);
    }

    public static void Borders(BufferedImage image, double value, int top, int bottom, int left, int right) {
        if (0 < top) {
            ImageDrawer.BorderTop(image, value, top);
        }
        if (0 < bottom) {
            ImageDrawer.BorderBottom(image, value, bottom);
        }
        if (0 < left) {
            ImageDrawer.BorderLeft(image, value, left);
        }
        if (0 < right) {
            ImageDrawer.BorderRight(image, value, right);
        }
    }

    public static void BorderBottom(BufferedImage image, double value, int size) {
        if (image.getRaster().getNumBands() != 1) {
            throw new IllegalArgumentException("Number of channel/band not supported (yet)");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        block0 : switch (image.getType()) {
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        double[] db = ((DataBufferDouble)image.getRaster().getDataBuffer()).getData();
                        Arrays.fill(db, width * (height - size), db.length, value);
                        db = null;
                        break block0;
                    }
                    case 4: {
                        float[] fb = ((DataBufferFloat)image.getRaster().getDataBuffer()).getData();
                        Arrays.fill(fb, width * (height - size), fb.length, (float)value);
                        fb = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void BorderTop(BufferedImage image, double value, int size) {
        block0 : switch (image.getType()) {
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        double[] db = ((DataBufferDouble)image.getRaster().getDataBuffer()).getData();
                        Arrays.fill(db, 0, size * image.getWidth(), value);
                        db = null;
                        break block0;
                    }
                    case 4: {
                        float[] fb = ((DataBufferFloat)image.getRaster().getDataBuffer()).getData();
                        Arrays.fill(fb, 0, size * image.getWidth(), (float)value);
                        fb = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void BorderLeft(BufferedImage image, double value, int size) {
        int width = image.getWidth();
        int height = image.getHeight();
        block0 : switch (image.getType()) {
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        double[] db = ((DataBufferDouble)image.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int y = 0;
                        while (y < height) {
                            Arrays.fill(db, pos, pos + size, value);
                            ++y;
                            pos += width;
                        }
                        db = null;
                        break block0;
                    }
                    case 4: {
                        float[] fb = ((DataBufferFloat)image.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int y = 0;
                        while (y < height) {
                            Arrays.fill(fb, pos, pos + size, (float)value);
                            ++y;
                            pos += width;
                        }
                        fb = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void BorderRight(BufferedImage image, double value, int size) {
        int width = image.getWidth();
        int height = image.getHeight();
        block0 : switch (image.getType()) {
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        double[] db = ((DataBufferDouble)image.getRaster().getDataBuffer()).getData();
                        int y = 0;
                        int pos = width - size;
                        while (y < height) {
                            Arrays.fill(db, pos, pos + size, value);
                            ++y;
                            pos += width;
                        }
                        db = null;
                        break block0;
                    }
                    case 4: {
                        float[] fb = ((DataBufferFloat)image.getRaster().getDataBuffer()).getData();
                        int y = 0;
                        int pos = width - size;
                        while (y < height) {
                            Arrays.fill(fb, pos, pos + size, (float)value);
                            ++y;
                            pos += width;
                        }
                        fb = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void Borders(BufferedImage image, int size) {
        ImageDrawer.Borders(image, size, size, size, size);
    }

    public static void Borders(BufferedImage image, int top, int bottom, int left, int right) {
        ImageDrawer.BorderTop(image, top);
        ImageDrawer.BorderBottom(image, bottom);
        ImageDrawer.BorderRight(image, right);
        ImageDrawer.BorderLeft(image, left);
    }

    public static void BorderBottom(BufferedImage image, int size) {
        int width = image.getWidth();
        int height = image.getHeight();
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                for (int y = height - size; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wr.setSample(x, y, 0, (int)(Math.random() * 2.0));
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int x = width * (height - size); x < bb.length; ++x) {
                    bb[x] = (byte)(Math.random() * 256.0);
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                for (int x = width * (height - size); x < sb.length; ++x) {
                    sb[x] = (short)(Math.random() * 65536.0);
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void BorderTop(BufferedImage image, int size) {
        int width = image.getWidth();
        int dim = size * width;
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                for (int y = 0; y < size; ++y) {
                    for (int x = 0; x < width; ++x) {
                        wr.setSample(x, y, 0, (int)(Math.random() * 2.0));
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < dim; ++x) {
                    bb[x] = (byte)(Math.random() * 256.0);
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < dim; ++x) {
                    sb[x] = (short)(Math.random() * 65536.0);
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void BorderLeft(BufferedImage image, int size) {
        int width = image.getWidth();
        int height = image.getHeight();
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < size; ++x) {
                        wr.setSample(x, y, 0, (int)(Math.random() * 2.0));
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int y = 0;
                while (y < height) {
                    int x = 0;
                    int pos2 = pos;
                    while (x < size) {
                        bb[pos2] = (byte)(Math.random() * 256.0);
                        ++x;
                        ++pos2;
                    }
                    ++y;
                    pos += width;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int y = 0;
                while (y < height) {
                    int x = 0;
                    int pos2 = pos;
                    while (x < size) {
                        sb[pos2] = (short)(Math.random() * 65536.0);
                        ++x;
                        ++pos2;
                    }
                    ++y;
                    pos += width;
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void BorderRight(BufferedImage image, int size) {
        int width = image.getWidth();
        int height = image.getHeight();
        switch (image.getType()) {
            case 12: {
                WritableRaster wr = image.getRaster();
                int pos = width - size;
                for (int y = 0; y < height; ++y) {
                    for (int x = pos; x < width; ++x) {
                        wr.setSample(x, y, 0, (int)(Math.random() * 2.0));
                    }
                }
                wr = null;
                break;
            }
            case 10: {
                byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                int y = 0;
                int pos = width - size;
                while (y < height) {
                    int x = 0;
                    int pos2 = pos;
                    while (x < size) {
                        bb[pos2] = (byte)(Math.random() * 256.0);
                        ++x;
                        ++pos2;
                    }
                    ++y;
                    pos += width;
                }
                bb = null;
                break;
            }
            case 11: {
                short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                int y = 0;
                int pos = width - size;
                while (y < height) {
                    int x = 0;
                    int pos2 = pos;
                    while (x < size) {
                        sb[pos2] = (short)(Math.random() * 65536.0);
                        ++x;
                        ++pos2;
                    }
                    ++y;
                    pos += width;
                }
                sb = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported.");
            }
        }
    }

    public static void Cells(BufferedImage image, int[] labels, float[] inner, float[] edges) {
        if (image.getType() != 5) {
            throw new IllegalArgumentException("image.getType() != BufferedImage.TYPE_3BYTE_BGR");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] bbrgb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int pos = 0;
        int posrgb = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (labels[pos] != 0) {
                    if (x == 0 || y == 0 || x == width - 1 || y == height - 1 || 0 < x && labels[pos - 1] < labels[pos] || x < width - 1 && labels[pos + 1] < labels[pos] || 0 < y && labels[pos - width] < labels[pos] || y < height - 1 && labels[pos + width] < labels[pos]) {
                        bbrgb[posrgb] = (byte)(edges[2] * 255.0f + 0.5f);
                        bbrgb[posrgb + 1] = (byte)(edges[1] * 255.0f + 0.5f);
                        bbrgb[posrgb + 2] = (byte)(edges[0] * 255.0f + 0.5f);
                    } else {
                        bbrgb[posrgb] = (byte)(inner[2] * (float)(bbrgb[posrgb] & 0xFF) + 0.5f);
                        bbrgb[posrgb + 1] = (byte)(inner[1] * (float)(bbrgb[posrgb + 1] & 0xFF) + 0.5f);
                        bbrgb[posrgb + 2] = (byte)(inner[0] * (float)(bbrgb[posrgb + 2] & 0xFF) + 0.5f);
                    }
                }
                ++x;
                ++pos;
                posrgb += 3;
            }
        }
    }

    public static void Cells(BufferedImage image, int[] labels, int[] positive, float[] inner, float[] edges) {
        if (image.getType() != 5) {
            throw new IllegalArgumentException("image.getType() != BufferedImage.TYPE_3BYTE_BGR");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] bbrgb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int pos = 0;
        int posrgb = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (labels[pos] != 0) {
                    if (x == 0 || y == 0 || x == width - 1 || y == height - 1 || 0 < x && labels[pos - 1] < labels[pos] || x < width - 1 && labels[pos + 1] < labels[pos] || 0 < y && labels[pos - width] < labels[pos] || y < height - 1 && labels[pos + width] < labels[pos] || 0 < x && positive[labels[pos - 1]] == 0 || x < width - 1 && positive[labels[pos + 1]] == 0 || 0 < y && positive[labels[pos - width]] == 0 || y < height - 1 && positive[labels[pos + width]] == 0) {
                        if (positive[labels[pos]] != 0) {
                            bbrgb[posrgb] = (byte)(edges[2] * 255.0f + 0.5f);
                            bbrgb[posrgb + 1] = (byte)(edges[1] * 255.0f + 0.5f);
                            bbrgb[posrgb + 2] = (byte)(edges[0] * 255.0f + 0.5f);
                        }
                    } else if (positive[labels[pos]] != 0) {
                        bbrgb[posrgb] = (byte)(inner[2] * (float)(bbrgb[posrgb] & 0xFF) + 0.5f);
                        bbrgb[posrgb + 1] = (byte)(inner[1] * (float)(bbrgb[posrgb + 1] & 0xFF) + 0.5f);
                        bbrgb[posrgb + 2] = (byte)(inner[0] * (float)(bbrgb[posrgb + 2] & 0xFF) + 0.5f);
                    }
                }
                ++x;
                ++pos;
                posrgb += 3;
            }
        }
    }

    public static void Cells(BufferedImage image, int[] labels, float[] overlap, float[] inner, float[] edges) {
        if (image.getType() != 5) {
            throw new IllegalArgumentException("image.getType() != BufferedImage.TYPE_3BYTE_BGR");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] bbrgb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int pos = 0;
        int posrgb = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (labels[pos] != 0) {
                    if (x == 0 || y == 0 || x == width - 1 || y == height - 1 || 0 < x && labels[pos - 1] < labels[pos] || x < width - 1 && labels[pos + 1] < labels[pos] || 0 < y && labels[pos - width] < labels[pos] || y < height - 1 && labels[pos + width] < labels[pos] || 0 < x && overlap[labels[pos - 1]] < 0.5f || x < width - 1 && overlap[labels[pos + 1]] < 0.5f || 0 < y && overlap[labels[pos - width]] < 0.5f || y < height - 1 && overlap[labels[pos + width]] < 0.5f) {
                        if (0.5f <= overlap[labels[pos]]) {
                            bbrgb[posrgb] = (byte)(edges[2] * 255.0f + 0.5f);
                            bbrgb[posrgb + 1] = (byte)(edges[1] * 255.0f + 0.5f);
                            bbrgb[posrgb + 2] = (byte)(edges[0] * 255.0f + 0.5f);
                        }
                    } else if (0.5f <= overlap[labels[pos]]) {
                        bbrgb[posrgb] = (byte)(inner[2] * (float)(bbrgb[posrgb] & 0xFF) + 0.5f);
                        bbrgb[posrgb + 1] = (byte)(inner[1] * (float)(bbrgb[posrgb + 1] & 0xFF) + 0.5f);
                        bbrgb[posrgb + 2] = (byte)(inner[0] * (float)(bbrgb[posrgb + 2] & 0xFF) + 0.5f);
                    }
                }
                ++x;
                ++pos;
                posrgb += 3;
            }
        }
    }

    public static void Cells(BufferedImage image, int[] labels, String[] positive, float[] inner, float[] edges) {
        if (image.getType() != 5) {
            throw new IllegalArgumentException("image.getType() != BufferedImage.TYPE_3BYTE_BGR");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] bbrgb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        int pos = 0;
        int posrgb = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                if (labels[pos] != 0 && positive[labels[pos]].equals("+")) {
                    if (x == 0 || y == 0 || x == width - 1 || y == height - 1 || 0 < x && labels[pos - 1] < labels[pos] || x < width - 1 && labels[pos + 1] < labels[pos] || 0 < y && labels[pos - width] < labels[pos] || y < height - 1 && labels[pos + width] < labels[pos] || 0 < x && !positive[labels[pos - 1]].equals("+") || x < width - 1 && !positive[labels[pos + 1]].equals("+") || 0 < y && !positive[labels[pos - width]].equals("+") || y < height - 1 && !positive[labels[pos + width]].equals("+")) {
                        bbrgb[posrgb] = (byte)(edges[2] * 255.0f + 0.5f);
                        bbrgb[posrgb + 1] = (byte)(edges[1] * 255.0f + 0.5f);
                        bbrgb[posrgb + 2] = (byte)(edges[0] * 255.0f + 0.5f);
                    } else {
                        bbrgb[posrgb] = (byte)(inner[2] * (float)(bbrgb[posrgb] & 0xFF) + 0.5f);
                        bbrgb[posrgb + 1] = (byte)(inner[1] * (float)(bbrgb[posrgb + 1] & 0xFF) + 0.5f);
                        bbrgb[posrgb + 2] = (byte)(inner[0] * (float)(bbrgb[posrgb + 2] & 0xFF) + 0.5f);
                    }
                }
                ++x;
                ++pos;
                posrgb += 3;
            }
        }
    }
}

