/*
 * Decompiled with CFR 0.152.
 */
package imageTiTi;

import arrayTiTi.ArrayArithmetic;
import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayNew;
import imageTiTi.ImageNew;
import imageTiTi.ImageTools;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import utils.strings.StringToolsImageDV;

public class ImageArithmetic {
    private static String MessageError(BufferedImage src1, Object src2, BufferedImage res) {
        StringBuilder message = new StringBuilder(1111);
        message.append("Configuration not supported: Add/Sub(");
        message.append(StringToolsImageDV.NameOfType((int)src1.getType())).append(", ");
        if (src2 instanceof BufferedImage) {
            message.append(StringToolsImageDV.NameOfType((int)((BufferedImage)src2).getType())).append(", ");
        } else if (src2 instanceof Integer) {
            message.append("int, ");
        } else {
            throw new Error("Bug: must not occured.");
        }
        message.append(StringToolsImageDV.NameOfType((int)res.getType())).append(", ");
        message.append("int, int)");
        return message.toString();
    }

    private static String MessageErrorArray(BufferedImage src1, Object src2, Object res) {
        StringBuilder message = new StringBuilder(1111);
        message.append("Configuration not supported: Add(");
        message.append(StringToolsImageDV.NameOfType((int)src1.getType())).append(", ");
        if (src2 instanceof double[][]) {
            message.append("double[][], ");
        } else if (src2 instanceof int[][]) {
            message.append("int[][], ");
        } else {
            message.append("?, ");
        }
        if (res instanceof double[][]) {
            message.append("double[][], ");
        } else if (res instanceof int[][]) {
            message.append("int[][], ");
        } else {
            message.append("?, ");
        }
        return message.toString();
    }

    public static BufferedImage Add(BufferedImage Original1, BufferedImage Original2) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original2);
        ImageArithmetic.Add(Original1, Original2, result);
        return result;
    }

    public static void Add(BufferedImage Original1, BufferedImage Original2, BufferedImage Result) {
        if (ImageTools.isColored((BufferedImage)Original1) || ImageTools.isColored((BufferedImage)Original2)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        if (!ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Original2) || !ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Different images dimensions.");
        }
        block0 : switch (Original2.getType()) {
            case 10: {
                switch (Original1.getType()) {
                    case 10: {
                        if (Result.getType() != 10) {
                            throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                        }
                        ArrayArithmetic.AddUnsigned((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 11: {
                        if (Result.getType() != 11) {
                            throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                        }
                        ArrayArithmetic.AddUnsigned((short[])((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 0: {
                        switch (Original1.getRaster().getDataBuffer().getDataType()) {
                            case 4: {
                                if (Result.getRaster().getDataBuffer().getDataType() != 4) {
                                    throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                                }
                                ArrayArithmetic.Add((float[])((DataBufferFloat)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (float[])((DataBufferFloat)Result.getRaster().getDataBuffer()).getData());
                            }
                        }
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
            case 11: {
                ArrayArithmetic.AddUnsigned((short[])((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 0: {
                switch (Original1.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        ArrayArithmetic.Add((double[])((DataBufferDouble)Original1.getRaster().getDataBuffer()).getData(), (double[])((DataBufferDouble)Original2.getRaster().getDataBuffer()).getData(), (double[])((DataBufferDouble)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 4: {
                        ArrayArithmetic.Add((float[])((DataBufferFloat)Original1.getRaster().getDataBuffer()).getData(), (float[])((DataBufferFloat)Original2.getRaster().getDataBuffer()).getData(), (float[])((DataBufferFloat)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 3: {
                        ArrayArithmetic.Add((int[])((DataBufferInt)Original1.getRaster().getDataBuffer()).getData(), (int[])((DataBufferInt)Original2.getRaster().getDataBuffer()).getData(), (int[])((DataBufferInt)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
        }
    }

    public static BufferedImage Add(BufferedImage Original1, BufferedImage Original2, int Threshold, int SafeValue) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original2);
        ImageArithmetic.Add(Original1, Original2, result, Threshold, SafeValue);
        return result;
    }

    public static void Add(BufferedImage Original1, BufferedImage Original2, BufferedImage Result, int Threshold, int SafeValue) {
        if (ImageTools.isColored((BufferedImage)Original1) || ImageTools.isColored((BufferedImage)Original2)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        if (!ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Original2) || !ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Differents images dimensions.");
        }
        block0 : switch (Original1.getType()) {
            case 10: {
                switch (Original2.getType()) {
                    case 10: {
                        switch (Result.getType()) {
                            case 10: {
                                ArrayArithmetic.AddUnsigned((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData(), (byte)((byte)Threshold), (byte)((byte)SafeValue));
                                break block0;
                            }
                            case 11: {
                                ArrayArithmetic.AddUnsigned((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (int)Threshold, (int)SafeValue);
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                    }
                    case 11: {
                        if (Result.getType() != 11) {
                            throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                        }
                        ArrayArithmetic.AddUnsigned((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (int)Threshold, (int)SafeValue);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
            case 11: {
                if (Original2.getType() != 11 || Result.getType() != 11) {
                    throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                }
                ArrayArithmetic.AddUnsigned((short[])((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (short)((short)Threshold), (short)((short)SafeValue));
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
        }
    }

    public static BufferedImage Add(BufferedImage Original, int Value) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original);
        ImageArithmetic.Add(Original, Value, result);
        return result;
    }

    public static void Add(BufferedImage Original, int Value, BufferedImage Result) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Differents images types or dimensions.");
        }
        switch (Original.getType()) {
            case 5: 
            case 10: {
                ArrayArithmetic.AddUnsigned((byte[])((DataBufferByte)Original.getRaster().getDataBuffer()).getData(), (byte)((byte)Value), (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 11: {
                ArrayArithmetic.AddUnsigned((short[])((DataBufferUShort)Original.getRaster().getDataBuffer()).getData(), (short)((short)Value), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData());
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
        }
    }

    public static BufferedImage Add(BufferedImage Original, int Value, int Threshold, int SafeValue) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original);
        ImageArithmetic.Add(Original, Value, result, Threshold, SafeValue);
        return result;
    }

    public static void Add(BufferedImage Original, int Value, BufferedImage Result, int Threshold, int SafeValue) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Differents images types or dimensions.");
        }
        switch (Original.getType()) {
            case 5: 
            case 6: 
            case 10: {
                ArrayArithmetic.AddUnsigned((byte[])((DataBufferByte)Original.getRaster().getDataBuffer()).getData(), (byte)((byte)Value), (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData(), (byte)((byte)Threshold), (byte)((byte)SafeValue));
                break;
            }
            case 11: {
                ArrayArithmetic.AddUnsigned((short[])((DataBufferUShort)Original.getRaster().getDataBuffer()).getData(), (short)((short)Value), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (short)((short)Threshold), (short)((short)SafeValue));
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
        }
    }

    public static BufferedImage Add(BufferedImage Original, double Value) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original);
        ImageArithmetic.Add(Original, Value, result);
        return result;
    }

    public static void Add(BufferedImage Original, double Value, BufferedImage Result) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Differents images types or dimensions.");
        }
        switch (Original.getRaster().getDataBuffer().getDataType()) {
            case 5: {
                ArrayArithmetic.Add((double[])((DataBufferDouble)Original.getRaster().getDataBuffer()).getData(), (double)Value, (double[])((DataBufferDouble)Result.getRaster().getDataBuffer()).getData());
                break;
            }
            case 4: {
                ArrayArithmetic.Add((float[])((DataBufferFloat)Original.getRaster().getDataBuffer()).getData(), (float)((float)Value), (float[])((DataBufferFloat)Result.getRaster().getDataBuffer()).getData());
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
        }
    }

    public static int[][] AddArray(BufferedImage original, int[][] array) {
        int[][] result = ArrayNew.Same((int[][])array);
        ImageArithmetic.AddArray(original, array, result);
        return result;
    }

    public static void AddArray(BufferedImage original, int[][] array, int[][] result) {
        if (result.length != original.getHeight() || result[0].length != original.getWidth()) {
            throw new IllegalArgumentException("Image and array have different dimensions");
        }
        switch (original.getType()) {
            case 12: {
                ArrayArithmetic.AddBinary((byte[])((DataBufferByte)original.getRaster().getDataBuffer()).getData(), (int[][])array, (int[][])result);
                break;
            }
            case 10: {
                ArrayArithmetic.AddUnsigned((byte[])((DataBufferByte)original.getRaster().getDataBuffer()).getData(), (int[][])array, (int[][])result);
                break;
            }
            case 11: {
                ArrayArithmetic.AddUnsigned((short[])((DataBufferUShort)original.getRaster().getDataBuffer()).getData(), (int[][])array, (int[][])result);
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageErrorArray(original, array, result));
            }
        }
    }

    public static double[][] Add(BufferedImage original, double[][] array) {
        double[][] result = new double[original.getHeight()][original.getWidth()];
        ImageArithmetic.Add(original, array, result);
        return result;
    }

    public static void Add(BufferedImage original, double[][] array, double[][] result) {
        switch (original.getType()) {
            case 10: {
                ArrayArithmetic.AddUnsigned((byte[])((DataBufferByte)original.getRaster().getDataBuffer()).getData(), (double[][])array, (double[][])result);
                break;
            }
            case 11: {
                ArrayArithmetic.AddUnsigned((short[])((DataBufferUShort)original.getRaster().getDataBuffer()).getData(), (double[][])array, (double[][])result);
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageErrorArray(original, array, result));
            }
        }
    }

    public static int[] AddArray(BufferedImage original, int[] array) {
        int[] result = ArrayNew.Same((int[])array);
        ImageArithmetic.AddArray(original, array, result);
        return result;
    }

    public static void AddArray(BufferedImage original, int[] array, int[] result) {
        if (result.length != array.length || original.getHeight() * original.getWidth() != array.length) {
            throw new IllegalArgumentException("Image and/or arrays have different dimensions");
        }
        switch (original.getType()) {
            case 10: {
                ArrayArithmetic.AddUnsigned((byte[])((DataBufferByte)original.getRaster().getDataBuffer()).getData(), (int[])array, (int[])result);
                break;
            }
            case 11: {
                ArrayArithmetic.AddUnsigned((short[])((DataBufferUShort)original.getRaster().getDataBuffer()).getData(), (int[])array, (int[])result);
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageErrorArray(original, array, result));
            }
        }
    }

    public static double[] Add(BufferedImage original, double[] array) {
        double[] result = ArrayNew.Same((double[])array);
        ImageArithmetic.Add(original, array, result);
        return result;
    }

    public static void Add(BufferedImage original, double[] array, double[] result) {
        if (result.length != array.length || original.getHeight() * original.getWidth() != array.length) {
            throw new IllegalArgumentException("Image and/or arrays have different dimensions");
        }
        switch (original.getType()) {
            case 10: {
                ArrayArithmetic.AddUnsigned((byte[])((DataBufferByte)original.getRaster().getDataBuffer()).getData(), (double[])array, (double[])result);
                break;
            }
            case 11: {
                ArrayArithmetic.AddUnsigned((short[])((DataBufferUShort)original.getRaster().getDataBuffer()).getData(), (double[])array, (double[])result);
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageErrorArray(original, array, result));
            }
        }
    }

    public static BufferedImage Subtract(BufferedImage Original1, BufferedImage Original2) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original2);
        ImageArithmetic.Subtract(Original1, Original2, result);
        return result;
    }

    public static void Subtract(BufferedImage Original1, BufferedImage Original2, BufferedImage Result) {
        if (ImageTools.isColored((BufferedImage)Original1) || ImageTools.isColored((BufferedImage)Original2)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        if (!ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Original2) || !ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Different images dimensions.");
        }
        block0 : switch (Original1.getType()) {
            case 10: {
                switch (Result.getRaster().getDataBuffer().getDataType()) {
                    case 0: {
                        ArrayArithmetic.SubtractUnsigned((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 4: {
                        ArrayArithmetic.SubtractUnsigned((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (float[])((DataBufferFloat)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 5: {
                        ArrayArithmetic.SubtractUnsigned((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (double[])((DataBufferDouble)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet) for result image.");
            }
            case 11: {
                switch (Result.getRaster().getDataBuffer().getDataType()) {
                    case 1: {
                        ArrayArithmetic.SubtractUnsigned((short[])((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 4: {
                        ArrayArithmetic.SubtractUnsigned((short[])((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData(), (float[])((DataBufferFloat)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 5: {
                        ArrayArithmetic.SubtractUnsigned((short[])((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData(), (double[])((DataBufferDouble)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet) for result image.");
            }
            case 0: {
                switch (Original1.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        ArrayArithmetic.Subtract((double[])((DataBufferDouble)Original1.getRaster().getDataBuffer()).getData(), (double[])((DataBufferDouble)Original2.getRaster().getDataBuffer()).getData(), (double[])((DataBufferDouble)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 4: {
                        ArrayArithmetic.Subtract((float[])((DataBufferFloat)Original1.getRaster().getDataBuffer()).getData(), (float[])((DataBufferFloat)Original2.getRaster().getDataBuffer()).getData(), (float[])((DataBufferFloat)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 3: {
                        ArrayArithmetic.Subtract((int[])((DataBufferInt)Original1.getRaster().getDataBuffer()).getData(), (int[])((DataBufferInt)Original2.getRaster().getDataBuffer()).getData(), (int[])((DataBufferInt)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported.");
            }
        }
    }

    public static BufferedImage Subtract(BufferedImage Original1, BufferedImage Original2, int Threshold, int SafeValue) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original2);
        ImageArithmetic.Subtract(Original1, Original2, result, Threshold, SafeValue);
        return result;
    }

    public static void Subtract(BufferedImage Original1, BufferedImage Original2, BufferedImage Result, int Threshold, int SafeValue) {
        if (!ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Original2) || !ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Different images dimensions.");
        }
        block0 : switch (Original1.getType()) {
            case 10: {
                if (Original2.getType() != 10 || Result.getType() != 10) {
                    throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                }
                ArrayArithmetic.SubtractUnsigned((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData(), (byte)((byte)Threshold), (byte)((byte)SafeValue));
                break;
            }
            case 11: {
                switch (Original2.getType()) {
                    case 10: {
                        switch (Result.getType()) {
                            case 10: {
                                ArrayArithmetic.SubtractUnsigned((short[])((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData(), (int)Threshold, (int)SafeValue);
                                break block0;
                            }
                            case 11: {
                                ArrayArithmetic.SubtractUnsigned((short[])((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (int)Threshold, (int)SafeValue);
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                    }
                    case 11: {
                        if (Result.getType() != 11) {
                            throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                        }
                        ArrayArithmetic.SubtractUnsigned((short[])((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (short)((short)Threshold), (short)((short)SafeValue));
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
            case 5: 
            case 6: {
                if (Original2.getType() != Original1.getType() || Result.getType() != Original1.getType()) {
                    throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                }
                ArrayArithmetic.SubtractUnsigned((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData(), (byte)((byte)Threshold), (byte)((byte)SafeValue));
                break;
            }
            case 0: {
                switch (Original1.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        ArrayArithmetic.Subtract((int[])((DataBufferInt)Original1.getRaster().getDataBuffer()).getData(), (int[])((DataBufferInt)Original2.getRaster().getDataBuffer()).getData(), (int[])((DataBufferInt)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
        }
    }

    public static BufferedImage Subtract(BufferedImage Original1, BufferedImage Original2, double Threshold, double SafeValue) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original2);
        ImageArithmetic.Subtract(Original1, Original2, result, Threshold, SafeValue);
        return result;
    }

    public static void Subtract(BufferedImage Original1, BufferedImage Original2, BufferedImage Result, double Threshold, double SafeValue) {
        if (ImageTools.isColored((BufferedImage)Original1) || ImageTools.isColored((BufferedImage)Original2)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        if (!ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Original2) || !ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Differents images dimensions.");
        }
        switch (Original1.getType()) {
            case 0: {
                switch (Original1.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        ArrayArithmetic.Subtract((double[])((DataBufferDouble)Original1.getRaster().getDataBuffer()).getData(), (double[])((DataBufferDouble)Original2.getRaster().getDataBuffer()).getData(), (double[])((DataBufferDouble)Result.getRaster().getDataBuffer()).getData());
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
        }
    }

    public static BufferedImage Subtract(BufferedImage Original1, BufferedImage Original2, float Threshold, float SafeValue) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original2);
        ImageArithmetic.Subtract(Original1, Original2, result, Threshold, SafeValue);
        return result;
    }

    public static void Subtract(BufferedImage Original1, BufferedImage Original2, BufferedImage Result, float Threshold, float SafeValue) {
        if (ImageTools.isColored((BufferedImage)Original1) || ImageTools.isColored((BufferedImage)Original2)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        if (!ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Original2) || !ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Differents images dimensions.");
        }
        switch (Original1.getType()) {
            case 0: {
                switch (Original1.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        ArrayArithmetic.Subtract((float[])((DataBufferFloat)Original1.getRaster().getDataBuffer()).getData(), (float[])((DataBufferFloat)Original2.getRaster().getDataBuffer()).getData(), (float[])((DataBufferFloat)Result.getRaster().getDataBuffer()).getData());
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
        }
    }

    public static BufferedImage Subtract(BufferedImage Original, int Value, int Threshold, int SafeValue) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original);
        ImageArithmetic.Subtract(Original, Value, result, Threshold, SafeValue);
        return result;
    }

    public static void Subtract(BufferedImage Original, int Value, BufferedImage Result, int Threshold, int SafeValue) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Different images types or dimensions.");
        }
        switch (Original.getType()) {
            case 10: {
                ArrayArithmetic.SubtractUnsigned((byte[])((DataBufferByte)Original.getRaster().getDataBuffer()).getData(), (byte)((byte)Value), (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData(), (byte)((byte)Threshold), (byte)((byte)SafeValue));
                break;
            }
            case 11: {
                ArrayArithmetic.SubtractUnsigned((short[])((DataBufferUShort)Original.getRaster().getDataBuffer()).getData(), (short)((short)Value), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (short)((short)Threshold), (short)((short)SafeValue));
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
        }
    }

    public static BufferedImage Subtract(BufferedImage Original, double Value, double Threshold, double SafeValue) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original);
        ImageArithmetic.Subtract(Original, Value, result, Threshold, SafeValue);
        return result;
    }

    public static void Subtract(BufferedImage Original, double Value, BufferedImage Result, double Threshold, double SafeValue) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Different images types or dimensions.");
        }
        block0 : switch (Original.getType()) {
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        ArrayArithmetic.Subtract((double[])((DataBufferDouble)Original.getRaster().getDataBuffer()).getData(), (double)Value, (double[])((DataBufferDouble)Result.getRaster().getDataBuffer()).getData(), (double)Threshold, (double)SafeValue);
                        break block0;
                    }
                    case 4: {
                        ArrayArithmetic.Subtract((float[])((DataBufferFloat)Original.getRaster().getDataBuffer()).getData(), (float)((float)Value), (float[])((DataBufferFloat)Result.getRaster().getDataBuffer()).getData(), (float)((float)Threshold), (float)((float)SafeValue));
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
        }
    }

    public static BufferedImage Multiply(BufferedImage Original1, BufferedImage Original2) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original2);
        ImageArithmetic.Multiply(Original1, Original2, result);
        return result;
    }

    public static void Multiply(BufferedImage Original1, BufferedImage Original2, BufferedImage Result) {
        switch (Original2.getType()) {
            case 10: {
                ImageArithmetic.Multiply(Original1, Original2, Result, 255, 255);
                break;
            }
            case 11: {
                ImageArithmetic.Multiply(Original1, Original2, Result, 65535, 65535);
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
        }
    }

    public static BufferedImage Multiply(BufferedImage Original1, BufferedImage Original2, int maxvalue, int safetymax) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original2);
        ImageArithmetic.Multiply(Original1, Original2, result, maxvalue, safetymax);
        return result;
    }

    public static void Multiply(BufferedImage Original1, BufferedImage Original2, BufferedImage Result, int maxvalue, int safetymax) {
        if (ImageTools.isColored((BufferedImage)Original1) || ImageTools.isColored((BufferedImage)Original2)) {
            throw new IllegalArgumentException("Only gray level or binary images supported.");
        }
        if (!ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Original2) || !ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Differents images dimensions.");
        }
        block0 : switch (Original1.getType()) {
            case 12: {
                switch (Original2.getType()) {
                    case 10: {
                        if (Result.getType() != 10) {
                            throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                        }
                        ArrayComparator.CompareBinary((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (String)"!=", (int)0, (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (int)0, (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData(), (int)Original1.getWidth(), (int)Original1.getHeight());
                        break block0;
                    }
                    case 11: {
                        if (Result.getType() != 11) {
                            throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                        }
                        ArrayComparator.CompareBinary((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (String)"!=", (int)0, (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (int)0, (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData(), (int)Original1.getWidth(), (int)Original1.getHeight());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
            case 10: {
                switch (Original2.getType()) {
                    case 10: {
                        switch (Result.getType()) {
                            case 10: {
                                ArrayArithmetic.MultiplyUnsigned((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData(), (int)maxvalue, (int)safetymax);
                                break block0;
                            }
                            case 11: {
                                ArrayArithmetic.MultiplyUnsigned((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (byte[])((DataBufferByte)Original2.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (int)maxvalue, (int)safetymax);
                                break block0;
                            }
                        }
                        throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                    }
                    case 11: {
                        if (Result.getType() != 11) {
                            throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                        }
                        ArrayArithmetic.MultiplyUnsigned((byte[])((DataBufferByte)Original1.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (int)maxvalue, (int)safetymax);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
            case 11: {
                if (Original2.getType() != 11 || Result.getType() != 11) {
                    throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
                }
                ArrayArithmetic.MultiplyUnsigned((short[])((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData(), (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (int)maxvalue, (int)safetymax);
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original1, Original2, Result));
            }
        }
    }

    public static BufferedImage Multiply(BufferedImage Original, int Value, int minvalue, int safetymin, int maxvalue, int safetymax) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original);
        ImageArithmetic.Multiply(Original, Value, result, minvalue, safetymin, maxvalue, safetymax);
        return result;
    }

    public static void Multiply(BufferedImage Original, int Value, BufferedImage Result, int minvalue, int safetymin, int maxvalue, int safetymax) {
        if (!ImageTools.areDimensionsEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Differents images dimensions.");
        }
        block0 : switch (Original.getType()) {
            case 10: {
                switch (Result.getType()) {
                    case 10: {
                        ArrayArithmetic.MultiplyUnsigned((byte[])((DataBufferByte)Original.getRaster().getDataBuffer()).getData(), (int)Value, (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData(), (int)minvalue, (int)safetymin, (int)maxvalue, (int)safetymax);
                        break block0;
                    }
                    case 11: {
                        ArrayArithmetic.MultiplyUnsigned((byte[])((DataBufferByte)Original.getRaster().getDataBuffer()).getData(), (int)Value, (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (int)minvalue, (int)safetymin, (int)maxvalue, (int)safetymax);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
            case 11: {
                ArrayArithmetic.MultiplyUnsigned((short[])((DataBufferUShort)Original.getRaster().getDataBuffer()).getData(), (int)Value, (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (int)minvalue, (int)safetymin, (int)maxvalue, (int)safetymax);
                break;
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
        }
    }

    public static BufferedImage Multiply(BufferedImage Original, double Value, int minvalue, int safetymin, int maxvalue, int safetymax) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original);
        ImageArithmetic.Multiply(Original, Value, result, minvalue, safetymin, maxvalue, safetymax);
        return result;
    }

    public static void Multiply(BufferedImage Original, double Value, BufferedImage Result, int minvalue, int safetymin, int maxvalue, int safetymax) {
        if (!ImageTools.areDimensionsEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Differents images dimensions.");
        }
        block0 : switch (Original.getType()) {
            case 10: {
                switch (Result.getType()) {
                    case 10: {
                        ArrayArithmetic.MultiplyUnsigned((byte[])((DataBufferByte)Original.getRaster().getDataBuffer()).getData(), (double)Value, (byte[])((DataBufferByte)Result.getRaster().getDataBuffer()).getData(), (int)minvalue, (int)safetymin, (int)maxvalue, (int)safetymax);
                        break block0;
                    }
                    case 11: {
                        ArrayArithmetic.MultiplyUnsigned((byte[])((DataBufferByte)Original.getRaster().getDataBuffer()).getData(), (double)Value, (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (int)minvalue, (int)safetymin, (int)maxvalue, (int)safetymax);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
            case 11: {
                ArrayArithmetic.MultiplyUnsigned((short[])((DataBufferUShort)Original.getRaster().getDataBuffer()).getData(), (double)Value, (short[])((DataBufferUShort)Result.getRaster().getDataBuffer()).getData(), (int)minvalue, (int)safetymin, (int)maxvalue, (int)safetymax);
                break;
            }
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        if (Result.getRaster().getDataBuffer().getDataType() != 4) {
                            throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
                        }
                        ArrayArithmetic.Multiply((float[])((DataBufferFloat)Original.getRaster().getDataBuffer()).getData(), (float)((float)Value), (float[])((DataBufferFloat)Result.getRaster().getDataBuffer()).getData(), (float)minvalue, (float)safetymin, (float)maxvalue, (float)safetymax);
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
        }
    }

    public static BufferedImage Multiply(BufferedImage Original, double Value) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original);
        ImageArithmetic.Multiply(Original, Value, result);
        return result;
    }

    public static void Multiply(BufferedImage Original, double Value, BufferedImage Result) {
        if (!ImageTools.areDimensionsEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Differents images dimensions.");
        }
        block0 : switch (Original.getType()) {
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        if (Result.getRaster().getDataBuffer().getDataType() != 4) {
                            throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
                        }
                        ArrayArithmetic.Multiply((float[])((DataBufferFloat)Original.getRaster().getDataBuffer()).getData(), (float)((float)Value), (float[])((DataBufferFloat)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                    case 5: {
                        if (Result.getRaster().getDataBuffer().getDataType() != 4) {
                            throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
                        }
                        ArrayArithmetic.Multiply((double[])((DataBufferDouble)Original.getRaster().getDataBuffer()).getData(), (double)Value, (double[])((DataBufferDouble)Result.getRaster().getDataBuffer()).getData());
                        break block0;
                    }
                }
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
            default: {
                throw new IllegalArgumentException(ImageArithmetic.MessageError(Original, Value, Result));
            }
        }
    }

    public static BufferedImage Average(BufferedImage image1, BufferedImage image2) {
        BufferedImage result = ImageNew.Same((BufferedImage)image1);
        ImageArithmetic.Average(image1, image2, result);
        return result;
    }

    public static void Average(BufferedImage image1, BufferedImage image2, BufferedImage result) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image1, (BufferedImage)image2)) {
            throw new IllegalArgumentException("Source images have different dimension or type.");
        }
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)image1, (BufferedImage)result)) {
            throw new IllegalArgumentException("Image source and result have different dimension or type.");
        }
        switch (image1.getType()) {
            case 5: 
            case 6: 
            case 10: {
                byte[] bb1 = ((DataBufferByte)image1.getRaster().getDataBuffer()).getData();
                byte[] bb2 = ((DataBufferByte)image2.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int i2 = 0; i2 < bb1.length; ++i2) {
                    bbres[i2] = (byte)((double)((bb1[i2] & 0xFF) + (bb2[i2] & 0xFF)) / 2.0);
                }
                bbres = null;
                bb2 = null;
                bb1 = null;
                break;
            }
            case 11: {
                short[] sb1 = ((DataBufferUShort)image1.getRaster().getDataBuffer()).getData();
                short[] sb2 = ((DataBufferUShort)image2.getRaster().getDataBuffer()).getData();
                short[] sbres = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                for (int i3 = 0; i3 < sb1.length; ++i3) {
                    sbres[i3] = (short)((double)((sb1[i3] & 0xFFFF) + (sb2[i3] & 0xFFFF)) / 2.0);
                }
                sbres = null;
                sb2 = null;
                sb1 = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not (yet) supported.");
            }
        }
    }

    public static BufferedImage Average(BufferedImage ... images) {
        BufferedImage result = ImageNew.Same((BufferedImage)images[0]);
        ImageArithmetic.Average(result, images);
        return result;
    }

    public static void Average(BufferedImage result, BufferedImage ... images) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)images[0], (BufferedImage)result)) {
            throw new IllegalArgumentException("Source images and result have different dimension or type.");
        }
        if (images.length < 3) {
            throw new IllegalArgumentException("At least 3 images required.");
        }
        int width = result.getWidth();
        int height = result.getHeight();
        int[][] sum = new int[height][width];
        switch (result.getType()) {
            case 5: 
            case 6: 
            case 10: {
                int x;
                int y;
                int pos;
                byte[] bbres = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int i2 = 0; i2 < images.length; ++i2) {
                    byte[] bb = ((DataBufferByte)images[i2].getRaster().getDataBuffer()).getData();
                    pos = 0;
                    for (y = 0; y < height; ++y) {
                        x = 0;
                        while (x < width) {
                            int[] nArray = sum[y];
                            int n = x++;
                            nArray[n] = nArray[n] + (bb[pos] & 0xFF);
                            ++pos;
                        }
                    }
                    bb = null;
                }
                pos = 0;
                for (y = 0; y < height; ++y) {
                    x = 0;
                    while (x < width) {
                        bbres[pos] = (byte)Math.round((double)sum[y][x] / (double)images.length);
                        ++x;
                        ++pos;
                    }
                }
                bbres = null;
                break;
            }
            case 11: {
                int x;
                int y;
                int pos;
                short[] sbres = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                for (int i3 = 0; i3 < images.length; ++i3) {
                    short[] sb = ((DataBufferUShort)images[i3].getRaster().getDataBuffer()).getData();
                    pos = 0;
                    for (y = 0; y < height; ++y) {
                        x = 0;
                        while (x < width) {
                            int[] nArray = sum[y];
                            int n = x++;
                            nArray[n] = nArray[n] + (sb[pos] & 0xFFFF);
                            ++pos;
                        }
                    }
                    sb = null;
                }
                pos = 0;
                for (y = 0; y < height; ++y) {
                    x = 0;
                    while (x < width) {
                        sbres[pos] = (short)Math.round((double)sum[y][x] / (double)images.length);
                        ++x;
                        ++pos;
                    }
                }
                sbres = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not (yet) supported.");
            }
        }
        sum = null;
    }

    public static BufferedImage And(BufferedImage Original1, BufferedImage Original2) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original2);
        ImageArithmetic.And(Original1, Original2, result);
        return result;
    }

    public static void And(BufferedImage Original1, BufferedImage Original2, BufferedImage Result) {
        if (!ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Original2) || !ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Differents images dimensions.");
        }
        switch (Original1.getType()) {
            case 10: {
                byte[] bbin1 = ((DataBufferByte)Original1.getRaster().getDataBuffer()).getData();
                byte[] bbin2 = ((DataBufferByte)Original2.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bbres.length; ++x) {
                    bbres[x] = (byte)(bbin1[x] & bbin2[x]);
                }
                bbres = null;
                bbin2 = null;
                bbin1 = null;
                break;
            }
            case 11: {
                short[] sbin1 = ((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData();
                short[] sbin2 = ((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData();
                short[] sbres = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < sbres.length; ++x) {
                    sbres[x] = (short)(sbin1[x] & sbin2[x]);
                }
                sbres = null;
                sbin2 = null;
                sbin1 = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not suported.");
            }
        }
    }

    public static BufferedImage Or(BufferedImage Original1, BufferedImage Original2) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original2);
        ImageArithmetic.Or(Original1, Original2, result);
        return result;
    }

    public static void Or(BufferedImage Original1, BufferedImage Original2, BufferedImage Result) {
        if (!ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Original2) || !ImageTools.areDimensionsEqual((BufferedImage)Original1, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Differents images dimensions.");
        }
        switch (Original1.getType()) {
            case 10: {
                byte[] bbin1 = ((DataBufferByte)Original1.getRaster().getDataBuffer()).getData();
                byte[] bbin2 = ((DataBufferByte)Original2.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < bbres.length; ++x) {
                    bbres[x] = (byte)(bbin1[x] | bbin2[x]);
                }
                bbres = null;
                bbin2 = null;
                bbin1 = null;
                break;
            }
            case 11: {
                short[] sbin1 = ((DataBufferUShort)Original1.getRaster().getDataBuffer()).getData();
                short[] sbin2 = ((DataBufferUShort)Original2.getRaster().getDataBuffer()).getData();
                short[] sbres = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                for (int x = 0; x < sbres.length; ++x) {
                    sbres[x] = (short)(sbin1[x] | sbin2[x]);
                }
                sbres = null;
                sbin2 = null;
                sbin1 = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not suported.");
            }
        }
    }

    public static BufferedImage Modulo(BufferedImage Original, int modulo) {
        BufferedImage result = ImageNew.Same((BufferedImage)Original);
        ImageArithmetic.Modulo(Original, modulo, result);
        return result;
    }

    public static void Modulo(BufferedImage Original, int modulo, BufferedImage Result) {
        if (!ImageTools.areDimensionsAndTypeEqual((BufferedImage)Original, (BufferedImage)Result) || !ImageTools.areDimensionsEqual((BufferedImage)Original, (BufferedImage)Result)) {
            throw new IllegalArgumentException("Images have different types or dimensions.");
        }
        block0 : switch (Original.getType()) {
            case 5: 
            case 10: {
                byte[] bbin = ((DataBufferByte)Original.getRaster().getDataBuffer()).getData();
                byte[] bbres = ((DataBufferByte)Result.getRaster().getDataBuffer()).getData();
                ArrayArithmetic.Modulo((byte[])bbin, (byte)((byte)modulo), (byte[])bbres);
                bbres = null;
                bbin = null;
                break;
            }
            case 11: {
                short[] sbin = ((DataBufferUShort)Original.getRaster().getDataBuffer()).getData();
                short[] sbres = ((DataBufferUShort)Result.getRaster().getDataBuffer()).getData();
                ArrayArithmetic.Modulo((short[])sbin, (short)((short)modulo), (short[])sbres);
                sbres = null;
                sbin = null;
                break;
            }
            case 0: {
                switch (Original.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        int[] ibin = ((DataBufferInt)Original.getRaster().getDataBuffer()).getData();
                        int[] ibres = ((DataBufferInt)Result.getRaster().getDataBuffer()).getData();
                        ArrayArithmetic.Modulo((int[])ibin, (int)modulo, (int[])ibres);
                        ibres = null;
                        ibin = null;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not suported (only TYPE_INT).");
            }
            default: {
                throw new IllegalArgumentException("Image type not suported (yet).");
            }
        }
    }
}

