/*
 * Decompiled with CFR 0.152.
 */
package imageJ.plugins;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.gui.ImageWindow;
import ij.plugin.PlugIn;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class Fractal_Generator
implements PlugIn {
    double type = 1.0;
    double D = 500.0;
    double iterations = 3.0;
    double SKALE = 0.3333333432674408;
    public float[][] FatFractalOrigins = new float[][]{{0.0f, 100.0f, 200.0f, 0.0f, 200.0f}, {0.0f, 100.0f, 0.0f, 200.0f, 200.0f}};
    public static float[][] DefaultFatFractalRules = new float[][]{{0.0f, 0.33333334f, 0.6666667f, 0.6666667f, 0.0f}, {0.0f, 0.33333334f, 0.6666667f, 0.0f, 0.6666667f}};
    public float[][] FatFractalRules = new float[][]{{0.0f, 0.33333334f, 0.6666667f, 0.6666667f, 0.0f}, {0.0f, 0.33333334f, 0.6666667f, 0.0f, 0.6666667f}};
    static String s = "s";
    static String r = "r";
    static String l = "l";
    double mag;

    public Fractal_Generator() {
        this.type = IJ.getNumber((String)"Type of image (2,3,8,18,32, or 50 for quadric segments or 1 for default)", (double)this.type);
        if (this.type != -2.147483648E9) {
            if (this.type == 1.0) {
                this.DrawIt();
                return;
            }
            if (this.type != 2.0 && this.type != 3.0 && this.type != 8.0 && this.type != 18.0 && this.type != 32.0 && this.type != 50.0) {
                this.type = 2.0;
            }
            this.D = IJ.getNumber((String)"Distance Between Points", (double)100.0);
            if (this.D != -2.147483648E9) {
                this.iterations = IJ.getNumber((String)"Iterations", (double)this.iterations);
                if (this.iterations != -2.147483648E9) {
                    double d = this.type == 3.0 ? 3.0 : (this.type == 8.0 ? 4.0 : (this.type == 18.0 ? 6.0 : (this.mag = this.type == 50.0 ? 10.0 : 8.0)));
                    if (this.type == 2.0) {
                        this.mag = Math.sqrt(5.0);
                    }
                    this.Iterate((int)this.iterations, (float)this.D, (int)this.type);
                }
            }
        }
    }

    void DrawIt() {
        String title = "Fractal";
        double x = 20.0;
        float[][] XYSize = this.GetNewOriginsAndRulesForFatFractal();
        int w = (int)(this.D + x + x);
        BufferedImage B = new BufferedImage(w, w, 2);
        Graphics2D g2 = (Graphics2D)B.getGraphics();
        this.DrawFat(g2, x, x, XYSize);
        new ImagePlus("new" + title, (Image)B).show();
    }

    public static void main(String[] args) {
        ImageJ imageJ = new ImageJ();
    }

    public void Iterate(int iterations, float DistanceBetweenPoints, int TYPE) {
        if (TYPE == 18) {
            this.Iterate18by4(iterations, DistanceBetweenPoints);
        }
        if (TYPE == 2) {
            this.Iterate2by4(iterations, DistanceBetweenPoints);
        }
        if (TYPE == 3) {
            this.Iterate3by4(iterations, DistanceBetweenPoints);
        }
        if (TYPE == 8) {
            this.Iterate8by4(iterations, DistanceBetweenPoints);
        }
        if (TYPE == 32) {
            this.Iterate32by4(iterations, DistanceBetweenPoints);
        }
        if (TYPE == 50) {
            this.Iterate50by4(iterations, DistanceBetweenPoints);
        }
    }

    public void Iterate3by4(int ITERS, float DistanceBetweenPoints) {
        int w;
        String title = "Cross Fractal Contour";
        double sc = Math.sqrt(5.0);
        double q = this.D;
        double off = this.D;
        int b = 0;
        b = 0;
        while ((double)b < this.iterations) {
            q += this.D + this.D / Math.pow(sc, b);
            off += (double)(b + 1) * this.D / Math.pow(sc, b);
            if (b > 3) {
                off += (double)(3 * (b + 1)) * this.D / Math.pow(sc, b);
            }
            if (b > 5) {
                off += (double)(5 * (b + 1)) * this.D / Math.pow(sc, b);
            }
            ++b;
        }
        int h = w = (int)(q + sc * this.D);
        BufferedImage B = new BufferedImage(w, h, 2);
        Graphics2D g2 = (Graphics2D)B.getGraphics();
        float[] As = new float[]{-90.0f, 0.0f, 90.0f, 180.0f};
        float[] Xs = new float[]{0.0f, (float)this.D, (float)this.D, 0.0f};
        float[] Ys = new float[]{0.0f, 0.0f, (float)this.D, (float)this.D};
        float x = 0.0f;
        float y = 0.0f;
        for (int A = 0; A < 4; ++A) {
            x = Xs[A];
            y = Ys[A];
            float[][] f = this.Iterate3(ITERS, DistanceBetweenPoints, x, y, As[A]);
            int[][] F = new int[2][f[0].length];
            for (int i2 = 0; i2 < f[0].length; ++i2) {
                F[0][i2] = (int)f[0][i2] + (int)off;
                F[1][i2] = (int)f[1][i2] + (int)off;
            }
            g2.drawPolyline(F[0], F[1], F[0].length);
        }
        ImageWindow iww = new ImageWindow(new ImagePlus(title, (Image)B));
        iww.setVisible(true);
    }

    public void Iterate50by4(int ITERS, float DistanceBetweenPoints) {
        String title = "50-Segment Quadric Fractal Contour";
        int w = (int)(this.D * this.mag);
        w += 2 * (int)this.D;
        int h = (int)(this.D * this.mag);
        if (this.type == 32.0) {
            h = w += 2 * (int)this.D;
        }
        BufferedImage B = new BufferedImage(w *= 2, h *= 2, 2);
        Graphics2D g2 = (Graphics2D)B.getGraphics();
        float[] As = new float[]{0.0f, 90.0f, 180.0f, -90.0f};
        float x = 0.0f;
        float y = 0.0f;
        for (int A = 0; A < 4; ++A) {
            float[][] f = Fractal_Generator.Iterate50(ITERS, DistanceBetweenPoints, x, y, As[A]);
            int[][] F = new int[2][f[0].length];
            for (int i2 = 0; i2 < f[0].length; ++i2) {
                F[0][i2] = (int)f[0][i2] + (int)(7.0 * this.D);
                F[1][i2] = (int)f[1][i2] + (int)(5.0 * this.D);
            }
            g2.drawPolyline(F[0], F[1], F[0].length);
            int end = f[0].length - 1;
            x = f[0][end];
            y = f[1][end];
        }
        ImageWindow iww = new ImageWindow(new ImagePlus(title, (Image)B));
        iww.setVisible(true);
    }

    public void Iterate2by4(int ITERS, float DistanceBetweenPoints) {
        String title = "Simple Quadric Fractal Contour";
        int w = (int)(this.D * this.mag);
        w += 2 * (int)this.D;
        int h = (int)(this.D * this.mag);
        h = w *= 2;
        BufferedImage B = new BufferedImage(w, h, 2);
        Graphics2D g2 = (Graphics2D)B.getGraphics();
        float[] As = new float[]{0.0f, -90.0f, 180.0f, 90.0f};
        float x = 0.0f;
        float y = 0.0f;
        int xoff = (int)(4.0 * this.D);
        int yoff = (int)(4.0 * this.D);
        for (int A = 0; A < 4; ++A) {
            float[][] f = Fractal_Generator.Iterate2(ITERS, DistanceBetweenPoints, x, y, As[A]);
            int[][] F = new int[2][f[0].length];
            for (int i2 = 0; i2 < f[0].length; ++i2) {
                F[0][i2] = (int)f[0][i2] + xoff;
                F[1][i2] = (int)f[1][i2] + yoff;
            }
            g2.drawPolyline(F[0], F[1], F[0].length);
            int end = f[0].length - 1;
            x = f[0][end];
            y = f[1][end];
        }
        ImageWindow iww = new ImageWindow(new ImagePlus(title, (Image)B));
        iww.setVisible(true);
    }

    public void Iterate32by4(int ITERS, float DistanceBetweenPoints) {
        String title = "32-Segment Quadric Fractal Contour";
        int w = (int)(this.D * this.mag);
        w += 2 * (int)this.D;
        int h = (int)(this.D * this.mag);
        if (this.type == 32.0) {
            h = w += 2 * (int)this.D;
        }
        BufferedImage B = new BufferedImage(w *= 2, h *= 2, 2);
        Graphics2D g2 = (Graphics2D)B.getGraphics();
        float[] As = new float[]{0.0f, 90.0f, 180.0f, -90.0f};
        float x = 0.0f;
        float y = 0.0f;
        for (int A = 0; A < 4; ++A) {
            float[][] f = Fractal_Generator.Iterate32(ITERS, DistanceBetweenPoints, x, y, As[A]);
            int[][] F = new int[2][f[0].length];
            for (int i2 = 0; i2 < f[0].length; ++i2) {
                F[0][i2] = (int)f[0][i2] + (int)(this.mag * 2.0 * this.D);
                F[1][i2] = (int)f[1][i2] + (int)(this.mag * this.D);
            }
            g2.drawPolyline(F[0], F[1], F[0].length);
            int end = f[0].length - 1;
            x = f[0][end];
            y = f[1][end];
        }
        ImageWindow iww = new ImageWindow(new ImagePlus(title, (Image)B));
        iww.setVisible(true);
    }

    public void Iterate18by4(int ITERS, float DistanceBetweenPoints) {
        String title = "18-Segment Quadric Fractal Contour";
        int w = (int)(this.D * this.mag);
        w += 2 * (int)this.D;
        int h = (int)(this.D * this.mag);
        if (this.type == 32.0) {
            h = w += 2 * (int)this.D;
        }
        BufferedImage B = new BufferedImage(w *= 3, h *= 3, 2);
        Graphics2D g2 = (Graphics2D)B.getGraphics();
        float[] As = new float[]{0.0f, 90.0f, 180.0f, -90.0f};
        float x = 0.0f;
        float y = 0.0f;
        for (int A = 0; A < 4; ++A) {
            float[][] f = Fractal_Generator.Iterate18(ITERS, DistanceBetweenPoints, x, y, As[A]);
            int[][] F = new int[2][f[0].length];
            for (int i2 = 0; i2 < f[0].length; ++i2) {
                F[0][i2] = (int)f[0][i2] + (int)(this.mag * this.D);
                F[1][i2] = (int)f[1][i2] + (int)(this.mag * this.D / 2.0);
            }
            g2.drawPolyline(F[0], F[1], F[0].length);
            int end = f[0].length - 1;
            x = f[0][end];
            y = f[1][end];
        }
        ImageWindow iww = new ImageWindow(new ImagePlus(title, (Image)B));
        iww.setVisible(true);
    }

    public void Iterate8by4(int ITERS, float DistanceBetweenPoints) {
        String title = "8-Segment Quadric Fractal Contour";
        int w = (int)(this.D * this.mag);
        w += 2 * (int)this.D;
        int h = (int)(this.D * this.mag);
        if (this.type == 32.0) {
            h = w += 2 * (int)this.D;
        }
        BufferedImage B = new BufferedImage(w *= 2, h *= 2, 2);
        Graphics2D g2 = (Graphics2D)B.getGraphics();
        float[] As = new float[]{0.0f, 90.0f, 180.0f, -90.0f};
        float x = 0.0f;
        float y = 0.0f;
        for (int A = 0; A < 4; ++A) {
            float[][] f = Fractal_Generator.Iterate8(ITERS, DistanceBetweenPoints, x, y, As[A]);
            int[][] F = new int[2][f[0].length];
            for (int i2 = 0; i2 < f[0].length; ++i2) {
                F[0][i2] = (int)f[0][i2] + (int)(this.mag * this.D);
                F[1][i2] = (int)f[1][i2] + (int)(this.mag * this.D / 2.0);
            }
            g2.drawPolyline(F[0], F[1], F[0].length);
            int end = f[0].length - 1;
            x = f[0][end];
            y = f[1][end];
        }
        ImageWindow iww = new ImageWindow(new ImagePlus(title, (Image)B));
        iww.setVisible(true);
    }

    public static float[][] Iterate18(int ITERS, float DistanceBetweenPoints) {
        return Fractal_Generator.Iterate18(ITERS, DistanceBetweenPoints, 0.0f, 0.0f, 0.0f);
    }

    public static float[][] Iterate18(int ITERS, float DistanceBetweenPoints, float seedx, float seedy, float seedangle) {
        float scale = 6.0f;
        int count = 0;
        int iterations = ITERS;
        int n = 1 + (int)Math.pow(18.0, iterations + 1);
        float[][] GrowingArray = new float[3][n];
        float[][] f = Fractal_Generator.MakeStartingArray18(DistanceBetweenPoints, seedx, seedy, seedangle);
        if (ITERS <= 1) {
            return f;
        }
        for (int i2 = 0; i2 < f[0].length; ++i2) {
            GrowingArray[0][i2] = f[0][i2];
            GrowingArray[1][i2] = f[1][i2];
            GrowingArray[2][i2] = f[2][i2];
        }
        float Length = DistanceBetweenPoints;
        count = 0;
        for (int Q = 0; Q < iterations - 1; ++Q) {
            count = 0;
            Length /= scale;
            for (int i3 = 0; i3 < f[0].length - 1; ++i3) {
                float[][] T = Fractal_Generator.MakeStartingArray18(Length, f[0][i3], f[1][i3], f[2][i3]);
                for (int j = 0; j < T[0].length - 1; ++j) {
                    GrowingArray[0][count] = T[0][j];
                    GrowingArray[1][count] = T[1][j];
                    GrowingArray[2][count] = T[2][j];
                    ++count;
                }
                if (i3 != f[0].length - 2) continue;
                GrowingArray[0][count] = T[0][T[0].length - 1];
                GrowingArray[1][count] = T[1][T[1].length - 1];
                GrowingArray[2][count] = T[2][T[2].length - 1];
                ++count;
            }
            f = new float[3][count];
            for (int z = 0; z < count; ++z) {
                f[0][z] = GrowingArray[0][z];
                f[1][z] = GrowingArray[1][z];
                f[2][z] = GrowingArray[2][z];
            }
        }
        System.gc();
        return f;
    }

    public static float[][] Iterate2(int ITERS, float DistanceBetweenPoints, float seedx, float seedy, float seedangle) {
        float scale = (float)Math.sqrt(5.0);
        int count = 0;
        int iterations = ITERS;
        int n = 1 + (int)Math.pow(3.0, iterations + 1);
        float[][] GrowingArray = new float[3][n];
        float[][] f = Fractal_Generator.MakeStartingArray2(DistanceBetweenPoints, seedx, seedy, seedangle);
        if (ITERS <= 1) {
            return f;
        }
        for (int i2 = 0; i2 < f[0].length; ++i2) {
            GrowingArray[0][i2] = f[0][i2];
            GrowingArray[1][i2] = f[1][i2];
            GrowingArray[2][i2] = f[2][i2];
        }
        float Length = DistanceBetweenPoints;
        count = 1;
        float TheLastXDrawn = f[0][0];
        float TheLastYDrawn = f[1][0];
        float FirstX = f[0][0];
        float FirstY = f[1][0];
        for (int Q = 0; Q < iterations - 1; ++Q) {
            count = 0;
            Length /= scale;
            TheLastXDrawn = FirstX;
            TheLastYDrawn = FirstY;
            for (int i3 = 0; i3 < f[0].length - 1; ++i3) {
                float angleOfThisSegment = f[2][i3];
                float x = TheLastXDrawn;
                float y = TheLastYDrawn;
                float[][] T = Fractal_Generator.MakeStartingArray2(Length, x, y, angleOfThisSegment);
                for (int j = 0; j < T[0].length - 1; ++j) {
                    GrowingArray[0][count] = T[0][j];
                    GrowingArray[1][count] = T[1][j];
                    GrowingArray[2][count] = T[2][j];
                    ++count;
                }
                TheLastXDrawn = T[0][T[0].length - 1];
                TheLastYDrawn = T[1][T[0].length - 1];
                if (i3 != f[0].length - 2) continue;
                GrowingArray[0][count] = T[0][T[0].length - 1];
                GrowingArray[1][count] = T[1][T[1].length - 1];
                GrowingArray[2][count] = T[2][T[2].length - 1];
                ++count;
            }
            f = new float[3][count];
            for (int z = 0; z < count; ++z) {
                f[0][z] = GrowingArray[0][z];
                f[1][z] = GrowingArray[1][z];
                f[2][z] = GrowingArray[2][z];
            }
        }
        System.gc();
        return f;
    }

    public static float[][] Iterate50(int ITERS, float DistanceBetweenPoints) {
        return Fractal_Generator.Iterate50(ITERS, DistanceBetweenPoints, 0.0f, 0.0f, 0.0f);
    }

    public static float[][] Iterate50(int ITERS, float DistanceBetweenPoints, float seedx, float seedy, float seedangle) {
        float scale = 10.0f;
        int count = 0;
        int iterations = ITERS;
        int n = 1 + (int)Math.pow(50.0, iterations + 1);
        float[][] GrowingArray = new float[3][n];
        float[][] f = Fractal_Generator.MakeStartingArray50(DistanceBetweenPoints, seedx, seedy, seedangle);
        if (ITERS <= 1) {
            return f;
        }
        for (int i2 = 0; i2 < f[0].length; ++i2) {
            GrowingArray[0][i2] = f[0][i2];
            GrowingArray[1][i2] = f[1][i2];
            GrowingArray[2][i2] = f[2][i2];
        }
        float Length = DistanceBetweenPoints;
        count = 0;
        for (int Q = 0; Q < iterations - 1; ++Q) {
            count = 0;
            Length /= scale;
            for (int i3 = 0; i3 < f[0].length - 1; ++i3) {
                float[][] T = Fractal_Generator.MakeStartingArray50(Length, f[0][i3], f[1][i3], f[2][i3]);
                for (int j = 0; j < T[0].length - 1; ++j) {
                    GrowingArray[0][count] = T[0][j];
                    GrowingArray[1][count] = T[1][j];
                    GrowingArray[2][count] = T[2][j];
                    ++count;
                }
                if (i3 != f[0].length - 2) continue;
                GrowingArray[0][count] = T[0][T[0].length - 1];
                GrowingArray[1][count] = T[1][T[1].length - 1];
                GrowingArray[2][count] = T[2][T[2].length - 1];
                ++count;
            }
            f = new float[3][count];
            for (int z = 0; z < count; ++z) {
                f[0][z] = GrowingArray[0][z];
                f[1][z] = GrowingArray[1][z];
                f[2][z] = GrowingArray[2][z];
            }
        }
        System.gc();
        return f;
    }

    public static float[][] Iterate8(int ITERS, float DistanceBetweenPoints) {
        return Fractal_Generator.Iterate8(ITERS, DistanceBetweenPoints, 0.0f, 0.0f, 0.0f);
    }

    public static float[][] Iterate8(int ITERS, float DistanceBetweenPoints, float seedx, float seedy, float seedangle) {
        float scale = 4.0f;
        int count = 0;
        int iterations = ITERS;
        int n = 1 + (int)Math.pow(8.0, iterations + 1);
        float[][] GrowingArray = new float[3][n];
        float[][] f = Fractal_Generator.MakeStartingArray8(DistanceBetweenPoints, seedx, seedy, seedangle);
        if (ITERS <= 1) {
            return f;
        }
        for (int i2 = 0; i2 < f[0].length; ++i2) {
            GrowingArray[0][i2] = f[0][i2];
            GrowingArray[1][i2] = f[1][i2];
            GrowingArray[2][i2] = f[2][i2];
        }
        float Length = DistanceBetweenPoints;
        count = 0;
        for (int Q = 0; Q < iterations - 1; ++Q) {
            count = 0;
            Length /= scale;
            for (int i3 = 0; i3 < f[0].length - 1; ++i3) {
                float[][] T = Fractal_Generator.MakeStartingArray8(Length, f[0][i3], f[1][i3], f[2][i3]);
                for (int j = 0; j < T[0].length - 1; ++j) {
                    GrowingArray[0][count] = T[0][j];
                    GrowingArray[1][count] = T[1][j];
                    GrowingArray[2][count] = T[2][j];
                    ++count;
                }
                if (i3 != f[0].length - 2) continue;
                GrowingArray[0][count] = T[0][T[0].length - 1];
                GrowingArray[1][count] = T[1][T[1].length - 1];
                GrowingArray[2][count] = T[2][T[2].length - 1];
                ++count;
            }
            f = new float[3][count];
            for (int z = 0; z < count; ++z) {
                f[0][z] = GrowingArray[0][z];
                f[1][z] = GrowingArray[1][z];
                f[2][z] = GrowingArray[2][z];
            }
        }
        System.gc();
        return f;
    }

    public static float[][] Iterate32(int ITERS, float DistanceBetweenPoints) {
        return Fractal_Generator.Iterate32(ITERS, DistanceBetweenPoints, 0.0f, 0.0f, 90.0f);
    }

    public static float[][] Iterate32(int ITERS, float DistanceBetweenPoints, float seedx, float seedy, float seedangle) {
        float scale = 8.0f;
        int count = 0;
        int iterations = ITERS;
        int n = 1 + (int)Math.pow(32.0, iterations + 1);
        float[][] GrowingArray = new float[3][n];
        float[][] f = Fractal_Generator.MakeStartingArray32(DistanceBetweenPoints, seedx, seedy, seedangle);
        if (ITERS <= 1) {
            return f;
        }
        for (int i2 = 0; i2 < f[0].length; ++i2) {
            GrowingArray[0][i2] = f[0][i2];
            GrowingArray[1][i2] = f[1][i2];
            GrowingArray[2][i2] = f[2][i2];
        }
        float Length = DistanceBetweenPoints;
        count = 0;
        for (int Q = 0; Q < iterations - 1; ++Q) {
            count = 0;
            Length /= scale;
            for (int i3 = 0; i3 < f[0].length - 1; ++i3) {
                float[][] T = Fractal_Generator.MakeStartingArray32(Length, f[0][i3], f[1][i3], f[2][i3] == -90.0f ? 180.0f : f[2][i3] - 90.0f);
                for (int j = 0; j < T[0].length - 1; ++j) {
                    GrowingArray[0][count] = T[0][j];
                    GrowingArray[1][count] = T[1][j];
                    GrowingArray[2][count] = T[2][j];
                    ++count;
                }
                if (i3 != f[0].length - 2) continue;
                GrowingArray[0][count] = T[0][T[0].length - 1];
                GrowingArray[1][count] = T[1][T[1].length - 1];
                GrowingArray[2][count] = T[2][T[2].length - 1];
                ++count;
            }
            f = new float[3][count];
            for (int z = 0; z < count; ++z) {
                f[0][z] = GrowingArray[0][z];
                f[1][z] = GrowingArray[1][z];
                f[2][z] = GrowingArray[2][z];
            }
        }
        System.gc();
        return f;
    }

    public float[][] Iterate3(int ITERS, float DistanceBetweenPoints) {
        return this.Iterate3(ITERS, DistanceBetweenPoints, 0.0f, 0.0f, -90.0f);
    }

    public float[][] Iterate3(int iterations, float DistanceBetweenFirstPoints, float seedx, float seedy, float seedangle) {
        float scale = (float)Math.sqrt(5.0);
        int count = 0;
        int n = 1 + (int)Math.pow(6.0, iterations + 1);
        float[][] GrowingArray = new float[3][n];
        float[][] f = Fractal_Generator.MakeStartingArray3(DistanceBetweenFirstPoints, seedangle, seedx, seedy);
        if (iterations < 2) {
            return f;
        }
        float DistanceBetweenPoints = DistanceBetweenFirstPoints;
        float DistanceToFirstPoint = DistanceBetweenFirstPoints;
        float LastLength = DistanceBetweenPoints;
        DistanceToFirstPoint = (DistanceBetweenPoints - DistanceBetweenPoints / scale) / 2.0f;
        float d = DistanceToFirstPoint;
        float ll = DistanceBetweenPoints /= scale;
        f = this.MakeNewArray3(d, ll, f[0][0], f[1][0], f[2][0]);
        if (iterations < 3) {
            return f;
        }
        for (int Q = 2; Q < iterations; ++Q) {
            count = 0;
            LastLength = DistanceBetweenPoints;
            DistanceToFirstPoint = (DistanceBetweenPoints - DistanceBetweenPoints / scale) / 2.0f;
            DistanceBetweenPoints /= scale;
            for (int p = 0; p < f[0].length; ++p) {
                GrowingArray[0][count] = f[0][p];
                GrowingArray[1][count] = f[1][p];
                GrowingArray[2][count] = f[2][p];
                ++count;
                boolean Stop = true;
                if (p > 0 && p < f[0].length - 1) {
                    Stop = false;
                }
                if (!Stop) {
                    Stop = true;
                    int Cw = 1;
                    int Cn = 1;
                    int Ct = 1;
                    int Cr = 1;
                    int Cq = 1;
                    int test = 0;
                    int start = 0;
                    for (int j = 0; j < f[0].length; ++j) {
                        if (j == 0) {
                            start = test = Q - 1;
                            if (p == test) {
                                Stop = false;
                                j = f[0].length;
                            }
                        } else {
                            if (Cw == 3) {
                                test += 2;
                                Cw = 0;
                            }
                            ++Cw;
                            if (Cn == 9) {
                                if (f[0].length > 9) {
                                    test += 2;
                                }
                                Cn = 0;
                            }
                            ++Cn;
                            if (Ct == 27) {
                                test += 2;
                                Ct = 0;
                            }
                            ++Ct;
                            if (Cr == 81) {
                                test += 2;
                                Cr = 0;
                            }
                            ++Cr;
                            if (Cq == 243) {
                                test += 2;
                                Cq = 0;
                            }
                            ++Cq;
                            test += 5;
                        }
                        if (p != test) continue;
                        Stop = false;
                        j = f[0].length;
                    }
                }
                if (Stop) continue;
                float[][] temp = this.MakeNewArray3(DistanceToFirstPoint, DistanceBetweenPoints, f[0][p], f[1][p], f[2][p]);
                --count;
                ++p;
                ++p;
                ++p;
                for (int j = 0; j < temp[0].length; ++j) {
                    GrowingArray[0][count] = temp[0][j];
                    GrowingArray[1][count] = temp[1][j];
                    GrowingArray[2][count] = temp[2][j];
                    ++count;
                }
            }
            f = new float[3][count];
            for (int w = 0; w < count; ++w) {
                f[0][w] = GrowingArray[0][w];
                f[1][w] = GrowingArray[1][w];
                f[2][w] = GrowingArray[2][w];
            }
        }
        System.gc();
        return f;
    }

    static float[][] MakeStartingArray18(float DistanceBetweenPoints, float seedx, float seedy, float seedangle) {
        int NumberOfParts = 18;
        int N = NumberOfParts + 1;
        float[] NewX = new float[N];
        float[] NewY = new float[N];
        NewX[0] = seedx;
        NewY[0] = seedy;
        String[] turns = new String[]{l, s, r, s, r, r, l, l, s, r, r, l, l, s, l, s, r, s};
        float[] Newangle = Fractal_Generator.ApplyGrammar(seedangle, turns);
        block6: for (int i2 = 1; i2 < NumberOfParts + 1; ++i2) {
            switch ((int)Newangle[i2 - 1]) {
                case 0: {
                    NewX[i2] = NewX[i2 - 1] + DistanceBetweenPoints;
                    NewY[i2] = NewY[i2 - 1];
                    continue block6;
                }
                case 90: {
                    NewX[i2] = NewX[i2 - 1];
                    NewY[i2] = NewY[i2 - 1] + DistanceBetweenPoints;
                    continue block6;
                }
                case -90: {
                    NewX[i2] = NewX[i2 - 1];
                    NewY[i2] = NewY[i2 - 1] - DistanceBetweenPoints;
                    continue block6;
                }
                case 180: {
                    NewX[i2] = NewX[i2 - 1] - DistanceBetweenPoints;
                    NewY[i2] = NewY[i2 - 1];
                }
            }
        }
        return new float[][]{NewX, NewY, Newangle};
    }

    static float[][] MakeStartingArray2(float D, float seedx, float seedy, float seedangle) {
        int NumberOfParts = 3;
        int N = NumberOfParts + 1;
        float[] NewX = new float[N];
        float[] NewY = new float[N];
        float[] Newangle = new float[N];
        NewX[0] = seedx;
        NewY[0] = seedy;
        if (seedangle == 0.0f) {
            NewX[1] = NewX[0] + D;
            NewY[1] = NewY[0];
            Newangle[0] = 0.0f;
            NewX[2] = NewX[1];
            NewY[2] = NewY[1] - D;
            Newangle[1] = -90.0f;
            NewX[3] = NewX[2] + D;
            NewY[3] = NewY[2];
            Newangle[2] = 0.0f;
        }
        if (seedangle == 90.0f) {
            NewX[1] = NewX[0];
            NewY[1] = NewY[0] + D;
            Newangle[0] = 90.0f;
            NewX[2] = NewX[1] + D;
            NewY[2] = NewY[1];
            Newangle[1] = 0.0f;
            NewX[3] = NewX[2];
            NewY[3] = NewY[2] + D;
            Newangle[2] = 90.0f;
        }
        if (seedangle == 180.0f) {
            NewX[1] = NewX[0] - D;
            NewY[1] = NewY[0];
            Newangle[0] = 180.0f;
            NewX[2] = NewX[1];
            NewY[2] = NewY[1] + D;
            Newangle[1] = 90.0f;
            NewX[3] = NewX[2] - D;
            NewY[3] = NewY[2];
            Newangle[2] = 180.0f;
        }
        if (seedangle == -90.0f) {
            NewX[1] = NewX[0];
            NewY[1] = NewY[0] - D;
            Newangle[0] = -90.0f;
            NewX[2] = NewX[1] - D;
            NewY[2] = NewY[1];
            Newangle[1] = 180.0f;
            NewX[3] = NewX[2];
            NewY[3] = NewY[2] - D;
            Newangle[2] = -90.0f;
        }
        return new float[][]{NewX, NewY, Newangle};
    }

    static float[][] MakeStartingArray32(float DistanceBetweenPoints, float seedx, float seedy, float seedangle) {
        int NumberOfParts = 32;
        int N = NumberOfParts + 1;
        float[] NewX = new float[N];
        float[] NewY = new float[N];
        NewX[0] = seedx;
        NewY[0] = seedy;
        String[] turns = new String[]{r, l, l, r, r, s, l, r, r, s, r, l, l, s, r, s, l, s, r, r, l, s, l, l, r, s, l, l, r, r, l, r};
        float[] Newangle = Fractal_Generator.ApplyGrammar(seedangle, turns);
        block6: for (int j = 1; j < NumberOfParts + 1; ++j) {
            switch ((int)Newangle[j - 1]) {
                case 0: {
                    NewX[j] = NewX[j - 1] + DistanceBetweenPoints;
                    NewY[j] = NewY[j - 1];
                    continue block6;
                }
                case 90: {
                    NewX[j] = NewX[j - 1];
                    NewY[j] = NewY[j - 1] + DistanceBetweenPoints;
                    continue block6;
                }
                case -90: {
                    NewX[j] = NewX[j - 1];
                    NewY[j] = NewY[j - 1] - DistanceBetweenPoints;
                    continue block6;
                }
                case 180: {
                    NewX[j] = NewX[j - 1] - DistanceBetweenPoints;
                    NewY[j] = NewY[j - 1];
                }
            }
        }
        return new float[][]{NewX, NewY, Newangle};
    }

    static float[][] MakeStartingArray8(float DistanceBetweenPoints, float seedx, float seedy, float seedangle) {
        int NumberOfParts = 8;
        int N = NumberOfParts + 1;
        float[] NewX = new float[N];
        float[] NewY = new float[N];
        NewX[0] = seedx;
        NewY[0] = seedy;
        String[] turns = new String[]{l, r, r, s, l, l, r};
        float[] Newangle = Fractal_Generator.ApplyGrammar(seedangle, turns);
        block6: for (int i2 = 1; i2 < NumberOfParts + 1; ++i2) {
            switch ((int)Newangle[i2 - 1]) {
                case 0: {
                    NewX[i2] = NewX[i2 - 1] + DistanceBetweenPoints;
                    NewY[i2] = NewY[i2 - 1];
                    continue block6;
                }
                case 90: {
                    NewX[i2] = NewX[i2 - 1];
                    NewY[i2] = NewY[i2 - 1] + DistanceBetweenPoints;
                    continue block6;
                }
                case -90: {
                    NewX[i2] = NewX[i2 - 1];
                    NewY[i2] = NewY[i2 - 1] - DistanceBetweenPoints;
                    continue block6;
                }
                case 180: {
                    NewX[i2] = NewX[i2 - 1] - DistanceBetweenPoints;
                    NewY[i2] = NewY[i2 - 1];
                }
            }
        }
        return new float[][]{NewX, NewY, Newangle};
    }

    static float[][] MakeStartingArray50(float DistanceBetweenPoints, float seedx, float seedy, float seedangle) {
        int i2;
        int NumberOfParts = 50;
        int N = NumberOfParts + 1;
        float[] NewX = new float[N];
        float[] NewY = new float[N];
        float[] Newangle = new float[N];
        Newangle[0] = seedangle;
        NewX[0] = seedx;
        NewY[0] = seedy;
        String[] D = new String[]{r, l, r, r, s, s, l, s, r, s, l, l, s, s, l, s, r, s, s, s, r, r, s, s, l, s, r, s, s, l, l, s, s, s, l, s, r, s, s, r, r, s, l, s, r, s, s, l, l, r};
        for (i2 = 1; i2 < D.length; ++i2) {
            Newangle[i2] = D[i2].equals(s) ? Newangle[i2 - 1] : (D[i2].equals(l) ? (Newangle[i2 - 1] == -90.0f ? 180.0f : Newangle[i2 - 1] - 90.0f) : (D[i2].equals(r) ? (Newangle[i2 - 1] == 180.0f ? -90.0f : Newangle[i2 - 1] + 90.0f) : 0.0f));
        }
        block7: for (i2 = 1; i2 < NumberOfParts + 1; ++i2) {
            switch ((int)Newangle[i2 - 1]) {
                case 0: {
                    NewX[i2] = NewX[i2 - 1] + DistanceBetweenPoints;
                    NewY[i2] = NewY[i2 - 1];
                    continue block7;
                }
                case 90: {
                    NewX[i2] = NewX[i2 - 1];
                    NewY[i2] = NewY[i2 - 1] + DistanceBetweenPoints;
                    continue block7;
                }
                case -90: {
                    NewX[i2] = NewX[i2 - 1];
                    NewY[i2] = NewY[i2 - 1] - DistanceBetweenPoints;
                    continue block7;
                }
                case 180: {
                    NewX[i2] = NewX[i2 - 1] - DistanceBetweenPoints;
                    NewY[i2] = NewY[i2 - 1];
                }
            }
        }
        return new float[][]{NewX, NewY, Newangle};
    }

    static float[] ApplyGrammar(float seedangle, String[] S) {
        float[] Newangle = new float[S.length + 2];
        Newangle[0] = seedangle;
        for (int i2 = 0; i2 < S.length; ++i2) {
            Newangle[i2 + 1] = S[i2].equals(s) ? Newangle[i2] : (S[i2].equals(l) ? (Newangle[i2] == -90.0f ? 180.0f : Newangle[i2] - 90.0f) : (S[i2].equals(r) ? (Newangle[i2] == 180.0f ? -90.0f : Newangle[i2] + 90.0f) : 0.0f));
        }
        Newangle[Newangle.length - 1] = Newangle[Newangle.length - 2];
        return Newangle;
    }

    static float[][] MakeStartingArray3(float DistanceBetweenPoints, float startingDirection, float seedx, float seedy) {
        int N = 4;
        float[] Newangle = new float[N];
        float[] NewX = new float[N];
        float[] NewY = new float[N];
        NewX[0] = seedx;
        NewY[0] = seedy;
        Newangle[0] = startingDirection;
        Newangle[1] = Newangle[0] == 180.0f ? -90.0f : Newangle[0] + 90.0f;
        Newangle[2] = Newangle[1] == 180.0f ? -90.0f : Newangle[1] + 90.0f;
        Newangle[3] = Newangle[2];
        block6: for (int i2 = 1; i2 < N; ++i2) {
            switch ((int)Newangle[i2 - 1]) {
                case 0: {
                    NewX[i2] = NewX[i2 - 1] + DistanceBetweenPoints;
                    NewY[i2] = NewY[i2 - 1];
                    continue block6;
                }
                case 90: {
                    NewX[i2] = NewX[i2 - 1];
                    NewY[i2] = NewY[i2 - 1] + DistanceBetweenPoints;
                    continue block6;
                }
                case -90: {
                    NewX[i2] = NewX[i2 - 1];
                    NewY[i2] = NewY[i2 - 1] - DistanceBetweenPoints;
                    continue block6;
                }
                case 180: {
                    NewX[i2] = NewX[i2 - 1] - DistanceBetweenPoints;
                    NewY[i2] = NewY[i2 - 1];
                }
            }
        }
        return new float[][]{NewX, NewY, Newangle};
    }

    float[][] MakeNewArray3(float d, float L, float px, float py, float seedangle) {
        int N = 16;
        float[] NewX = new float[N];
        float[] NewY = new float[N];
        NewX[0] = px;
        NewY[0] = py;
        String[] turns = new String[]{l, r, r, l, r, l, r, r, l, r, l, r, r, l, s};
        float[] Newangle = Fractal_Generator.ApplyGrammar(seedangle, turns);
        float S = L;
        block6: for (int i2 = 1; i2 < N; ++i2) {
            S = i2 == 1 || i2 == 5 || i2 == 6 || i2 == 10 || i2 == 11 || i2 == 15 ? (i2 == 1 || i2 == 15 ? (float)(this.iterations + 1.0) * d : d) : L;
            switch ((int)Newangle[i2 - 1]) {
                case 0: {
                    NewX[i2] = NewX[i2 - 1] + S;
                    NewY[i2] = NewY[i2 - 1];
                    continue block6;
                }
                case 90: {
                    NewX[i2] = NewX[i2 - 1];
                    NewY[i2] = NewY[i2 - 1] + S;
                    continue block6;
                }
                case -90: {
                    NewX[i2] = NewX[i2 - 1];
                    NewY[i2] = NewY[i2 - 1] - S;
                    continue block6;
                }
                case 180: {
                    NewX[i2] = NewX[i2 - 1] - S;
                    NewY[i2] = NewY[i2 - 1];
                }
            }
        }
        return new float[][]{NewX, NewY, Newangle};
    }

    public void run(String str) {
    }

    public static float[][] MakeActualNewPositionsInFatFractal(float[][] XYRules, float size, float SKale, double iterations) {
        int newparts = XYRules[0].length;
        int finallength = (int)Math.pow(newparts, iterations);
        float[][] newxysize = new float[3][finallength];
        float[] Oldx = new float[1];
        float[] Oldy = new float[1];
        Oldx[0] = 0.0f;
        Oldy[0] = 0.0f;
        float lastsize = size;
        float currentsize = size;
        for (int i2 = 0; i2 < (int)iterations; ++i2) {
            lastsize = currentsize;
            currentsize = lastsize * SKale;
            int c = 0;
            for (int b = 0; b < Oldx.length; ++b) {
                for (int f = 0; f < newparts; ++f) {
                    newxysize[0][c] = Oldx[b] + lastsize * XYRules[0][f];
                    newxysize[1][c] = Oldy[b] + lastsize * XYRules[1][f];
                    newxysize[2][c] = currentsize;
                    ++c;
                }
            }
            Oldx = new float[c];
            Oldy = new float[c];
            for (int m = 0; m < c; ++m) {
                Oldx[m] = newxysize[0][m];
                Oldy[m] = newxysize[1][m];
            }
        }
        return newxysize;
    }

    float[][] GetNewOriginsAndRulesForFatFractal() {
        boolean quit = false;
        int parts = DefaultFatFractalRules[0].length;
        int iters = 5;
        int p = (int)IJ.getNumber((String)"Number of new parts", (double)parts);
        if (p == Integer.MIN_VALUE) {
            quit = true;
        } else {
            parts = p;
        }
        if (!quit) {
            float S = Fractal_Generator.getFraction("Scale for new parts (fraction)", (float)this.SKALE);
            if (S < 0.0f) {
                quit = true;
            } else {
                this.SKALE = S;
            }
        }
        if (!quit) {
            int T = (int)IJ.getNumber((String)"Number of iterations", (double)iters);
            if (T == Integer.MIN_VALUE) {
                quit = true;
            } else {
                iters = T;
            }
        }
        if (!quit) {
            float SS = (float)IJ.getNumber((String)"Starting Size", (double)((float)this.D));
            if (SS == -2.1474836E9f) {
                quit = true;
            } else {
                this.D = SS;
            }
        }
        if (!quit) {
            int i2;
            float[][] Rules = new float[2][parts];
            for (i2 = 0; i2 < parts; ++i2) {
                if (quit) {
                    i2 = parts;
                    continue;
                }
                float defx = i2 < DefaultFatFractalRules[0].length ? DefaultFatFractalRules[0][i2] : 0.0f;
                float F = Fractal_Generator.getFraction("Fraction from X for position " + i2, defx);
                if (F < 0.0f) {
                    quit = true;
                    Rules[0][i2] = defx;
                } else {
                    Rules[0][i2] = F;
                }
                if (quit) continue;
                float defy = i2 < DefaultFatFractalRules[1].length ? DefaultFatFractalRules[1][i2] : 0.0f;
                F = Fractal_Generator.getFraction("Fraction from Y for position " + i2, defy);
                if (F < 0.0f) {
                    quit = true;
                    Rules[1][i2] = defy;
                    continue;
                }
                Rules[1][i2] = F;
            }
            this.FatFractalRules = new float[2][parts];
            for (i2 = 0; i2 < parts; ++i2) {
                this.FatFractalRules[0][i2] = Rules[0][i2];
                this.FatFractalRules[1][i2] = Rules[1][i2];
            }
        }
        return Fractal_Generator.MakeActualNewPositionsInFatFractal(this.FatFractalRules, (float)this.D, (float)this.SKALE, iters);
    }

    static float getFraction(String request, float defaultvalue) {
        float t;
        float rr;
        float h;
        float n;
        int sineindex = -1;
        int cosindex = -1;
        int lastsine = -1;
        int lastcos = -1;
        int slash = -1;
        int m = -1;
        String str = null;
        float f = defaultvalue;
        Object[] D = new Object[]{request, Float.toString(defaultvalue)};
        str = IJ.getString((String)request, (String)Float.toString(defaultvalue));
        if (str == null) {
            return -1.0f;
        }
        sineindex = str.toLowerCase().indexOf("sin");
        cosindex = str.toLowerCase().indexOf("cos");
        lastsine = str.toLowerCase().lastIndexOf("sin");
        lastcos = str.toLowerCase().lastIndexOf("cos");
        slash = str.indexOf(47);
        m = str.indexOf(42);
        if (sineindex < 0 && cosindex < 0 && m < 0 & slash < 0) {
            f = Fractal_Generator.toFloat(str);
        }
        if (sineindex < 0 && cosindex < 0 && m < 0 & slash > 0) {
            n = Fractal_Generator.toFloat(str.substring(slash + 1, str.length()));
            float k = Fractal_Generator.toFloat(str.substring(0, slash));
            f = k / n;
        }
        if (sineindex < 0 && cosindex >= 0 && m < 0 & slash < 0) {
            f = Fractal_Generator.Cos(str.substring(cosindex + 3, str.length()));
        }
        if (sineindex >= 0 && cosindex < 0 && m < 0 & slash < 0) {
            f = Fractal_Generator.Sin(str.substring(sineindex + 3, str.length()));
        }
        if (m > 0) {
            if (sineindex < 0 && cosindex < 0 && slash < 0) {
                n = Fractal_Generator.toFloat(str.substring(m + 1, str.length()));
                h = Fractal_Generator.toFloat(str.substring(0, m));
                f = h * n;
            }
            if (sineindex >= 0 && cosindex < 0 && lastsine == sineindex && slash < 0 && m > 0) {
                if (sineindex < m) {
                    f = Fractal_Generator.Sin(str.substring(sineindex + 3, m));
                    f *= Fractal_Generator.toFloat(str.substring(m + 1, str.length()));
                } else if (sineindex > m) {
                    f = Fractal_Generator.Sin(str.substring(sineindex + 3, str.length()));
                    f *= Fractal_Generator.toFloat(str.substring(0, m));
                }
            }
            if (sineindex < 0 && cosindex >= 0 && lastcos == cosindex && slash < 0) {
                if (cosindex < m) {
                    f = Fractal_Generator.Cos(str.substring(cosindex + 3, m));
                    f *= Fractal_Generator.toFloat(str.substring(m + 1, str.length()));
                } else {
                    f = Fractal_Generator.Cos(str.substring(cosindex + 3, str.length()));
                    f *= Fractal_Generator.toFloat(str.substring(0, m));
                }
            }
        }
        if (slash > 0) {
            float y;
            float t2;
            if (sineindex < 0 && cosindex < 0 && m < 0) {
                n = Fractal_Generator.toFloat(str.substring(slash + 1, str.length()));
                h = Fractal_Generator.toFloat(str.substring(0, slash));
                f = h / n;
            }
            if (sineindex >= 0 && cosindex < 0 && lastsine == sineindex && m < 0) {
                if (sineindex < slash) {
                    t2 = Fractal_Generator.Sin(str.substring(sineindex + 3, slash));
                    y = Fractal_Generator.toFloat(str.substring(slash + 1, str.length()));
                    f = t2 / y;
                } else {
                    t2 = Fractal_Generator.Sin(str.substring(sineindex + 3, str.length()));
                    y = Fractal_Generator.toFloat(str.substring(0, slash));
                    f = y / t2;
                }
            }
            if (sineindex < 0 && cosindex >= 0 && lastcos == cosindex && m < 0) {
                if (cosindex < slash) {
                    t2 = Fractal_Generator.Cos(str.substring(cosindex + 3, slash));
                    y = Fractal_Generator.toFloat(str.substring(slash + 1, str.length()));
                    f = t2 / y;
                } else {
                    t2 = Fractal_Generator.Cos(str.substring(cosindex + 3, str.length()));
                    y = Fractal_Generator.toFloat(str.substring(0, slash));
                    f = y / t2;
                }
            }
        }
        if (sineindex >= 0 && cosindex < 0 && lastsine > sineindex && m < 0 && slash > 0) {
            f = Fractal_Generator.Sin(str.substring(sineindex + 3, slash));
            f /= Fractal_Generator.Sin(str.substring(lastsine + 3, str.length()));
        }
        if (sineindex >= 0 && cosindex < 0 && lastsine > sineindex && m > 0 && slash < 0) {
            f = Fractal_Generator.Sin(str.substring(sineindex + 3, m));
            f *= Fractal_Generator.Sin(str.substring(lastsine + 3, str.length()));
        }
        if (sineindex < 0 && cosindex >= 0 && lastcos > cosindex && m < 0 && slash > 0) {
            f = Fractal_Generator.Cos(str.substring(cosindex + 3, slash));
            f /= Fractal_Generator.Cos(str.substring(lastcos + 3, str.length()));
        }
        if (sineindex < 0 && cosindex >= 0 && lastcos > cosindex && m > 0 && slash < 0) {
            f = Fractal_Generator.Cos(str.substring(cosindex + 3, m));
            f *= Fractal_Generator.Cos(str.substring(lastcos + 3, str.length()));
        }
        if (sineindex >= 0 && cosindex >= 0 && m < 0 && slash >= 0) {
            if (sineindex < cosindex) {
                rr = Fractal_Generator.Sin(str.substring(sineindex + 3, slash));
                t = Fractal_Generator.Cos(str.substring(cosindex + 3, str.length()));
                f = rr / t;
            } else {
                float rrr = Fractal_Generator.Sin(str.substring(sineindex + 3, str.length()));
                t = Fractal_Generator.Cos(str.substring(cosindex + 3, slash));
                f = t / rrr;
            }
        }
        if (sineindex >= 0 && cosindex >= 0 && m >= 0 && slash < 0) {
            if (sineindex < cosindex) {
                rr = Fractal_Generator.Sin(str.substring(sineindex + 3, slash));
                t = Fractal_Generator.Cos(str.substring(cosindex + 3, str.length()));
                f = rr * t;
            } else {
                rr = Fractal_Generator.Sin(str.substring(sineindex + 3, str.length()));
                t = Fractal_Generator.Cos(str.substring(cosindex + 3, slash));
                f = t * rr;
            }
        }
        return f;
    }

    static float Cos(String s) {
        float f = 1.0f;
        try {
            f = (float)Math.cos(Math.toRadians(Float.parseFloat(s)));
        }
        catch (NumberFormatException nf) {
            f = 1.0f;
        }
        catch (NullPointerException np) {
            f = 1.0f;
        }
        return f;
    }

    static float Sin(String s) {
        float f = 1.0f;
        try {
            f = (float)Math.sin(Math.toRadians(Float.parseFloat(s)));
        }
        catch (NumberFormatException nf) {
            f = 1.0f;
        }
        catch (NullPointerException np) {
            f = 1.0f;
        }
        return f;
    }

    static float toFloat(String s) {
        float f = 1.0f;
        try {
            f = Float.parseFloat(s);
        }
        catch (NumberFormatException nf) {
            f = 1.0f;
        }
        catch (NullPointerException np) {
            f = 1.0f;
        }
        return f;
    }

    public void DrawFat(Graphics2D G, double sx, double sy, float[][] XYSize) {
        G.setColor(Color.white);
        int[][] P = new int[3][XYSize[0].length];
        int xc = (int)sx;
        int yc = (int)sy;
        for (int i2 = 0; i2 < XYSize[0].length; ++i2) {
            P[0][i2] = (int)XYSize[0][i2] + xc;
            P[1][i2] = (int)XYSize[1][i2] + yc;
            P[2][i2] = (int)XYSize[2][i2];
            if (P[2][i2] >= 1) continue;
            P[2][i2] = 1;
        }
        int totalpoints = P[0].length;
        for (int i3 = 0; i3 < totalpoints; ++i3) {
            G.fillRect(P[0][i3], P[1][i3], P[2][i3], P[2][i3]);
        }
    }
}

