/*
 * Decompiled with CFR 0.152.
 */
package imageJ.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.ImageWindow;
import ij.gui.ProgressBar;
import ij.plugin.PlugIn;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import imageJ.plugins.differentialsDialog;
import java.awt.Frame;
import java.awt.Window;

public class Differentials
implements PlugIn {
    static final int GRADIENT_MAGNITUDE = 1;
    static final int GRADIENT_DIRECTION = 2;
    static final int LAPLACIAN = 3;
    static final int LARGEST_HESSIAN = 4;
    static final int SMALLEST_HESSIAN = 5;
    static final int HESSIAN_ORIENTATION = 6;
    private final double FLT_EPSILON = Float.intBitsToFloat(0x33FFFFFF);
    private ImagePlus imp = null;
    private ProgressBar progressBar = IJ.getInstance().getProgressBar();
    private long lastTime = System.currentTimeMillis();
    private int completed = 1;
    private int processDuration = 1;
    private static int operation = 3;
    private int stackSize = 1;
    private boolean cancel = false;

    public void getCrossHessian(ImageProcessor ip, double tolerance) {
        this.getHorizontalGradient(ip, tolerance);
        this.getVerticalGradient(ip, tolerance);
    }

    public void getHorizontalGradient(ImageProcessor ip, double tolerance) {
        if (!(ip.getPixels() instanceof float[])) {
            throw new IllegalArgumentException("Float image required");
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        double[] line = new double[width];
        for (int y = 0; y < height; ++y) {
            this.getRow(ip, y, line);
            this.getSplineInterpolationCoefficients(line, tolerance);
            this.getGradient(line);
            this.putRow(ip, y, line);
            this.stepProgressBar();
        }
    }

    public void getHorizontalHessian(ImageProcessor ip, double tolerance) {
        if (!(ip.getPixels() instanceof float[])) {
            throw new IllegalArgumentException("Float image required");
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        double[] line = new double[width];
        for (int y = 0; y < height; ++y) {
            this.getRow(ip, y, line);
            this.getSplineInterpolationCoefficients(line, tolerance);
            this.getHessian(line);
            this.putRow(ip, y, line);
            this.stepProgressBar();
        }
    }

    public void getVerticalGradient(ImageProcessor ip, double tolerance) {
        if (!(ip.getPixels() instanceof float[])) {
            throw new IllegalArgumentException("Float image required");
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        double[] line = new double[height];
        for (int x = 0; x < width; ++x) {
            this.getColumn(ip, x, line);
            this.getSplineInterpolationCoefficients(line, tolerance);
            this.getGradient(line);
            this.putColumn(ip, x, line);
            this.stepProgressBar();
        }
    }

    public void getVerticalHessian(ImageProcessor ip, double tolerance) {
        if (!(ip.getPixels() instanceof float[])) {
            throw new IllegalArgumentException("Float image required");
        }
        int width = ip.getWidth();
        int height = ip.getHeight();
        double[] line = new double[height];
        for (int x = 0; x < width; ++x) {
            this.getColumn(ip, x, line);
            this.getSplineInterpolationCoefficients(line, tolerance);
            this.getHessian(line);
            this.putColumn(ip, x, line);
            this.stepProgressBar();
        }
    }

    public void run(String arg) {
        ImagePlus implus;
        this.imp = implus = WindowManager.getCurrentImage();
        if (implus == null) {
            IJ.noImage();
            return;
        }
        if (1 < implus.getStackSize()) {
            if (implus.getType() == 3) {
                IJ.error((String)"Stack of color images not supported (use grayscale)");
                return;
            }
        }
        if (1 < implus.getStackSize() && implus.getStack().isRGB()) {
            IJ.error((String)"RGB color images not supported (use grayscale)");
            return;
        }
        if (1 < implus.getStackSize() && implus.getStack().isHSB()) {
            IJ.error((String)"HSB color images not supported (use grayscale)");
            return;
        }
        if (implus.getType() == 3) {
            IJ.error((String)"Indexed color images not supported (use grayscale)");
            return;
        }
        if (implus.getType() == 4) {
            IJ.error((String)"Color images not supported (use grayscale)");
            return;
        }
        differentialsDialog dialog = new differentialsDialog((Frame)IJ.getInstance(), "Differentials", true, operation);
        GUI.center((Window)dialog);
        dialog.setVisible(true);
        this.cancel = dialog.getCancel();
        operation = dialog.getOperation();
        dialog.dispose();
        if (this.cancel) {
            return;
        }
        implus.startTiming();
        if (1 < implus.getStackSize()) {
            if (!(implus.getProcessor().getPixels() instanceof float[])) {
                new StackConverter(implus).convertToGray32();
            }
        } else if (!(implus.getProcessor().getPixels() instanceof float[])) {
            new ImageConverter(implus).convertToGray32();
        }
        ImageStack stack = implus.getStack();
        this.stackSize = stack.getSize();
        Undo.reset();
        this.setupProgressBar();
        this.resetProgressBar();
        for (int i2 = 1; i2 <= this.stackSize; ++i2) {
            ImageProcessor ip = stack.getProcessor(i2);
            this.doIt(ip);
            implus.getProcessor().resetMinAndMax();
            implus.setSlice(i2);
            implus.updateAndRepaintWindow();
        }
        implus.getProcessor().resetMinAndMax();
        implus.setSlice(1);
        implus.updateAndRepaintWindow();
        this.cleanUpProgressBar();
        IJ.showTime((ImagePlus)implus, (long)implus.getStartTime(), (String)"Differentials: ");
        ImageWindow win = implus.getWindow();
        if (win != null) {
            win.running = false;
        }
    }

    void antiSymmetricFirMirrorOnBounds(double[] h, double[] c, double[] s) {
        if (h.length != 2) {
            throw new IndexOutOfBoundsException("The half-length filter size should be 2");
        }
        if (h[0] != 0.0) {
            throw new IllegalArgumentException("Antisymmetry violation (should have h[0]=0.0)");
        }
        if (c.length != s.length) {
            throw new IndexOutOfBoundsException("Incompatible size");
        }
        if (2 <= c.length) {
            s[0] = 0.0;
            for (int i2 = 1; i2 < s.length - 1; ++i2) {
                s[i2] = h[1] * (c[i2 + 1] - c[i2 - 1]);
            }
            s[s.length - 1] = 0.0;
        } else if (c.length == 1) {
            s[0] = 0.0;
        } else {
            throw new NegativeArraySizeException("Invalid length of data");
        }
    }

    void cleanUpProgressBar() {
        this.completed = 0;
        this.progressBar.show(2.0);
    }

    void doIt(ImageProcessor ip) {
        int width = ip.getWidth();
        int height = ip.getHeight();
        if (!(ip.getPixels() instanceof float[])) {
            throw new IllegalArgumentException("Float image required");
        }
        switch (operation) {
            case 1: {
                ImageProcessor h = ip.duplicate();
                ImageProcessor v = ip.duplicate();
                float[] floatPixels = (float[])ip.getPixels();
                float[] floatPixelsH = (float[])h.getPixels();
                float[] floatPixelsV = (float[])v.getPixels();
                this.getHorizontalGradient(h, this.FLT_EPSILON);
                this.getVerticalGradient(v, this.FLT_EPSILON);
                int k = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        floatPixels[k] = (float)Math.sqrt(floatPixelsH[k] * floatPixelsH[k] + floatPixelsV[k] * floatPixelsV[k]);
                        ++x;
                        ++k;
                    }
                    this.stepProgressBar();
                }
                break;
            }
            case 2: {
                ImageProcessor h = ip.duplicate();
                ImageProcessor v = ip.duplicate();
                float[] floatPixels = (float[])ip.getPixels();
                float[] floatPixelsH = (float[])h.getPixels();
                float[] floatPixelsV = (float[])v.getPixels();
                this.getHorizontalGradient(h, this.FLT_EPSILON);
                this.getVerticalGradient(v, this.FLT_EPSILON);
                int k = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        floatPixels[k] = (float)Math.atan2(floatPixelsH[k], floatPixelsV[k]);
                        ++x;
                        ++k;
                    }
                    this.stepProgressBar();
                }
                break;
            }
            case 3: {
                ImageProcessor hh = ip.duplicate();
                ImageProcessor vv = ip.duplicate();
                float[] floatPixels = (float[])ip.getPixels();
                float[] floatPixelsHH = (float[])hh.getPixels();
                float[] floatPixelsVV = (float[])vv.getPixels();
                this.getHorizontalHessian(hh, this.FLT_EPSILON);
                this.getVerticalHessian(vv, this.FLT_EPSILON);
                int k = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        floatPixels[k] = floatPixelsHH[k] + floatPixelsVV[k];
                        ++x;
                        ++k;
                    }
                    this.stepProgressBar();
                }
                break;
            }
            case 4: {
                ImageProcessor hh = ip.duplicate();
                ImageProcessor vv = ip.duplicate();
                ImageProcessor hv = ip.duplicate();
                float[] floatPixels = (float[])ip.getPixels();
                float[] floatPixelsHH = (float[])hh.getPixels();
                float[] floatPixelsVV = (float[])vv.getPixels();
                float[] floatPixelsHV = (float[])hv.getPixels();
                this.getHorizontalHessian(hh, this.FLT_EPSILON);
                this.getVerticalHessian(vv, this.FLT_EPSILON);
                this.getCrossHessian(hv, this.FLT_EPSILON);
                int k = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        floatPixels[k] = (float)(0.5 * ((double)(floatPixelsHH[k] + floatPixelsVV[k]) + Math.sqrt(4.0 * (double)floatPixelsHV[k] * (double)floatPixelsHV[k] + (double)((floatPixelsHH[k] - floatPixelsVV[k]) * (floatPixelsHH[k] - floatPixelsVV[k])))));
                        ++x;
                        ++k;
                    }
                    this.stepProgressBar();
                }
                break;
            }
            case 5: {
                ImageProcessor hh = ip.duplicate();
                ImageProcessor vv = ip.duplicate();
                ImageProcessor hv = ip.duplicate();
                float[] floatPixels = (float[])ip.getPixels();
                float[] floatPixelsHH = (float[])hh.getPixels();
                float[] floatPixelsVV = (float[])vv.getPixels();
                float[] floatPixelsHV = (float[])hv.getPixels();
                this.getHorizontalHessian(hh, this.FLT_EPSILON);
                this.getVerticalHessian(vv, this.FLT_EPSILON);
                this.getCrossHessian(hv, this.FLT_EPSILON);
                int k = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        floatPixels[k] = (float)(0.5 * ((double)(floatPixelsHH[k] + floatPixelsVV[k]) - Math.sqrt(4.0 * (double)floatPixelsHV[k] * (double)floatPixelsHV[k] + (double)((floatPixelsHH[k] - floatPixelsVV[k]) * (floatPixelsHH[k] - floatPixelsVV[k])))));
                        ++x;
                        ++k;
                    }
                    this.stepProgressBar();
                }
                break;
            }
            case 6: {
                ImageProcessor hh = ip.duplicate();
                ImageProcessor vv = ip.duplicate();
                ImageProcessor hv = ip.duplicate();
                float[] floatPixels = (float[])ip.getPixels();
                float[] floatPixelsHH = (float[])hh.getPixels();
                float[] floatPixelsVV = (float[])vv.getPixels();
                float[] floatPixelsHV = (float[])hv.getPixels();
                this.getHorizontalHessian(hh, this.FLT_EPSILON);
                this.getVerticalHessian(vv, this.FLT_EPSILON);
                this.getCrossHessian(hv, this.FLT_EPSILON);
                int k = 0;
                for (int y = 0; y < height; ++y) {
                    int x = 0;
                    while (x < width) {
                        floatPixels[k] = (double)floatPixelsHV[k] < 0.0 ? (float)(-0.5 * Math.acos((double)(floatPixelsHH[k] - floatPixelsVV[k]) / Math.sqrt(4.0 * (double)floatPixelsHV[k] * (double)floatPixelsHV[k] + (double)((floatPixelsHH[k] - floatPixelsVV[k]) * (floatPixelsHH[k] - floatPixelsVV[k]))))) : (float)(0.5 * Math.acos((double)(floatPixelsHH[k] - floatPixelsVV[k]) / Math.sqrt(4.0 * (double)floatPixelsHV[k] * (double)floatPixelsHV[k] + (double)((floatPixelsHH[k] - floatPixelsVV[k]) * (floatPixelsHH[k] - floatPixelsVV[k])))));
                        ++x;
                        ++k;
                    }
                    this.stepProgressBar();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid operation");
            }
        }
        ip.resetMinAndMax();
        this.imp.updateAndDraw();
    }

    void getColumn(ImageProcessor ip, int x, double[] column) {
        int width = ip.getWidth();
        if (ip.getHeight() != column.length) {
            throw new IndexOutOfBoundsException("Incoherent array sizes");
        }
        if (ip.getPixels() instanceof float[]) {
            float[] floatPixels = (float[])ip.getPixels();
            for (int i2 = 0; i2 < column.length; ++i2) {
                column[i2] = floatPixels[x];
                x += width;
            }
        } else {
            throw new IllegalArgumentException("Float image required");
        }
    }

    void getGradient(double[] c) {
        double[] h = new double[]{0.0, -0.5};
        double[] s = new double[c.length];
        this.antiSymmetricFirMirrorOnBounds(h, c, s);
        System.arraycopy(s, 0, c, 0, s.length);
    }

    void getHessian(double[] c) {
        double[] h = new double[]{-2.0, 1.0};
        double[] s = new double[c.length];
        this.symmetricFirMirrorOnBounds(h, c, s);
        System.arraycopy(s, 0, c, 0, s.length);
    }

    double getInitialAntiCausalCoefficientMirrorOnBounds(double[] c, double z, double tolerance) {
        return (z * c[c.length - 2] + c[c.length - 1]) * z / (z * z - 1.0);
    }

    double getInitialCausalCoefficientMirrorOnBounds(double[] c, double z, double tolerance) {
        double z1 = z;
        double zn = Math.pow(z, c.length - 1);
        double sum = c[0] + zn * c[c.length - 1];
        int horizon = c.length;
        if (0.0 < tolerance) {
            horizon = 2 + (int)(Math.log(tolerance) / Math.log(Math.abs(z)));
            horizon = horizon < c.length ? horizon : c.length;
        }
        zn *= zn;
        for (int n = 1; n < horizon - 1; ++n) {
            sum += (z1 + (zn /= z)) * c[n];
            z1 *= z;
        }
        return sum / (1.0 - Math.pow(z, 2 * c.length - 2));
    }

    void getRow(ImageProcessor ip, int y, double[] row) {
        int rowLength = ip.getWidth();
        if (rowLength != row.length) {
            throw new IndexOutOfBoundsException("Incoherent array sizes");
        }
        y *= rowLength;
        if (ip.getPixels() instanceof float[]) {
            float[] floatPixels = (float[])ip.getPixels();
            for (int i2 = 0; i2 < rowLength; ++i2) {
                row[i2] = floatPixels[y++];
            }
        } else {
            throw new IllegalArgumentException("Float image required");
        }
    }

    void getSplineInterpolationCoefficients(double[] c, double tolerance) {
        int k;
        double[] z = new double[]{Math.sqrt(3.0) - 2.0};
        double lambda = 1.0;
        if (c.length == 1) {
            return;
        }
        for (k = 0; k < z.length; ++k) {
            lambda = lambda * (1.0 - z[k]) * (1.0 - 1.0 / z[k]);
        }
        int n = 0;
        while (n < c.length) {
            int n2 = n++;
            c[n2] = c[n2] * lambda;
        }
        for (k = 0; k < z.length; ++k) {
            int n3;
            c[0] = this.getInitialCausalCoefficientMirrorOnBounds(c, z[k], tolerance);
            for (n3 = 1; n3 < c.length; ++n3) {
                int n4 = n3;
                c[n4] = c[n4] + z[k] * c[n3 - 1];
            }
            c[c.length - 1] = this.getInitialAntiCausalCoefficientMirrorOnBounds(c, z[k], tolerance);
            for (n3 = c.length - 2; 0 <= n3; --n3) {
                c[n3] = z[k] * (c[n3 + 1] - c[n3]);
            }
        }
    }

    void putColumn(ImageProcessor ip, int x, double[] column) {
        int width = ip.getWidth();
        if (ip.getHeight() != column.length) {
            throw new IndexOutOfBoundsException("Incoherent array sizes");
        }
        if (ip.getPixels() instanceof float[]) {
            float[] floatPixels = (float[])ip.getPixels();
            for (int i2 = 0; i2 < column.length; ++i2) {
                floatPixels[x] = (float)column[i2];
                x += width;
            }
        } else {
            throw new IllegalArgumentException("Float image required");
        }
    }

    void putRow(ImageProcessor ip, int y, double[] row) {
        int rowLength = ip.getWidth();
        if (rowLength != row.length) {
            throw new IndexOutOfBoundsException("Incoherent array sizes");
        }
        y *= rowLength;
        if (ip.getPixels() instanceof float[]) {
            float[] floatPixels = (float[])ip.getPixels();
            for (int i2 = 0; i2 < rowLength; ++i2) {
                floatPixels[y++] = (float)row[i2];
            }
        } else {
            throw new IllegalArgumentException("Float image required");
        }
    }

    void resetProgressBar() {
        this.completed = 0;
        this.lastTime = System.currentTimeMillis();
        this.progressBar.show(2.0);
    }

    void setupProgressBar() {
        int height = this.imp.getHeight();
        int width = this.imp.getWidth();
        this.completed = 0;
        this.lastTime = System.currentTimeMillis();
        switch (operation) {
            case 1: {
                this.processDuration = this.stackSize * (width + 2 * height);
                break;
            }
            case 2: {
                this.processDuration = this.stackSize * (width + 2 * height);
                break;
            }
            case 3: {
                this.processDuration = this.stackSize * (width + 2 * height);
                break;
            }
            case 4: {
                this.processDuration = this.stackSize * (2 * width + 3 * height);
                break;
            }
            case 5: {
                this.processDuration = this.stackSize * (2 * width + 3 * height);
                break;
            }
            case 6: {
                this.processDuration = this.stackSize * (2 * width + 3 * height);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid operation");
            }
        }
    }

    void stepProgressBar() {
        long timeStamp = System.currentTimeMillis();
        ++this.completed;
        if (50L < timeStamp - this.lastTime) {
            this.lastTime = timeStamp;
            this.progressBar.show((double)this.completed / (double)this.processDuration);
        }
    }

    void symmetricFirMirrorOnBounds(double[] h, double[] c, double[] s) {
        if (h.length != 2) {
            throw new IndexOutOfBoundsException("The half-length filter size should be 2");
        }
        if (c.length != s.length) {
            throw new IndexOutOfBoundsException("Incompatible size");
        }
        if (2 <= c.length) {
            s[0] = h[0] * c[0] + 2.0 * h[1] * c[1];
            for (int i2 = 1; i2 < s.length - 1; ++i2) {
                s[i2] = h[0] * c[i2] + h[1] * (c[i2 - 1] + c[i2 + 1]);
            }
            s[s.length - 1] = h[0] * c[c.length - 1] + 2.0 * h[1] * c[c.length - 2];
        } else {
            switch (c.length) {
                case 1: {
                    s[0] = (h[0] + 2.0 * h[1]) * c[0];
                    break;
                }
                default: {
                    throw new NegativeArraySizeException("Invalid length of data");
                }
            }
        }
    }
}

