/*
 * Decompiled with CFR 0.152.
 */
package imageJ.plugins;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.plugin.RGBStackConverter;
import ij.process.ImageConverter;
import ij.process.StackConverter;

public class Converter
implements PlugIn {
    public static final String BIT8 = "8-bit";
    public static final String BIT16 = "16-bit";
    public static final String BIT32 = "32-bit";
    public static final String BIT8COLOR = "8-bit Color";
    public static final String RGBCOLOR = "RGB Color";
    public static final String RGBSTACK = "RGB Stack";
    public static final String HSBSTACK = "HSB Stack";

    public void convert(ImagePlus imp, String item) {
        ImageStack stack = null;
        if (imp.getStackSize() > 1) {
            stack = imp.getStack();
        }
        Roi roi = imp.getRoi();
        imp.killRoi();
        boolean saveChanges = imp.changes;
        imp.changes = IJ.getApplet() == null;
        ImageWindow win = imp.getWindow();
        if (stack != null) {
            boolean wasVirtual = stack.isVirtual();
            if (stack.isRGB() && item.equals(RGBCOLOR)) {
                new ImageConverter(imp).convertRGBStackToRGB();
                if (win != null) {
                    new ImageWindow(imp, imp.getCanvas());
                }
            } else if (stack.isHSB() && item.equals(RGBCOLOR)) {
                new ImageConverter(imp).convertHSBToRGB();
                if (win != null) {
                    new ImageWindow(imp, imp.getCanvas());
                }
            } else if (item.equals(BIT8)) {
                new StackConverter(imp).convertToGray8();
            } else if (item.equals(BIT16)) {
                new StackConverter(imp).convertToGray16();
            } else if (item.equals(BIT32)) {
                new StackConverter(imp).convertToGray32();
            } else if (item.equals(RGBCOLOR)) {
                new StackConverter(imp).convertToRGB();
            } else if (item.equals(RGBSTACK)) {
                new StackConverter(imp).convertToRGBHyperstack();
            } else if (item.equals(HSBSTACK)) {
                new StackConverter(imp).convertToHSBHyperstack();
            } else if (item.equals(BIT8COLOR)) {
                int nColors = this.getNumber(imp);
                if (nColors != 0) {
                    new StackConverter(imp).convertToIndexedColor(nColors);
                }
            } else {
                throw new IllegalArgumentException();
            }
            if (wasVirtual) {
                imp.setTitle(imp.getTitle());
            }
        } else {
            Undo.setup((int)2, (ImagePlus)imp);
            ImageConverter ic = new ImageConverter(imp);
            switch (item) {
                case "8-bit": {
                    ic.convertToGray8();
                    break;
                }
                case "16-bit": {
                    ic.convertToGray16();
                    break;
                }
                case "32-bit": {
                    ic.convertToGray32();
                    break;
                }
                case "RGB Stack": {
                    Undo.reset();
                    ic.convertToRGBStack();
                    break;
                }
                case "HSB Stack": {
                    Undo.reset();
                    ic.convertToHSB();
                    break;
                }
                case "RGB Color": {
                    ic.convertToRGB();
                    break;
                }
                case "8-bit Color": {
                    int nColors = this.getNumber(imp);
                    if (nColors == 0) break;
                    ic.convertRGBtoIndexedColor(nColors);
                    break;
                }
                default: {
                    imp.changes = saveChanges;
                    return;
                }
            }
        }
        if (roi != null) {
            imp.setRoi(roi);
        }
        imp.repaintWindow();
    }

    public void unsupportedConversion() {
        IJ.error((String)"Converter", (String)"Supported Conversions:\n \n8-bit -> 16-bit*\n8-bit -> 32-bit*\n8-bit -> RGB Color*\n16-bit -> 8-bit*\n16-bit -> 32-bit*\n16-bit -> RGB Color*\n32-bit -> 8-bit*\n32-bit -> 16-bit\n32-bit -> RGB Color*\n8-bit Color -> 8-bit (grayscale)*\n8-bit Color -> RGB Color\nRGB Color -> 8-bit (grayscale)*\nRGB Color -> 8-bit Color*\nRGB Color -> RGB Stack*\nRGB Color -> HSB Stack*\nRGB Stack -> RGB Color\nHSB Stack -> RGB Color\n \n* works with stacks\n");
    }

    private int getNumber(ImagePlus imp) {
        if (imp.getType() != 4) {
            return 256;
        }
        GenericDialog gd = new GenericDialog("MedianCut");
        gd.addNumericField("Number of Colors (2-256):", 256.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 0;
        }
        int n = (int)gd.getNextNumber();
        if (n < 2) {
            n = 2;
        }
        if (n > 256) {
            n = 256;
        }
        return n;
    }

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp != null) {
            if (imp.isComposite() && arg.equals(RGBCOLOR)) {
                new RGBStackConverter().run("");
            } else if (imp.lock()) {
                this.convert(imp, arg);
                imp.unlock();
            }
        } else {
            IJ.noImage();
        }
    }
}

