/*
 * Decompiled with CFR 0.152.
 */
package imageJ.plugInFilter;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageConverter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Frame;
import java.awt.Rectangle;

public class FFT_Filter
implements PlugInFilter {
    private ImagePlus imp;
    private float[] C;
    private float[] S;
    static double filterLargeDia = 40.0;
    static double filterSmallDia = 3.0;
    static int choiceIndex = 0;
    static String[] choices = new String[]{"none", "horizontal", "vertical"};
    static String choiceDia = choices[0];
    static double toleranceDia = 5.0;
    static boolean doScalingDia = true;
    static boolean saturateDia = true;
    static boolean processStack = false;

    public int setup(String arg, ImagePlus imp) {
        IJ.register(FFT_Filter.class);
        this.imp = imp;
        int stackSize = imp.getStackSize();
        GenericDialog dia = new GenericDialog("Fourier Filter 1.2", (Frame)IJ.getInstance());
        dia.addNumericField("Filter_large structures down to x pixels", filterLargeDia, 1);
        dia.addNumericField("Filter_small structures up to x pixels", filterSmallDia, 1);
        dia.addChoice("Suppress stripes in one direction", choices, choiceDia);
        dia.addNumericField("Tolerance of direction (%)", toleranceDia, 1);
        dia.addCheckbox("Autoscale after filtering", doScalingDia);
        dia.addCheckbox("Saturate image when autoscaling", saturateDia);
        if (stackSize > 1) {
            dia.addCheckbox("Process entire Stack", processStack);
        }
        dia.showDialog();
        if (dia.wasCanceled()) {
            return 4096;
        }
        if (dia.invalidNumber()) {
            IJ.showMessage((String)"Error", (String)"Invalid input Number");
            return 4096;
        }
        filterLargeDia = dia.getNextNumber();
        filterSmallDia = dia.getNextNumber();
        choiceIndex = dia.getNextChoiceIndex();
        choiceDia = choices[choiceIndex];
        toleranceDia = dia.getNextNumber();
        doScalingDia = dia.getNextBoolean();
        saturateDia = dia.getNextBoolean();
        if (stackSize > 1) {
            processStack = dia.getNextBoolean();
        }
        int returnValue = 13;
        if (stackSize > 1 && processStack) {
            returnValue |= 0x20;
        }
        return returnValue;
    }

    public void run(ImageProcessor ip) {
        Rectangle roiRect = ip.getRoi();
        int maxN = Math.max(roiRect.width, roiRect.height);
        double filterLarge = filterLargeDia / (double)maxN;
        double filterSmall = filterSmallDia / (double)maxN;
        double sharpness = (100.0 - toleranceDia) / 100.0;
        boolean doScaling = doScalingDia;
        boolean saturate = saturateDia;
        IJ.wait((int)31);
        IJ.showProgress((double)0.05);
        int i2 = 2;
        while ((double)i2 < 1.5 * (double)maxN) {
            i2 *= 2;
        }
        Rectangle fitRect = new Rectangle();
        fitRect.x = (int)Math.round((double)(i2 - roiRect.width) / 2.0);
        fitRect.y = (int)Math.round((double)(i2 - roiRect.height) / 2.0);
        fitRect.width = roiRect.width;
        fitRect.height = roiRect.height;
        ImageProcessor ip2 = this.tileMirror(ip, i2, i2, fitRect.x, fitRect.y);
        ImagePlus imp2 = new ImagePlus(this.imp.getTitle() + "-filtered", ip2);
        int imagetype = imp2.getType();
        if (imagetype != 2) {
            new ImageConverter(imp2).convertToGray32();
            ip2 = imp2.getProcessor();
            System.gc();
        }
        IJ.showProgress((double)0.1);
        boolean inverse = false;
        this.fft(ip2, inverse);
        System.gc();
        IJ.showProgress((double)0.45);
        this.filterLargeSmall(ip2, filterLarge, filterSmall, choiceIndex, sharpness);
        IJ.showProgress((double)0.55);
        inverse = true;
        this.fft(ip2, inverse);
        IJ.showProgress((double)0.95);
        ip2.setRoi(fitRect);
        ip2 = ip2.crop();
        imp2.setProcessor(null, ip2);
        if (doScaling) {
            this.autoAdjust(imp2, ip2, saturate);
        }
        if (imagetype != 2) {
            boolean defaultscaling = ImageConverter.getDoScaling();
            ImageConverter.setDoScaling((boolean)doScaling);
            if (imagetype == 0) {
                new ImageConverter(imp2).convertToGray8();
            } else if (imagetype == 1) {
                new ImageConverter(imp2).convertToGray16();
            }
            ImageConverter.setDoScaling((boolean)defaultscaling);
        }
        ip.copyBits(imp2.getProcessor(), roiRect.x, roiRect.y, 0);
        imp2.flush();
        System.gc();
        IJ.showProgress((double)1.1);
    }

    void autoAdjust(ImagePlus imp, ImageProcessor ip, boolean saturate) {
        Calibration cal = imp.getCalibration();
        imp.setCalibration(null);
        ImageStatistics stats = imp.getStatistics();
        imp.setCalibration(cal);
        int[] histogram = stats.histogram;
        int threshold = saturate ? stats.pixelCount / 5000 : 0;
        int i2 = -1;
        boolean found = false;
        do {
            boolean bl = found = histogram[++i2] > threshold;
        } while (!found && i2 < 255);
        int hmin = i2 > 0 ? i2 - 1 : 0;
        i2 = 256;
        do {
            boolean bl = found = histogram[--i2] > threshold;
        } while (!found && i2 > 0);
        int hmax = i2 < 255 ? i2 + 1 : 255;
        if (hmax > hmin) {
            imp.killRoi();
            double min = stats.histMin + (double)hmin * stats.binSize;
            double max = stats.histMin + (double)hmax * stats.binSize;
            ip.setMinAndMax(min, max);
        }
    }

    public ImageProcessor tileMirror(ImageProcessor ip, int width, int height, int x, int y) {
        int j;
        int i2;
        if (x < 0 || x > width - 1 || y < 0 || y > height - 1) {
            IJ.error((String)"Image to be tiled is out of bounds.");
            return null;
        }
        ImageProcessor ipout = ip.createProcessor(width, height);
        ImageProcessor ip2 = ip.crop();
        int w2 = ip2.getWidth();
        int h2 = ip2.getHeight();
        int i1 = (int)Math.ceil((double)x / (double)w2);
        int i22 = (int)Math.ceil((double)(width - x) / (double)w2);
        int j1 = (int)Math.ceil((double)y / (double)h2);
        int j2 = (int)Math.ceil((double)(height - y) / (double)h2);
        if ((double)(i1 % 2) > 0.5) {
            ip2.flipHorizontal();
        }
        if ((double)(j1 % 2) > 0.5) {
            ip2.flipVertical();
        }
        for (i2 = -i1; i2 < i22; i2 += 2) {
            for (j = -j1; j < j2; j += 2) {
                ipout.insert(ip2, x - i2 * w2, y - j * h2);
            }
        }
        ip2.flipHorizontal();
        for (i2 = -i1 + 1; i2 < i22; i2 += 2) {
            for (j = -j1; j < j2; j += 2) {
                ipout.insert(ip2, x - i2 * w2, y - j * h2);
            }
        }
        ip2.flipVertical();
        for (i2 = -i1 + 1; i2 < i22; i2 += 2) {
            for (j = -j1 + 1; j < j2; j += 2) {
                ipout.insert(ip2, x - i2 * w2, y - j * h2);
            }
        }
        ip2.flipHorizontal();
        for (i2 = -i1; i2 < i22; i2 += 2) {
            for (j = -j1 + 1; j < j2; j += 2) {
                ipout.insert(ip2, x - i2 * w2, y - j * h2);
            }
        }
        return ipout;
    }

    void filterLargeSmall(ImageProcessor ip, double filterLarge, double filterSmall, int stripesHorVert, double scaleStripes) {
        float colFactSmall;
        float colFactLarge;
        int backcol;
        int col;
        float rowFactSmall;
        float rowFactLarge;
        int backrow;
        int row;
        int maxN = ip.getWidth();
        float[] fht = (float[])ip.getPixels();
        double scaleLarge = filterLarge * filterLarge;
        double scaleSmall = filterSmall * filterSmall;
        scaleStripes *= scaleStripes;
        for (int j = 1; j < maxN / 2; ++j) {
            row = j * maxN;
            backrow = (maxN - j) * maxN;
            rowFactLarge = (float)Math.exp((double)(-(j * j)) * scaleLarge);
            rowFactSmall = (float)Math.exp((double)(-(j * j)) * scaleSmall);
            for (col = 1; col < maxN / 2; ++col) {
                backcol = maxN - col;
                colFactLarge = (float)Math.exp((double)(-(col * col)) * scaleLarge);
                colFactSmall = (float)Math.exp((double)(-(col * col)) * scaleSmall);
                float factor = (1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall;
                switch (stripesHorVert) {
                    case 1: {
                        factor *= 1.0f - (float)Math.exp((double)(-(col * col)) * scaleStripes);
                        break;
                    }
                    case 2: {
                        factor *= 1.0f - (float)Math.exp((double)(-(j * j)) * scaleStripes);
                    }
                }
                int n = col + row;
                fht[n] = fht[n] * factor;
                int n2 = col + backrow;
                fht[n2] = fht[n2] * factor;
                int n3 = backcol + row;
                fht[n3] = fht[n3] * factor;
                int n4 = backcol + backrow;
                fht[n4] = fht[n4] * factor;
            }
        }
        int rowmid = maxN * (maxN / 2);
        rowFactLarge = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleLarge);
        rowFactSmall = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleSmall);
        float factStripes = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleStripes);
        int n = maxN / 2;
        fht[n] = fht[n] * ((1.0f - rowFactLarge) * rowFactSmall);
        int n5 = rowmid;
        fht[n5] = fht[n5] * ((1.0f - rowFactLarge) * rowFactSmall);
        int n6 = maxN / 2 + rowmid;
        fht[n6] = fht[n6] * ((1.0f - rowFactLarge * rowFactLarge) * rowFactSmall * rowFactSmall);
        switch (stripesHorVert) {
            case 1: {
                int n7 = maxN / 2;
                fht[n7] = fht[n7] * (1.0f - factStripes);
                fht[rowmid] = 0.0f;
                int n8 = maxN / 2 + rowmid;
                fht[n8] = fht[n8] * (1.0f - factStripes);
                break;
            }
            case 2: {
                fht[maxN / 2] = 0.0f;
                int n9 = rowmid;
                fht[n9] = fht[n9] * (1.0f - factStripes);
                int n10 = maxN / 2 + rowmid;
                fht[n10] = fht[n10] * (1.0f - factStripes);
            }
        }
        rowFactLarge = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleLarge);
        rowFactSmall = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleSmall);
        block20: for (col = 1; col < maxN / 2; ++col) {
            backcol = maxN - col;
            colFactLarge = (float)Math.exp((double)(-(col * col)) * scaleLarge);
            colFactSmall = (float)Math.exp((double)(-(col * col)) * scaleSmall);
            switch (stripesHorVert) {
                case 0: {
                    int n11 = col;
                    fht[n11] = fht[n11] * ((1.0f - colFactLarge) * colFactSmall);
                    int n12 = backcol;
                    fht[n12] = fht[n12] * ((1.0f - colFactLarge) * colFactSmall);
                    int n13 = col + rowmid;
                    fht[n13] = fht[n13] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall);
                    int n14 = backcol + rowmid;
                    fht[n14] = fht[n14] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall);
                    continue block20;
                }
                case 1: {
                    factStripes = (float)Math.exp((double)(-(col * col)) * scaleStripes);
                    int n15 = col;
                    fht[n15] = fht[n15] * ((1.0f - colFactLarge) * colFactSmall * (1.0f - factStripes));
                    int n16 = backcol;
                    fht[n16] = fht[n16] * ((1.0f - colFactLarge) * colFactSmall * (1.0f - factStripes));
                    int n17 = col + rowmid;
                    fht[n17] = fht[n17] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    int n18 = backcol + rowmid;
                    fht[n18] = fht[n18] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    continue block20;
                }
                case 2: {
                    factStripes = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleStripes);
                    fht[col] = 0.0f;
                    fht[backcol] = 0.0f;
                    int n19 = col + rowmid;
                    fht[n19] = fht[n19] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                    int n20 = backcol + rowmid;
                    fht[n20] = fht[n20] * ((1.0f - colFactLarge * rowFactLarge) * colFactSmall * rowFactSmall * (1.0f - factStripes));
                }
            }
        }
        colFactLarge = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleLarge);
        colFactSmall = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleSmall);
        block21: for (int j = 1; j < maxN / 2; ++j) {
            row = j * maxN;
            backrow = (maxN - j) * maxN;
            rowFactLarge = (float)Math.exp((double)(-(j * j)) * scaleLarge);
            rowFactSmall = (float)Math.exp((double)(-(j * j)) * scaleSmall);
            switch (stripesHorVert) {
                case 0: {
                    int n21 = row;
                    fht[n21] = fht[n21] * ((1.0f - rowFactLarge) * rowFactSmall);
                    int n22 = backrow;
                    fht[n22] = fht[n22] * ((1.0f - rowFactLarge) * rowFactSmall);
                    int n23 = row + maxN / 2;
                    fht[n23] = fht[n23] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall);
                    int n24 = backrow + maxN / 2;
                    fht[n24] = fht[n24] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall);
                    continue block21;
                }
                case 1: {
                    factStripes = (float)Math.exp((double)(-(maxN / 2) * (maxN / 2)) * scaleStripes);
                    fht[row] = 0.0f;
                    fht[backrow] = 0.0f;
                    int n25 = row + maxN / 2;
                    fht[n25] = fht[n25] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    int n26 = backrow + maxN / 2;
                    fht[n26] = fht[n26] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    continue block21;
                }
                case 2: {
                    factStripes = (float)Math.exp((double)(-(j * j)) * scaleStripes);
                    int n27 = row;
                    fht[n27] = fht[n27] * ((1.0f - rowFactLarge) * rowFactSmall * (1.0f - factStripes));
                    int n28 = backrow;
                    fht[n28] = fht[n28] * ((1.0f - rowFactLarge) * rowFactSmall * (1.0f - factStripes));
                    int n29 = row + maxN / 2;
                    fht[n29] = fht[n29] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                    int n30 = backrow + maxN / 2;
                    fht[n30] = fht[n30] * ((1.0f - rowFactLarge * colFactLarge) * rowFactSmall * colFactSmall * (1.0f - factStripes));
                }
            }
        }
    }

    public void fft(ImageProcessor ip, boolean inverse) {
        int maxN = ip.getWidth();
        this.makeSinCosTables(maxN);
        float[] fht = (float[])ip.getPixels();
        this.rc2DFHT(fht, inverse, maxN);
    }

    void makeSinCosTables(int maxN) {
        int n = maxN / 4;
        this.C = new float[n];
        this.S = new float[n];
        double theta = 0.0;
        double dTheta = Math.PI * 2 / (double)maxN;
        for (int i2 = 0; i2 < n; ++i2) {
            this.C[i2] = (float)Math.cos(theta);
            this.S[i2] = (float)Math.sin(theta);
            theta += dTheta;
        }
    }

    void rc2DFHT(float[] x, boolean inverse, int maxN) {
        int row;
        for (row = 0; row < maxN; ++row) {
            this.dfht3(x, row * maxN, inverse, maxN);
        }
        this.transposeR(x, maxN);
        for (row = 0; row < maxN; ++row) {
            this.dfht3(x, row * maxN, inverse, maxN);
        }
        this.transposeR(x, maxN);
        for (int row2 = 0; row2 < maxN / 2; ++row2) {
            for (int col = 0; col < maxN / 2; ++col) {
                int mRow = (maxN - row2) % maxN;
                int mCol = (maxN - col) % maxN;
                float A = x[row2 * maxN + col];
                float B = x[mRow * maxN + col];
                float C = x[row2 * maxN + mCol];
                float D = x[mRow * maxN + mCol];
                float E = (A + D - (B + C)) / 2.0f;
                x[row2 * maxN + col] = A - E;
                x[mRow * maxN + col] = B + E;
                x[row2 * maxN + mCol] = C + E;
                x[mRow * maxN + mCol] = D - E;
            }
        }
    }

    void dfht3(float[] x, int base, boolean inverse, int maxN) {
        float rt2;
        float rt1;
        int Ad4;
        int Ad3;
        int Ad2;
        int Ad1;
        int gpNum;
        int Nlog2 = this.log2(maxN);
        this.BitRevRArr(x, base, Nlog2, maxN);
        int gpSize = 2;
        int numGps = maxN / 4;
        for (gpNum = 0; gpNum < numGps; ++gpNum) {
            Ad1 = gpNum * 4;
            Ad2 = Ad1 + 1;
            Ad3 = Ad1 + gpSize;
            Ad4 = Ad2 + gpSize;
            rt1 = x[base + Ad1] + x[base + Ad2];
            rt2 = x[base + Ad1] - x[base + Ad2];
            float rt3 = x[base + Ad3] + x[base + Ad4];
            float rt4 = x[base + Ad3] - x[base + Ad4];
            x[base + Ad1] = rt1 + rt3;
            x[base + Ad2] = rt2 + rt4;
            x[base + Ad3] = rt1 - rt3;
            x[base + Ad4] = rt2 - rt4;
        }
        if (Nlog2 > 2) {
            gpSize = 4;
            int numBfs = 2;
            numGps /= 2;
            for (int stage = 2; stage < Nlog2; ++stage) {
                for (gpNum = 0; gpNum < numGps; ++gpNum) {
                    int Ad0;
                    Ad1 = Ad0 = gpNum * gpSize * 2;
                    Ad2 = Ad1 + gpSize;
                    Ad3 = Ad1 + gpSize / 2;
                    Ad4 = Ad3 + gpSize;
                    rt1 = x[base + Ad1];
                    int n = base + Ad1;
                    x[n] = x[n] + x[base + Ad2];
                    x[base + Ad2] = rt1 - x[base + Ad2];
                    rt1 = x[base + Ad3];
                    int n2 = base + Ad3;
                    x[n2] = x[n2] + x[base + Ad4];
                    x[base + Ad4] = rt1 - x[base + Ad4];
                    for (int bfNum = 1; bfNum < numBfs; ++bfNum) {
                        Ad1 = bfNum + Ad0;
                        Ad2 = Ad1 + gpSize;
                        Ad3 = gpSize - bfNum + Ad0;
                        Ad4 = Ad3 + gpSize;
                        int CSAd = bfNum * numGps;
                        rt1 = x[base + Ad2] * this.C[CSAd] + x[base + Ad4] * this.S[CSAd];
                        rt2 = x[base + Ad4] * this.C[CSAd] - x[base + Ad2] * this.S[CSAd];
                        x[base + Ad2] = x[base + Ad1] - rt1;
                        int n3 = base + Ad1;
                        x[n3] = x[n3] + rt1;
                        x[base + Ad4] = x[base + Ad3] + rt2;
                        int n4 = base + Ad3;
                        x[n4] = x[n4] - rt2;
                    }
                }
                gpSize *= 2;
                numBfs *= 2;
                numGps /= 2;
            }
        }
        if (inverse) {
            for (int i2 = 0; i2 < maxN; ++i2) {
                int n = base + i2;
                x[n] = x[n] / (float)maxN;
            }
        }
    }

    void transposeR(float[] x, int maxN) {
        for (int r = 0; r < maxN; ++r) {
            for (int c = r; c < maxN; ++c) {
                if (r == c) continue;
                float rTemp = x[r * maxN + c];
                x[r * maxN + c] = x[c * maxN + r];
                x[c * maxN + r] = rTemp;
            }
        }
    }

    int log2(int x) {
        int count = 15;
        while (!this.btst(x, count)) {
            --count;
        }
        return count;
    }

    private boolean btst(int x, int bit) {
        return (x & 1 << bit) != 0;
    }

    void BitRevRArr(float[] x, int base, int bitlen, int maxN) {
        float[] tempArr = new float[maxN];
        for (int i2 = 0; i2 < maxN; ++i2) {
            int l = this.BitRevX(i2, bitlen);
            tempArr[i2] = x[base + l];
        }
        System.arraycopy(tempArr, 0, x, base, maxN);
    }

    private int BitRevX(int x, int bitlen) {
        int temp = 0;
        for (int i2 = 0; i2 <= bitlen; ++i2) {
            if ((x & 1 << i2) == 0) continue;
            temp |= 1 << bitlen - i2 - 1;
        }
        return temp & 0xFFFF;
    }
}

