/*
 * Decompiled with CFR 0.152.
 */
package imageJ.plugInFilter;

import ij.ImagePlus;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;

public class Entropy_Threshold
implements PlugInFilter {
    public int setup(String s, ImagePlus imagePlus) {
        return 33;
    }

    public void run(ImageProcessor imageProcessor) {
        int[] hist = imageProcessor.getHistogram();
        int threshold = this.entropySplit(hist);
        imageProcessor.threshold(threshold);
    }

    private int entropySplit(int[] hist) {
        double sum = 0.0;
        for (int i2 = 0; i2 < hist.length; ++i2) {
            sum += (double)hist[i2];
        }
        if (sum == 0.0) {
            throw new IllegalArgumentException("Empty histogram: sum of all bins is zero.");
        }
        double[] normalizedHist = new double[hist.length];
        for (int i3 = 0; i3 < hist.length; ++i3) {
            normalizedHist[i3] = (double)hist[i3] / sum;
        }
        double[] pT = new double[hist.length];
        pT[0] = normalizedHist[0];
        for (int i4 = 1; i4 < hist.length; ++i4) {
            pT[i4] = pT[i4 - 1] + normalizedHist[i4];
        }
        double epsilon = Double.MIN_VALUE;
        double[] hB = new double[hist.length];
        double[] hW = new double[hist.length];
        for (int t = 0; t < hist.length; ++t) {
            if (pT[t] > Double.MIN_VALUE) {
                double hhB = 0.0;
                for (int i5 = 0; i5 <= t; ++i5) {
                    if (!(normalizedHist[i5] > Double.MIN_VALUE)) continue;
                    hhB -= normalizedHist[i5] / pT[t] * Math.log(normalizedHist[i5] / pT[t]);
                }
                hB[t] = hhB;
            } else {
                hB[t] = 0.0;
            }
            double pTW = 1.0 - pT[t];
            if (pTW > Double.MIN_VALUE) {
                double hhW = 0.0;
                for (int i6 = t + 1; i6 < hist.length; ++i6) {
                    if (!(normalizedHist[i6] > Double.MIN_VALUE)) continue;
                    hhW -= normalizedHist[i6] / pTW * Math.log(normalizedHist[i6] / pTW);
                }
                hW[t] = hhW;
                continue;
            }
            hW[t] = 0.0;
        }
        double jMax = hB[0] + hW[0];
        int tMax = 0;
        for (int t = 1; t < hist.length; ++t) {
            double j = hB[t] + hW[t];
            if (!(j > jMax)) continue;
            jMax = j;
            tMax = t;
        }
        return tMax;
    }
}

