/*
 * Decompiled with CFR 0.152.
 */
package imageJ;

import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageWindow;
import ij.io.FileInfo;
import ij.plugin.PlugIn;
import ij.plugin.filter.PlugInFilter;
import ij.process.BinaryProcessor;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import imageTiTi.ImageNew;
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.util.List;
import utils.strings.StringToolsImageDV;

public class IJInterfacor {
    public static ImageProcessor BufferedImageToImageProcessor(BufferedImage source) {
        int width = source.getWidth();
        int height = source.getHeight();
        ArrayFeatures AF = new ArrayFeatures();
        switch (source.getType()) {
            case 12: {
                return new BinaryProcessor(new ByteProcessor((Image)source));
            }
            case 10: {
                return new ByteProcessor(source);
            }
            case 11: {
                return new ShortProcessor(source);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new ColorProcessor((Image)source);
            }
            case 0: {
                if (source.getRaster().getNumBands() != 1) {
                    throw new IllegalArgumentException("Images with more than 1 band/channel/bank not (yet) supported => Split channels.");
                }
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 5: {
                        return new FloatProcessor(width, height, ((DataBufferDouble)source.getRaster().getDataBuffer()).getData());
                    }
                    case 4: {
                        return new FloatProcessor(width, height, ((DataBufferFloat)source.getRaster().getDataBuffer()).getData());
                    }
                    case 3: {
                        int[] databuffer = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                        int min = AF.Minimum(databuffer);
                        int max = AF.Maximum(databuffer);
                        if (min < 0) {
                            return new FloatProcessor(width, height, databuffer);
                        }
                        if (max < 256) {
                            return new ByteProcessor(width, height, ArrayConverter.IntToByte((int[])databuffer));
                        }
                        if (max < 65536) {
                            return new ShortProcessor(width, height, ArrayConverter.IntToShort((int[])databuffer), null);
                        }
                        return new FloatProcessor(width, height, databuffer);
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported for TYPE_CUSTOM images.");
            }
        }
        throw new IllegalArgumentException("BufferedImage type not supported: " + source.getType() + " <=> " + StringToolsImageDV.NameOfType((int)source.getType()));
    }

    public static FileInfo CreateFileInfo(BufferedImage source) {
        FileInfo fi = new FileInfo();
        fi.width = source.getWidth();
        fi.height = source.getHeight();
        fi.nImages = 1;
        block0 : switch (source.getType()) {
            case 10: {
                fi.pixels = ((DataBufferByte)source.getRaster().getDataBuffer()).getData();
                fi.fileType = 0;
                break;
            }
            case 11: {
                fi.pixels = ((DataBufferUShort)source.getRaster().getDataBuffer()).getData();
                fi.fileType = 1;
                break;
            }
            case 0: {
                switch (source.getRaster().getDataBuffer().getDataType()) {
                    case 4: {
                        fi.pixels = ((DataBufferFloat)source.getRaster().getDataBuffer()).getData();
                        fi.fileType = 4;
                        break block0;
                    }
                    case 3: {
                        fi.pixels = ((DataBufferInt)source.getRaster().getDataBuffer()).getData();
                        fi.fileType = 3;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Data type not supported (yet).");
            }
        }
        return fi;
    }

    public static FileInfo CreateFileInfo(ImageProcessor source) {
        FileInfo fi = new FileInfo();
        fi.width = source.getWidth();
        fi.height = source.getHeight();
        fi.nImages = 1;
        fi.pixels = source.getPixels();
        if (source instanceof ByteProcessor) {
            fi.fileFormat = 0;
        } else if (source instanceof ShortProcessor) {
            fi.fileFormat = 1;
        } else if (source instanceof FloatProcessor) {
            fi.fileFormat = 4;
        } else if (source instanceof ColorProcessor) {
            fi.fileFormat = 6;
        } else {
            throw new IllegalAccessError("Format not supported (yet).");
        }
        return fi;
    }

    public static ImagePlus BufferedImageToImagePlus(BufferedImage source) {
        ImagePlus imp = new ImagePlus("BufferedImageToImagePlus", IJInterfacor.BufferedImageToImageProcessor(source));
        imp.setFileInfo(IJInterfacor.CreateFileInfo(source));
        return imp;
    }

    public static ImagePlus ImageProcessorToImagePlus(ImageProcessor source, String name) {
        ImagePlus imp = new ImagePlus(name, source);
        FileInfo fi = IJInterfacor.CreateFileInfo(source);
        fi.fileName = name;
        imp.setFileInfo(fi);
        return imp;
    }

    public static BufferedImage ImageProcessorToBufferedImage(ImageProcessor source) {
        int width = source.getWidth();
        int height = source.getHeight();
        BufferedImage result = null;
        if (source instanceof BinaryProcessor) {
            result = new BufferedImage(width, height, 12);
            WritableRaster wr = result.getRaster();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    wr.setSample(x, y, 0, source.get(x, y));
                }
            }
        } else if (source instanceof ByteProcessor) {
            result = new BufferedImage(width, height, 10);
            System.arraycopy((byte[])source.getPixels(), 0, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), 0, width * height);
        } else {
            if (source instanceof ShortProcessor) {
                return ((ShortProcessor)source).get16BitBufferedImage();
            }
            if (source instanceof ColorProcessor) {
                result = new BufferedImage(width, height, 5);
                byte[] bb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                int[] ib = (int[])source.getPixels();
                int i2 = 0;
                int b = 0;
                while (i2 < ib.length) {
                    int p = ib[i2];
                    bb[b + 2] = (byte)((p & 0xFF0000) >> 16);
                    bb[b + 1] = (byte)((p & 0xFF00) >> 8);
                    bb[b] = (byte)(p & 0xFF);
                    ++i2;
                    b += 3;
                }
                bb = null;
                ib = null;
            } else {
                Object pixels = source.getPixels();
                if (pixels instanceof byte[]) {
                    byte[] pix = (byte[])pixels;
                    result = new BufferedImage(source.getWidth(), source.getHeight(), 10);
                    byte[] bb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                    System.arraycopy(pix, 0, bb, 0, pix.length);
                } else if (pixels instanceof short[]) {
                    short[] pix = (short[])pixels;
                    result = new BufferedImage(source.getWidth(), source.getHeight(), 11);
                    short[] sb = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                    System.arraycopy(pix, 0, sb, 0, pix.length);
                } else if (pixels instanceof int[]) {
                    int[] pix = (int[])pixels;
                    result = ImageNew.Integer((int)source.getWidth(), (int)source.getHeight(), (int)source.getNChannels());
                    int[] ib = ((DataBufferInt)result.getRaster().getDataBuffer()).getData();
                    System.arraycopy(pix, 0, ib, 0, pix.length);
                } else if (pixels instanceof float[]) {
                    float[] pix = (float[])pixels;
                    result = ImageNew.Float((int)source.getWidth(), (int)source.getHeight(), (int)source.getNChannels());
                    float[] fb = ((DataBufferFloat)result.getRaster().getDataBuffer()).getData();
                    System.arraycopy(pix, 0, fb, 0, pix.length);
                } else if (pixels instanceof double[]) {
                    double[] pix = (double[])pixels;
                    result = ImageNew.Double((int)source.getWidth(), (int)source.getHeight(), (int)source.getNChannels());
                    double[] db = ((DataBufferDouble)result.getRaster().getDataBuffer()).getData();
                    System.arraycopy(pix, 0, db, 0, pix.length);
                } else {
                    throw new IllegalArgumentException("ImageProcessor type unknown and pixel type unknown.");
                }
            }
        }
        return result;
    }

    public static void PluginLauncher(ImageJ ij, PlugIn plugin, BufferedImage source, String str) {
        ImagePlus imp = IJInterfacor.BufferedImageToImagePlus(source);
        ImageWindow iw = new ImageWindow(imp);
        WindowManager.addWindow((Frame)iw);
        iw.setVisible(false);
        plugin.run(str);
    }

    public static BufferedImage PluginFilterInterfacor(PlugInFilter plugin, BufferedImage source) {
        ImagePlus imp = IJInterfacor.BufferedImageToImagePlus(source);
        plugin.setup(null, imp);
        plugin.run(imp.getProcessor());
        return IJInterfacor.ImageProcessorToBufferedImage(imp.getProcessor());
    }

    public static BufferedImage PluginFilterInterfacor(List<PlugInFilter> plugins, BufferedImage source) {
        ImagePlus imp = IJInterfacor.BufferedImageToImagePlus(source);
        for (PlugInFilter plugin : plugins) {
            plugin.setup(null, imp);
            plugin.run(imp.getProcessor());
        }
        return IJInterfacor.ImageProcessorToBufferedImage(imp.getProcessor());
    }
}

