/*
 * Decompiled with CFR 0.152.
 */
package filesAndFolders.fichiersTabules;

import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayTools;
import filesAndFolders.fichiersTabules.FichierTabule;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import utils.sorts.QuickSort;

public class FichierTabuleTools {
    public static final int ERROR = -1;
    public static final int FAILURE = 0;
    public static final int SUCCESS = 1;

    public static FichierTabule Merge(FichierTabule f1, FichierTabule f2) {
        return FichierTabuleTools.Merge(f1, 0, f1.Height(), f2, 0, f2.Height());
    }

    public static FichierTabule Merge(FichierTabule f1, int f1start, int f1end, FichierTabule f2, int f2start, int f2end) {
        int y;
        int x;
        int largeur = f1.Width();
        FichierTabule resultat = null;
        if (!ArrayTools.AreEqual((boolean[])f1.getExcludedColumn(), (boolean[])f2.getExcludedColumn())) {
            throw new IllegalArgumentException("Files have different number or excluded colums.");
        }
        for (int x2 = 0; x2 < largeur; ++x2) {
            if (f1.isExcludedColumn(x2) || f1.ColumnType(x2) == f2.ColumnType(x2)) continue;
            throw new IllegalArgumentException("Types of columns different between f1 and f2.");
        }
        int[] types = new int[largeur - f1.nbExcludedColumn()];
        String[] names = new String[largeur - f1.nbExcludedColumn()];
        int pos = 0;
        for (x = 0; x < largeur; ++x) {
            if (f1.isExcludedColumn(x)) continue;
            types[pos] = f1.ColumnType(x);
            names[pos++] = f1.getColumnName(x);
        }
        int hauteur1 = f1.Height();
        int hauteur = f1end - f1start + f2end - f2start - f1.nbExcluded(f1start, f1end) - f2.nbExcluded(f2start, f2end);
        resultat = new FichierTabule(hauteur, types, f1.Name() + f2.Name());
        resultat.setColumnsNames(names);
        int poswidth = 0;
        block7: for (x = 0; x < largeur; ++x) {
            if (f1.isExcludedColumn(x)) continue;
            pos = 0;
            switch (f1.ColumnType(x)) {
                case 0: {
                    int[] ColonneInt = resultat.getColumnInt(poswidth++);
                    int[] ColonneIntBis = f1.getColumnInt(x);
                    for (y = f1start; y < f1end; ++y) {
                        if (f1.isExcluded(y)) continue;
                        ColonneInt[pos++] = ColonneIntBis[y];
                    }
                    ColonneIntBis = f2.getColumnInt(x);
                    for (y = f2start; y < f2end; ++y) {
                        if (f2.isExcluded(y)) continue;
                        ColonneInt[pos++] = ColonneIntBis[y];
                    }
                    continue block7;
                }
                case 1: {
                    double[] ColonneDouble = resultat.getColumnDouble(poswidth++);
                    double[] ColonneDoubleBis = f1.getColumnDouble(x);
                    for (y = f1start; y < f1end; ++y) {
                        if (f1.isExcluded(y)) continue;
                        ColonneDouble[pos++] = ColonneDoubleBis[y];
                    }
                    ColonneDoubleBis = f2.getColumnDouble(x);
                    for (y = f2start; y < f2end; ++y) {
                        if (f2.isExcluded(y)) continue;
                        ColonneDouble[hauteur1 + y] = ColonneDoubleBis[y];
                    }
                    continue block7;
                }
                case 2: {
                    String[] ColonneString = resultat.getColumnString(poswidth++);
                    String[] ColonneStringBis = f1.getColumnString(x);
                    for (y = f1start; y < f1end; ++y) {
                        if (f1.isExcluded(y)) continue;
                        ColonneString[pos++] = ColonneStringBis[y] == null ? null : ColonneStringBis[y].substring(0);
                    }
                    ColonneStringBis = f2.getColumnString(x);
                    for (y = f2start; y < f2end; ++y) {
                        if (f2.isExcluded(y)) continue;
                        ColonneString[pos++] = ColonneStringBis[y] == null ? null : ColonneStringBis[y].substring(0);
                    }
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type: " + f1.ColumnType(x));
                }
            }
        }
        double[] weights = resultat.Weights();
        double[] w = f1.Weights();
        for (y = pos = f1start; y < f1end; ++y) {
            if (f1.isExcluded(y)) continue;
            weights[pos++] = w[y];
        }
        w = f2.Weights();
        for (y = f2start; y < f2end; ++y) {
            if (f2.isExcluded(y)) continue;
            weights[pos++] = w[y];
        }
        return resultat;
    }

    public static FichierTabule MergeSideBySide(FichierTabule f1, FichierTabule f2) {
        String[] ColonneStringBis;
        String[] ColonneString;
        double[] ColonneDoubleBis;
        double[] ColonneDouble;
        int y;
        int[] ColonneIntBis;
        int[] ColonneInt;
        int pos;
        int x;
        int largeur1 = f1.Width();
        int largeur2 = f2.Width();
        int hauteur = f1.Height();
        FichierTabule resultat = null;
        if (!ArrayTools.AreEqual((boolean[])f1.getExcluded(), (boolean[])f2.getExcluded())) {
            throw new IllegalArgumentException("Number or excluded instances (rows) different between files.");
        }
        int[] Types = new int[largeur1 + largeur2 - f1.getNbExcludedColumn() - f2.nbExcludedColumn()];
        int poswidth = 0;
        for (x = 0; x < largeur1; ++x) {
            if (f1.isExcludedColumn(x)) continue;
            Types[poswidth++] = f1.ColumnType(x);
        }
        for (x = 0; x < largeur2; ++x) {
            if (f2.isExcludedColumn(x)) continue;
            Types[poswidth++] = f2.ColumnType(x);
        }
        resultat = new FichierTabule(hauteur - f1.nbExcluded(), Types, f1.Name() + "_Right_" + f2.Name());
        poswidth = 0;
        block12: for (x = 0; x < largeur1; ++x) {
            if (f1.isExcludedColumn(x)) continue;
            pos = 0;
            resultat.setNominal(poswidth, f1.isNominal(x));
            resultat.setColumnName(poswidth, f1.getColumnName(x).substring(0));
            switch (f1.ColumnType(x)) {
                case 0: {
                    ColonneInt = resultat.getColumnInt(poswidth++);
                    ColonneIntBis = f1.getColumnInt(x);
                    for (y = 0; y < hauteur; ++y) {
                        if (f1.isExcluded(y)) continue;
                        ColonneInt[pos++] = ColonneIntBis[y];
                    }
                    continue block12;
                }
                case 1: {
                    ColonneDouble = resultat.getColumnDouble(poswidth++);
                    ColonneDoubleBis = f1.getColumnDouble(x);
                    for (y = 0; y < hauteur; ++y) {
                        if (f1.isExcluded(y)) continue;
                        ColonneDouble[pos++] = ColonneDoubleBis[y];
                    }
                    continue block12;
                }
                case 2: {
                    ColonneString = resultat.getColumnString(poswidth++);
                    ColonneStringBis = f1.getColumnString(x);
                    for (y = 0; y < hauteur; ++y) {
                        if (f1.isExcluded(y)) continue;
                        ColonneString[pos++] = ColonneStringBis[y].substring(0);
                    }
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Unknown or not supported column type: " + f1.ColumnType(x));
                }
            }
        }
        block16: for (x = 0; x < largeur2; ++x) {
            if (f2.isExcludedColumn(x)) continue;
            pos = 0;
            resultat.setNominal(poswidth, f2.isNominal(x));
            resultat.setColumnName(poswidth, f2.getColumnName(x).substring(0));
            switch (f2.ColumnType(x)) {
                case 0: {
                    ColonneInt = resultat.getColumnInt(poswidth++);
                    ColonneIntBis = f2.getColumnInt(x);
                    for (y = 0; y < hauteur; ++y) {
                        if (f2.isExcluded(y)) continue;
                        ColonneInt[pos++] = ColonneIntBis[y];
                    }
                    continue block16;
                }
                case 1: {
                    ColonneDouble = resultat.getColumnDouble(poswidth++);
                    ColonneDoubleBis = f2.getColumnDouble(x);
                    for (y = 0; y < hauteur; ++y) {
                        if (f2.isExcluded(y)) continue;
                        ColonneDouble[pos++] = ColonneDoubleBis[y];
                    }
                    continue block16;
                }
                case 2: {
                    ColonneString = resultat.getColumnString(poswidth++);
                    ColonneStringBis = f2.getColumnString(x);
                    for (y = 0; y < hauteur; ++y) {
                        if (ColonneStringBis[y] == null || f2.isExcluded(y)) continue;
                        ColonneString[pos++] = ColonneStringBis[y].substring(0);
                    }
                    continue block16;
                }
                default: {
                    throw new IllegalArgumentException("Unknown or not supported column type: " + f1.ColumnType(x));
                }
            }
        }
        pos = 0;
        for (int y2 = 0; y2 < hauteur; ++y2) {
            if (f1.isExcluded(y2)) continue;
            resultat.Weight(pos++, f1.Weight(y2));
        }
        return resultat;
    }

    public static FichierTabule AddColumn(FichierTabule file) {
        int x;
        int largeur = file.Width();
        int hauteur = file.Height();
        FichierTabule resultat = null;
        int[] Types = new int[largeur + 1];
        for (x = 0; x < largeur; ++x) {
            Types[x] = file.ColumnType(x);
        }
        Types[largeur] = -1;
        resultat = new FichierTabule(hauteur, Types, file.Name() + "+1Col");
        for (x = 0; x < largeur; ++x) {
            switch (file.ColumnType(x)) {
                case 0: {
                    resultat.setColumn(x, file.getColumnInt(x));
                    break;
                }
                case 1: {
                    resultat.setColumn(x, file.getColumnDouble(x));
                    break;
                }
                case 2: {
                    resultat.setColumn(x, file.getColumnString(x));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type: " + file.ColumnType(x));
                }
            }
            resultat.setExcludedColumn(x, file.isExcludedColumn(x));
            resultat.setNominal(x, file.isNominal(x));
            resultat.setSelectedColumn(x, file.isSelectedColumn(x));
            resultat.setColumnName(x, file.getColumnName(x));
        }
        resultat.setSelected(file.getSelected());
        resultat.setExcluded(file.getExcluded());
        return resultat;
    }

    public static FichierTabule AddColumn(FichierTabule file, int Value) {
        FichierTabule resultat = FichierTabuleTools.AddColumn(file);
        int largeur = resultat.Width();
        resultat.setTypeColonne(largeur - 1, 0);
        Arrays.fill(resultat.getColumnInt(largeur - 1), Value);
        return resultat;
    }

    public static FichierTabule AddColumn(FichierTabule file, double Value) {
        FichierTabule resultat = FichierTabuleTools.AddColumn(file);
        int largeur = resultat.Width();
        resultat.setTypeColonne(largeur - 1, 1);
        Arrays.fill(resultat.getColumnDouble(largeur - 1), Value);
        return resultat;
    }

    public static FichierTabule AddColumn(FichierTabule file, String Value) {
        FichierTabule resultat = FichierTabuleTools.AddColumn(file);
        int largeur = resultat.Width();
        resultat.setTypeColonne(largeur - 1, 2);
        Object[] Colonne = resultat.getColumnString(largeur - 1);
        Arrays.fill(Colonne, Value);
        return resultat;
    }

    public static FichierTabule AddColumns(FichierTabule file, FichierTabule file2, int Start, int End) {
        int x;
        int nb = End - Start + 1;
        int largeur = file.Width();
        int hauteur = file.Height();
        FichierTabule resultat = null;
        int[] Types = new int[largeur + nb];
        for (x = 0; x < largeur; ++x) {
            Types[x] = file.ColumnType(x);
        }
        for (x = 0; x < nb; ++x) {
            Types[largeur + x] = file2.ColumnType(Start + x);
        }
        resultat = new FichierTabule(hauteur, Types, file.Name() + "_" + Start + "_" + End + "_of_" + file2.Name());
        for (x = 0; x < largeur; ++x) {
            resultat.setColumnName(x, file.getColumnName(x));
        }
        for (x = 0; x < nb; ++x) {
            resultat.setColumnName(largeur + x, file2.getColumnName(Start + x));
        }
        block16: for (x = 0; x < largeur; ++x) {
            switch (file.ColumnType(x)) {
                case 0: {
                    resultat.setColumn(x, file.getColumnInt(x));
                    continue block16;
                }
                case 1: {
                    resultat.setColumn(x, file.getColumnDouble(x));
                    continue block16;
                }
                case 2: {
                    resultat.setColumn(x, file.getColumnString(x));
                    continue block16;
                }
                case -1: {
                    continue block16;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type: " + file.ColumnType(x));
                }
            }
        }
        for (x = Start; x <= End; ++x) {
            switch (file.ColumnType(x)) {
                case 0: {
                    resultat.setColumn(largeur, file2.getColumnInt(x));
                    break;
                }
                case 1: {
                    resultat.setColumn(largeur, file2.getColumnDouble(x));
                    break;
                }
                case 2: {
                    resultat.setColumn(largeur, file2.getColumnString(x));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type: " + file.ColumnType(x));
                }
            }
            ++largeur;
        }
        return resultat;
    }

    public static FichierTabule AddColumns(FichierTabule file, int[] ColumnsType) {
        int x;
        int largeur = file.Width();
        int hauteur = file.Height();
        FichierTabule resultat = null;
        int[] Types = new int[largeur + ColumnsType.length];
        for (x = 0; x < largeur; ++x) {
            Types[x] = file.ColumnType(x);
        }
        block10: for (x = 0; x < ColumnsType.length; ++x) {
            switch (ColumnsType[x]) {
                case -1: 
                case 0: 
                case 1: 
                case 2: {
                    Types[largeur + x] = ColumnsType[x];
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type: " + ColumnsType[x]);
                }
            }
        }
        resultat = new FichierTabule(hauteur, Types, file.Name() + "+" + ColumnsType.length + "Columns");
        for (x = 0; x < ColumnsType.length; ++x) {
            resultat.setColumnName(largeur + x, "Add" + x);
        }
        for (x = 0; x < largeur; ++x) {
            switch (file.ColumnType(x)) {
                case 0: {
                    resultat.setColumn(x, file.getColumnInt(x));
                    break;
                }
                case 1: {
                    resultat.setColumn(x, file.getColumnDouble(x));
                    break;
                }
                case 2: {
                    resultat.setColumn(x, file.getColumnString(x));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type: " + file.ColumnType(x));
                }
            }
            resultat.setExcludedColumn(x, file.isExcludedColumn(x));
            resultat.setNominal(x, file.isNominal(x));
            resultat.setSelectedColumn(x, file.isSelectedColumn(x));
            resultat.setColumnName(x, file.getColumnName(x));
        }
        resultat.setSelected(file.getSelected());
        resultat.setExcluded(file.getExcluded());
        return resultat;
    }

    public static FichierTabule DeleteColumn(FichierTabule file, int num) {
        int x;
        int largeur = file.Width() - 1;
        int Largeur = file.Width();
        int hauteur = file.Height();
        int[] Types = new int[largeur];
        FichierTabule resultat = null;
        int nb = 0;
        for (x = 0; x < Largeur; ++x) {
            if (num == x) continue;
            Types[nb++] = file.ColumnType(x);
        }
        resultat = new FichierTabule(hauteur, Types, file.Name() + "-1Col");
        nb = 0;
        for (x = 0; x < Largeur; ++x) {
            if (num == x) continue;
            resultat.setExcludedColumn(nb, file.isExcludedColumn(x));
            resultat.setNominal(nb, file.isNominal(x));
            resultat.setColumnName(nb, file.getColumnName(x).substring(0));
            resultat.setSelectedColumn(nb, file.isSelectedColumn(x));
            switch (file.ColumnType(x)) {
                case 0: {
                    resultat.setColumn(nb, file.getColumnInt(x));
                    break;
                }
                case 1: {
                    resultat.setColumn(nb, file.getColumnDouble(x));
                    break;
                }
                case 2: {
                    resultat.setColumn(nb, file.getColumnString(x));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type: " + file.ColumnType(x));
                }
            }
            ++nb;
        }
        resultat.setSelected(file.getSelected());
        resultat.setExcluded(file.getExcluded());
        if (0 <= file.Target() && !file.isExcludedColumn(file.Target())) {
            resultat.Target(file.Target());
        }
        return resultat;
    }

    public static FichierTabule DeleteExcludedColumns(FichierTabule file) {
        int x;
        int Largeur = file.Width();
        int width = file.Width() - file.getNbExcludedColumn();
        int hauteur = file.Height();
        int target = file.Target();
        int[] Types = new int[width];
        FichierTabule resultat = null;
        boolean[] excluded = file.getExcludedColumn();
        int nb = 0;
        for (x = 0; x < Largeur; ++x) {
            if (excluded[x]) continue;
            Types[nb++] = file.ColumnType(x);
        }
        resultat = new FichierTabule(hauteur, Types, file.Name() + "-xCol");
        nb = 0;
        for (x = 0; x < Largeur; ++x) {
            if (excluded[x]) continue;
            resultat.setNominal(nb, file.isNominal(x));
            resultat.setColumnName(nb, file.getColumnName(x).substring(0));
            resultat.setSelectedColumn(nb, file.isSelectedColumn(x));
            if (x == target) {
                resultat.TargetNominal(nb);
            }
            switch (file.ColumnType(x)) {
                case 0: {
                    resultat.setColumn(nb, file.getColumnInt(x));
                    break;
                }
                case 1: {
                    resultat.setColumn(nb, file.getColumnDouble(x));
                    break;
                }
                case 2: {
                    resultat.setColumn(nb, file.getColumnString(x));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type: " + file.ColumnType(x));
                }
            }
            ++nb;
        }
        resultat.setSelected(file.getSelected());
        resultat.setExcluded(file.getExcluded());
        return resultat;
    }

    public static FichierTabule DeleteSelectedRows(FichierTabule fichier) {
        return FichierTabuleTools.DeleteRows(fichier, fichier.getSelected());
    }

    public static FichierTabule DeleteExcludedRows(FichierTabule fichier) {
        return FichierTabuleTools.DeleteRows(fichier, fichier.getExcluded());
    }

    public static FichierTabule DeleteRows(FichierTabule file, boolean[] Excluded) {
        int hauteur = file.Height();
        int largeur = file.Width();
        if (file.Height() != Excluded.length) {
            throw new IllegalArgumentException("Array and file have different length.");
        }
        int nb = 0;
        for (int y = 0; y < Excluded.length; ++y) {
            if (!Excluded[y]) continue;
            ++nb;
        }
        int Hauteur = file.Height() - nb;
        FichierTabule resultat = new FichierTabule(Hauteur, file.ColumnType(), file.Name() + "-Cols");
        block7: for (int x = 0; x < largeur; ++x) {
            resultat.setNominal(x, file.isNominal(x));
            resultat.setColumnName(x, file.getColumnName(x).substring(0));
            resultat.setExcludedColumn(x, file.isExcludedColumn(x));
            nb = 0;
            switch (file.ColumnType(x)) {
                case 0: {
                    int y;
                    int[] ColonneInt = resultat.getColumnInt(x);
                    int[] ColonneIntBis = file.getColumnInt(x);
                    for (y = 0; y < hauteur; ++y) {
                        if (Excluded[y]) continue;
                        ColonneInt[nb++] = ColonneIntBis[y];
                    }
                    continue block7;
                }
                case 1: {
                    int y;
                    double[] ColonneDouble = resultat.getColumnDouble(x);
                    double[] ColonneDoubleBis = file.getColumnDouble(x);
                    for (y = 0; y < hauteur; ++y) {
                        if (Excluded[y]) continue;
                        ColonneDouble[nb++] = ColonneDoubleBis[y];
                    }
                    continue block7;
                }
                case 2: {
                    int y;
                    String[] ColonneString = resultat.getColumnString(x);
                    String[] ColonneStringBis = file.getColumnString(x);
                    for (y = 0; y < hauteur; ++y) {
                        if (Excluded[y]) continue;
                        ColonneString[nb++] = ColonneStringBis[y] != null ? ColonneStringBis[y].substring(0) : null;
                    }
                    continue block7;
                }
                case -1: {
                    continue block7;
                }
                default: {
                    throw new Error("Unknown column type: " + file.ColumnType(x));
                }
            }
        }
        resultat.setExcludedColumn(file.getExcludedColumn());
        resultat.setColumnsNames(file.getColumnsNames());
        resultat.setNominal(file.getNominal());
        resultat.setSelectedColumn(file.getSelectedColumn());
        if (0 <= file.Target() && !file.isExcludedColumn(file.Target())) {
            resultat.Target(file.Target());
        }
        return resultat;
    }

    public static FichierTabule DeleteExcluded(FichierTabule file) {
        FichierTabule res = FichierTabuleTools.DeleteExcludedRows(file);
        FichierTabule result = FichierTabuleTools.DeleteExcludedColumns(res);
        res = null;
        return result;
    }

    public static FichierTabule SaveSelectedRows(FichierTabule file) {
        return FichierTabuleTools.SaveRows(file, file.getSelected());
    }

    public static FichierTabule SaveExcludedRows(FichierTabule file) {
        return FichierTabuleTools.SaveRows(file, file.getExcluded());
    }

    public static FichierTabule SaveRows(FichierTabule fichier, boolean[] Save) {
        int hauteur = fichier.Height();
        int largeur = fichier.Width();
        ArrayFeatures AF = new ArrayFeatures();
        if (fichier.Height() != Save.length) {
            throw new IllegalArgumentException("File and array dimension are differents.");
        }
        int Hauteur = AF.Integral(Save);
        if (Hauteur == 0) {
            throw new IllegalArgumentException("No selected rows into the boolean array.");
        }
        FichierTabule resultat = new FichierTabule(Hauteur, fichier.ColumnType(), fichier.Name() + "_Part");
        block6: for (int x = 0; x < largeur; ++x) {
            resultat.setNominal(x, fichier.isNominal(x));
            resultat.setColumnName(x, fichier.getColumnName(x).substring(0));
            resultat.setExcludedColumn(x, fichier.isExcludedColumn(x));
            int nb = 0;
            switch (fichier.ColumnType(x)) {
                case 0: {
                    int y;
                    int[] ColonneInt = resultat.getColumnInt(x);
                    int[] ColonneIntBis = fichier.getColumnInt(x);
                    for (y = 0; y < hauteur; ++y) {
                        if (!Save[y]) continue;
                        ColonneInt[nb++] = ColonneIntBis[y];
                    }
                    continue block6;
                }
                case 1: {
                    int y;
                    double[] ColonneDouble = resultat.getColumnDouble(x);
                    double[] ColonneDoubleBis = fichier.getColumnDouble(x);
                    for (y = 0; y < hauteur; ++y) {
                        if (!Save[y]) continue;
                        ColonneDouble[nb++] = ColonneDoubleBis[y];
                    }
                    continue block6;
                }
                case 2: {
                    int y;
                    String[] ColonneString = resultat.getColumnString(x);
                    String[] ColonneStringBis = fichier.getColumnString(x);
                    for (y = 0; y < hauteur; ++y) {
                        if (!Save[y]) continue;
                        ColonneString[nb++] = ColonneStringBis[y].substring(0);
                    }
                    continue block6;
                }
                case -1: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Type de colonne incorrect : " + fichier.ColumnType(x));
                }
            }
        }
        resultat.setExcludedColumn(fichier.getExcludedColumn());
        resultat.setColumnsNames(fichier.getColumnsNames());
        resultat.setNominal(fichier.getNominal());
        resultat.setSelectedColumn(fichier.getSelectedColumn());
        resultat.setColumnsNames(fichier.getColumnsNames());
        return resultat;
    }

    public static int IntersectionBetweenFiles(List<String> FileNames, List<Integer> Columns, double Epsilon) throws Exception {
        if (FileNames.size() < 2) {
            throw new IllegalArgumentException("At least two required in the list.");
        }
        ArrayList<FichierTabule> Fichiers = new ArrayList<FichierTabule>(FileNames.size());
        Iterator<String> iter = FileNames.iterator();
        while (iter.hasNext()) {
            try {
                Fichiers.add(new FichierTabule(iter.next(), true));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                throw new FileNotFoundException("");
            }
        }
        return FichierTabuleTools.IntersectionsBetweenFiles(Fichiers, Columns, Epsilon);
    }

    public static int IntersectionsBetweenFiles(List<FichierTabule> FileNames, List<Integer> Columns, double Epsilon) {
        if (FileNames.size() < 2) {
            throw new IllegalArgumentException("At least two files are required in the list.");
        }
        if (Columns.isEmpty()) {
            throw new IllegalArgumentException("Empty column list.");
        }
        if (Epsilon < 0.0) {
            throw new IllegalArgumentException("Epsilon is negative (dumb ass :@).");
        }
        int[] Colonnes = new int[Columns.size()];
        Iterator<Integer> itercol = Columns.iterator();
        Iterator<FichierTabule> iterfichiers = FileNames.iterator();
        FichierTabule f1 = null;
        FichierTabule f2 = null;
        int i2 = 0;
        while (itercol.hasNext()) {
            Colonnes[i2++] = itercol.next();
        }
        int nbColonnes = Colonnes.length;
        int nb = 0;
        f2 = iterfichiers.next();
        f2.SelectAllRows();
        while (iterfichiers.hasNext()) {
            f1 = f2;
            f2 = iterfichiers.next();
            f2.ClearSelection();
            for (i2 = 0; i2 < nbColonnes; ++i2) {
                if (f1.ColumnType(Colonnes[i2]) == f2.ColumnType(Colonnes[i2])) continue;
                throw new IllegalArgumentException("Incompatible column types between files " + nb + " and " + (nb + 1));
            }
            int nbLignes1 = f1.Height();
            int nbLignes2 = f2.Height();
            for (int y1 = 0; y1 < nbLignes1; ++y1) {
                if (!f1.isSelected(y1)) continue;
                for (int y2 = 0; y2 < nbLignes2; ++y2) {
                    boolean Identiques = true;
                    block10: for (i2 = 0; Identiques && i2 < nbColonnes; ++i2) {
                        switch (f1.ColumnType(Colonnes[i2])) {
                            case 0: {
                                if (f1.getValueInt(y1, Colonnes[i2]) == f2.getValueInt(y2, Colonnes[i2])) continue block10;
                                Identiques = false;
                                continue block10;
                            }
                            case 1: {
                                if (!(Math.abs(f1.getValueDouble(y1, Colonnes[i2]) - f2.getValueDouble(y2, Colonnes[i2])) > Epsilon)) continue block10;
                                Identiques = false;
                                continue block10;
                            }
                            case 2: {
                                if (f1.getValueString(y1, Colonnes[i2]).equalsIgnoreCase(f2.getValueString(y2, Colonnes[i2]))) continue block10;
                                Identiques = false;
                                continue block10;
                            }
                            default: {
                                throw new IllegalArgumentException("Default fichier.ColumnType()");
                            }
                        }
                    }
                    if (!Identiques) continue;
                    f2.setSelected(y2, true);
                }
            }
            ++nb;
        }
        nb = f2.getNbSelected();
        itercol = null;
        iterfichiers = null;
        f2 = null;
        f1 = null;
        Colonnes = null;
        return nb;
    }

    public static FichierTabule Clone(FichierTabule Source2) {
        FichierTabule Fichier = new FichierTabule(Source2.Height(), Source2.ColumnType(), Source2.Name() + "_Clone");
        block5: for (int x = 0; x < Source2.Width(); ++x) {
            switch (Source2.ColumnType(x)) {
                case 1: {
                    Fichier.setColumn(x, Source2.getColumnDouble(x));
                    continue block5;
                }
                case 0: {
                    Fichier.setColumn(x, Source2.getColumnInt(x));
                    continue block5;
                }
                case 2: {
                    Fichier.setColumn(x, Source2.getColumnString(x));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Default: " + Source2.ColumnType(x));
                }
            }
        }
        Fichier.setExcluded(Source2.getExcluded());
        Fichier.setExcludedColumn(Source2.getExcludedColumn());
        Fichier.setSelected(Source2.getSelected());
        Fichier.setSelectedColumn(Source2.getSelectedColumn());
        Fichier.setColumnsNames(Source2.getColumnsNames());
        Fichier.setNominal(Source2.getNominal());
        if (0 <= Source2.Target()) {
            Fichier.Target(Source2.Target());
        }
        return Fichier;
    }

    public static FichierTabule CloneIntToDouble(FichierTabule Source2) {
        int[] Type2 = new int[Source2.Width()];
        for (int x = 0; x < Source2.Width(); ++x) {
            Type2[x] = Source2.ColumnType(x) == 0 ? 1 : Source2.ColumnType(x);
        }
        FichierTabule Fichier = new FichierTabule(Source2.Height(), Type2, Source2.Name() + "_CloneIntToDouble");
        block6: for (int x = 0; x < Source2.Width(); ++x) {
            switch (Source2.ColumnType(x)) {
                case 1: {
                    Fichier.setColumn(x, Source2.getColumnDouble(x));
                    continue block6;
                }
                case 0: {
                    for (int y = 0; y < Source2.Height(); ++y) {
                        Fichier.setValue(y, x, (double)Source2.getValueInt(y, x));
                    }
                    continue block6;
                }
                case 2: {
                    Fichier.setColumn(x, Source2.getColumnString(x));
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Default: " + Source2.ColumnType(x));
                }
            }
        }
        Fichier.setExcluded(Source2.getExcluded());
        Fichier.setExcludedColumn(Source2.getExcludedColumn());
        Fichier.setSelected(Source2.getSelected());
        Fichier.setSelectedColumn(Source2.getSelectedColumn());
        Fichier.setColumnsNames(Source2.getColumnsNames());
        Fichier.setNominal(Source2.getNominal());
        if (0 <= Source2.Target()) {
            Fichier.Target(Source2.Target());
        }
        return Fichier;
    }

    public static FichierTabule Same(FichierTabule file) {
        return FichierTabuleTools.Same(file, file.Height() - file.getNbExcluded());
    }

    public static FichierTabule Same(FichierTabule file, int nbRows) {
        int width = file.Width();
        int nbExcluded = file.getNbExcludedColumn();
        String[] names = new String[width - nbExcluded];
        int[] types = new int[width - nbExcluded];
        boolean[] excluded = file.getExcludedColumn();
        int nb = 0;
        for (int x = 0; x < width; ++x) {
            if (excluded[x]) continue;
            names[nb] = file.getColumnName(x).substring(0);
            types[nb++] = file.ColumnType(x);
        }
        FichierTabule result = new FichierTabule(nbRows, types, file.Name() + "_Same");
        result.setColumnsNames(names);
        excluded = null;
        types = null;
        names = null;
        return result;
    }

    public static void Copy(FichierTabule fileIn, FichierTabule fileOut) {
        FichierTabuleTools.Copy(fileIn, 0, fileIn.Width() - 1, fileOut, 0);
    }

    public static void Copy(FichierTabule fileIn, int start, int end, FichierTabule fileOut, int pos) {
        if (fileIn.Height() != fileOut.Height()) {
            throw new IllegalArgumentException("Different number of instances between files in and out.");
        }
        int nb = 0;
        int[] in = fileIn.ColumnType();
        int[] out = fileOut.ColumnType();
        for (int x = start; x <= end; ++x) {
            if (in[x] != out[pos + nb]) {
                throw new IllegalArgumentException("Colums types are differents.");
            }
            switch (in[x]) {
                case 1: {
                    fileOut.setColumn(pos + nb, fileIn.getColumnDouble(x));
                    break;
                }
                case 0: {
                    fileOut.setColumn(pos + nb, fileIn.getColumnInt(x));
                    break;
                }
                case 2: {
                    fileOut.setColumn(pos + nb, fileIn.getColumnString(x));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new Error("Default: incorrect type of column.");
                }
            }
            ++nb;
        }
    }

    public static void CopySelected(FichierTabule fileIn, FichierTabule fileOut, int pos) {
        if (fileIn.Height() != fileOut.Height()) {
            throw new IllegalArgumentException("Different number of instances between files in and out.");
        }
        int nb = 0;
        int width = fileIn.Width();
        int[] in = fileIn.ColumnType();
        int[] out = fileOut.ColumnType();
        for (int x = 0; x <= width; ++x) {
            if (in[x] != out[pos + nb]) {
                throw new IllegalArgumentException("Colums types are differents.");
            }
            switch (in[x]) {
                case 1: {
                    fileOut.setColumn(pos + nb, fileIn.getColumnDouble(x));
                    break;
                }
                case 0: {
                    fileOut.setColumn(pos + nb, fileIn.getColumnInt(x));
                    break;
                }
                case 2: {
                    fileOut.setColumn(pos + nb, fileIn.getColumnString(x));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new Error("Default: incorrect type of column.");
                }
            }
            ++nb;
        }
    }

    public static void CopySelectedInSelected(FichierTabule fileIn, FichierTabule fileOut) {
        if (fileIn.Height() != fileOut.Height()) {
            throw new IllegalArgumentException("Different number of instances between files in and out.");
        }
        if (fileIn.getNbSelectedColumn() != fileOut.getNbSelectedColumn()) {
            throw new IllegalArgumentException("Number of selected columns different between files in and out.");
        }
        int nb = 0;
        int width = fileIn.Width();
        int[] in = fileIn.ColumnType();
        int[] out = fileOut.ColumnType();
        for (int x = 0; x <= width; ++x) {
            if (!fileIn.isSelected(x)) continue;
            while (!fileOut.isSelected(nb)) {
                ++nb;
            }
            if (in[x] != out[nb]) {
                throw new IllegalArgumentException("Colums types are differents.");
            }
            switch (in[x]) {
                case 1: {
                    fileOut.setColumn(nb, fileIn.getColumnDouble(x));
                    break;
                }
                case 0: {
                    fileOut.setColumn(nb, fileIn.getColumnInt(x));
                    break;
                }
                case 2: {
                    fileOut.setColumn(nb, fileIn.getColumnString(x));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new Error("Default: incorrect type of column.");
                }
            }
            ++nb;
        }
    }

    public static void CopyInstance(FichierTabule in, int rowin, FichierTabule out, int rowout) {
        block5: for (int x = 0; x < in.Width(); ++x) {
            switch (in.ColumnType(x)) {
                case 1: {
                    out.setValue(rowout, x, in.getValueDouble(rowin, x));
                    continue block5;
                }
                case 0: {
                    out.setValue(rowout, x, in.getValueInt(rowin, x));
                    continue block5;
                }
                case 2: {
                    out.setValue(rowout, x, in.getValueString(rowin, x));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Type not supported.");
                }
            }
        }
        out.Weight(rowout, in.Weight(rowin));
    }

    public static void CopyInstances(FichierTabule in, int rowinstart, int rowinend, FichierTabule out, int rowoutstart) {
        while (rowinstart <= rowinend) {
            block6: for (int x = 0; x < in.Width(); ++x) {
                switch (in.ColumnType(x)) {
                    case 1: {
                        out.setValue(rowoutstart, x, in.getValueDouble(rowinstart, x));
                        continue block6;
                    }
                    case 0: {
                        out.setValue(rowoutstart, x, in.getValueInt(rowinstart, x));
                        continue block6;
                    }
                    case 2: {
                        out.setValue(rowoutstart, x, in.getValueString(rowinstart, x));
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Type not supported.");
                    }
                }
            }
            out.Weight(rowoutstart, in.Weight(rowinstart));
            ++rowinstart;
            ++rowoutstart;
        }
    }

    public static void CopySelectedInstances(FichierTabule in, FichierTabule out, int rowoutstart) {
        boolean[] selected = in.getSelected();
        for (int i2 = 0; i2 < selected.length; ++i2) {
            if (!selected[i2]) continue;
            FichierTabuleTools.CopyInstance(in, i2, out, rowoutstart++);
        }
    }

    public static int CheckIntegrityInfinityNaN(FichierTabule file) {
        if (FichierTabuleTools.CheckIntegrityInfinity(file) == 0) {
            return 0;
        }
        if (FichierTabuleTools.CheckIntegrityNaN(file) == 0) {
            return 0;
        }
        return 1;
    }

    public static int CheckIntegrityInfinity(FichierTabule file) {
        int nbLines = file.Height();
        int nbColumns = file.Width();
        for (int x = 0; x < nbColumns; ++x) {
            if (file.isExcludedColumn(x) || file.ColumnType(x) != 1) continue;
            for (int y = 0; y < nbLines; ++y) {
                if (file.isExcluded(y) || !Double.isInfinite(file.getValueDouble(y, x))) continue;
                return 0;
            }
        }
        return 1;
    }

    public static int CheckIntegrityNaN(FichierTabule file) {
        int nbLines = file.Height();
        int nbColumns = file.Width();
        for (int x = 0; x < nbColumns; ++x) {
            if (file.isExcludedColumn(x) || file.ColumnType(x) != 1) continue;
            for (int y = 0; y < nbLines; ++y) {
                if (file.isExcluded(y) || !Double.isNaN(file.getValueDouble(y, x))) continue;
                return 0;
            }
        }
        return 1;
    }

    public static FichierTabule DuplicateInstances(FichierTabule file, int[] occurrences) {
        int height = file.Height();
        if (height != occurrences.length) {
            throw new IllegalArgumentException("file and occurences have different dimensions.");
        }
        int size = 0;
        for (int y = 0; y < height; ++y) {
            size += occurrences[y];
        }
        FichierTabule result = new FichierTabule(size, file.ColumnType(), file.Name() + "_DuplicatedInstances");
        result.setColumnsNames(file.getColumnsNames());
        int n = 0;
        int y = 0;
        while (y < height) {
            while (true) {
                int n2 = y++;
                int n3 = occurrences[n2];
                occurrences[n2] = n3 - 1;
                if (n3 <= 0) break;
                FichierTabuleTools.CopyInstance(file, y, result, n++);
            }
        }
        result.setColumnsNames(file.getColumnsNames());
        result.setNominal(file.getNominal());
        int target = file.Target();
        if (0 <= target) {
            result.Target(target);
        }
        return result;
    }

    public static FichierTabule DuplicateInstances(FichierTabule file, int occurrences) {
        int height = file.Height();
        FichierTabule result = new FichierTabule(height * occurrences, file.ColumnType(), file.Name() + "_Duplicated_" + occurrences);
        result.setColumnsNames(file.getColumnsNames());
        int n = 0;
        for (int y = 0; y < height; ++y) {
            for (int i2 = 0; i2 < occurrences; ++i2) {
                FichierTabuleTools.CopyInstance(file, y, result, n++);
            }
        }
        return result;
    }

    public static void DisplayRow(FichierTabule file, int number, int start, int end, String separator) {
        block6: for (int i2 = start; i2 <= end; ++i2) {
            switch (file.ColumnType(i2)) {
                case 1: {
                    System.out.print(file.getValueDouble(number, i2) + separator);
                    continue block6;
                }
                case 0: {
                    System.out.print(file.getValueInt(number, i2) + separator);
                    continue block6;
                }
                case 2: {
                    System.out.print(file.getValueString(number, i2) + separator);
                    continue block6;
                }
                case -1: {
                    continue block6;
                }
                default: {
                    throw new Error("Column " + i2 + ", unknown type " + file.ColumnType(i2) + ". Must not occured.");
                }
            }
        }
    }

    public static void DisplayColumn(FichierTabule file, String name, int start, int end, String separator) {
        FichierTabuleTools.DisplayColumn(file, file.ColumnNumber(name), start, end, separator);
    }

    public static void DisplayColumn(FichierTabule file, int number, int start, int end, String separator) {
        switch (file.ColumnType(number)) {
            case 1: {
                for (int i2 = start; i2 <= end; ++i2) {
                    System.out.print(file.getValueDouble(i2, number) + separator);
                }
                break;
            }
            case 0: {
                for (int i3 = start; i3 <= end; ++i3) {
                    System.out.print(file.getValueInt(i3, number) + separator);
                }
                break;
            }
            case 2: {
                for (int i4 = start; i4 <= end; ++i4) {
                    System.out.print(file.getValueString(i4, number) + separator);
                }
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new Error("Column " + number + ", unknown type " + file.ColumnType(number) + ". Must not occured.");
            }
        }
    }

    public static void Swap(FichierTabule file, int row1, int row2) {
        block6: for (int x = 0; x < file.Width(); ++x) {
            switch (file.ColumnType(x)) {
                case 1: {
                    double[] dcolumn = file.getColumnDouble(x);
                    double dtmp = dcolumn[row1];
                    dcolumn[row1] = dcolumn[row2];
                    dcolumn[row2] = dtmp;
                    dcolumn = null;
                    continue block6;
                }
                case 0: {
                    int[] icolumn = file.getColumnInt(x);
                    int itmp = icolumn[row1];
                    icolumn[row1] = icolumn[row2];
                    icolumn[row2] = itmp;
                    icolumn = null;
                    continue block6;
                }
                case 2: {
                    String[] scolumn = file.getColumnString(x);
                    String stmp = scolumn[row1];
                    scolumn[row1] = scolumn[row2];
                    scolumn[row2] = stmp;
                    scolumn = null;
                    continue block6;
                }
                case -1: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Column type not defined.");
                }
            }
        }
    }

    public static void Sort(FichierTabule file, int col) {
        FichierTabuleTools.Sort(file, col, 0, file.Height() - 1);
    }

    public static void Sort(FichierTabule file, int col, int start, int end) {
        QuickSort.Sort(file, col, start, end);
    }

    public static FichierTabule CopySelectedColumns(FichierTabule file) {
        int x;
        int Largeur = file.Width();
        int width = file.getNbSelectedColumn();
        int hauteur = file.Height();
        int[] Types = new int[width];
        FichierTabule resultat = null;
        boolean[] selected = file.getSelectedColumn();
        int nb = 0;
        for (x = 0; x < Largeur; ++x) {
            if (!selected[x]) continue;
            Types[nb++] = file.ColumnType(x);
        }
        resultat = new FichierTabule(hauteur, Types, "SelectedColums");
        nb = 0;
        for (x = 0; x < Largeur; ++x) {
            if (!selected[x]) continue;
            resultat.setNominal(nb, file.isNominal(x));
            resultat.setColumnName(nb, file.getColumnName(x).substring(0));
            switch (file.ColumnType(x)) {
                case 0: {
                    resultat.setColumn(nb, file.getColumnInt(x));
                    break;
                }
                case 1: {
                    resultat.setColumn(nb, file.getColumnDouble(x));
                    break;
                }
                case 2: {
                    resultat.setColumn(nb, file.getColumnString(x));
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type: " + file.ColumnType(x));
                }
            }
            ++nb;
        }
        resultat.setSelected(file.getSelected());
        resultat.setExcluded(file.getExcluded());
        return resultat;
    }
}

