/*
 * Decompiled with CFR 0.152.
 */
package filesAndFolders.fichiersTabules;

import arrayTiTi.ArrayFeatures;
import dataMining.InstancesTools;
import filesAndFolders.fichiersTabules.FichierTabule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jsat.DataSet;
import jsat.SimpleDataSet;
import jsat.classifiers.CategoricalData;
import jsat.classifiers.ClassificationDataSet;
import jsat.classifiers.DataPoint;
import jsat.linear.DenseVector;
import jsat.linear.Vec;
import jsat.regression.RegressionDataSet;
import listTiTi.ListTools;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class FichierTabuleConverter {
    public static FichierTabule LastConvertedFile = null;
    public static Instances LastInstances = null;
    public static SimpleDataSet LastSimpleDataSet = null;
    public static ClassificationDataSet LastClassificationDataSet = null;

    public static void ForceConvertion() {
        LastConvertedFile = null;
        LastInstances = null;
        LastSimpleDataSet = null;
        LastClassificationDataSet = null;
    }

    public static Instances FichierTabuleToWekaInstances(FichierTabule file, String name) {
        Instances instances = null;
        ArrayList<Attribute> Attributes2 = new ArrayList<Attribute>(file.Width());
        int newtarget = -1;
        int target = file.Target();
        for (int x = 0; x < file.Width(); ++x) {
            if (file.isExcludedColumn(x)) continue;
            if (file.isNominal(x)) {
                ArrayList<String> classes = new ArrayList<String>(13);
                switch (file.ColumnType(x)) {
                    case 0: {
                        int y;
                        for (y = 0; y < file.Height(); ++y) {
                            if (file.isExcluded(y) || ListTools.isInList(classes, (String)String.valueOf(file.getValueInt(y, x)))) continue;
                            classes.add(String.valueOf(file.getValueInt(y, x)));
                        }
                        break;
                    }
                    case 2: {
                        int y;
                        for (y = 0; y < file.Height(); ++y) {
                            if (file.isExcluded(y) || ListTools.isInList(classes, (String)file.getValueString(y, x))) continue;
                            classes.add(file.getValueString(y, x));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Default: column " + x + " must not be nominal.Only INTEGER or STRING supported.");
                    }
                }
                Attributes2.add(new Attribute(file.getColumnName(x), classes));
                if (x != target) continue;
                newtarget = Attributes2.size() - 1;
                continue;
            }
            switch (file.ColumnType(x)) {
                case 0: 
                case 1: {
                    Attributes2.add(new Attribute(file.getColumnName(x)));
                    break;
                }
                case 2: {
                    Attributes2.add(new Attribute(file.getColumnName(x), (List)null));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Default: type not supported (" + file.ColumnType(x) + ") for column " + x);
                }
            }
            if (x != target) continue;
            newtarget = Attributes2.size() - 1;
        }
        instances = new Instances(name, Attributes2, file.Height());
        if (0 <= newtarget) {
            instances.setClassIndex(newtarget);
        }
        FichierTabuleConverter.FillWekaInstances(file, instances);
        return instances;
    }

    public static void FillWekaInstances(FichierTabule file, Instances instances) {
        for (int y = 0; y < file.Height(); ++y) {
            if (file.isExcluded(y)) continue;
            DenseInstance instance = new DenseInstance(instances.numAttributes());
            instance.setDataset(instances);
            instance.setWeight(file.Weight(y));
            int nb = 0;
            block8: for (int x = 0; x < file.Width(); ++x) {
                if (file.isExcludedColumn(x)) continue;
                switch (file.ColumnType(x)) {
                    case 1: {
                        instance.setValue(nb++, file.getValueDouble(y, x));
                        continue block8;
                    }
                    case 0: {
                        instance.setValue(nb++, (double)file.getValueInt(y, x));
                        continue block8;
                    }
                    case 2: {
                        try {
                            instance.setValue(nb++, file.getValueString(y, x));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException("Default: column " + x + ", type not supported (" + file.ColumnType(x) + ")");
                    }
                }
            }
            instances.add((Instance)instance);
        }
        LastConvertedFile = file;
        LastInstances = instances;
    }

    public static SimpleDataSet FichierTabuleToJsatDataSet(FichierTabule file) {
        boolean[] excol = file.getExcludedColumn();
        boolean[] exc = file.getExcluded();
        int[] types = file.ColumnType();
        boolean[] isreal = new boolean[file.Width() - file.getNbExcludedColumn()];
        int numcat = 0;
        int numreal = 0;
        int nb = 0;
        int pos = 0;
        block9: for (int x = 0; x < excol.length; ++x) {
            if (excol[x]) continue;
            switch (types[x]) {
                case 0: 
                case 1: {
                    ++numreal;
                    isreal[pos++] = true;
                    continue block9;
                }
                case 2: {
                    ++numcat;
                    ++nb;
                    isreal[pos++] = false;
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Default: column " + x + ", type not supported (" + file.ColumnType(x) + ")");
                }
            }
        }
        if (1 < nb) {
            throw new IllegalArgumentException("The file cannot contain more than 1 STRING column.");
        }
        ArrayList catvals = new ArrayList(file.Width());
        for (int x = 0; x < excol.length; ++x) {
            if (excol[x] || types[x] != 2) continue;
            HashMap<String, Integer> tmpmap = new HashMap<String, Integer>(13);
            String[] column = file.getColumnString(x);
            int poscat = 0;
            for (int y = 0; y < exc.length; ++y) {
                String s;
                if (exc[y] || tmpmap.containsKey(s = column[y])) continue;
                tmpmap.put(s, poscat++);
            }
            catvals.add(tmpmap);
            column = null;
        }
        CategoricalData[] categoricalData = new CategoricalData[numcat];
        int poscat = 0;
        for (int x = 0; x < excol.length; ++x) {
            if (excol[x] || types[x] != 2) continue;
            categoricalData[poscat] = new CategoricalData(((HashMap)catvals.get(poscat)).size());
            categoricalData[poscat].setCategoryName(file.getColumnName(x));
            for (Map.Entry entry : ((HashMap)catvals.get(poscat)).entrySet()) {
                categoricalData[poscat].setOptionName((String)entry.getKey(), ((Integer)entry.getValue()).intValue());
            }
            ++poscat;
        }
        ArrayList<DataPoint> list = new ArrayList<DataPoint>(file.Height() - file.nbExcluded());
        for (int y = 0; y < file.Height(); ++y) {
            if (exc[y]) continue;
            DenseVector dvec = new DenseVector(numreal);
            int[] cats = new int[numcat];
            int posreal = 0;
            int poscat2 = 0;
            block15: for (int x = 0; x < file.Width(); ++x) {
                if (excol[x]) continue;
                switch (file.ColumnType(x)) {
                    case 1: {
                        dvec.set(posreal++, file.getValueDouble(y, x));
                        continue block15;
                    }
                    case 0: {
                        dvec.set(posreal++, (double)file.getValueInt(y, x));
                        continue block15;
                    }
                    case 2: {
                        cats[poscat2] = (Integer)((HashMap)catvals.get(poscat2)).get(file.getValueString(y, x));
                        ++poscat2;
                        continue block15;
                    }
                    default: {
                        throw new IllegalArgumentException("Default: column " + x + ", type not supported (" + file.ColumnType(x) + ")");
                    }
                }
            }
            list.add(new DataPoint((Vec)dvec, cats, categoricalData, file.Weight(y)));
        }
        SimpleDataSet dataset = new SimpleDataSet(list);
        int pos2 = 0;
        int posreal = 0;
        for (int x = 0; x < excol.length; ++x) {
            if (excol[x] || !isreal[pos2++]) continue;
            dataset.setNumericName(file.getColumnName(x), posreal++);
        }
        LastConvertedFile = file;
        LastSimpleDataSet = dataset;
        return dataset;
    }

    public static int FindFutureTarget(FichierTabule file) {
        int target = file.Target();
        if (target < 0) {
            throw new IllegalArgumentException("The file does not contain a target (nominal column containing labels).");
        }
        int nb = 0;
        for (int x = 0; x < target; ++x) {
            if (!file.isExcludedColumn(x)) continue;
            ++nb;
        }
        return target - nb;
    }

    public static ClassificationDataSet FichierTabuleToJsatClassificationDataSet(FichierTabule file) {
        LastSimpleDataSet = FichierTabuleConverter.FichierTabuleToJsatDataSet(file);
        LastClassificationDataSet = new ClassificationDataSet((DataSet)LastSimpleDataSet, 0);
        return LastClassificationDataSet;
    }

    public static RegressionDataSet FichierTabuleToJsatRegressionDataSet(FichierTabule file) {
        int target = 0;
        boolean[] excol = file.getExcludedColumn();
        int[] types = file.ColumnType();
        int numcol = 0;
        block7: for (int x = 0; x < excol.length; ++x) {
            if (excol[x]) continue;
            switch (types[x]) {
                case 0: 
                case 1: {
                    if (file.Target() == x) {
                        target = numcol;
                    }
                    ++numcol;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Default: column " + x + ", type not supported (" + file.ColumnType(x) + ")");
                }
            }
        }
        ArrayList<DataPoint> datapoints = new ArrayList<DataPoint>(file.getHeight() - file.nbExcluded());
        for (int y = 0; y < file.Height(); ++y) {
            if (file.isExcluded(y)) continue;
            double[] array = new double[numcol];
            int nb = 0;
            block9: for (int x = 0; x < excol.length; ++x) {
                if (excol[x]) continue;
                switch (types[x]) {
                    case 1: {
                        array[nb++] = file.getValueDouble(y, x);
                        continue block9;
                    }
                    case 0: {
                        array[nb++] = file.getValueInt(y, x);
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException("Must not occur!");
                    }
                }
            }
            datapoints.add(new DataPoint((Vec)new DenseVector(array)));
        }
        return new RegressionDataSet(datapoints, target);
    }

    public static void WriteArffFile(FichierTabule file, String name) {
        InstancesTools.WriteArffFile(FichierTabuleConverter.FichierTabuleToWekaInstances(file, name));
    }

    public static float[][] FichierTabuleToNeuralNetworkDataSet(FichierTabule file) {
        int target = file.Target();
        int[] colok = new int[file.Width()];
        int[] coltype = file.ColumnType();
        ArrayFeatures AF = new ArrayFeatures();
        for (int x = 0; x < file.Width(); ++x) {
            colok[x] = !file.isExcludedColumn(x) && x != target && !file.isNominal(x) && (file.ColumnType(x) == 1 || file.ColumnType(x) == 0) ? 1 : 0;
        }
        float[][] instances = new float[file.Height() - file.nbExcluded()][(int)AF.Integral(colok)];
        int posinst = 0;
        for (int y = 0; y < file.Height(); ++y) {
            if (file.isExcluded(y)) continue;
            float[] row = instances[posinst++];
            int poscol = 0;
            for (int x = 0; x < file.Width(); ++x) {
                if (colok[x] != 1) continue;
                row[poscol++] = (float)(coltype[x] == 0 ? (double)file.getValueInt(y, x) : file.getValueDouble(y, x));
            }
            row = null;
        }
        coltype = null;
        colok = null;
        return instances;
    }

    public static float[][] FichierTabuleToNeuralNetworkTarget(FichierTabule file) {
        int target = file.Target();
        if (target < 0) {
            throw new IllegalArgumentException("Any target defined.");
        }
        float[][] instances = null;
        if (!file.isNominal(target)) {
            instances = new float[file.Height() - file.nbExcluded()][1];
            switch (file.ColumnType(target)) {
                case 1: {
                    double[] cold = file.getColumnDouble(target);
                    int pos = 0;
                    for (int y = 0; y < file.Height(); ++y) {
                        if (file.isExcluded(y)) continue;
                        instances[pos++][0] = (float)cold[y];
                    }
                    cold = null;
                    break;
                }
                case 0: {
                    int[] coli = file.getColumnInt(target);
                    int pos = 0;
                    for (int y = 0; y < file.Height(); ++y) {
                        if (file.isExcluded(y)) continue;
                        instances[pos++][0] = coli[y];
                    }
                    coli = null;
                    break;
                }
                default: {
                    throw new Error("Must not occur.");
                }
            }
            return instances;
        }
        switch (file.ColumnType(target)) {
            case 2: {
                int y;
                HashMap<String, Integer> hms = new HashMap<String, Integer>(13);
                String[] cols = file.getColumnString(target);
                int nb = 0;
                for (y = 0; y < file.Height(); ++y) {
                    if (file.isExcluded(y) || hms.containsKey(cols[y])) continue;
                    hms.put(cols[y], nb++);
                }
                instances = new float[file.Height() - file.nbExcluded()][hms.size()];
                int pos = 0;
                for (y = 0; y < file.Height(); ++y) {
                    if (file.isExcluded(y)) continue;
                    instances[pos++][((Integer)hms.get((Object)cols[y])).intValue()] = 1.0f;
                }
                break;
            }
            case 0: {
                int y;
                HashMap<Integer, Integer> hmi = new HashMap<Integer, Integer>(13);
                int[] coli = file.getColumnInt(target);
                int nb = 0;
                for (y = 0; y < file.Height(); ++y) {
                    if (file.isExcluded(y) || hmi.containsKey(coli[y])) continue;
                    hmi.put(coli[y], nb++);
                }
                instances = new float[file.Height() - file.nbExcluded()][hmi.size()];
                int pos = 0;
                for (y = 0; y < file.Height(); ++y) {
                    if (file.isExcluded(y)) continue;
                    instances[pos++][((Integer)hmi.get((Object)Integer.valueOf((int)coli[y]))).intValue()] = 1.0f;
                }
                break;
            }
            default: {
                throw new Error("Must not occur.");
            }
        }
        return instances;
    }

    public static String[] FichierTabuleToNeuralNetworkClassesNames(FichierTabule file) {
        String[] array;
        int target = file.Target();
        if (target < 0) {
            throw new IllegalArgumentException("Any target defined.");
        }
        if (!file.isNominal(target)) {
            throw new IllegalArgumentException("The target is not nominal.");
        }
        switch (file.ColumnType(target)) {
            case 2: {
                String[] cols = file.getColumnString(target);
                ArrayList<String> classes = new ArrayList<String>(7);
                for (int y = 0; y < file.Height(); ++y) {
                    if (file.isExcluded(y) || ListTools.isInList(classes, (String)cols[y])) continue;
                    classes.add(cols[y]);
                }
                array = new String[classes.size()];
                for (int i2 = 0; i2 < array.length; ++i2) {
                    array[i2] = (String)classes.get(i2);
                }
                cols = null;
                break;
            }
            case 0: {
                int[] coli = file.getColumnInt(target);
                ArrayList<Integer> classi = new ArrayList<Integer>(7);
                for (int y = 0; y < file.Height(); ++y) {
                    if (file.isExcluded(y) || ListTools.isInList(classi, (int)coli[y])) continue;
                    classi.add(coli[y]);
                }
                array = new String[classi.size()];
                for (int i3 = 0; i3 < array.length; ++i3) {
                    array[i3] = String.valueOf(classi.get(i3));
                }
                coli = null;
                break;
            }
            default: {
                throw new Error("Must not occur.");
            }
        }
        return array;
    }

    public static float[] FichierTabuleToNeuralNetworkWeights(FichierTabule file) {
        float[] weights = new float[file.Height() - file.nbExcluded()];
        double[] ws = file.Weights();
        int pos = 0;
        for (int y = 0; y < file.Height(); ++y) {
            if (file.isExcluded(y)) continue;
            weights[pos++] = (float)ws[y];
        }
        ws = null;
        return weights;
    }

    public static FichierTabule InstancesToFichierTabule(Instances instances) {
        int[] types = new int[instances.numAttributes()];
        block8: for (int att = 0; att < types.length; ++att) {
            switch (instances.attribute(att).type()) {
                case 0: {
                    types[att] = 1;
                    continue block8;
                }
                case 1: 
                case 2: {
                    types[att] = 2;
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Attribute type not supported (yet): " + instances.attribute(att).type());
                }
            }
        }
        FichierTabule file = new FichierTabule(instances.numInstances(), types, "");
        for (int att = 0; att < types.length; ++att) {
            file.setColumnName(att, instances.attribute(att).name());
            if (!instances.attribute(att).isNominal()) continue;
            file.setNominal(att, true);
        }
        for (int i2 = 0; i2 < file.Height(); ++i2) {
            Instance inst = instances.get(i2);
            block11: for (int att = 0; att < file.Width(); ++att) {
                switch (file.ColumnType(att)) {
                    case 1: {
                        file.setValue(i2, att, inst.value(att));
                        continue block11;
                    }
                    case 2: {
                        file.setValue(i2, att, inst.stringValue(att));
                        continue block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Column type not supported. Must not occur!");
                    }
                }
            }
            file.Weight(inst.weight());
            inst = null;
        }
        return file;
    }
}

