/*
 * Decompiled with CFR 0.152.
 */
package filesAndFolders.fichiersTabules;

import filesAndFolders.FichiersDossiersIHM;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import utils.times.Dates;

public class FichierTabule {
    public static final int INTEGER = 0;
    public static final int DOUBLE = 1;
    public static final int STRING = 2;
    public static final int UNKNOWN = -1;
    public static final int Equal = 0;
    public static final int Superior = 1;
    public static final int Inferior = 2;
    public static final int SupOrEqual = 3;
    public static final int InfOrEqual = 4;
    public static final int Different = 5;
    public static final int Contains = 6;
    private String Name = null;
    private String[] NomColonnes = null;
    private Object[] Tableau = null;
    private int[] TypeColonnes = null;
    private int Width = -1;
    private int Height = -1;
    private boolean[] Excluded = null;
    private boolean[] ExcludedColumn = null;
    private boolean[] Nominal = null;
    private boolean[] Selected = null;
    private boolean[] SelectedColumn = null;
    private double[] Weights = null;
    private int nbLineComment = 0;
    private String Separator = " ";
    private int currentselected = -1;
    private int Target = -1;
    private boolean writeweights = false;
    public static boolean DisplayDate = true;

    public FichierTabule(int nbInstances, int[] TypeColums, String Name2) {
        if (nbInstances <= 0) {
            throw new IllegalArgumentException("Invalid number of instances: " + nbInstances + ", [1..N[ waited.");
        }
        if (TypeColums == null || TypeColums.length == 0) {
            throw new IllegalArgumentException("TypeColums == null or TypeColums.length == 0");
        }
        this.Width = TypeColums.length;
        this.Height = nbInstances;
        this.Name = Name2.substring(0);
        this.NomColonnes = new String[this.Width];
        this.Tableau = new Object[this.Width];
        this.TypeColonnes = new int[this.Width];
        this.Excluded = new boolean[this.Height];
        this.ExcludedColumn = new boolean[this.Width];
        this.Selected = new boolean[this.Height];
        this.SelectedColumn = new boolean[this.Width];
        this.Nominal = new boolean[this.Width];
        this.Weights = new double[this.Height];
        for (int i2 = 0; i2 < this.Width; ++i2) {
            switch (TypeColums[i2]) {
                case 0: {
                    this.Tableau[i2] = new int[this.Height];
                    break;
                }
                case 1: {
                    this.Tableau[i2] = new double[this.Height];
                    break;
                }
                case 2: {
                    this.Tableau[i2] = new String[this.Height];
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown column type: " + this.TypeColonnes[i2]);
                }
            }
            this.TypeColonnes[i2] = TypeColums[i2];
            this.NomColonnes[i2] = "Column " + i2;
            this.ExcludedColumn[i2] = false;
            this.SelectedColumn[i2] = false;
            this.Nominal[i2] = false;
        }
        Arrays.fill(this.Weights, 1.0);
        Arrays.fill(this.Excluded, false);
        Arrays.fill(this.Selected, false);
    }

    public FichierTabule(String PathFile, boolean IncludedColumnNames, String Separator2) throws Exception {
        int i2;
        File Fichier = null;
        Scanner Entree = null;
        this.Separator = Separator2;
        Fichier = PathFile == null ? FichiersDossiersIHM.ChoisirFichier(new File("").getAbsolutePath(), true) : new File(PathFile);
        Entree = new Scanner(new FileInputStream(Fichier));
        String date = DisplayDate ? Dates.DateAAAAMMJJ("/") + " " + Dates.Time(":") + " - " : "";
        System.out.print(date + "Loading file '" + Fichier.getAbsolutePath() + "'... ");
        this.nbLineComment = this.FindNbLineComment(Entree);
        Entree.close();
        int index = Fichier.getName().lastIndexOf(46);
        if (index == -1) {
            index = Fichier.getName().length();
        }
        this.Name = Fichier.getName().substring(0, index);
        Entree = new Scanner(new FileInputStream(Fichier));
        for (i2 = 0; i2 < this.nbLineComment; ++i2) {
            Entree.nextLine();
        }
        if (IncludedColumnNames) {
            switch (Separator2) {
                case " ": {
                    this.NomColonnes = this.SearchColumnsNames(Entree.nextLine());
                    break;
                }
                case ",": {
                    this.NomColonnes = this.SearchColumnsNamesCSV(Entree.nextLine());
                    break;
                }
                default: {
                    throw new Exception("Unsupported separator.");
                }
            }
        } else {
            this.FindWidth(Entree.nextLine());
            this.NomColonnes = new String[this.Width];
            for (i2 = 0; i2 < this.Width; ++i2) {
                this.NomColonnes[i2] = "Column " + i2;
            }
            Entree.close();
            Entree = new Scanner(new FileInputStream(Fichier));
            for (i2 = 0; i2 < this.nbLineComment; ++i2) {
                Entree.nextLine();
            }
        }
        switch (Separator2) {
            case " ": {
                this.SearchColumnsTypes(Entree);
                break;
            }
            case ",": {
                this.SearchColumnsTypesCSV(Entree);
                break;
            }
            default: {
                throw new Exception("Unsupported separator.");
            }
        }
        this.Excluded = new boolean[this.Height];
        this.Selected = new boolean[this.Height];
        this.Weights = new double[this.Height];
        Arrays.fill(this.Excluded, false);
        Arrays.fill(this.Selected, false);
        Arrays.fill(this.Weights, 1.0);
        this.Nominal = new boolean[this.Width];
        this.ExcludedColumn = new boolean[this.Width];
        this.SelectedColumn = new boolean[this.Width];
        Arrays.fill(this.ExcludedColumn, false);
        Arrays.fill(this.Nominal, false);
        Arrays.fill(this.SelectedColumn, false);
        System.out.print("(" + this.Width + " columns" + (this.writeweights ? " + weights, " : ", ") + this.Height + " rows)... ");
        System.out.flush();
        Entree.close();
        Entree = new Scanner(new FileInputStream(Fichier));
        switch (Separator2) {
            case " ": {
                this.ReadFile(Entree, IncludedColumnNames);
                break;
            }
            case ",": {
                this.ReadFileCSV(Entree, IncludedColumnNames);
                break;
            }
            default: {
                throw new Exception("Unsupported separator.");
            }
        }
        Entree.close();
        System.out.println("successfully.");
    }

    public FichierTabule(String PathFile, boolean IncludedColumnNames) throws Exception {
        this(PathFile, IncludedColumnNames, " ");
    }

    public void PermuteColumns(int column1, int column2) {
        Object tempobj = null;
        String tempname = null;
        tempobj = this.Tableau[column1];
        this.Tableau[column1] = this.Tableau[column2];
        this.Tableau[column2] = tempobj;
        int temp = this.TypeColonnes[column1];
        this.TypeColonnes[column1] = this.TypeColonnes[column2];
        this.TypeColonnes[column2] = temp;
        tempname = this.NomColonnes[column1].substring(0);
        this.NomColonnes[column1] = this.NomColonnes[column2].substring(0);
        this.NomColonnes[column2] = tempname.substring(0);
        boolean tempbool = this.ExcludedColumn[column1];
        this.ExcludedColumn[column1] = this.ExcludedColumn[column2];
        this.ExcludedColumn[column2] = tempbool;
        tempbool = this.SelectedColumn[column1];
        this.SelectedColumn[column1] = this.SelectedColumn[column2];
        this.SelectedColumn[column2] = tempbool;
        tempbool = this.Nominal[column1];
        this.Nominal[column1] = this.Nominal[column2];
        this.Nominal[column2] = tempbool;
    }

    public void Permute(int row1, int row2) {
        double tempdouble;
        block6: for (int x = 0; x < this.Width; ++x) {
            switch (this.TypeColonnes[x]) {
                case 0: {
                    int tempint = ((int[])this.Tableau[x])[row1];
                    ((int[])this.Tableau[x])[row1] = ((int[])this.Tableau[x])[row2];
                    ((int[])this.Tableau[x])[row2] = tempint;
                    continue block6;
                }
                case 1: {
                    tempdouble = ((double[])this.Tableau[x])[row1];
                    ((double[])this.Tableau[x])[row1] = ((double[])this.Tableau[x])[row2];
                    ((double[])this.Tableau[x])[row2] = tempdouble;
                    continue block6;
                }
                case 2: {
                    String tempstr = ((String[])this.Tableau[x])[row1];
                    ((String[])this.Tableau[x])[row1] = ((String[])this.Tableau[x])[row2];
                    ((String[])this.Tableau[x])[row2] = tempstr;
                    continue block6;
                }
                case -1: {
                    continue block6;
                }
                default: {
                    throw new Error("Default: must not occured.");
                }
            }
        }
        boolean tempbool = this.Selected[row1];
        this.Selected[row1] = this.Selected[row2];
        this.Selected[row2] = tempbool;
        tempbool = this.Excluded[row1];
        this.Excluded[row1] = this.Excluded[row2];
        this.Excluded[row2] = tempbool;
        tempdouble = this.Weights[row1];
        this.Weights[row1] = this.Weights[row2];
        this.Weights[row2] = tempdouble;
    }

    public void SelectWhere(String Colonne, int Operation, int Value) {
        this.SelectWhere(this.ColumnNumber(Colonne), Operation, Value);
    }

    public void SelectWhere(int Colonne, int Operation, int Value) {
        int[] column = this.getColumnInt(Colonne);
        switch (Operation) {
            case 0: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y] == Value;
                }
                break;
            }
            case 5: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y] != Value;
                }
                break;
            }
            case 1: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y] > Value;
                }
                break;
            }
            case 2: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y] < Value;
                }
                break;
            }
            case 3: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y] >= Value;
                }
                break;
            }
            case 4: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y] <= Value;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow operation : " + Operation);
            }
        }
    }

    public void SelectWhere(String Colonne, int Operation, double Value) {
        this.SelectWhere(this.ColumnNumber(Colonne), Operation, Value);
    }

    public void SelectWhere(int Column, int Operation, double Value) {
        double[] column = this.getColumnDouble(Column);
        if (Double.isNaN(Value)) {
            switch (Operation) {
                case 0: {
                    for (int y = 0; y < this.Height; ++y) {
                        this.Selected[y] = Double.isNaN(column[y]);
                    }
                    return;
                }
                case 5: {
                    for (int y = 0; y < this.Height; ++y) {
                        this.Selected[y] = Double.isNaN(column[y]);
                    }
                    return;
                }
            }
            throw new IllegalArgumentException("Default: Unknow operation for NaN value: " + Operation);
        }
        switch (Operation) {
            case 0: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y] == Value;
                }
                break;
            }
            case 5: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y] != Value;
                }
                break;
            }
            case 1: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y] > Value;
                }
                break;
            }
            case 2: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y] < Value;
                }
                break;
            }
            case 3: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y] >= Value;
                }
                break;
            }
            case 4: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y] <= Value;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: Unknow operation: " + Operation);
            }
        }
    }

    public void SelectWhere(String Column, int Operation, String Value) {
        this.SelectWhere(this.ColumnNumber(Column), Operation, Value);
    }

    public void SelectWhere(int Column, int Operation, String Value) {
        String[] column = this.getColumnString(Column);
        switch (Operation) {
            case 6: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y].contains(Value);
                }
                break;
            }
            case 0: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y].compareTo(Value) == 0;
                }
                break;
            }
            case 5: {
                for (int y = 0; y < this.Height; ++y) {
                    this.Selected[y] = column[y].compareTo(Value) != 0;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow operation : " + Operation);
            }
        }
    }

    public void SelectFromSelectionWhere(String Column, int Operation, int Value) {
        this.SelectFromSelectionWhere(this.ColumnNumber(Column), Operation, Value);
    }

    public void SelectFromSelectionWhere(int Column, int Operation, int Value) {
        int[] column = this.getColumnInt(Column);
        switch (Operation) {
            case 0: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y] == Value) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            case 5: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y] != Value) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            case 1: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y] > Value) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            case 2: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y] < Value) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            case 3: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y] >= Value) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            case 4: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y] <= Value) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow operation : " + Operation);
            }
        }
    }

    public void SelectFromSelectionWhere(String Column, int Operation, double Value) {
        this.SelectFromSelectionWhere(this.ColumnNumber(Column), Operation, Value);
    }

    public void SelectFromSelectionWhere(int Column, int Operation, double Value) {
        double[] column = this.getColumnDouble(Column);
        if (Double.isNaN(Value)) {
            switch (Operation) {
                case 0: {
                    for (int y = 0; y < this.Height; ++y) {
                        if (!this.Selected[y] || Double.isNaN(column[y])) continue;
                        this.Selected[y] = false;
                    }
                    return;
                }
                case 5: {
                    for (int y = 0; y < this.Height; ++y) {
                        if (!this.Selected[y] || !Double.isNaN(column[y])) continue;
                        this.Selected[y] = false;
                    }
                    return;
                }
            }
            throw new IllegalArgumentException("Unknow operation for NaN value: " + Operation);
        }
        switch (Operation) {
            case 0: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y] == Value) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            case 5: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y] != Value) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            case 1: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y] > Value) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            case 2: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y] < Value) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            case 3: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y] >= Value) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            case 4: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y] <= Value) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow operation: " + Operation);
            }
        }
    }

    public void SelectFromSelectionWhere(String Column, int Operation, String Value) {
        this.SelectFromSelectionWhere(this.ColumnNumber(Column), Operation, Value);
    }

    public void SelectFromSelectionWhere(int Column, int Operation, String Value) {
        String[] column = this.getColumnString(Column);
        switch (Operation) {
            case 6: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y].contains(Value)) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            case 0: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y].compareTo(Value) == 0) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            case 5: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!this.Selected[y] || column[y].compareTo(Value) != 0) continue;
                    this.Selected[y] = false;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow operation : " + Operation);
            }
        }
    }

    public void ExtendSelectionWhere(String Column, int Operation, int Value) {
        this.ExtendSelectionWhere(this.ColumnNumber(Column), Operation, Value);
    }

    public void ExtendSelectionWhere(int Column, int Operation, int Value) {
        int[] column = this.getColumnInt(Column);
        switch (Operation) {
            case 0: {
                for (int y = 0; y < this.Height; ++y) {
                    if (column[y] != Value) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            case 5: {
                for (int y = 0; y < this.Height; ++y) {
                    if (column[y] == Value) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            case 1: {
                for (int y = 0; y < this.Height; ++y) {
                    if (column[y] <= Value) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            case 2: {
                for (int y = 0; y < this.Height; ++y) {
                    if (column[y] >= Value) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            case 3: {
                for (int y = 0; y < this.Height; ++y) {
                    if (column[y] < Value) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            case 4: {
                for (int y = 0; y < this.Height; ++y) {
                    if (column[y] > Value) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow operation : " + Operation);
            }
        }
    }

    public void ExtendSelectionWhere(String Column, int Operation, double Value) {
        this.ExtendSelectionWhere(this.ColumnNumber(Column), Operation, Value);
    }

    public void ExtendSelectionWhere(int Column, int Operation, double Value) {
        double[] column = this.getColumnDouble(Column);
        if (Double.isNaN(Value)) {
            switch (Operation) {
                case 0: {
                    for (int y = 0; y < this.Height; ++y) {
                        if (!Double.isNaN(column[y])) continue;
                        this.Selected[y] = true;
                    }
                    return;
                }
                case 5: {
                    for (int y = 0; y < this.Height; ++y) {
                        if (Double.isNaN(column[y])) continue;
                        this.Selected[y] = true;
                    }
                    return;
                }
            }
            throw new IllegalArgumentException("Unknow operation for NaN value: " + Operation);
        }
        switch (Operation) {
            case 0: {
                for (int y = 0; y < this.Height; ++y) {
                    if (column[y] != Value) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            case 5: {
                for (int y = 0; y < this.Height; ++y) {
                    if (column[y] == Value) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            case 1: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!(column[y] > Value)) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            case 2: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!(column[y] < Value)) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            case 3: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!(column[y] >= Value)) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            case 4: {
                for (int y = 0; y < this.Height; ++y) {
                    if (!(column[y] <= Value)) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow operation: " + Operation);
            }
        }
    }

    public void ExtendSelectionWhere(String Column, int Operation, String Value) {
        this.ExtendSelectionWhere(this.ColumnNumber(Column), Operation, Value);
    }

    public void ExtendSelectionWhere(int Column, int Operation, String Value) {
        String[] column = this.getColumnString(Column);
        switch (Operation) {
            case 0: {
                for (int y = 0; y < this.Height; ++y) {
                    if (column[y].compareTo(Value) != 0) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            case 5: {
                for (int y = 0; y < this.Height; ++y) {
                    if (column[y].compareTo(Value) == 0) continue;
                    this.Selected[y] = true;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow operation : " + Operation);
            }
        }
    }

    public int ColumnNumber(String Column) {
        int num = -1;
        for (int x = 0; x < this.Width; ++x) {
            if (Column.compareTo(this.NomColonnes[x]) != 0) continue;
            if (num == -1) {
                num = x;
                continue;
            }
            throw new IllegalArgumentException("Two columns have the name \"" + Column + "\". Operation impossible.");
        }
        if (num == -1) {
            throw new IllegalArgumentException("Column not found: '" + Column + "'");
        }
        return num;
    }

    public void SelectExcluded() {
        System.arraycopy(this.Excluded, 0, this.Selected, 0, this.Excluded.length);
    }

    public int nbExcluded() {
        return this.nbExcluded(0, this.Height);
    }

    public int nbExcluded(int start, int end) {
        int nb = 0;
        for (int y = start; y < end; ++y) {
            if (!this.Excluded[y]) continue;
            ++nb;
        }
        return nb;
    }

    public int nbExcludedColumn() {
        int nb = 0;
        for (int x = 0; x < this.Width; ++x) {
            if (!this.ExcludedColumn[x]) continue;
            ++nb;
        }
        return nb;
    }

    public int nbSelected() {
        int nb = 0;
        for (int y = 0; y < this.Height; ++y) {
            if (!this.Selected[y]) continue;
            ++nb;
        }
        return nb;
    }

    public int nbSelectedColumn() {
        int nb = 0;
        for (int x = 0; x < this.Width; ++x) {
            if (!this.SelectedColumn[x]) continue;
            ++nb;
        }
        return nb;
    }

    public void SelectAll() {
        this.SelectAllColumns();
        this.SelectAllRows();
    }

    public void SelectAllColumns() {
        Arrays.fill(this.SelectedColumn, true);
    }

    public void SelectAllRows() {
        Arrays.fill(this.Selected, true);
    }

    public void ClearSelection() {
        this.ClearSelectionColumns();
        this.ClearSelectionRows();
    }

    public void ClearSelectionRows() {
        Arrays.fill(this.Selected, false);
        this.currentselected = -1;
    }

    public void ClearSelectionColumns() {
        Arrays.fill(this.SelectedColumn, false);
    }

    public void ClearExclusion() {
        this.ClearExcludedColumns();
        this.ClearExcludedRows();
    }

    public void ClearExcludedColumns() {
        Arrays.fill(this.ExcludedColumn, false);
    }

    public void ClearExcludedRows() {
        Arrays.fill(this.Excluded, false);
    }

    public void ClearAll() {
        this.ClearSelection();
        this.ClearExclusion();
    }

    public void InverseSelectionRows() {
        for (int y = 0; y < this.Height; ++y) {
            this.Selected[y] = !this.Selected[y];
        }
    }

    public void InverseSelectionColumns() {
        for (int y = 0; y < this.Width; ++y) {
            this.SelectedColumn[y] = !this.SelectedColumn[y];
        }
    }

    public void InverseSelection() {
        this.InverseSelectionColumns();
        this.InverseSelectionRows();
    }

    public void InverseExclusionRows() {
        for (int y = 0; y < this.Height; ++y) {
            this.Excluded[y] = !this.Excluded[y];
        }
    }

    public void InverseExclusionColumns() {
        for (int y = 0; y < this.Width; ++y) {
            this.ExcludedColumn[y] = !this.ExcludedColumn[y];
        }
    }

    public void InverseExclusion() {
        this.InverseExclusionColumns();
        this.InverseExclusionRows();
    }

    public void ExcludeSelectedRows() {
        for (int y = 0; y < this.Height; ++y) {
            if (!this.Selected[y]) continue;
            this.Excluded[y] = true;
        }
    }

    public void ExcludeSelectedColumns() {
        for (int y = 0; y < this.Width; ++y) {
            if (!this.SelectedColumn[y]) continue;
            this.ExcludedColumn[y] = true;
        }
    }

    public void ExcludeSelected() {
        this.ExcludeSelectedColumns();
        this.ExcludeSelectedRows();
    }

    public void SelectRandomly(double ratio) {
        if (ratio <= 0.0 || 1.0 <= ratio) {
            throw new IllegalArgumentException("Bad value of ratio, ]0,1[ wished.");
        }
        this.SelectRandomly((int)(ratio * (double)this.Height));
    }

    public void SelectRandomly(int number) {
        int i2;
        if (number < 0 || this.Height < number) {
            throw new IllegalArgumentException("Bad value of number, ]0,Height] wished.");
        }
        for (i2 = 0; i2 < number; ++i2) {
            this.Selected[i2] = true;
        }
        while (i2 < this.Height) {
            this.Selected[i2] = false;
            ++i2;
        }
        for (i2 = 0; i2 < number; ++i2) {
            int x = (int)(Math.random() * (double)this.Height);
            boolean temp = this.Selected[x];
            this.Selected[x] = this.Selected[i2];
            this.Selected[i2] = temp;
        }
    }

    public void SelectRandomlyFromSelection(double ratio) {
        if (ratio <= 0.0 || 1.0 <= ratio) {
            throw new IllegalArgumentException("Bad value of ratio, ]0,1[ wished.");
        }
        this.SelectRandomly((int)(ratio * (double)this.nbSelected() + 0.5));
    }

    public void SelectRandomlyFromSelection(int number) {
        if (number > this.nbSelected()) {
            throw new IllegalArgumentException("Number greater than the number of selected instances.");
        }
        this.ClearExclusion();
        this.ExcludeSelected();
        this.ClearSelection();
        int x = 0;
        int i2 = 0;
        while (x < number) {
            if (this.Excluded[i2]) {
                this.Selected[i2] = true;
                ++x;
            }
            ++i2;
        }
        int p = 0;
        i2 = 0;
        while (i2 < number) {
            while (!this.Excluded[p]) {
                ++p;
            }
            while (!this.Excluded[x = (int)(Math.random() * (double)this.Height)]) {
            }
            boolean temp = this.Selected[x];
            this.Selected[x] = this.Selected[p];
            this.Selected[p] = temp;
            ++i2;
            ++p;
        }
        this.ClearExclusion();
    }

    public void SelectNanInfinity() {
        this.ClearSelection();
        this.ClearExclusion();
        for (int c = 0; c < this.Width; ++c) {
            if (this.TypeColonnes[c] != 1) continue;
            double[] column = (double[])this.Tableau[c];
            for (int y = 0; y < this.Height; ++y) {
                if (!Double.isInfinite(column[y]) && !Double.isNaN(column[y])) continue;
                this.Selected[y] = true;
            }
        }
    }

    public void SelectInfinity() {
        this.ClearSelection();
        this.ClearExclusion();
        for (int c = 0; c < this.Width; ++c) {
            if (this.TypeColonnes[c] != 1) continue;
            double[] column = (double[])this.Tableau[c];
            for (int y = 0; y < this.Height; ++y) {
                if (!Double.isInfinite(column[y])) continue;
                this.Selected[y] = true;
            }
        }
    }

    public void SelectNaN() {
        this.ClearSelection();
        this.ClearExclusion();
        for (int c = 0; c < this.Width; ++c) {
            if (this.TypeColonnes[c] != 1) continue;
            double[] column = (double[])this.Tableau[c];
            for (int y = 0; y < this.Height; ++y) {
                if (!Double.isNaN(column[y])) continue;
                this.Selected[y] = true;
            }
        }
    }

    public void SelectNull(String column) {
        this.SelectNull(this.ColumnNumber(column));
    }

    public void SelectNull(int column) {
        if (this.TypeColonnes[column] != 2) {
            throw new IllegalArgumentException("Given column is not of type STRING.");
        }
        String[] array = (String[])this.Tableau[column];
        for (int i2 = 0; i2 < this.Height; ++i2) {
            this.Selected[i2] = array[i2] == null;
        }
        array = null;
    }

    public void SelectNull() {
        this.ClearSelection();
        for (int x = 0; x < this.Width; ++x) {
            if (this.TypeColonnes[x] != 2) continue;
            String[] array = (String[])this.Tableau[x];
            for (int i2 = 0; i2 < this.Height; ++i2) {
                if (array[i2] != null) continue;
                this.Selected[i2] = true;
            }
            Object var2_2 = null;
        }
    }

    public int FirstSelected() {
        for (int i2 = 0; i2 < this.Height; ++i2) {
            if (!this.Selected[i2]) continue;
            this.currentselected = i2;
            return i2;
        }
        return -1;
    }

    public int LastSelected() {
        for (int i2 = this.Height - 1; i2 >= 0; --i2) {
            if (!this.Selected[i2]) continue;
            this.currentselected = i2;
            return i2;
        }
        return -1;
    }

    public int NextSelected() {
        for (int i2 = this.currentselected + 1; i2 < this.Height; ++i2) {
            if (!this.Selected[i2]) continue;
            this.currentselected = i2;
            return i2;
        }
        this.currentselected = -1;
        return -1;
    }

    public int PreviousSelected() {
        for (int i2 = this.currentselected - 1; i2 >= 0; --i2) {
            if (!this.Selected[i2]) continue;
            this.currentselected = i2;
            return i2;
        }
        return -1;
    }

    private int FindNbLineComment(Scanner in) {
        int nb = 0;
        while (in.hasNext()) {
            if (in.nextLine().charAt(0) == '#') {
                ++nb;
                continue;
            }
            return nb;
        }
        return nb;
    }

    private void FindWidth(String Ligne) {
        boolean fusion = false;
        boolean newcol = true;
        int nbColonnes = 0;
        block4: for (int i2 = 0; i2 < Ligne.length(); ++i2) {
            switch (Ligne.charAt(i2)) {
                case '\t': 
                case ' ': 
                case ',': {
                    if (fusion) continue block4;
                    newcol = true;
                    continue block4;
                }
                case '\"': {
                    fusion = !fusion;
                    continue block4;
                }
                default: {
                    if (!newcol) continue block4;
                    ++nbColonnes;
                    newcol = false;
                }
            }
        }
        if (Ligne.contains("{") && Ligne.contains("}")) {
            --nbColonnes;
            this.writeweights = true;
        } else {
            this.writeweights = false;
        }
        this.Width = nbColonnes;
    }

    private String[] SearchColumnsNames(String Ligne) {
        int i2;
        Object nom = null;
        String[] resultat = null;
        ArrayList<String> noms = new ArrayList<String>(23);
        boolean fusion = false;
        nom = "";
        block4: for (i2 = 0; i2 < Ligne.length(); ++i2) {
            switch (Ligne.charAt(i2)) {
                case '\t': 
                case ' ': 
                case ',': {
                    if (fusion) {
                        nom = (String)nom + Ligne.charAt(i2);
                        continue block4;
                    }
                    if (((String)nom).isEmpty()) continue block4;
                    noms.add(((String)nom).substring(0));
                    nom = "";
                    continue block4;
                }
                case '\"': {
                    if (!((String)nom).isEmpty()) {
                        noms.add(((String)nom).substring(0));
                        nom = "";
                        fusion = false;
                        continue block4;
                    }
                    fusion = true;
                    continue block4;
                }
                default: {
                    nom = (String)nom + Ligne.charAt(i2);
                    if (i2 != Ligne.length() - 1) continue block4;
                    noms.add(((String)nom).substring(0));
                    nom = "";
                }
            }
        }
        if (((String)noms.get(noms.size() - 1)).equalsIgnoreCase("{Weights}")) {
            noms.remove(noms.size() - 1);
            this.writeweights = true;
        } else {
            this.writeweights = false;
        }
        this.Width = noms.size();
        resultat = new String[this.Width];
        for (i2 = 0; i2 < this.Width; ++i2) {
            resultat[i2] = (String)noms.get(i2);
        }
        return resultat;
    }

    private String[] SearchColumnsNamesCSV(String Line) {
        String[] split = Line.split(",");
        for (int i2 = 0; i2 < split.length; ++i2) {
            if (split[i2].charAt(0) != '\"' || split[i2].charAt(split[i2].length() - 1) != '\"') continue;
            split[i2] = split[i2].substring(1, split[i2].length() - 1);
        }
        if (split[split.length - 1].equalsIgnoreCase("{Weights}")) {
            this.writeweights = true;
            this.Width = split.length - 1;
            return Arrays.copyOfRange(split, 0, split.length - 1);
        }
        this.writeweights = false;
        this.Width = split.length;
        return split;
    }

    /*
     * Unable to fully structure code
     */
    private void SearchColumnsTypes(Scanner Entree) {
        nbLignes = 0;
        nbColonnes = this.Width;
        this.TypeColonnes = new int[nbColonnes];
        Arrays.fill(this.TypeColonnes, 0);
        while (Entree.hasNext()) {
            value = null;
            block15: for (i = 0; i < nbColonnes; ++i) {
                value = Entree.next();
                switch (this.TypeColonnes[i]) {
                    case 0: {
                        try {
                            Integer.valueOf((String)value);
                            continue block15;
                        }
                        catch (NumberFormatException nfe) {
                            this.TypeColonnes[i] = 1;
                        }
                    }
                    case 1: {
                        try {
                            Double.valueOf((String)value);
                            continue block15;
                        }
                        catch (NumberFormatException nfe) {
                            this.TypeColonnes[i] = 2;
                            if (value.charAt(0) != '\"' || value.charAt(value.length() - 1) == '\"' && value.length() != 1) ** GOTO lbl27
                            while ((value = (String)value + Entree.next()).charAt(value.length() - 1) != '\"') {
                            }
                        }
                    }
lbl27:
                    // 3 sources

                    case 2: {
                        if (value.charAt(0) != '\"' || value.charAt(value.length() - 1) == '\"' && value.length() != 1) continue block15;
                        while ((value = (String)value + Entree.next()).charAt(value.length() - 1) != '\"') {
                        }
                        continue block15;
                    }
                    default: {
                        throw new Error("Default => Bad column type: " + this.TypeColonnes[i]);
                    }
                }
            }
            if (this.writeweights) {
                while ((value = (String)value + Entree.next()).charAt(value.length() - 1) != '}') {
                }
            }
            ++nbLignes;
        }
        this.Height = nbLignes;
        this.Tableau = new Object[this.Width];
        block19: for (i = 0; i < this.Width; ++i) {
            switch (this.TypeColonnes[i]) {
                case 0: {
                    this.Tableau[i] = new int[this.Height];
                    continue block19;
                }
                case 1: {
                    this.Tableau[i] = new double[this.Height];
                    continue block19;
                }
                case 2: {
                    this.Tableau[i] = new String[this.Height];
                    continue block19;
                }
                default: {
                    throw new Error("Default => Bad column type: " + this.TypeColonnes[i]);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void SearchColumnsTypesCSV(Scanner Entree) throws Exception {
        nbLignes = 0;
        nbColumns = this.Width;
        this.TypeColonnes = new int[this.Width];
        Arrays.fill(this.TypeColonnes, 0);
        v0 = weights = this.writeweights != false ? 1 : 0;
        while (Entree.hasNext()) {
            line = Entree.nextLine();
            split = line.split(",");
            if (split.length != nbColumns + weights) {
                throw new Exception("'split.length != nbColumns' in line " + nbLignes + ": " + line);
            }
            block15: for (i = 0; i < nbColumns; ++i) {
                value = split[i].charAt(0) == '\"' && split[i].charAt(split[i].length() - 1) == '\"' ? split[i].substring(1, split[i].length() - 1) : split[i];
                switch (this.TypeColonnes[i]) {
                    case 0: {
                        try {
                            Integer.valueOf((String)value);
                            continue block15;
                        }
                        catch (NumberFormatException nfe) {
                            this.TypeColonnes[i] = 1;
                        }
                    }
                    case 1: {
                        try {
                            Double.valueOf((String)value);
                            continue block15;
                        }
                        catch (NumberFormatException nfe) {
                            this.TypeColonnes[i] = 2;
                            if (value.isEmpty() || value.charAt(0) != '\"' || value.charAt(value.length() - 1) == '\"' && value.length() != 1) ** GOTO lbl31
                            while ((value = (String)value + Entree.next()).charAt(value.length() - 1) != '\"') {
                            }
                        }
                    }
lbl31:
                    // 3 sources

                    case 2: {
                        if (value.isEmpty() || value.charAt(0) != '\"' || value.charAt(value.length() - 1) == '\"' && value.length() != 1) continue block15;
                        while ((value = (String)value + Entree.next()).charAt(value.length() - 1) != '\"') {
                        }
                        continue block15;
                    }
                    default: {
                        throw new Error("Default => Bad column type: " + this.TypeColonnes[i]);
                    }
                }
            }
            ++nbLignes;
        }
        this.Height = nbLignes;
        this.Tableau = new Object[this.Width];
        block18: for (i = 0; i < this.Width; ++i) {
            switch (this.TypeColonnes[i]) {
                case 0: {
                    this.Tableau[i] = new int[this.Height];
                    continue block18;
                }
                case 1: {
                    this.Tableau[i] = new double[this.Height];
                    continue block18;
                }
                case 2: {
                    this.Tableau[i] = new String[this.Height];
                    continue block18;
                }
                default: {
                    throw new Error("Default => Bad column type: " + this.TypeColonnes[i]);
                }
            }
        }
    }

    private void ReadFile(Scanner Entree, boolean NomColonnesInclu) {
        char[] tablu = null;
        Object value = null;
        String lu = null;
        for (int x = 0; x < this.nbLineComment; ++x) {
            Entree.nextLine();
        }
        if (NomColonnesInclu) {
            Entree.nextLine();
        }
        for (int y = 0; y < this.Height; ++y) {
            block7: for (int x = 0; x < this.Width; ++x) {
                switch (this.TypeColonnes[x]) {
                    case 0: {
                        ((int[])this.Tableau[x])[y] = Integer.valueOf(Entree.next());
                        continue block7;
                    }
                    case 1: {
                        value = Entree.next();
                        if (((String)value).indexOf(44) != -1) {
                            tablu = ((String)value).toCharArray();
                            tablu[((String)value).indexOf((int)44)] = 46;
                            lu = String.valueOf(tablu);
                        } else {
                            lu = value;
                        }
                        ((double[])this.Tableau[x])[y] = Double.valueOf(lu);
                        continue block7;
                    }
                    case 2: {
                        value = Entree.next();
                        if (((String)value).charAt(0) == '\"' && (((String)value).charAt(((String)value).length() - 1) != '\"' || ((String)value).length() == 1)) {
                            while (((String)(value = (String)value + " " + Entree.next())).charAt(((String)value).length() - 1) != '\"') {
                            }
                            value = ((String)value).substring(1, ((String)value).length() - 1);
                        } else if (((String)value).charAt(0) == '\"' && ((String)value).charAt(((String)value).length() - 1) == '\"') {
                            value = ((String)value).substring(1, ((String)value).length() - 1);
                        }
                        ((String[])this.Tableau[x])[y] = value;
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Column type not supported: " + this.TypeColonnes[x]);
                    }
                }
            }
            if (!this.writeweights) continue;
            value = Entree.next();
            this.Weights[y] = Double.valueOf(((String)value).substring(1, ((String)value).length() - 1));
        }
    }

    private void ReadFileCSV(Scanner Entree, boolean NomColonnesInclu) throws Exception {
        for (int x = 0; x < this.nbLineComment; ++x) {
            Entree.nextLine();
        }
        if (NomColonnesInclu) {
            Entree.nextLine();
        }
        int nbColumn = this.Width;
        int width = nbColumn + (this.writeweights ? 1 : 0);
        for (int y = 0; y < this.Height; ++y) {
            String line = Entree.nextLine();
            String[] split = line.split(",");
            if (split.length != width) {
                throw new Exception("split.length != width");
            }
            block7: for (int x = 0; x < nbColumn; ++x) {
                switch (this.TypeColonnes[x]) {
                    case 0: {
                        ((int[])this.Tableau[x])[y] = Integer.valueOf(split[x]);
                        continue block7;
                    }
                    case 1: {
                        ((double[])this.Tableau[x])[y] = Double.valueOf(split[x]);
                        continue block7;
                    }
                    case 2: {
                        if (split[x].charAt(0) == '\"' && split[x].charAt(split[x].length() - 1) == '\"') {
                            split[x] = split[x].substring(1, split[x].length() - 1);
                        }
                        ((String[])this.Tableau[x])[y] = split[x];
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Column type not supported: " + this.TypeColonnes[x]);
                    }
                }
            }
            if (!this.writeweights) continue;
            this.Weights[y] = Double.valueOf(split[nbColumn].substring(1, split[nbColumn].length() - 1));
        }
    }

    public void Write(String file, boolean writeweights, String separator) {
        this.setSeparator(separator);
        this.Write(file, writeweights);
    }

    public void Write(String file, boolean writeweights) {
        this.WriteWeights(writeweights);
        try {
            String date = DisplayDate ? Dates.DateAAAAMMJJ("/") + " " + Dates.Time(":") + " - " : "";
            DataOutputStream Sortie = new DataOutputStream(new FileOutputStream(file));
            System.out.print(date + "Writing file '" + file + "' (" + this.Width + " column" + (this.Width == 1 ? "" : "s") + ", " + this.Height + " row" + (this.Height == 1 ? "" : "s") + ")...");
            Sortie.write(this.toString().getBytes("ISO-8859-1"));
            Sortie.close();
            System.out.println(" successfully.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String[] getColumnsNames() {
        return this.NomColonnes;
    }

    public String getColumnName(int i2) {
        return this.NomColonnes[i2];
    }

    public void setColumnsNames(String[] Names) {
        if (Names.length != this.Width) {
            throw new IllegalArgumentException("Parameter Names have a length different of the number of attributes (columns).");
        }
        this.NomColonnes = (String[])Names.clone();
    }

    public void setColumnName(int i2, String Name2) {
        this.NomColonnes[i2] = Name2;
    }

    public Object[] getTableau() {
        return this.Tableau;
    }

    public Object getColumn(int i2) {
        return this.Tableau[i2];
    }

    public int[][] getFileInt() {
        int y;
        int x;
        int nbc = 0;
        for (x = 0; x < this.Width; ++x) {
            if (this.ExcludedColumn[x]) continue;
            if (this.TypeColonnes[x] != 0) {
                throw new Error("File have not only Integer columns.");
            }
            ++nbc;
        }
        int nbl = 0;
        for (y = 0; y < this.Height; ++y) {
            if (this.Excluded[y]) continue;
            ++nbl;
        }
        int[][] resultat = new int[nbl][nbc];
        int[] Colonne = null;
        nbc = 0;
        for (x = 0; x < this.Width; ++x) {
            if (this.ExcludedColumn[x]) continue;
            Colonne = (int[])this.Tableau[x];
            nbl = 0;
            for (y = 0; y < this.Height; ++y) {
                if (this.Excluded[y]) continue;
                resultat[nbl++][nbc] = Colonne[y];
            }
            ++nbc;
        }
        return resultat;
    }

    public int[] getColumnInt(String name) {
        return this.getColumnInt(this.ColumnNumber(name));
    }

    public int[] getColumnInt(int i2) {
        if (this.TypeColonnes[i2] != 0) {
            throw new IllegalArgumentException("Bad access => column " + i2 + " is not int");
        }
        return (int[])this.Tableau[i2];
    }

    public void setColumn(String name, int[] Column) {
        this.setColumn(this.ColumnNumber(name), Column);
    }

    public void setColumn(int i2, int[] Column) {
        if (this.TypeColonnes[i2] == -1) {
            this.TypeColonnes[i2] = 0;
        }
        if (this.TypeColonnes[i2] != 0) {
            throw new IllegalArgumentException("Wrong column type.");
        }
        if (Column.length != this.Height) {
            throw new IllegalArgumentException("Bad length of 'column', different from file.");
        }
        this.Tableau[i2] = Arrays.copyOf(Column, Column.length);
    }

    public int getValueInt(int y, int x) {
        return ((int[])this.Tableau[x])[y];
    }

    public double[][] getFileDouble() {
        int y;
        int x;
        int nbc = 0;
        for (x = 0; x < this.Width; ++x) {
            if (this.ExcludedColumn[x]) continue;
            if (this.TypeColonnes[x] != 1) {
                throw new Error("Ce fichier ne contient pas que des Double.");
            }
            ++nbc;
        }
        int nbl = 0;
        for (y = 0; y < this.Height; ++y) {
            if (this.Excluded[y]) continue;
            ++nbl;
        }
        double[][] resultat = new double[nbl][nbc];
        double[] Colonne = null;
        nbc = 0;
        for (x = 0; x < this.Width; ++x) {
            if (this.ExcludedColumn[x]) continue;
            Colonne = (double[])this.Tableau[x];
            nbl = 0;
            for (y = 0; y < this.Height; ++y) {
                if (this.Excluded[y]) continue;
                resultat[nbl++][nbc] = Colonne[y];
            }
            ++nbc;
        }
        return resultat;
    }

    public double[] getColumnDouble(String name) {
        return this.getColumnDouble(this.ColumnNumber(name));
    }

    public double[] getColumnDouble(int i2) {
        if (this.TypeColonnes[i2] != 1) {
            throw new IllegalArgumentException("Acces incorrect => column " + i2 + " n'est pas de type double");
        }
        return (double[])this.Tableau[i2];
    }

    public void setColumn(String name, float[] Column) {
        this.setColumn(this.ColumnNumber(name), Column);
    }

    public void setColumn(int i2, float[] Column) {
        if (this.TypeColonnes[i2] == -1) {
            this.TypeColonnes[i2] = 1;
        }
        if (this.TypeColonnes[i2] != 1) {
            throw new IllegalArgumentException("Wrong column type.");
        }
        if (Column.length != this.Height) {
            throw new IllegalArgumentException("Dimension du parametre differente de celle du fichier.");
        }
        double[] col = (double[])this.Tableau[i2];
        for (int x = 0; x < Column.length; ++x) {
            col[x] = Column[x];
        }
    }

    public void setColumn(String name, double[] Column) {
        this.setColumn(this.ColumnNumber(name), Column);
    }

    public void setColumn(int i2, double[] Column) {
        if (this.TypeColonnes[i2] == -1) {
            this.TypeColonnes[i2] = 1;
        }
        if (this.TypeColonnes[i2] != 1) {
            throw new IllegalArgumentException("Wrong column type.");
        }
        if (Column.length != this.Height) {
            throw new IllegalArgumentException("Dimension du parametre differente de celle du fichier.");
        }
        this.Tableau[i2] = Arrays.copyOf(Column, Column.length);
    }

    public double getValueDouble(int y, int x) {
        return ((double[])this.Tableau[x])[y];
    }

    public String[] getColumnString(String name) {
        return this.getColumnString(this.ColumnNumber(name));
    }

    public String[] getColumnString(int i2) {
        if (this.TypeColonnes[i2] != 2) {
            throw new IllegalArgumentException("Acces incorrect => column " + i2 + " n'est pas de type String");
        }
        return (String[])this.Tableau[i2];
    }

    public void setColumn(String name, String[] Column) {
        this.setColumn(this.ColumnNumber(name), Column);
    }

    public void setColumn(int i2, String[] Column) {
        if (this.TypeColonnes[i2] == -1) {
            this.TypeColonnes[i2] = 2;
        }
        if (this.TypeColonnes[i2] != 2) {
            throw new IllegalArgumentException("Wrong column type.");
        }
        if (Column.length != this.Height) {
            throw new IllegalArgumentException("The new colum length does not match the file height.");
        }
        this.Tableau[i2] = Arrays.copyOf(Column, Column.length);
    }

    public String getValueString(int y, int x) {
        return ((String[])this.Tableau[x])[y];
    }

    public void setValue(int row, int column, int Value) {
        ((int[])this.Tableau[column])[row] = Value;
    }

    public void setValue(int row, int column, double Value) {
        ((double[])this.Tableau[column])[row] = Value;
    }

    public void setValue(int row, int column, String Value) {
        ((String[])this.Tableau[column])[row] = Value;
    }

    public void setValueSafe(int row, int column, int Value) {
        if (this.TypeColonnes[column] != 0) {
            throw new IllegalArgumentException("Column " + column + " is not INTEGER");
        }
        ((int[])this.Tableau[column])[row] = Value;
    }

    public void setValueSafe(int row, int column, double Value) {
        if (this.TypeColonnes[column] != 1) {
            throw new IllegalArgumentException("Column " + column + " is not DOUBLE");
        }
        ((double[])this.Tableau[column])[row] = Value;
    }

    public void setValueSafe(int row, int column, String Value) {
        if (this.TypeColonnes[column] != 2) {
            throw new IllegalArgumentException("La column " + column + " is not STRING");
        }
        ((String[])this.Tableau[column])[row] = Value;
    }

    public void Fill(int column, int Value) {
        if (this.TypeColonnes[column] != 0) {
            throw new IllegalArgumentException("Column " + column + " is not INTEGER");
        }
        Arrays.fill((int[])this.Tableau[column], Value);
    }

    public void Fill(int column, double Value) {
        if (this.TypeColonnes[column] != 1) {
            throw new IllegalArgumentException("Column " + column + " is not DOUBLE");
        }
        Arrays.fill((double[])this.Tableau[column], Value);
    }

    public void Fill(int column, String Value) {
        if (this.TypeColonnes[column] != 2) {
            throw new IllegalArgumentException("Column " + column + " is not STRING");
        }
        Arrays.fill((String[])this.Tableau[column], Value);
    }

    public void setValueInSelection(int column, int Value) {
        if (this.TypeColonnes[column] != 0) {
            throw new IllegalArgumentException("Column " + column + " is not INTEGER");
        }
        int[] col = (int[])this.Tableau[column];
        for (int y = 0; y < this.Height; ++y) {
            if (!this.Selected[y]) continue;
            col[y] = Value;
        }
    }

    public void setValueInSelection(int column, String Value) {
        if (this.TypeColonnes[column] != 2) {
            throw new IllegalArgumentException("Column " + column + " is not STRING");
        }
        String[] col = (String[])this.Tableau[column];
        for (int y = 0; y < this.Height; ++y) {
            if (!this.Selected[y]) continue;
            col[y] = Value;
        }
    }

    public void setValueInSelection(int column, double Value) {
        if (this.TypeColonnes[column] != 1) {
            throw new IllegalArgumentException("Column " + column + " is not DOUBLE");
        }
        double[] col = (double[])this.Tableau[column];
        for (int y = 0; y < this.Height; ++y) {
            if (!this.Selected[y]) continue;
            col[y] = Value;
        }
    }

    public int[] ColumnType() {
        return this.TypeColonnes;
    }

    public int ColumnType(String name) {
        return this.ColumnType(this.ColumnNumber(name));
    }

    public int ColumnType(int i2) {
        return this.TypeColonnes[i2];
    }

    public void setTypeColonne(String name, int Type2) {
        this.setTypeColonne(this.ColumnNumber(name), Type2);
    }

    public void setTypeColonne(int i2, int Type2) {
        if (this.TypeColonnes[i2] != -1) {
            throw new IllegalArgumentException("Type of column is not Unknown => cannot be affected.");
        }
        switch (Type2) {
            case 1: {
                this.Tableau[i2] = new double[this.Height];
                break;
            }
            case 0: {
                this.Tableau[i2] = new int[this.Height];
                break;
            }
            case 2: {
                this.Tableau[i2] = new String[this.Height];
                break;
            }
            default: {
                throw new Error("Type de column incorrect : " + Type2);
            }
        }
        this.TypeColonnes[i2] = Type2;
    }

    public int getWidth() {
        return this.Width;
    }

    public int Width() {
        return this.Width;
    }

    public int getNbColumn() {
        return this.Width;
    }

    public int nbColumn() {
        return this.Width;
    }

    public int getNbAttribut() {
        return this.Width;
    }

    public int nbAttribut() {
        return this.Width;
    }

    public int getHeight() {
        return this.Height;
    }

    public int Height() {
        return this.Height;
    }

    public int getNbRows() {
        return this.Height;
    }

    public int nbRows() {
        return this.Height;
    }

    public boolean[] getExcludedColumn() {
        return this.ExcludedColumn;
    }

    public boolean isExcludedColumn(int i2) {
        return this.ExcludedColumn[i2];
    }

    public void setExcludedColumn(boolean[] columns) {
        System.arraycopy(columns, 0, this.ExcludedColumn, 0, columns.length);
    }

    public void setExcludedColumn(String name, boolean excluded) {
        this.setExcludedColumn(this.ColumnNumber(name), excluded);
    }

    public void setExcludedColumn(int i2, boolean excluded) {
        this.ExcludedColumn[i2] = excluded;
    }

    public boolean[] getExcluded() {
        return this.Excluded;
    }

    public boolean isExcluded(int i2) {
        return this.Excluded[i2];
    }

    public void setExcluded(boolean[] excluded) {
        System.arraycopy(excluded, 0, this.Excluded, 0, excluded.length);
    }

    public void setExcluded(int i2, boolean excluded) {
        this.Excluded[i2] = excluded;
    }

    public boolean isDouble(int x) {
        return this.TypeColonnes[x] == 1;
    }

    public boolean isInteger(int x) {
        return this.TypeColonnes[x] == 0;
    }

    public boolean isString(int x) {
        return this.TypeColonnes[x] == 2;
    }

    public boolean[] getNominal() {
        return this.Nominal;
    }

    public boolean isNominal(int x) {
        return this.Nominal[x];
    }

    public void setNominal(boolean[] nominal) {
        System.arraycopy(nominal, 0, this.Nominal, 0, nominal.length);
    }

    public void setNominal(String name, boolean nominal) {
        this.setNominal(this.ColumnNumber(name), nominal);
    }

    public void setNominal(int x, boolean nominal) {
        if (nominal && (this.TypeColonnes[x] == 1 || this.TypeColonnes[x] == -1)) {
            throw new IllegalArgumentException("The column " + x + " is Double or Unknown, therefore it can't be nominal.");
        }
        this.Nominal[x] = nominal;
    }

    public void setNominalAndTarget(String x) {
        this.TargetNominal(this.ColumnNumber(x));
    }

    public void setNominalAndTarget(int x) {
        this.TargetNominal(x);
    }

    public boolean[] getSelected() {
        return this.Selected;
    }

    public boolean[] getSelectedColumn() {
        return this.SelectedColumn;
    }

    public boolean isSelectedColumn(int i2) {
        return this.SelectedColumn[i2];
    }

    public void setSelectedColumn(boolean[] selected) {
        System.arraycopy(selected, 0, this.SelectedColumn, 0, selected.length);
    }

    public void setSelectedColumn(String name, boolean selected) {
        this.setSelectedColumn(this.ColumnNumber(name), selected);
    }

    public void setSelectedColumn(int i2, boolean selected) {
        this.SelectedColumn[i2] = selected;
    }

    public boolean isSelected(int i2) {
        return this.Selected[i2];
    }

    public void setSelected(boolean[] selected) {
        System.arraycopy(selected, 0, this.Selected, 0, selected.length);
    }

    public void setSelected(int i2, boolean selected) {
        this.Selected[i2] = selected;
    }

    public void Weight(double weight) {
        Arrays.fill(this.Weights, weight);
    }

    public double Weight(int row) {
        return this.Weights[row];
    }

    public double[] Weights() {
        return this.Weights;
    }

    public void Weight(int row, double weight) {
        this.Weights[row] = weight;
    }

    public void Target(int Target) {
        if (Target < 0 || this.Width <= Target) {
            throw new IllegalArgumentException("Target < 0 or Width <= Target.");
        }
        if (this.TypeColonnes[Target] == -1) {
            throw new IllegalArgumentException("The Target column is of type UNKNOWN.");
        }
        this.Target = Target;
    }

    public void Target(String Target) {
        this.Target(this.ColumnNumber(Target));
    }

    public void TargetNominal(String Target) {
        this.TargetNominal(this.ColumnNumber(Target));
    }

    public void TargetNominal(int Target) {
        this.setNominal(Target, true);
        this.Target(Target);
    }

    public int Target() {
        return this.Target < 0 ? this.FindAndSetTarget() : this.Target;
    }

    public int FindAndSetTarget() {
        int target = -1;
        for (int i2 = 0; i2 < this.Width; ++i2) {
            if (!this.Nominal[i2]) continue;
            if (target < 0) {
                target = i2;
                continue;
            }
            return -1;
        }
        if (target != -1) {
            this.Target = target;
        }
        return target;
    }

    public void setSeparator(String Separator2) {
        this.Separator = Separator2;
    }

    public void Display() {
        System.out.println("\"" + this.Name + "\"");
        System.out.println(this.toString());
    }

    public void Display(String Separator2) {
        this.setSeparator(Separator2);
        this.Display();
    }

    public void appendTo(Appendable out) throws IOException {
        int i2;
        for (i2 = 0; i2 < this.Width - 1; ++i2) {
            out.append("\"").append(this.NomColonnes[i2]).append("\"").append(this.Separator);
        }
        out.append("\"").append(this.NomColonnes[this.Width - 1]).append("\"");
        if (this.writeweights) {
            out.append("{Weights}");
        }
        out.append("\n");
        for (i2 = 0; i2 < this.Height; ++i2) {
            int j;
            block14: for (j = 0; j < this.Width - 1; ++j) {
                switch (this.TypeColonnes[j]) {
                    case 0: {
                        out.append(String.valueOf(((int[])this.Tableau[j])[i2])).append(this.Separator);
                        continue block14;
                    }
                    case 1: {
                        out.append(String.valueOf(((double[])this.Tableau[j])[i2])).append(this.Separator);
                        continue block14;
                    }
                    case 2: {
                        out.append("\"" + ((String[])this.Tableau[j])[i2] + "\"").append(this.Separator);
                        continue block14;
                    }
                    case -1: {
                        out.append("FichierTabule.UNKNOWN").append(this.Separator);
                        continue block14;
                    }
                    default: {
                        throw new Error("Default: Column type not valid : " + this.TypeColonnes[j]);
                    }
                }
            }
            j = this.Width - 1;
            switch (this.TypeColonnes[j]) {
                case 0: {
                    out.append(String.valueOf(((int[])this.Tableau[j])[i2]));
                    break;
                }
                case 1: {
                    out.append(String.valueOf(((double[])this.Tableau[j])[i2]));
                    break;
                }
                case 2: {
                    out.append("\"" + ((String[])this.Tableau[j])[i2] + "\"");
                    break;
                }
                case -1: {
                    out.append("FichierTabule.UNKNOWN");
                    break;
                }
                default: {
                    throw new Error("Default: Column type not valid : " + this.TypeColonnes[j]);
                }
            }
            if (this.writeweights) {
                out.append(" {").append(String.valueOf(this.Weights[i2])).append("}");
            }
            out.append("\n");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1000);
        try {
            this.appendTo(sb);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public void WriteWeights(boolean writeweights) {
        this.writeweights = writeweights;
    }

    public boolean WriteWeights() {
        return this.writeweights;
    }

    public int getNbSelected() {
        int nb = 0;
        for (int i2 = 0; i2 < this.Height; ++i2) {
            if (!this.Selected[i2]) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbSelectedColumn() {
        int nb = 0;
        for (int i2 = 0; i2 < this.Width; ++i2) {
            if (!this.SelectedColumn[i2]) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbExcluded() {
        int nb = 0;
        for (int i2 = 0; i2 < this.Height; ++i2) {
            if (!this.Excluded[i2]) continue;
            ++nb;
        }
        return nb;
    }

    public int getNbExcludedColumn() {
        int nb = 0;
        for (int i2 = 0; i2 < this.Width; ++i2) {
            if (!this.ExcludedColumn[i2]) continue;
            ++nb;
        }
        return nb;
    }

    public String Name() {
        return this.Name;
    }

    public void Rename(String Name2) {
        this.Name = Name2.substring(0);
    }

    public void Kill() {
        this.ExcludedColumn = null;
        this.Excluded = null;
        this.SelectedColumn = null;
        this.Selected = null;
        this.NomColonnes = null;
        this.Nominal = null;
        this.TypeColonnes = null;
        this.Weights = null;
        this.Name = null;
        this.Separator = null;
        for (int i2 = 0; i2 < this.Tableau.length; ++i2) {
            this.Tableau[i2] = null;
        }
        this.Tableau = null;
    }
}

