/*
 * Decompiled with CFR 0.152.
 */
package filesAndFolders;

import arrayTiTi.ArrayOperations;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Comparator;

public class FilesFolders {
    public static final int CONTAINS = 0;
    public static final int EQUALS = 1;

    public static boolean CopyFile(File Source2, File Destination) {
        FileChannel in = null;
        FileChannel out = null;
        try {
            in = new FileInputStream(Source2).getChannel();
            out = Destination.isDirectory() ? new FileOutputStream(Destination.getAbsolutePath() + "/" + Source2.getName()).getChannel() : new FileOutputStream(Destination).getChannel();
            in.transferTo(0L, in.size(), out);
            in.close();
            out.close();
        }
        catch (Exception E) {
            E.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean MoveFile(File source, File destination) {
        if (!destination.exists()) {
            if (source.renameTo(destination)) {
                return true;
            }
            boolean result = FilesFolders.CopyFile(source, destination);
            if (result) {
                result &= source.delete();
            }
            return result;
        }
        throw new UnsupportedOperationException("'" + source.getAbsolutePath() + "' already exists in '" + destination.getAbsolutePath() + "'.");
    }

    public static boolean MoveFolder(File source, File destination) {
        boolean result;
        if (!destination.exists()) {
            destination.mkdirs();
        }
        if (result = FilesFolders.CopyFolder(source, destination)) {
            result &= FilesFolders.Delete(source);
        }
        return result;
    }

    public static boolean Delete(File path) {
        boolean result = true;
        if (path.exists() && path.isDirectory()) {
            File[] files;
            for (File file : files = path.listFiles()) {
                if (file.isDirectory()) {
                    result &= FilesFolders.Delete(file);
                }
                result &= file.delete();
            }
            Object var2_2 = null;
        }
        return result & path.delete();
    }

    public static boolean FindAndDelete(File CurrentPath, int Action2, String Name2) {
        if (!CurrentPath.isDirectory()) {
            throw new IllegalArgumentException("CurrentPath is not a directory.");
        }
        File[] files = CurrentPath.listFiles();
        boolean result = true;
        for (File file : files) {
            if (Action2 == 0 && file.getName().contains(Name2) || Action2 == 1 && file.getName().equalsIgnoreCase(Name2)) {
                FilesFolders.Delete(file.getAbsoluteFile());
                continue;
            }
            if (!file.isDirectory()) continue;
            result &= FilesFolders.FindAndDelete(file.getAbsoluteFile(), Action2, Name2);
        }
        files = null;
        return result;
    }

    public static boolean FindAndDelete(File CurrentPath, String Name1, String Name2) {
        if (!CurrentPath.isDirectory()) {
            throw new IllegalArgumentException("CurrentPath is not a directory.");
        }
        File[] files = CurrentPath.listFiles();
        boolean result = true;
        for (File file : files) {
            if (file.getName().contains(Name1) && file.getName().contains(Name2)) {
                FilesFolders.Delete(file.getAbsoluteFile());
                continue;
            }
            if (!file.isDirectory()) continue;
            result &= FilesFolders.FindAndDelete(file.getAbsoluteFile(), Name1, Name2);
        }
        files = null;
        return result;
    }

    public static boolean CopyFolder(File Source2, File Destination) {
        if (!Source2.isDirectory()) {
            throw new IllegalArgumentException("Source file is not a directory.");
        }
        if (!Destination.isDirectory()) {
            throw new IllegalArgumentException("Destination file is not a directory.");
        }
        File tmp = new File(Destination.getAbsolutePath() + "/" + Source2.getName());
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        return FilesFolders.CopyFolder(Source2, Source2.getAbsoluteFile(), tmp);
    }

    private static boolean CopyFolder(File Source2, File CurrentPath, File Destination) {
        if (!CurrentPath.isDirectory()) {
            throw new IllegalArgumentException("CurrentPath is not a directory.");
        }
        File[] files = CurrentPath.listFiles();
        File tmp = null;
        try {
            for (File file : files) {
                if (file.isDirectory()) {
                    tmp = null;
                    tmp = new File(Destination.getAbsolutePath() + "/" + CurrentPath.getAbsolutePath().substring(Source2.getAbsolutePath().length()) + "/" + file.getName() + "/");
                    if (!tmp.exists()) {
                        tmp.mkdirs();
                    }
                    FilesFolders.CopyFolder(Source2, file.getAbsoluteFile(), Destination);
                    continue;
                }
                if (!CurrentPath.exists()) {
                    CurrentPath.mkdir();
                }
                tmp = null;
                tmp = new File(Destination.getAbsolutePath() + "/" + CurrentPath.getAbsolutePath().substring(Source2.getAbsolutePath().length()));
                FilesFolders.CopyFile(file.getAbsoluteFile(), tmp);
            }
        }
        catch (Exception E) {
            E.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean CopySpecificallyTo(String inputfolder, String outputfolder, FileFilter ff) {
        File[] files;
        boolean result = true;
        File out = new File(outputfolder);
        if (!out.exists()) {
            out.mkdirs();
        }
        for (File file : files = new File(inputfolder).listFiles()) {
            if (!file.isDirectory()) continue;
            result &= FilesFolders.CopySpecificallyTo(inputfolder + "/" + file.getName() + "/", outputfolder + "/" + file.getName() + "/", ff);
        }
        for (File file : files = new File(inputfolder).listFiles(ff)) {
            FilesFolders.CopyFile(file, out);
        }
        out = null;
        return result;
    }

    public static boolean FindAndRenameFiles(File CurrentPath, int Action2, String OldName, String NewName) {
        if (!CurrentPath.isDirectory()) {
            throw new IllegalArgumentException("CurrentPath is not a directory.");
        }
        File[] files = CurrentPath.listFiles();
        boolean result = true;
        for (File file : files) {
            if (file.isDirectory()) {
                result &= FilesFolders.FindAndRenameFiles(file.getAbsoluteFile(), Action2, OldName, NewName);
                continue;
            }
            if ((Action2 != 0 || !file.getName().contains(OldName)) && (Action2 != 1 || !file.getName().equalsIgnoreCase(OldName))) continue;
            result &= file.renameTo(new File(file.getParentFile().getAbsolutePath() + "/" + NewName));
        }
        files = null;
        return result;
    }

    public static boolean FindAndRenameFolders(File CurrentPath, int Action2, String OldName, String NewName) {
        if (!CurrentPath.isDirectory()) {
            throw new IllegalArgumentException("CurrentPath is not a directory.");
        }
        File[] files = CurrentPath.listFiles();
        boolean result = true;
        for (File file : files) {
            if (!file.isDirectory()) continue;
            result &= FilesFolders.FindAndRenameFolders(file.getAbsoluteFile(), Action2, OldName, NewName);
            if ((Action2 != 0 || !file.getName().contains(OldName)) && (Action2 != 1 || !file.getName().equalsIgnoreCase(OldName))) continue;
            result &= file.renameTo(new File(file.getParentFile().getAbsolutePath() + "/" + NewName));
        }
        files = null;
        return result;
    }

    public static boolean FindAndReplace(File CurrentPath, String OldPartOfName, String NewPartOfName) {
        if (!CurrentPath.isDirectory()) {
            throw new IllegalArgumentException("CurrentPath is not a directory.");
        }
        File[] files = CurrentPath.listFiles();
        boolean result = true;
        for (File file : files) {
            if (file.isDirectory()) {
                result &= FilesFolders.FindAndReplace(file.getAbsoluteFile(), OldPartOfName, NewPartOfName);
            }
            if (!file.getName().contains(OldPartOfName)) continue;
            result &= file.renameTo(new File(file.getParentFile().getAbsolutePath() + "/" + file.getName().replace(OldPartOfName, NewPartOfName)));
        }
        files = null;
        return result;
    }

    public static void AddZeros(File path) {
        int p;
        if (path == null) {
            throw new Error("path = null.");
        }
        if (!path.exists()) {
            throw new Error("Fichier inexistant.");
        }
        File[] files = path.listFiles();
        String Parent = path.getAbsolutePath();
        String Nom = null;
        String Suffixe = null;
        Object zeros = null;
        int max = 0;
        for (File file : files) {
            if (!file.isFile() || file.getName().equals(".DS_Store")) continue;
            Nom = file.getName();
            for (p = Nom.length() - 1; p >= 0 && Nom.charAt(p) != '.'; --p) {
            }
            if (p < 0) {
                throw new Error("Aucune extension detectee dans le nom : " + Nom);
            }
            Suffixe = Nom.substring(0, p);
            if (Integer.valueOf(Suffixe) <= max) continue;
            max = Integer.valueOf(Suffixe);
        }
        int nbChiffres = String.valueOf(max).length();
        for (File file : files) {
            if (!file.isFile() || file.getName().equals(".DS_Store")) continue;
            Nom = file.getName();
            for (p = Nom.length() - 1; p >= 0 && Nom.charAt(p) != '.'; --p) {
            }
            Suffixe = Nom.substring(0, p);
            int nbzeros = nbChiffres - Suffixe.length();
            zeros = null;
            zeros = "";
            for (int z = 0; z < nbzeros; ++z) {
                zeros = (String)zeros + "0";
            }
            file.renameTo(new File(Parent + "/" + (String)zeros + file.getName()));
        }
    }

    public static boolean RenameAndEnumerate(File Folder, String Name2, String NewName, String Extension2) {
        if (!Folder.isDirectory()) {
            throw new IllegalArgumentException("CurrentPath is not a directory.");
        }
        Object[] files = Folder.listFiles();
        boolean result = true;
        int count = 0;
        StringBuilder prefixe = new StringBuilder(4);
        Arrays.sort(files);
        for (Object file : files) {
            if (!((File)file).isFile() || !((File)file).getName().contains(Name2)) continue;
            ++count;
        }
        int zeros = (int)Math.log10(count);
        count = 0;
        while (count++ < zeros) {
            prefixe.append("0");
        }
        count = 1;
        int nb = 10;
        for (Object file : files) {
            if (!((File)file).isFile() || !((File)file).getName().contains(Name2)) continue;
            result &= ((File)file).renameTo(new File(((File)file).getParentFile().getAbsolutePath() + "/" + NewName + prefixe.toString() + count + "." + Extension2));
            if (++count != nb) continue;
            prefixe.deleteCharAt(0);
            nb *= 10;
        }
        files = null;
        return result;
    }

    public static boolean RenameAndInverseEnumerate(File Folder, String Name2, String NewName, String Extension2) {
        int i2;
        if (!Folder.isDirectory()) {
            throw new IllegalArgumentException("CurrentPath is not a directory.");
        }
        Object[] files = Folder.listFiles();
        Object f = null;
        boolean result = true;
        StringBuilder prefixe = new StringBuilder(5);
        Arrays.sort(files);
        for (i2 = 0; i2 < files.length >> 1; ++i2) {
            f = files[i2];
            files[i2] = files[files.length - i2 - 1];
            files[files.length - i2 - 1] = f;
        }
        int count = 0;
        for (i2 = 0; i2 < files.length; ++i2) {
            if (!((File)files[i2]).isFile() || !((File)files[i2]).getName().contains(Name2)) continue;
            ++count;
        }
        int zeros = (int)Math.log10(count);
        i2 = 0;
        while (i2++ < zeros) {
            prefixe.append("0");
        }
        count = 1;
        int nb = 10;
        for (i2 = 0; i2 < files.length; ++i2) {
            if (!((File)files[i2]).isFile() || !((File)files[i2]).getName().contains(Name2)) continue;
            result &= ((File)files[i2]).renameTo(new File(((File)files[i2]).getParentFile().getAbsolutePath() + "/" + NewName + prefixe.toString() + count + "." + Extension2));
            if (++count != nb) continue;
            prefixe.deleteCharAt(0);
            nb *= 10;
        }
        files = null;
        return result;
    }

    public static boolean ReplaceInNameRec(File Folder, String Name2, String NewName) {
        if (!Folder.isDirectory()) {
            throw new IllegalArgumentException("CurrentPath is not a directory.");
        }
        File[] files = Folder.listFiles();
        boolean result = true;
        for (File file : files) {
            if (file.isDirectory()) {
                FilesFolders.ReplaceInNameRec(file, Name2, NewName);
                continue;
            }
            if (!file.isFile() || !file.getName().contains(Name2)) continue;
            result &= file.renameTo(new File(file.getParentFile().getAbsolutePath() + "/" + file.getName().replace(Name2, NewName)));
        }
        files = null;
        return result;
    }

    public static boolean ReplaceInName(File Folder, String Name2, String NewName) {
        if (!Folder.isDirectory()) {
            throw new IllegalArgumentException("CurrentPath is not a directory.");
        }
        File[] files = Folder.listFiles();
        boolean result = true;
        int i2 = 0;
        while (i2 < files.length) {
            if (files[i2].isFile() && files[i2].getName().contains(Name2)) {
                result &= files[i2].renameTo(new File(files[i2].getParentFile().getAbsolutePath() + "/" + files[i2].getName().replace(Name2, NewName)));
                continue;
            }
            ++i2;
        }
        files = null;
        return result;
    }

    public static int Count(File file, FileFilter ff) throws Exception {
        File[] files;
        if (!file.exists()) {
            throw new Exception("This file does not exist.");
        }
        if (!file.isDirectory()) {
            throw new Exception("This file is not a directory.");
        }
        int count = 0;
        for (File file1 : files = new File(file.getAbsolutePath()).listFiles()) {
            if (!file1.isDirectory()) continue;
            count += FilesFolders.Count(file1, ff);
        }
        files = null;
        files = new File(file.getAbsolutePath()).listFiles(ff);
        count += files.length;
        files = null;
        return count;
    }

    public static boolean AddExtension(String path, String ext) {
        File file = new File(path);
        boolean result = FilesFolders.AddExtension(file, ext);
        file = null;
        return result;
    }

    public static boolean AddExtension(File file, String ext) {
        if (!file.exists()) {
            return false;
        }
        File newfile = new File(file.getAbsolutePath() + ext);
        file.renameTo(newfile);
        newfile = null;
        return true;
    }

    public static boolean AddExtension(String path, FilenameFilter fnf, String ext) {
        File[] file = new File(path).listFiles(fnf);
        if (file == null) {
            return false;
        }
        boolean success = true;
        for (File file1 : file) {
            success &= FilesFolders.AddExtension(file1, ext);
        }
        file = null;
        return success;
    }

    public static Comparator<File> ComparatorLength() {
        return (t, t1) -> {
            if (t.getAbsolutePath().length() > t1.getAbsolutePath().length()) {
                return 1;
            }
            if (t.getAbsolutePath().length() < t1.getAbsolutePath().length()) {
                return -1;
            }
            return t.compareTo((File)t1);
        };
    }

    public static void RandomCopy(File srcdir, FilenameFilter fnf, int NB, File destdir) {
        if (!destdir.exists()) {
            destdir.mkdirs();
        }
        if (!destdir.isDirectory()) {
            throw new IllegalArgumentException("The destination file is not a directory.");
        }
        Object[] files = srcdir.listFiles(fnf);
        ArrayOperations.Shuffle((File[])files);
        for (int i2 = 0; i2 < NB; ++i2) {
            FilesFolders.CopyFile(files[i2], destdir);
        }
        Arrays.fill(files, null);
        files = null;
    }

    public static void RandomSplit(File srcdir, FilenameFilter fnf, int NB1, File destdir1, int NB2, File destdir2) {
        if (!destdir1.exists()) {
            destdir1.mkdirs();
        }
        if (!destdir1.isDirectory()) {
            throw new IllegalArgumentException("The first destination file is not a directory.");
        }
        if (!destdir2.exists()) {
            destdir2.mkdirs();
        }
        if (!destdir2.isDirectory()) {
            throw new IllegalArgumentException("The second destination file is not a directory.");
        }
        Object[] files = srcdir.listFiles(fnf);
        ArrayOperations.Shuffle((File[])files);
        for (int i2 = 0; i2 < NB1; ++i2) {
            FilesFolders.CopyFile(files[i2], destdir1);
        }
        int sum = NB1 + NB2;
        for (int i3 = NB1; i3 < sum; ++i3) {
            FilesFolders.CopyFile(files[i3], destdir2);
        }
        Arrays.fill(files, null);
        files = null;
    }
}

