/*
 * Decompiled with CFR 0.152.
 */
package dv.marchingCube;

import dv.DV;
import dv.marchingCube.TriangleMC;
import dv.marchingCube.XYZMC;

public class MarchingCubes {
    public int MAX_Tri = 2500000;
    public int nb_triangle = 0;
    public TriangleMC[] triangle = new TriangleMC[this.MAX_Tri];
    public XYZMC[] norm = new XYZMC[this.MAX_Tri];
    private XYZMC[] centre_arrete = new XYZMC[12];
    private XYZMC[] sommet = new XYZMC[8];
    private int[] arrete = new int[12];
    private int[] edgeTable = new int[]{0, 265, 515, 778, 1030, 1295, 1541, 1804, 2060, 2309, 2575, 2822, 3082, 3331, 3593, 3840, 400, 153, 915, 666, 1430, 1183, 1941, 1692, 2460, 2197, 2975, 2710, 3482, 3219, 3993, 3728, 560, 825, 51, 314, 1590, 1855, 1077, 1340, 2620, 2869, 2111, 2358, 3642, 3891, 3129, 3376, 928, 681, 419, 170, 1958, 1711, 1445, 1196, 2988, 2725, 2479, 2214, 4010, 3747, 3497, 3232, 1120, 1385, 1635, 1898, 102, 367, 613, 876, 3180, 3429, 3695, 3942, 2154, 2403, 2665, 2912, 1520, 1273, 2035, 1786, 502, 255, 1013, 764, 3580, 3317, 4095, 3830, 2554, 2291, 3065, 2800, 1616, 1881, 1107, 1370, 598, 863, 85, 348, 3676, 3925, 3167, 3414, 2650, 2899, 2137, 2384, 1984, 1737, 1475, 1226, 966, 719, 453, 204, 4044, 3781, 3535, 3270, 3018, 2755, 2505, 2240, 2240, 2505, 2755, 3018, 3270, 3535, 3781, 4044, 204, 453, 719, 966, 1226, 1475, 1737, 1984, 2384, 2137, 2899, 2650, 3414, 3167, 3925, 3676, 348, 85, 863, 598, 1370, 1107, 1881, 1616, 2800, 3065, 2291, 2554, 3830, 4095, 3317, 3580, 764, 1013, 255, 502, 1786, 2035, 1273, 1520, 2912, 2665, 2403, 2154, 3942, 3695, 3429, 3180, 876, 613, 367, 102, 1898, 1635, 1385, 1120, 3232, 3497, 3747, 4010, 2214, 2479, 2725, 2988, 1196, 1445, 1711, 1958, 170, 419, 681, 928, 3376, 3129, 3891, 3642, 2358, 2111, 2869, 2620, 1340, 1077, 1855, 1590, 314, 51, 825, 560, 3728, 3993, 3219, 3482, 2710, 2975, 2197, 2460, 1692, 1941, 1183, 1430, 666, 915, 153, 400, 3840, 3593, 3331, 3082, 2822, 2575, 2309, 2060, 1804, 1541, 1295, 1030, 778, 515, 265, 0};
    private int[][] triTable = new int[][]{{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 8, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 8, 3, 9, 8, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 2, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 8, 3, 1, 2, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {9, 2, 10, 0, 2, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, 8, 3, 2, 10, 8, 10, 9, 8, -1, -1, -1, -1, -1, -1, -1}, {3, 11, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 11, 2, 8, 11, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 9, 0, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 11, 2, 1, 9, 11, 9, 8, 11, -1, -1, -1, -1, -1, -1, -1}, {3, 10, 1, 11, 10, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 10, 1, 0, 8, 10, 8, 11, 10, -1, -1, -1, -1, -1, -1, -1}, {3, 9, 0, 3, 11, 9, 11, 10, 9, -1, -1, -1, -1, -1, -1, -1}, {9, 8, 10, 10, 8, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, 3, 0, 7, 3, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 9, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, 1, 9, 4, 7, 1, 7, 3, 1, -1, -1, -1, -1, -1, -1, -1}, {1, 2, 10, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, 4, 7, 3, 0, 4, 1, 2, 10, -1, -1, -1, -1, -1, -1, -1}, {9, 2, 10, 9, 0, 2, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1}, {2, 10, 9, 2, 9, 7, 2, 7, 3, 7, 9, 4, -1, -1, -1, -1}, {8, 4, 7, 3, 11, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {11, 4, 7, 11, 2, 4, 2, 0, 4, -1, -1, -1, -1, -1, -1, -1}, {9, 0, 1, 8, 4, 7, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1}, {4, 7, 11, 9, 4, 11, 9, 11, 2, 9, 2, 1, -1, -1, -1, -1}, {3, 10, 1, 3, 11, 10, 7, 8, 4, -1, -1, -1, -1, -1, -1, -1}, {1, 11, 10, 1, 4, 11, 1, 0, 4, 7, 11, 4, -1, -1, -1, -1}, {4, 7, 8, 9, 0, 11, 9, 11, 10, 11, 0, 3, -1, -1, -1, -1}, {4, 7, 11, 4, 11, 9, 9, 11, 10, -1, -1, -1, -1, -1, -1, -1}, {9, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {9, 5, 4, 0, 8, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 5, 4, 1, 5, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {8, 5, 4, 8, 3, 5, 3, 1, 5, -1, -1, -1, -1, -1, -1, -1}, {1, 2, 10, 9, 5, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, 0, 8, 1, 2, 10, 4, 9, 5, -1, -1, -1, -1, -1, -1, -1}, {5, 2, 10, 5, 4, 2, 4, 0, 2, -1, -1, -1, -1, -1, -1, -1}, {2, 10, 5, 3, 2, 5, 3, 5, 4, 3, 4, 8, -1, -1, -1, -1}, {9, 5, 4, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 11, 2, 0, 8, 11, 4, 9, 5, -1, -1, -1, -1, -1, -1, -1}, {0, 5, 4, 0, 1, 5, 2, 3, 11, -1, -1, -1, -1, -1, -1, -1}, {2, 1, 5, 2, 5, 8, 2, 8, 11, 4, 8, 5, -1, -1, -1, -1}, {10, 3, 11, 10, 1, 3, 9, 5, 4, -1, -1, -1, -1, -1, -1, -1}, {4, 9, 5, 0, 8, 1, 8, 10, 1, 8, 11, 10, -1, -1, -1, -1}, {5, 4, 0, 5, 0, 11, 5, 11, 10, 11, 0, 3, -1, -1, -1, -1}, {5, 4, 8, 5, 8, 10, 10, 8, 11, -1, -1, -1, -1, -1, -1, -1}, {9, 7, 8, 5, 7, 9, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {9, 3, 0, 9, 5, 3, 5, 7, 3, -1, -1, -1, -1, -1, -1, -1}, {0, 7, 8, 0, 1, 7, 1, 5, 7, -1, -1, -1, -1, -1, -1, -1}, {1, 5, 3, 3, 5, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {9, 7, 8, 9, 5, 7, 10, 1, 2, -1, -1, -1, -1, -1, -1, -1}, {10, 1, 2, 9, 5, 0, 5, 3, 0, 5, 7, 3, -1, -1, -1, -1}, {8, 0, 2, 8, 2, 5, 8, 5, 7, 10, 5, 2, -1, -1, -1, -1}, {2, 10, 5, 2, 5, 3, 3, 5, 7, -1, -1, -1, -1, -1, -1, -1}, {7, 9, 5, 7, 8, 9, 3, 11, 2, -1, -1, -1, -1, -1, -1, -1}, {9, 5, 7, 9, 7, 2, 9, 2, 0, 2, 7, 11, -1, -1, -1, -1}, {2, 3, 11, 0, 1, 8, 1, 7, 8, 1, 5, 7, -1, -1, -1, -1}, {11, 2, 1, 11, 1, 7, 7, 1, 5, -1, -1, -1, -1, -1, -1, -1}, {9, 5, 8, 8, 5, 7, 10, 1, 3, 10, 3, 11, -1, -1, -1, -1}, {5, 7, 0, 5, 0, 9, 7, 11, 0, 1, 0, 10, 11, 10, 0, -1}, {11, 10, 0, 11, 0, 3, 10, 5, 0, 8, 0, 7, 5, 7, 0, -1}, {11, 10, 5, 7, 11, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {10, 6, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 8, 3, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {9, 0, 1, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 8, 3, 1, 9, 8, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1}, {1, 6, 5, 2, 6, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 6, 5, 1, 2, 6, 3, 0, 8, -1, -1, -1, -1, -1, -1, -1}, {9, 6, 5, 9, 0, 6, 0, 2, 6, -1, -1, -1, -1, -1, -1, -1}, {5, 9, 8, 5, 8, 2, 5, 2, 6, 3, 2, 8, -1, -1, -1, -1}, {2, 3, 11, 10, 6, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {11, 0, 8, 11, 2, 0, 10, 6, 5, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 9, 2, 3, 11, 5, 10, 6, -1, -1, -1, -1, -1, -1, -1}, {5, 10, 6, 1, 9, 2, 9, 11, 2, 9, 8, 11, -1, -1, -1, -1}, {6, 3, 11, 6, 5, 3, 5, 1, 3, -1, -1, -1, -1, -1, -1, -1}, {0, 8, 11, 0, 11, 5, 0, 5, 1, 5, 11, 6, -1, -1, -1, -1}, {3, 11, 6, 0, 3, 6, 0, 6, 5, 0, 5, 9, -1, -1, -1, -1}, {6, 5, 9, 6, 9, 11, 11, 9, 8, -1, -1, -1, -1, -1, -1, -1}, {5, 10, 6, 4, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, 3, 0, 4, 7, 3, 6, 5, 10, -1, -1, -1, -1, -1, -1, -1}, {1, 9, 0, 5, 10, 6, 8, 4, 7, -1, -1, -1, -1, -1, -1, -1}, {10, 6, 5, 1, 9, 7, 1, 7, 3, 7, 9, 4, -1, -1, -1, -1}, {6, 1, 2, 6, 5, 1, 4, 7, 8, -1, -1, -1, -1, -1, -1, -1}, {1, 2, 5, 5, 2, 6, 3, 0, 4, 3, 4, 7, -1, -1, -1, -1}, {8, 4, 7, 9, 0, 5, 0, 6, 5, 0, 2, 6, -1, -1, -1, -1}, {7, 3, 9, 7, 9, 4, 3, 2, 9, 5, 9, 6, 2, 6, 9, -1}, {3, 11, 2, 7, 8, 4, 10, 6, 5, -1, -1, -1, -1, -1, -1, -1}, {5, 10, 6, 4, 7, 2, 4, 2, 0, 2, 7, 11, -1, -1, -1, -1}, {0, 1, 9, 4, 7, 8, 2, 3, 11, 5, 10, 6, -1, -1, -1, -1}, {9, 2, 1, 9, 11, 2, 9, 4, 11, 7, 11, 4, 5, 10, 6, -1}, {8, 4, 7, 3, 11, 5, 3, 5, 1, 5, 11, 6, -1, -1, -1, -1}, {5, 1, 11, 5, 11, 6, 1, 0, 11, 7, 11, 4, 0, 4, 11, -1}, {0, 5, 9, 0, 6, 5, 0, 3, 6, 11, 6, 3, 8, 4, 7, -1}, {6, 5, 9, 6, 9, 11, 4, 7, 9, 7, 11, 9, -1, -1, -1, -1}, {10, 4, 9, 6, 4, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, 10, 6, 4, 9, 10, 0, 8, 3, -1, -1, -1, -1, -1, -1, -1}, {10, 0, 1, 10, 6, 0, 6, 4, 0, -1, -1, -1, -1, -1, -1, -1}, {8, 3, 1, 8, 1, 6, 8, 6, 4, 6, 1, 10, -1, -1, -1, -1}, {1, 4, 9, 1, 2, 4, 2, 6, 4, -1, -1, -1, -1, -1, -1, -1}, {3, 0, 8, 1, 2, 9, 2, 4, 9, 2, 6, 4, -1, -1, -1, -1}, {0, 2, 4, 4, 2, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {8, 3, 2, 8, 2, 4, 4, 2, 6, -1, -1, -1, -1, -1, -1, -1}, {10, 4, 9, 10, 6, 4, 11, 2, 3, -1, -1, -1, -1, -1, -1, -1}, {0, 8, 2, 2, 8, 11, 4, 9, 10, 4, 10, 6, -1, -1, -1, -1}, {3, 11, 2, 0, 1, 6, 0, 6, 4, 6, 1, 10, -1, -1, -1, -1}, {6, 4, 1, 6, 1, 10, 4, 8, 1, 2, 1, 11, 8, 11, 1, -1}, {9, 6, 4, 9, 3, 6, 9, 1, 3, 11, 6, 3, -1, -1, -1, -1}, {8, 11, 1, 8, 1, 0, 11, 6, 1, 9, 1, 4, 6, 4, 1, -1}, {3, 11, 6, 3, 6, 0, 0, 6, 4, -1, -1, -1, -1, -1, -1, -1}, {6, 4, 8, 11, 6, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {7, 10, 6, 7, 8, 10, 8, 9, 10, -1, -1, -1, -1, -1, -1, -1}, {0, 7, 3, 0, 10, 7, 0, 9, 10, 6, 7, 10, -1, -1, -1, -1}, {10, 6, 7, 1, 10, 7, 1, 7, 8, 1, 8, 0, -1, -1, -1, -1}, {10, 6, 7, 10, 7, 1, 1, 7, 3, -1, -1, -1, -1, -1, -1, -1}, {1, 2, 6, 1, 6, 8, 1, 8, 9, 8, 6, 7, -1, -1, -1, -1}, {2, 6, 9, 2, 9, 1, 6, 7, 9, 0, 9, 3, 7, 3, 9, -1}, {7, 8, 0, 7, 0, 6, 6, 0, 2, -1, -1, -1, -1, -1, -1, -1}, {7, 3, 2, 6, 7, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, 3, 11, 10, 6, 8, 10, 8, 9, 8, 6, 7, -1, -1, -1, -1}, {2, 0, 7, 2, 7, 11, 0, 9, 7, 6, 7, 10, 9, 10, 7, -1}, {1, 8, 0, 1, 7, 8, 1, 10, 7, 6, 7, 10, 2, 3, 11, -1}, {11, 2, 1, 11, 1, 7, 10, 6, 1, 6, 7, 1, -1, -1, -1, -1}, {8, 9, 6, 8, 6, 7, 9, 1, 6, 11, 6, 3, 1, 3, 6, -1}, {0, 9, 1, 11, 6, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {7, 8, 0, 7, 0, 6, 3, 11, 0, 11, 6, 0, -1, -1, -1, -1}, {7, 11, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {7, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, 0, 8, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 9, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {8, 1, 9, 8, 3, 1, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1}, {10, 1, 2, 6, 11, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 2, 10, 3, 0, 8, 6, 11, 7, -1, -1, -1, -1, -1, -1, -1}, {2, 9, 0, 2, 10, 9, 6, 11, 7, -1, -1, -1, -1, -1, -1, -1}, {6, 11, 7, 2, 10, 3, 10, 8, 3, 10, 9, 8, -1, -1, -1, -1}, {7, 2, 3, 6, 2, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {7, 0, 8, 7, 6, 0, 6, 2, 0, -1, -1, -1, -1, -1, -1, -1}, {2, 7, 6, 2, 3, 7, 0, 1, 9, -1, -1, -1, -1, -1, -1, -1}, {1, 6, 2, 1, 8, 6, 1, 9, 8, 8, 7, 6, -1, -1, -1, -1}, {10, 7, 6, 10, 1, 7, 1, 3, 7, -1, -1, -1, -1, -1, -1, -1}, {10, 7, 6, 1, 7, 10, 1, 8, 7, 1, 0, 8, -1, -1, -1, -1}, {0, 3, 7, 0, 7, 10, 0, 10, 9, 6, 10, 7, -1, -1, -1, -1}, {7, 6, 10, 7, 10, 8, 8, 10, 9, -1, -1, -1, -1, -1, -1, -1}, {6, 8, 4, 11, 8, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, 6, 11, 3, 0, 6, 0, 4, 6, -1, -1, -1, -1, -1, -1, -1}, {8, 6, 11, 8, 4, 6, 9, 0, 1, -1, -1, -1, -1, -1, -1, -1}, {9, 4, 6, 9, 6, 3, 9, 3, 1, 11, 3, 6, -1, -1, -1, -1}, {6, 8, 4, 6, 11, 8, 2, 10, 1, -1, -1, -1, -1, -1, -1, -1}, {1, 2, 10, 3, 0, 11, 0, 6, 11, 0, 4, 6, -1, -1, -1, -1}, {4, 11, 8, 4, 6, 11, 0, 2, 9, 2, 10, 9, -1, -1, -1, -1}, {10, 9, 3, 10, 3, 2, 9, 4, 3, 11, 3, 6, 4, 6, 3, -1}, {8, 2, 3, 8, 4, 2, 4, 6, 2, -1, -1, -1, -1, -1, -1, -1}, {0, 4, 2, 4, 6, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 9, 0, 2, 3, 4, 2, 4, 6, 4, 3, 8, -1, -1, -1, -1}, {1, 9, 4, 1, 4, 2, 2, 4, 6, -1, -1, -1, -1, -1, -1, -1}, {8, 1, 3, 8, 6, 1, 8, 4, 6, 6, 10, 1, -1, -1, -1, -1}, {10, 1, 0, 10, 0, 6, 6, 0, 4, -1, -1, -1, -1, -1, -1, -1}, {4, 6, 3, 4, 3, 8, 6, 10, 3, 0, 3, 9, 10, 9, 3, -1}, {10, 9, 4, 6, 10, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, 9, 5, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 8, 3, 4, 9, 5, 11, 7, 6, -1, -1, -1, -1, -1, -1, -1}, {5, 0, 1, 5, 4, 0, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1}, {11, 7, 6, 8, 3, 4, 3, 5, 4, 3, 1, 5, -1, -1, -1, -1}, {9, 5, 4, 10, 1, 2, 7, 6, 11, -1, -1, -1, -1, -1, -1, -1}, {6, 11, 7, 1, 2, 10, 0, 8, 3, 4, 9, 5, -1, -1, -1, -1}, {7, 6, 11, 5, 4, 10, 4, 2, 10, 4, 0, 2, -1, -1, -1, -1}, {3, 4, 8, 3, 5, 4, 3, 2, 5, 10, 5, 2, 11, 7, 6, -1}, {7, 2, 3, 7, 6, 2, 5, 4, 9, -1, -1, -1, -1, -1, -1, -1}, {9, 5, 4, 0, 8, 6, 0, 6, 2, 6, 8, 7, -1, -1, -1, -1}, {3, 6, 2, 3, 7, 6, 1, 5, 0, 5, 4, 0, -1, -1, -1, -1}, {6, 2, 8, 6, 8, 7, 2, 1, 8, 4, 8, 5, 1, 5, 8, -1}, {9, 5, 4, 10, 1, 6, 1, 7, 6, 1, 3, 7, -1, -1, -1, -1}, {1, 6, 10, 1, 7, 6, 1, 0, 7, 8, 7, 0, 9, 5, 4, -1}, {4, 0, 10, 4, 10, 5, 0, 3, 10, 6, 10, 7, 3, 7, 10, -1}, {7, 6, 10, 7, 10, 8, 5, 4, 10, 4, 8, 10, -1, -1, -1, -1}, {6, 9, 5, 6, 11, 9, 11, 8, 9, -1, -1, -1, -1, -1, -1, -1}, {3, 6, 11, 0, 6, 3, 0, 5, 6, 0, 9, 5, -1, -1, -1, -1}, {0, 11, 8, 0, 5, 11, 0, 1, 5, 5, 6, 11, -1, -1, -1, -1}, {6, 11, 3, 6, 3, 5, 5, 3, 1, -1, -1, -1, -1, -1, -1, -1}, {1, 2, 10, 9, 5, 11, 9, 11, 8, 11, 5, 6, -1, -1, -1, -1}, {0, 11, 3, 0, 6, 11, 0, 9, 6, 5, 6, 9, 1, 2, 10, -1}, {11, 8, 5, 11, 5, 6, 8, 0, 5, 10, 5, 2, 0, 2, 5, -1}, {6, 11, 3, 6, 3, 5, 2, 10, 3, 10, 5, 3, -1, -1, -1, -1}, {5, 8, 9, 5, 2, 8, 5, 6, 2, 3, 8, 2, -1, -1, -1, -1}, {9, 5, 6, 9, 6, 0, 0, 6, 2, -1, -1, -1, -1, -1, -1, -1}, {1, 5, 8, 1, 8, 0, 5, 6, 8, 3, 8, 2, 6, 2, 8, -1}, {1, 5, 6, 2, 1, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 3, 6, 1, 6, 10, 3, 8, 6, 5, 6, 9, 8, 9, 6, -1}, {10, 1, 0, 10, 0, 6, 9, 5, 0, 5, 6, 0, -1, -1, -1, -1}, {0, 3, 8, 5, 6, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {10, 5, 6, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {11, 5, 10, 7, 5, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {11, 5, 10, 11, 7, 5, 8, 3, 0, -1, -1, -1, -1, -1, -1, -1}, {5, 11, 7, 5, 10, 11, 1, 9, 0, -1, -1, -1, -1, -1, -1, -1}, {10, 7, 5, 10, 11, 7, 9, 8, 1, 8, 3, 1, -1, -1, -1, -1}, {11, 1, 2, 11, 7, 1, 7, 5, 1, -1, -1, -1, -1, -1, -1, -1}, {0, 8, 3, 1, 2, 7, 1, 7, 5, 7, 2, 11, -1, -1, -1, -1}, {9, 7, 5, 9, 2, 7, 9, 0, 2, 2, 11, 7, -1, -1, -1, -1}, {7, 5, 2, 7, 2, 11, 5, 9, 2, 3, 2, 8, 9, 8, 2, -1}, {2, 5, 10, 2, 3, 5, 3, 7, 5, -1, -1, -1, -1, -1, -1, -1}, {8, 2, 0, 8, 5, 2, 8, 7, 5, 10, 2, 5, -1, -1, -1, -1}, {9, 0, 1, 5, 10, 3, 5, 3, 7, 3, 10, 2, -1, -1, -1, -1}, {9, 8, 2, 9, 2, 1, 8, 7, 2, 10, 2, 5, 7, 5, 2, -1}, {1, 3, 5, 3, 7, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 8, 7, 0, 7, 1, 1, 7, 5, -1, -1, -1, -1, -1, -1, -1}, {9, 0, 3, 9, 3, 5, 5, 3, 7, -1, -1, -1, -1, -1, -1, -1}, {9, 8, 7, 5, 9, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {5, 8, 4, 5, 10, 8, 10, 11, 8, -1, -1, -1, -1, -1, -1, -1}, {5, 0, 4, 5, 11, 0, 5, 10, 11, 11, 3, 0, -1, -1, -1, -1}, {0, 1, 9, 8, 4, 10, 8, 10, 11, 10, 4, 5, -1, -1, -1, -1}, {10, 11, 4, 10, 4, 5, 11, 3, 4, 9, 4, 1, 3, 1, 4, -1}, {2, 5, 1, 2, 8, 5, 2, 11, 8, 4, 5, 8, -1, -1, -1, -1}, {0, 4, 11, 0, 11, 3, 4, 5, 11, 2, 11, 1, 5, 1, 11, -1}, {0, 2, 5, 0, 5, 9, 2, 11, 5, 4, 5, 8, 11, 8, 5, -1}, {9, 4, 5, 2, 11, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, 5, 10, 3, 5, 2, 3, 4, 5, 3, 8, 4, -1, -1, -1, -1}, {5, 10, 2, 5, 2, 4, 4, 2, 0, -1, -1, -1, -1, -1, -1, -1}, {3, 10, 2, 3, 5, 10, 3, 8, 5, 4, 5, 8, 0, 1, 9, -1}, {5, 10, 2, 5, 2, 4, 1, 9, 2, 9, 4, 2, -1, -1, -1, -1}, {8, 4, 5, 8, 5, 3, 3, 5, 1, -1, -1, -1, -1, -1, -1, -1}, {0, 4, 5, 1, 0, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {8, 4, 5, 8, 5, 3, 9, 0, 5, 0, 3, 5, -1, -1, -1, -1}, {9, 4, 5, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, 11, 7, 4, 9, 11, 9, 10, 11, -1, -1, -1, -1, -1, -1, -1}, {0, 8, 3, 4, 9, 7, 9, 11, 7, 9, 10, 11, -1, -1, -1, -1}, {1, 10, 11, 1, 11, 4, 1, 4, 0, 7, 4, 11, -1, -1, -1, -1}, {3, 1, 4, 3, 4, 8, 1, 10, 4, 7, 4, 11, 10, 11, 4, -1}, {4, 11, 7, 9, 11, 4, 9, 2, 11, 9, 1, 2, -1, -1, -1, -1}, {9, 7, 4, 9, 11, 7, 9, 1, 11, 2, 11, 1, 0, 8, 3, -1}, {11, 7, 4, 11, 4, 2, 2, 4, 0, -1, -1, -1, -1, -1, -1, -1}, {11, 7, 4, 11, 4, 2, 8, 3, 4, 3, 2, 4, -1, -1, -1, -1}, {2, 9, 10, 2, 7, 9, 2, 3, 7, 7, 4, 9, -1, -1, -1, -1}, {9, 10, 7, 9, 7, 4, 10, 2, 7, 8, 7, 0, 2, 0, 7, -1}, {3, 7, 10, 3, 10, 2, 7, 4, 10, 1, 10, 0, 4, 0, 10, -1}, {1, 10, 2, 8, 7, 4, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, 9, 1, 4, 1, 7, 7, 1, 3, -1, -1, -1, -1, -1, -1, -1}, {4, 9, 1, 4, 1, 7, 0, 8, 1, 8, 7, 1, -1, -1, -1, -1}, {4, 0, 3, 7, 4, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {4, 8, 7, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {9, 10, 8, 10, 11, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, 0, 9, 3, 9, 11, 11, 9, 10, -1, -1, -1, -1, -1, -1, -1}, {0, 1, 10, 0, 10, 8, 8, 10, 11, -1, -1, -1, -1, -1, -1, -1}, {3, 1, 10, 11, 3, 10, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 2, 11, 1, 11, 9, 9, 11, 8, -1, -1, -1, -1, -1, -1, -1}, {3, 0, 9, 3, 9, 11, 1, 2, 9, 2, 11, 9, -1, -1, -1, -1}, {0, 2, 11, 8, 0, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, 2, 11, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, 3, 8, 2, 8, 10, 10, 8, 9, -1, -1, -1, -1, -1, -1, -1}, {9, 10, 2, 0, 9, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, 3, 8, 2, 8, 10, 0, 1, 8, 1, 10, 8, -1, -1, -1, -1}, {1, 10, 2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 3, 8, 9, 1, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 9, 1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {0, 3, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}};

    /*
     * Opcode count of 18734 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public MarchingCubes(DV dv) {
        this.Init();
        this.Calculer(dv);
    }

    /*
     * Opcode count of 18734 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public MarchingCubes(int[][][] voxel) {
        this.Init();
        this.Calculer(voxel);
    }

    private void Init() {
        int i2;
        for (i2 = 0; i2 < this.MAX_Tri; ++i2) {
            this.triangle[i2] = new TriangleMC();
            this.norm[i2] = new XYZMC();
        }
        for (i2 = 0; i2 < 12; ++i2) {
            this.centre_arrete[i2] = new XYZMC();
        }
        for (i2 = 0; i2 < 8; ++i2) {
            this.sommet[i2] = new XYZMC();
        }
    }

    private XYZMC normale(XYZMC a, XYZMC b, XYZMC c) {
        XYZMC ab = new XYZMC();
        XYZMC bc = new XYZMC();
        XYZMC vect = new XYZMC();
        XYZMC vect_norm = new XYZMC();
        ab.x = b.x - a.x;
        ab.y = b.y - a.y;
        ab.z = b.z - a.z;
        bc.x = c.x - b.x;
        bc.y = c.y - b.y;
        bc.z = c.z - b.z;
        vect.x = ab.y * bc.z - ab.z * bc.y;
        vect.y = ab.z * bc.x - ab.x * bc.z;
        vect.z = ab.x * bc.y - ab.y * bc.x;
        float N = (float)Math.sqrt(vect.x * vect.x + vect.y * vect.y + vect.z * vect.z);
        vect_norm.x = vect.x / N;
        vect_norm.y = vect.y / N;
        vect_norm.z = vect.z / N;
        return vect_norm;
    }

    private int ecrit_triangle(int index) {
        int ind_triTable = 0;
        int nb = 0;
        XYZMC vectnorm = new XYZMC(0.0f, 0.0f, 0.0f);
        while (this.triTable[index][ind_triTable] != -1) {
            this.triangle[this.nb_triangle].p[0].x = this.centre_arrete[this.triTable[index][ind_triTable]].x;
            this.triangle[this.nb_triangle].p[0].y = this.centre_arrete[this.triTable[index][ind_triTable]].y;
            this.triangle[this.nb_triangle].p[0].z = this.centre_arrete[this.triTable[index][ind_triTable]].z;
            this.triangle[this.nb_triangle].p[1].x = this.centre_arrete[this.triTable[index][ind_triTable + 1]].x;
            this.triangle[this.nb_triangle].p[1].y = this.centre_arrete[this.triTable[index][ind_triTable + 1]].y;
            this.triangle[this.nb_triangle].p[1].z = this.centre_arrete[this.triTable[index][ind_triTable + 1]].z;
            this.triangle[this.nb_triangle].p[2].x = this.centre_arrete[this.triTable[index][ind_triTable + 2]].x;
            this.triangle[this.nb_triangle].p[2].y = this.centre_arrete[this.triTable[index][ind_triTable + 2]].y;
            this.triangle[this.nb_triangle].p[2].z = this.centre_arrete[this.triTable[index][ind_triTable + 2]].z;
            this.norm[this.nb_triangle] = vectnorm = this.normale(this.triangle[this.nb_triangle].p[0], this.triangle[this.nb_triangle].p[1], this.triangle[this.nb_triangle].p[2]);
            ++this.nb_triangle;
            ++nb;
            ind_triTable += 3;
            if (this.nb_triangle != this.MAX_Tri) continue;
            System.err.println("Ereur <=> Nombre de triangle trop important => Augmenter Max_Tri");
            System.exit(0);
        }
        return nb;
    }

    private void coord_centre_arrete(int x, int y, int z) {
        for (int i2 = 0; i2 < 12; ++i2) {
            this.centre_arrete[i2].x = 0.0f;
            this.centre_arrete[i2].y = 0.0f;
            this.centre_arrete[i2].z = 0.0f;
        }
        if (this.arrete[0] != 0) {
            this.centre_arrete[0].x = (this.sommet[0].x + this.sommet[1].x) / 2.0f;
            this.centre_arrete[0].y = (this.sommet[0].y + this.sommet[1].y) / 2.0f;
            this.centre_arrete[0].z = (this.sommet[0].z + this.sommet[1].z) / 2.0f;
        }
        if (this.arrete[1] != 0) {
            this.centre_arrete[1].x = (this.sommet[1].x + this.sommet[2].x) / 2.0f;
            this.centre_arrete[1].y = (this.sommet[1].y + this.sommet[2].y) / 2.0f;
            this.centre_arrete[1].z = (this.sommet[1].z + this.sommet[2].z) / 2.0f;
        }
        if (this.arrete[2] != 0) {
            this.centre_arrete[2].x = (this.sommet[2].x + this.sommet[3].x) / 2.0f;
            this.centre_arrete[2].y = (this.sommet[2].y + this.sommet[3].y) / 2.0f;
            this.centre_arrete[2].z = (this.sommet[2].z + this.sommet[3].z) / 2.0f;
        }
        if (this.arrete[3] != 0) {
            this.centre_arrete[3].x = (this.sommet[3].x + this.sommet[0].x) / 2.0f;
            this.centre_arrete[3].y = (this.sommet[3].y + this.sommet[0].y) / 2.0f;
            this.centre_arrete[3].z = (this.sommet[3].z + this.sommet[0].z) / 2.0f;
        }
        if (this.arrete[4] != 0) {
            this.centre_arrete[4].x = (this.sommet[4].x + this.sommet[5].x) / 2.0f;
            this.centre_arrete[4].y = (this.sommet[4].y + this.sommet[5].y) / 2.0f;
            this.centre_arrete[4].z = (this.sommet[4].z + this.sommet[5].z) / 2.0f;
        }
        if (this.arrete[5] != 0) {
            this.centre_arrete[5].x = (this.sommet[5].x + this.sommet[6].x) / 2.0f;
            this.centre_arrete[5].y = (this.sommet[5].y + this.sommet[6].y) / 2.0f;
            this.centre_arrete[5].z = (this.sommet[5].z + this.sommet[6].z) / 2.0f;
        }
        if (this.arrete[6] != 0) {
            this.centre_arrete[6].x = (this.sommet[6].x + this.sommet[7].x) / 2.0f;
            this.centre_arrete[6].y = (this.sommet[6].y + this.sommet[7].y) / 2.0f;
            this.centre_arrete[6].z = (this.sommet[6].z + this.sommet[7].z) / 2.0f;
        }
        if (this.arrete[7] != 0) {
            this.centre_arrete[7].x = (this.sommet[7].x + this.sommet[4].x) / 2.0f;
            this.centre_arrete[7].y = (this.sommet[7].y + this.sommet[4].y) / 2.0f;
            this.centre_arrete[7].z = (this.sommet[7].z + this.sommet[4].z) / 2.0f;
        }
        if (this.arrete[8] != 0) {
            this.centre_arrete[8].x = (this.sommet[0].x + this.sommet[4].x) / 2.0f;
            this.centre_arrete[8].y = (this.sommet[0].y + this.sommet[4].y) / 2.0f;
            this.centre_arrete[8].z = (this.sommet[0].z + this.sommet[4].z) / 2.0f;
        }
        if (this.arrete[9] != 0) {
            this.centre_arrete[9].x = (this.sommet[1].x + this.sommet[5].x) / 2.0f;
            this.centre_arrete[9].y = (this.sommet[1].y + this.sommet[5].y) / 2.0f;
            this.centre_arrete[9].z = (this.sommet[1].z + this.sommet[5].z) / 2.0f;
        }
        if (this.arrete[10] != 0) {
            this.centre_arrete[10].x = (this.sommet[2].x + this.sommet[6].x) / 2.0f;
            this.centre_arrete[10].y = (this.sommet[2].y + this.sommet[6].y) / 2.0f;
            this.centre_arrete[10].z = (this.sommet[2].z + this.sommet[6].z) / 2.0f;
        }
        if (this.arrete[11] != 0) {
            this.centre_arrete[11].x = (this.sommet[3].x + this.sommet[7].x) / 2.0f;
            this.centre_arrete[11].y = (this.sommet[3].y + this.sommet[7].y) / 2.0f;
            this.centre_arrete[11].z = (this.sommet[3].z + this.sommet[7].z) / 2.0f;
        }
    }

    private void lecture_edge(int index) {
        for (int i2 = 0; i2 < 12; ++i2) {
            this.arrete[i2] = 0;
        }
        if ((this.edgeTable[index] & 1) != 0) {
            this.arrete[0] = 1;
        }
        if ((this.edgeTable[index] & 2) != 0) {
            this.arrete[1] = 1;
        }
        if ((this.edgeTable[index] & 4) != 0) {
            this.arrete[2] = 1;
        }
        if ((this.edgeTable[index] & 8) != 0) {
            this.arrete[3] = 1;
        }
        if ((this.edgeTable[index] & 0x10) != 0) {
            this.arrete[4] = 1;
        }
        if ((this.edgeTable[index] & 0x20) != 0) {
            this.arrete[5] = 1;
        }
        if ((this.edgeTable[index] & 0x40) != 0) {
            this.arrete[6] = 1;
        }
        if ((this.edgeTable[index] & 0x80) != 0) {
            this.arrete[7] = 1;
        }
        if ((this.edgeTable[index] & 0x100) != 0) {
            this.arrete[8] = 1;
        }
        if ((this.edgeTable[index] & 0x200) != 0) {
            this.arrete[9] = 1;
        }
        if ((this.edgeTable[index] & 0x400) != 0) {
            this.arrete[10] = 1;
        }
        if ((this.edgeTable[index] & 0x800) != 0) {
            this.arrete[11] = 1;
        }
    }

    private int Vox_to_int(DV dv, int x, int y, int z) {
        boolean index = false;
        throw new Error("Update coordinates");
    }

    private int Vox_to_int(int[][][] voxel, int x, int y, int z) {
        int index = 0;
        if (voxel[z][y][x] > 0) {
            index |= 1;
        }
        if (voxel[z][y][x + 1] > 0) {
            index |= 2;
        }
        if (voxel[z + 1][y][x + 1] > 0) {
            index |= 4;
        }
        if (voxel[z + 1][y][x] > 0) {
            index |= 8;
        }
        if (voxel[z][y + 1][x] > 0) {
            index |= 0x10;
        }
        if (voxel[z][y + 1][x + 1] > 0) {
            index |= 0x20;
        }
        if (voxel[z + 1][y + 1][x + 1] > 0) {
            index |= 0x40;
        }
        if (voxel[z + 1][y + 1][x] > 0) {
            index |= 0x80;
        }
        return index;
    }

    private int Calculer(DV dv) {
        int i2;
        for (i2 = 0; i2 < this.MAX_Tri; ++i2) {
            for (int j = 0; j < 3; ++j) {
                this.triangle[i2].p[j].x = 0.0f;
                this.triangle[i2].p[j].y = 0.0f;
                this.triangle[i2].p[j].z = 0.0f;
            }
        }
        this.nb_triangle = 0;
        for (int z = 0; z < dv.SizeZ - 1; ++z) {
            for (int y = 0; y < dv.SizeY - 1; ++y) {
                block9: for (int x = 0; x < dv.SizeX - 1; ++x) {
                    this.sommet[0].x = x;
                    this.sommet[0].y = y;
                    this.sommet[0].z = z;
                    this.sommet[1].x = x + 1;
                    this.sommet[1].y = y;
                    this.sommet[1].z = z;
                    this.sommet[2].x = x + 1;
                    this.sommet[2].y = y;
                    this.sommet[2].z = z + 1;
                    this.sommet[3].x = x;
                    this.sommet[3].y = y;
                    this.sommet[3].z = z + 1;
                    this.sommet[4].x = x;
                    this.sommet[4].y = y + 1;
                    this.sommet[4].z = z;
                    this.sommet[5].x = x + 1;
                    this.sommet[5].y = y + 1;
                    this.sommet[5].z = z;
                    this.sommet[6].x = x + 1;
                    this.sommet[6].y = y + 1;
                    this.sommet[6].z = z + 1;
                    this.sommet[7].x = x;
                    this.sommet[7].y = y + 1;
                    this.sommet[7].z = z + 1;
                    int indice_edge = this.Vox_to_int(dv, x, y, z);
                    this.lecture_edge(indice_edge);
                    this.coord_centre_arrete(x, y, z);
                    int nb = this.ecrit_triangle(indice_edge);
                    switch (dv.Type) {
                        case 8: {
                            if (dv.getVoxelByte(x, y, z, 0) == 0) continue block9;
                            for (i2 = 0; i2 < nb; ++i2) {
                                this.triangle[this.nb_triangle - 1 - i2].coul = (float)dv.getVoxelByte(x, y, z, 0) / 255.0f;
                            }
                            continue block9;
                        }
                        case 16: {
                            if (dv.getVoxelShort(x, y, z, 0) == 0) continue block9;
                            for (i2 = 0; i2 < nb; ++i2) {
                                this.triangle[this.nb_triangle - 1 - i2].coul = (float)dv.getVoxelShort(x, y, z, 0) / 255.0f;
                            }
                            continue block9;
                        }
                        case 32: {
                            if (dv.getVoxelInt(x, y, z, 0) == 0) continue block9;
                            for (i2 = 0; i2 < nb; ++i2) {
                                this.triangle[this.nb_triangle - 1 - i2].coul = (float)dv.getVoxelInt(x, y, z, 0) / 255.0f;
                            }
                            continue block9;
                        }
                    }
                }
            }
        }
        return 1;
    }

    private int Calculer(int[][][] voxel) {
        int i2;
        for (i2 = 0; i2 < this.MAX_Tri; ++i2) {
            for (int j = 0; j < 3; ++j) {
                this.triangle[i2].p[j].x = 0.0f;
                this.triangle[i2].p[j].y = 0.0f;
                this.triangle[i2].p[j].z = 0.0f;
            }
        }
        this.nb_triangle = 0;
        for (int z = 0; z < voxel.length - 1; ++z) {
            for (int y = 0; y < voxel[z].length - 1; ++y) {
                for (int x = 0; x < voxel[z][y].length - 1; ++x) {
                    this.sommet[0].x = x;
                    this.sommet[0].y = y;
                    this.sommet[0].z = z;
                    this.sommet[1].x = x + 1;
                    this.sommet[1].y = y;
                    this.sommet[1].z = z;
                    this.sommet[2].x = x + 1;
                    this.sommet[2].y = y;
                    this.sommet[2].z = z + 1;
                    this.sommet[3].x = x;
                    this.sommet[3].y = y;
                    this.sommet[3].z = z + 1;
                    this.sommet[4].x = x;
                    this.sommet[4].y = y + 1;
                    this.sommet[4].z = z;
                    this.sommet[5].x = x + 1;
                    this.sommet[5].y = y + 1;
                    this.sommet[5].z = z;
                    this.sommet[6].x = x + 1;
                    this.sommet[6].y = y + 1;
                    this.sommet[6].z = z + 1;
                    this.sommet[7].x = x;
                    this.sommet[7].y = y + 1;
                    this.sommet[7].z = z + 1;
                    int indice_edge = this.Vox_to_int(voxel, x, y, z);
                    this.lecture_edge(indice_edge);
                    this.coord_centre_arrete(x, y, z);
                    int nb = this.ecrit_triangle(indice_edge);
                    if (voxel[z][y][x] <= 0) continue;
                    for (i2 = 0; i2 < nb; ++i2) {
                        this.triangle[this.nb_triangle - 1 - i2].coul = (float)voxel[z][y][x] / 255.0f;
                    }
                }
            }
        }
        return 1;
    }
}

