/*
 * Decompiled with CFR 0.152.
 */
package dv;

import dv.DV;
import dv.DvNew;
import mathematics.Interpolations;

public class DvTransformations {
    public static DV Scale(DV source, double ratio, Interpolations.Methods3D interpolation) {
        return DvTransformations.Scale(source, ratio, ratio, ratio, interpolation);
    }

    public static DV Scale(DV source, double xratio, double yratio, double zratio, Interpolations.Methods3D interpolation) {
        DV result = new DV((int)((double)source.SizeX * xratio + 0.5), (int)((double)source.SizeX * yratio + 0.5), (int)((double)source.SizeX * zratio + 0.5), source.Channel, source.Type);
        DvTransformations.Scale(source, interpolation, result);
        return result;
    }

    public static void Scale(DV source, Interpolations.Methods3D interpolation, DV result) {
        double xratio = (double)source.SizeX / (double)result.SizeX;
        double yratio = (double)source.SizeY / (double)result.SizeY;
        double zratio = (double)source.SizeZ / (double)result.SizeZ;
        switch (source.Type) {
            case 8: {
                for (int c = 0; c < source.Channel; ++c) {
                    byte[] src = source.getDataBufferByte(c);
                    byte[] res = result.getDataBufferByte(c);
                    int pos = 0;
                    for (int z = 0; z < result.SizeZ; ++z) {
                        for (int y = 0; y < result.SizeY; ++y) {
                            int x = 0;
                            while (x < result.SizeX) {
                                res[pos] = Interpolations.Dispatch((double)x * xratio, (double)y * yratio, (double)z * zratio, interpolation, src, source.SizeX, source.SizeY, source.SizeZ, source.LayerSize);
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    res = null;
                    src = null;
                }
                break;
            }
            case 16: {
                for (int c = 0; c < source.Channel; ++c) {
                    short[] src = source.getDataBufferShort(c);
                    short[] res = result.getDataBufferShort(c);
                    int pos = 0;
                    for (int z = 0; z < result.SizeZ; ++z) {
                        for (int y = 0; y < result.SizeY; ++y) {
                            int x = 0;
                            while (x < result.SizeX) {
                                res[pos] = Interpolations.Dispatch((double)x * xratio, (double)y * yratio, (double)z * zratio, interpolation, src, source.SizeX, source.SizeY, source.SizeZ, source.LayerSize);
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    res = null;
                    src = null;
                }
                break;
            }
            case 32: {
                for (int c = 0; c < source.Channel; ++c) {
                    int[] src = source.getDataBufferInt(c);
                    int[] res = result.getDataBufferInt(c);
                    int pos = 0;
                    for (int z = 0; z < result.SizeZ; ++z) {
                        for (int y = 0; y < result.SizeY; ++y) {
                            int x = 0;
                            while (x < result.SizeX) {
                                res[pos] = Interpolations.Dispatch((double)x * xratio, (double)y * yratio, (double)z * zratio, interpolation, src, source.SizeX, source.SizeY, source.SizeZ, source.LayerSize);
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    res = null;
                    src = null;
                }
                break;
            }
            case -32: {
                for (int c = 0; c < source.Channel; ++c) {
                    float[] src = source.getDataBufferFloat(c);
                    float[] res = result.getDataBufferFloat(c);
                    int pos = 0;
                    for (int z = 0; z < result.SizeZ; ++z) {
                        for (int y = 0; y < result.SizeY; ++y) {
                            int x = 0;
                            while (x < result.SizeX) {
                                res[pos] = Interpolations.Dispatch((double)x * xratio, (double)y * yratio, (double)z * zratio, interpolation, src, source.SizeX, source.SizeY, source.SizeZ, source.LayerSize);
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    res = null;
                    src = null;
                }
                break;
            }
            case 64: {
                for (int c = 0; c < source.Channel; ++c) {
                    double[] src = source.getDataBufferDouble(c);
                    double[] res = result.getDataBufferDouble(c);
                    int pos = 0;
                    for (int z = 0; z < result.SizeZ; ++z) {
                        for (int y = 0; y < result.SizeY; ++y) {
                            int x = 0;
                            while (x < result.SizeX) {
                                res[pos] = Interpolations.Dispatch((double)x * xratio, (double)y * yratio, (double)z * zratio, interpolation, src, source.SizeX, source.SizeY, source.SizeZ, source.LayerSize);
                                ++x;
                                ++pos;
                            }
                        }
                    }
                    res = null;
                    src = null;
                }
                break;
            }
        }
    }

    public static DV ReshapeGreatter(DV source, int minimum) {
        DV result = new DV(Math.max(source.SizeX, minimum), Math.max(source.SizeY, minimum), Math.max(source.SizeZ, minimum), source.Channel, source.Type);
        DvTransformations.ReshapeGreatter(source, result);
        return result;
    }

    public static void ReshapeGreatter(DV source, DV result) {
        if (result.SizeX < source.SizeX) {
            throw new IllegalArgumentException("result.SizeX < source.SizeX");
        }
        if (result.SizeY < source.SizeY) {
            throw new IllegalArgumentException("result.SizeY < source.SizeY");
        }
        if (result.SizeZ < source.SizeZ) {
            throw new IllegalArgumentException("result.SizeZ < source.SizeZ");
        }
        int sx = result.SizeX - source.SizeX >> 1;
        int sy = result.SizeY - source.SizeY >> 1;
        int sz = result.SizeZ - source.SizeZ >> 1;
        DvNew.CopyIntoBigger((DV)source, (DV)result, (int)sx, (int)sy, (int)sz);
    }
}

