/*
 * Decompiled with CFR 0.152.
 */
package dv;

import arrayTiTi.ArrayIO;
import dv.DV;
import dv.DvConverter;
import imageTiTi.ImageIO;
import imageTiTi.ImageNew;
import io.FileInputStreamScanner;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import utils.strings.IntGenerator;
import utils.strings.StringToolsImageDV;

public class DvIO {
    public static final String MAGIC_DV = "DV\n";
    public static final String MAGIC_DVPP = "DV++\n";
    public static final int BMP = 0;
    public static final int IFF = 13;
    public static final int JPG = 3;
    public static final int JPEG = 3;
    public static final int PNG = 6;

    public static DV Read(String filename) throws IOException {
        int sc;
        System.out.print("Reading DV '" + filename + "'... ");
        System.out.flush();
        FileInputStreamScanner fist = new FileInputStreamScanner(filename);
        if (!fist.MagicNumber(MAGIC_DVPP)) {
            throw new IOException("The Magic Number does not match.");
        }
        int sx = fist.ReadInt();
        int sy = fist.ReadInt();
        int sz = fist.ReadInt();
        System.out.print("(" + sx + "x" + sy + "x" + sz + " <=> " + sx * sy * sz + " voxels on " + sc + " channel" + (1 < (sc = fist.ReadInt()) ? "s" : ""));
        System.out.flush();
        DV dv = null;
        BufferedImage im = javax.imageio.ImageIO.read(fist);
        block0 : switch (im.getType()) {
            case 10: {
                dv = new DV(sx, sy, sz, sc, 8);
                byte[] bb = ((DataBufferByte)im.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int c = 0;
                while (c < sc) {
                    System.arraycopy(bb, pos, dv.getDataBufferByte(c), 0, dv.Length);
                    ++c;
                    pos += dv.Length;
                }
                bb = null;
                break;
            }
            case 11: {
                dv = new DV(sx, sy, sz, sc, 16);
                short[] sb = ((DataBufferUShort)im.getRaster().getDataBuffer()).getData();
                int pos = 0;
                int c = 0;
                while (c < sc) {
                    System.arraycopy(sb, pos, dv.getDataBufferShort(c), 0, dv.Length);
                    ++c;
                    pos += dv.Length;
                }
                sb = null;
                break;
            }
            case 0: {
                switch (im.getRaster().getDataBuffer().getDataType()) {
                    case 0: {
                        dv = new DV(sx, sy, sz, sc, 8);
                        byte[] bb2 = ((DataBufferByte)im.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int c = 0;
                        while (c < sc) {
                            System.arraycopy(bb2, pos, dv.getDataBufferByte(c), 0, dv.Length);
                            ++c;
                            pos += dv.Length;
                        }
                        bb2 = null;
                        break block0;
                    }
                    case 5: {
                        dv = new DV(sx, sy, sz, sc, 64);
                        double[] db = ((DataBufferDouble)im.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int c = 0;
                        while (c < sc) {
                            System.arraycopy(db, pos, dv.getDataBufferDouble(c), 0, dv.Length);
                            ++c;
                            pos += dv.Length;
                        }
                        db = null;
                        break block0;
                    }
                    case 4: {
                        dv = new DV(sx, sy, sz, sc, -32);
                        float[] fb = ((DataBufferFloat)im.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int c = 0;
                        while (c < sc) {
                            System.arraycopy(fb, pos, dv.getDataBufferFloat(c), 0, dv.Length);
                            ++c;
                            pos += dv.Length;
                        }
                        fb = null;
                        break block0;
                    }
                    case 3: {
                        dv = new DV(sx, sy, sz, sc, 32);
                        int[] ib = ((DataBufferInt)im.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int c = 0;
                        while (c < sc) {
                            System.arraycopy(ib, pos, dv.getDataBufferInt(c), 0, dv.Length);
                            ++c;
                            pos += dv.Length;
                        }
                        ib = null;
                        break block0;
                    }
                    case 1: {
                        dv = new DV(sx, sy, sz, sc, 16);
                        short[] sb2 = ((DataBufferShort)im.getRaster().getDataBuffer()).getData();
                        int pos = 0;
                        int c = 0;
                        while (c < sc) {
                            System.arraycopy(sb2, pos, dv.getDataBufferShort(c), 0, dv.Length);
                            ++c;
                            pos += dv.Length;
                        }
                        sb2 = null;
                        break block0;
                    }
                }
                throw new IOException("DataBuffer type not supported.");
            }
            default: {
                throw new IOException("Image type not supported (yet).");
            }
        }
        System.out.println(", Type " + StringToolsImageDV.NameOfType((int)dv.Type) + "... successfully.");
        System.out.flush();
        im = null;
        return dv;
    }

    public static void Write(DV dv, String filename, int type) throws IOException {
        System.out.print("Writing DV '" + filename + "'... (" + dv.SizeX + "x" + dv.SizeY + "x" + dv.SizeZ + " <=> " + dv.Length + " voxels on " + dv.Channel + " channel" + (1 < dv.Channel ? "s" : "") + ", Type " + StringToolsImageDV.NameOfType((int)dv.Type) + "...");
        System.out.flush();
        File file = new File(filename);
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Cannot create file.");
        }
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(MAGIC_DVPP.getBytes());
        StringBuilder sb = new StringBuilder(113);
        sb.append(dv.SizeX).append(' ');
        sb.append(dv.SizeY).append(' ');
        sb.append(dv.SizeZ).append('\n');
        sb.append(dv.Channel).append('\n');
        fos.write(sb.toString().getBytes());
        sb = null;
        BufferedImage im = null;
        switch (dv.Type) {
            case 8: {
                im = new BufferedImage(dv.SizeX, dv.SizeY * dv.SizeZ * dv.Channel, 10);
                byte[] bbim = ((DataBufferByte)im.getRaster().getDataBuffer()).getData();
                for (int c = 0; c < dv.Channel; ++c) {
                    System.arraycopy(dv.getDataBufferByte(c), 0, bbim, c * dv.Length, dv.Length);
                }
                bbim = null;
                break;
            }
            case 16: {
                im = new BufferedImage(dv.Length * dv.Channel, 1, 11);
                short[] sbim = ((DataBufferUShort)im.getRaster().getDataBuffer()).getData();
                for (int c = 0; c < dv.Channel; ++c) {
                    System.arraycopy(dv.getDataBufferShort(c), 0, sbim, c * dv.Length, dv.Length);
                }
                sbim = null;
                break;
            }
            case 32: {
                im = ImageNew.Integer((int)(dv.Length * dv.Channel), (int)1, (int)1);
                int[] ibim = ((DataBufferInt)im.getRaster().getDataBuffer()).getData();
                for (int c = 0; c < dv.Channel; ++c) {
                    System.arraycopy(dv.getDataBufferInt(c), 0, ibim, c * dv.Length, dv.Length);
                }
                ibim = null;
                break;
            }
            case -32: {
                im = ImageNew.Float((int)(dv.Length * dv.Channel), (int)1, (int)1);
                float[] fbim = ((DataBufferFloat)im.getRaster().getDataBuffer()).getData();
                for (int c = 0; c < dv.Channel; ++c) {
                    System.arraycopy(dv.getDataBufferInt(c), 0, fbim, c * dv.Length, dv.Length);
                }
                fbim = null;
                break;
            }
            case 64: {
                im = ImageNew.Double((int)(dv.Length * dv.Channel), (int)1, (int)1);
                double[] dbim = ((DataBufferDouble)im.getRaster().getDataBuffer()).getData();
                for (int c = 0; c < dv.Channel; ++c) {
                    System.arraycopy(dv.getDataBufferInt(c), 0, dbim, c * dv.Length, dv.Length);
                }
                dbim = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        if (!javax.imageio.ImageIO.write((RenderedImage)im, ImageIO.TypeToExtension(type), fos)) {
            throw new IOException("Cannot write: '" + filename + "'.");
        }
        System.out.println(" successfully.");
        System.out.flush();
        im = null;
    }

    public static void WriteStack(DV dv, String dirpath, String filename, String type) throws IOException {
        DvIO.WriteStack(dv, dirpath, filename, ImageIO.ExtensionToType(type));
    }

    public static void WriteStack(DV dv, String dirpath, String filename, int type) throws IOException {
        System.out.println("Writing DV as a stack '" + dirpath + "/'... (" + dv.SizeX + "x" + dv.SizeY + " <=> " + dv.LayerSize + " pixels on " + dv.Channel + " channel" + (1 < dv.Channel ? "s" : "") + " x " + dv.SizeZ + " image" + (1 < dv.SizeZ ? "s" : "") + ", Type " + StringToolsImageDV.NameOfTypeDV((int)dv.Type) + "...");
        System.out.flush();
        File resdir = new File(dirpath);
        if (!resdir.exists() && !resdir.mkdirs()) {
            throw new IllegalStateException("Impossible to create result directory '" + resdir.getAbsolutePath() + "'.");
        }
        resdir = null;
        String path = dirpath + "/" + filename;
        if (type == -1) {
            throw new IllegalArgumentException("Unknow extension type: '" + type + "'.");
        }
        String ext = ImageIO.TypeToExtension(type);
        BufferedImage im = null;
        IntGenerator ig = new IntGenerator(0, dv.SizeZ);
        switch (dv.Type) {
            case 8: {
                if (3 < dv.Channel) {
                    throw new IllegalArgumentException("No more than 3 channels supported.");
                }
                im = new BufferedImage(dv.SizeX, dv.SizeY, dv.Channel == 1 ? 10 : 5);
                int pos = 0;
                int z = 0;
                while (z < dv.SizeZ) {
                    System.out.print(" - ");
                    DvConverter.DVtoBufferedImage(dv, z, im);
                    ImageIO.Write(im, path + "_" + ig.Next() + "." + ext, type);
                    ++z;
                    pos += dv.LayerSize;
                }
                break;
            }
            case 16: {
                if (1 < dv.Channel) {
                    throw new IllegalArgumentException("No more than one channel supported (so far).");
                }
                im = new BufferedImage(dv.SizeX, dv.SizeY, 11);
                short[] sbim = ((DataBufferUShort)im.getRaster().getDataBuffer()).getData();
                short[] sbdv = dv.getDataBufferShort(0);
                int pos = 0;
                int z = 0;
                while (z < dv.SizeZ) {
                    System.out.print(" - ");
                    System.arraycopy(sbdv, pos, sbim, 0, dv.LayerSize);
                    ImageIO.Write(im, path + "_" + ig.Next() + "." + ext, type);
                    ++z;
                    pos += dv.LayerSize;
                }
                sbdv = null;
                sbim = null;
                break;
            }
            case -32: {
                if (1 < dv.Channel) {
                    throw new IllegalArgumentException("No more than one channel supported (so far).");
                }
                im = ImageNew.Float((int)dv.SizeX, (int)dv.SizeY, (int)1);
                float[] fbim = ((DataBufferFloat)im.getRaster().getDataBuffer()).getData();
                float[] fbdv = dv.getDataBufferFloat(0);
                int pos = 0;
                int z = 0;
                while (z < dv.SizeZ) {
                    System.out.print(" - ");
                    System.arraycopy(fbdv, pos, fbim, 0, dv.LayerSize);
                    ImageIO.Write(im, path + "_" + ig.Next() + "." + ext, type);
                    ++z;
                    pos += dv.LayerSize;
                }
                fbdv = null;
                fbim = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
        System.out.println("DV written successfully.");
        System.out.flush();
        im = null;
    }

    public static DV ReadFromStack(String folder, FilenameFilter fnf) throws IOException, IllegalArgumentException {
        Object[] images = new File(folder).listFiles(fnf);
        Arrays.sort(images);
        return DvIO.ReadFromStack((File[])images, 0, images.length);
    }

    public static DV ReadFromStack(String folder, Comparator<File> comparator, FilenameFilter fnf) throws IOException, IllegalArgumentException {
        File[] images = new File(folder).listFiles(fnf);
        Arrays.sort(images, comparator);
        return DvIO.ReadFromStack(images, 0, images.length);
    }

    public static DV ReadFromStack(File[] images) throws IOException, IllegalArgumentException {
        return DvIO.ReadFromStack(images, 0, images.length);
    }

    public static DV ReadFromStack(File[] images, int start, int nbimages) throws IOException, IllegalArgumentException {
        DV dv = null;
        BufferedImage image = ImageIO.Read(images[start]);
        block0 : switch (image.getType()) {
            case 10: {
                dv = new DV(image.getWidth(), image.getHeight(), nbimages, 1, 8);
                break;
            }
            case 11: {
                dv = new DV(image.getWidth(), image.getHeight(), nbimages, 1, 16);
                break;
            }
            case 0: {
                switch (image.getRaster().getDataBuffer().getDataType()) {
                    case 3: {
                        dv = new DV(image.getWidth(), image.getHeight(), nbimages, 1, 32);
                        break block0;
                    }
                }
                throw new IllegalArgumentException("DataBuffer type not supported (yet).");
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
        DvIO.ReadFromStack(images, start, nbimages, dv);
        return dv;
    }

    public static void ReadFromStack(File[] images, int start, int nbimages, DV result) throws IOException, IllegalArgumentException {
        if (images.length == 0) {
            throw new IllegalArgumentException("No images found.");
        }
        if (nbimages != result.SizeZ) {
            throw new IllegalArgumentException("The number of images to read and the DV depth do not match (" + nbimages + " vs " + result.SizeZ + ")");
        }
        int pos = 0;
        for (int i2 = 0; i2 < nbimages; ++i2) {
            BufferedImage image = ImageIO.Read(images[start + i2]);
            if (image.getWidth() != result.SizeX || image.getHeight() != result.SizeY) {
                throw new IllegalArgumentException("Images have different dimensions or do not match with the DV dimensions.");
            }
            block0 : switch (image.getType()) {
                case 10: {
                    if (result.Type != 8) {
                        throw new IllegalArgumentException("Images have different types or do not match with the DV type.");
                    }
                    byte[] bb = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                    System.arraycopy(bb, 0, result.getDataBufferByte(0), pos, bb.length);
                    pos += bb.length;
                    bb = null;
                    break;
                }
                case 11: {
                    if (result.Type != 16) {
                        throw new IllegalArgumentException("Images have different types or do not match with the DV type.");
                    }
                    short[] sb = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                    System.arraycopy(sb, 0, result.getDataBufferShort(0), pos, sb.length);
                    pos += sb.length;
                    sb = null;
                    break;
                }
                case 0: {
                    switch (image.getRaster().getDataBuffer().getDataType()) {
                        case 3: {
                            if (result.Type != 32) {
                                throw new IllegalArgumentException("Images have different types or do not match with the DV type.");
                            }
                            int[] ib = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                            System.arraycopy(ib, 0, result.getDataBufferInt(0), pos, ib.length);
                            pos += ib.length;
                            ib = null;
                            break block0;
                        }
                    }
                    throw new IllegalArgumentException("DataBuffer type not supported (yet).");
                }
                default: {
                    throw new IllegalArgumentException("Image type not supported (yet).");
                }
            }
            image = null;
        }
    }

    public static void Display(DV dv, int channel, String name, String separator) {
        switch (dv.Type) {
            case 8: {
                ArrayIO.DisplayUnsigned(dv.getDataBufferByte(channel), dv.SizeX, dv.SizeY, dv.SizeZ, name, separator);
                break;
            }
            case 16: {
                ArrayIO.DisplayUnsigned(dv.getDataBufferShort(channel), dv.SizeX, dv.SizeY, dv.SizeZ, name, separator);
                break;
            }
            case 32: {
                ArrayIO.Display(dv.getDataBufferInt(channel), dv.SizeX, dv.SizeY, dv.SizeZ, name, separator);
                break;
            }
            case -32: {
                ArrayIO.Display(dv.getDataBufferFloat(channel), dv.SizeX, dv.SizeY, dv.SizeZ, name, separator);
                break;
            }
            case 64: {
                ArrayIO.Display(dv.getDataBufferDouble(channel), dv.SizeX, dv.SizeY, dv.SizeZ, name, separator);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }
}

