/*
 * Decompiled with CFR 0.152.
 */
package dv;

import arrayTiTi.ArrayConverter;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import imageTiTi.ImageNew;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import utils.strings.StringToolsImageDV;

public class DvConverter {
    private static String MessageError(DV source, DV target) {
        StringBuilder message = new StringBuilder(13);
        message.append("Configuration not supported: Convert(").append(StringToolsImageDV.NameOfType((int)source.Type)).append(",");
        message.append(StringToolsImageDV.NameOfType((int)target.Type)).append(")");
        return message.toString();
    }

    public static DV Universal(DV source, int type) {
        DV result = DvNew.Same((DV)source, (int)type);
        DvConverter.Universal(source, result);
        return result;
    }

    public static void Universal(DV source, DV target) {
        if (!DvTools.areDimensionsEqual((DV)source, (DV)target)) {
            throw new IllegalArgumentException("DVs have different type or dimensions.");
        }
        int length = source.Length;
        block26: for (int c = 0; c < source.Channel; ++c) {
            switch (source.Type) {
                case 8: {
                    switch (target.Type) {
                        case 8: {
                            System.arraycopy(source.getDataBufferByte(c), 0, target.getDataBufferByte(c), 0, length);
                            continue block26;
                        }
                        case 32: {
                            ArrayConverter.UnsignedByteToInt((byte[])source.getDataBufferByte(c), (int[])target.getDataBufferInt(c));
                            continue block26;
                        }
                        case 16: {
                            ArrayConverter.UnsignedByteToShort((byte[])source.getDataBufferByte(c), (short[])target.getDataBufferShort(c));
                            continue block26;
                        }
                        case -32: {
                            ArrayConverter.UnsignedByteToFloat((byte[])source.getDataBufferByte(c), (float[])target.getDataBufferFloat(c));
                            continue block26;
                        }
                        case 64: {
                            ArrayConverter.UnsignedByteToDouble((byte[])source.getDataBufferByte(c), (double[])target.getDataBufferDouble(c));
                            continue block26;
                        }
                    }
                    throw new IllegalArgumentException(DvConverter.MessageError(source, target));
                }
                case 16: {
                    switch (target.Type) {
                        case 8: {
                            ArrayConverter.UnsignedShortToByte((short[])source.getDataBufferShort(c), (byte[])target.getDataBufferByte(c));
                            continue block26;
                        }
                        case 32: {
                            ArrayConverter.UnsignedShortToInt((short[])source.getDataBufferShort(c), (int[])target.getDataBufferInt(c));
                            continue block26;
                        }
                        case 16: {
                            System.arraycopy(source.getDataBufferShort(c), 0, target.getDataBufferShort(c), 0, length);
                            continue block26;
                        }
                        case -32: {
                            ArrayConverter.UnsignedShortToFloat((short[])source.getDataBufferShort(c), (float[])target.getDataBufferFloat(c));
                            continue block26;
                        }
                        case 64: {
                            ArrayConverter.UnsignedShortToDouble((short[])source.getDataBufferShort(c), (double[])target.getDataBufferDouble(c));
                            continue block26;
                        }
                    }
                    throw new IllegalArgumentException(DvConverter.MessageError(source, target));
                }
                case 32: {
                    switch (target.Type) {
                        case 8: {
                            ArrayConverter.IntToByte((int[])source.getDataBufferInt(c), (byte[])target.getDataBufferByte(c));
                            continue block26;
                        }
                        case 32: {
                            System.arraycopy(source.getDataBufferInt(c), 0, target.getDataBufferInt(c), 0, length);
                            continue block26;
                        }
                        case 16: {
                            ArrayConverter.IntToShort((int[])source.getDataBufferInt(c), (short[])target.getDataBufferShort(c));
                            continue block26;
                        }
                        case -32: {
                            ArrayConverter.IntToFloat((int[])source.getDataBufferInt(c), (float[])target.getDataBufferFloat(c));
                            continue block26;
                        }
                        case 64: {
                            ArrayConverter.IntToDouble((int[])source.getDataBufferInt(c), (double[])target.getDataBufferDouble(c));
                            continue block26;
                        }
                    }
                    throw new IllegalArgumentException(DvConverter.MessageError(source, target));
                }
                default: {
                    throw new IllegalArgumentException(DvConverter.MessageError(source, target));
                }
            }
        }
    }

    public static BufferedImage DVtoBufferedImage(DV dv, int slice) {
        if (dv.Channel == 1) {
            return DvConverter.DVtoBufferedImage(dv, 0, slice);
        }
        if (3 < dv.Channel) {
            throw new IllegalArgumentException("Maximum 3 channels required.");
        }
        BufferedImage result = null;
        switch (dv.Type) {
            case 8: {
                result = new BufferedImage(dv.SizeX, dv.SizeY, 5);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
        DvConverter.DVtoBufferedImage(dv, slice, result);
        return result;
    }

    public static void DVtoBufferedImage(DV dv, int slice, BufferedImage result) {
        if (dv.Channel == 1) {
            DvConverter.DVtoBufferedImage(dv, 0, slice, result);
            return;
        }
        int width = dv.SizeX;
        int height = dv.SizeY;
        if (width != result.getWidth() || height != result.getHeight()) {
            throw new IllegalArgumentException("DV and image dimensions do not match.");
        }
        int pos = dv.LayerSize * slice;
        switch (dv.Type) {
            case 8: {
                if (result.getType() != 5) {
                    throw new IllegalArgumentException("DV and image type do not match.");
                }
                byte[] bb = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                for (int c = 0; c < dv.Channel; ++c) {
                    byte[] band = dv.getDataBufferByte(c);
                    int posim = c;
                    int posdv = pos;
                    for (int y = 0; y < height; ++y) {
                        int x = 0;
                        while (x < width) {
                            bb[posim] = band[posdv];
                            ++x;
                            posim += 3;
                            ++posdv;
                        }
                    }
                    band = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported (yet).");
            }
        }
    }

    public static BufferedImage DVtoBufferedImage(DV dv, int channel, int slice) {
        BufferedImage result = null;
        switch (dv.Type) {
            case 8: {
                result = new BufferedImage(dv.SizeX, dv.SizeY, 10);
                break;
            }
            case 16: {
                result = new BufferedImage(dv.SizeX, dv.SizeY, 11);
                break;
            }
            case 32: {
                result = ImageNew.Integer((int)dv.SizeX, (int)dv.SizeY, (int)1);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
        DvConverter.DVtoBufferedImage(dv, channel, slice, result);
        return result;
    }

    public static void DVtoBufferedImage(DV dv, int channel, int slice, BufferedImage result) {
        if (dv.SizeX != result.getWidth() || dv.SizeY != result.getHeight()) {
            throw new IllegalArgumentException("DV and image dimensions do not match.");
        }
        switch (dv.Type) {
            case 8: {
                if (result.getType() != 10) {
                    throw new IllegalArgumentException("DV and image type do not match.");
                }
                System.arraycopy(dv.getDataBufferByte(channel), slice * dv.LayerSize, ((DataBufferByte)result.getRaster().getDataBuffer()).getData(), 0, dv.LayerSize);
                break;
            }
            case 16: {
                if (result.getType() != 11) {
                    throw new IllegalArgumentException("DV and image type do not match.");
                }
                System.arraycopy(dv.getDataBufferShort(channel), slice * dv.LayerSize, ((DataBufferUShort)result.getRaster().getDataBuffer()).getData(), 0, dv.LayerSize);
                break;
            }
            case 32: {
                if (result.getType() != 0 && result.getRaster().getDataBuffer().getDataType() != 3) {
                    throw new IllegalArgumentException("DV and image type do not match.");
                }
                System.arraycopy(dv.getDataBufferInt(channel), slice * dv.LayerSize, ((DataBufferInt)result.getRaster().getDataBuffer()).getData(), 0, dv.LayerSize);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
    }

    public static void DVtoBufferedImage(DV dv, int dvstartx, int dvstarty, int dvstartz, int lengthx, int lengthy, int lengthz, BufferedImage[] result, int imstartx, int imstarty, int imstartnum) {
        int imwidth = result[imstartnum].getWidth();
        int dvwidth = dv.SizeX;
        int pos = imstarty * imwidth + imstartx;
        switch (dv.Type) {
            case 8: {
                if (result[imstartnum].getType() != 10) {
                    throw new IllegalArgumentException("DV and image type do not match.");
                }
                byte[] bbdv = dv.getDataBufferByte(0);
                for (int z = 0; z < lengthz; ++z) {
                    byte[] bbim = ((DataBufferByte)result[imstartnum + z].getRaster().getDataBuffer()).getData();
                    int y = 0;
                    int impos = pos;
                    int dvpos = dv.Position(dvstartx, dvstarty, dvstartz + z);
                    while (y < lengthy) {
                        System.arraycopy(bbdv, dvpos, bbim, impos, lengthx);
                        ++y;
                        impos += imwidth;
                        dvpos += dvwidth;
                    }
                    bbim = null;
                }
                bbdv = null;
                break;
            }
            case 16: {
                if (result[imstartnum].getType() != 11) {
                    throw new IllegalArgumentException("DV and image type do not match.");
                }
                short[] sbdv = dv.getDataBufferShort(0);
                for (int z = 0; z < lengthz; ++z) {
                    short[] sbim = ((DataBufferUShort)result[imstartnum + z].getRaster().getDataBuffer()).getData();
                    int y = 0;
                    int impos = pos;
                    int dvpos = dv.Position(dvstartx, dvstarty, dvstartz + z);
                    while (y < lengthy) {
                        System.arraycopy(sbdv, dvpos, sbim, impos, lengthx);
                        ++y;
                        impos += imwidth;
                        dvpos += dvwidth;
                    }
                    sbim = null;
                }
                sbdv = null;
                break;
            }
            case -32: {
                if (result[imstartnum].getRaster().getDataBuffer().getDataType() != 4) {
                    throw new IllegalArgumentException("DV and image type do not match.");
                }
                float[] fbdv = dv.getDataBufferFloat(0);
                for (int z = 0; z < lengthz; ++z) {
                    float[] fbim = ((DataBufferFloat)result[imstartnum + z].getRaster().getDataBuffer()).getData();
                    int y = 0;
                    int impos = pos;
                    int dvpos = dv.Position(dvstartx, dvstarty, dvstartz + z);
                    while (y < lengthy) {
                        System.arraycopy(fbdv, dvpos, fbim, impos, lengthx);
                        ++y;
                        impos += imwidth;
                        dvpos += dvwidth;
                    }
                    fbim = null;
                }
                fbdv = null;
                break;
            }
            case 64: {
                if (result[imstartnum].getRaster().getDataBuffer().getDataType() != 5) {
                    throw new IllegalArgumentException("DV and image type do not match.");
                }
                double[] dbdv = dv.getDataBufferDouble(0);
                for (int z = 0; z < lengthz; ++z) {
                    double[] dbim = ((DataBufferDouble)result[imstartnum + z].getRaster().getDataBuffer()).getData();
                    int y = 0;
                    int impos = pos;
                    int dvpos = dv.Position(dvstartx, dvstarty, dvstartz + z);
                    while (y < lengthy) {
                        System.arraycopy(dbdv, dvpos, dbim, impos, lengthx);
                        ++y;
                        impos += imwidth;
                        dvpos += dvwidth;
                    }
                    dbim = null;
                }
                dbdv = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
    }

    public static BufferedImage DvXZtoBufferedImage(DV dv, int channel, int xz) {
        BufferedImage result = null;
        switch (dv.Type) {
            case 8: {
                result = new BufferedImage(dv.SizeX, dv.SizeZ, 10);
                break;
            }
            case 16: {
                result = new BufferedImage(dv.SizeX, dv.SizeZ, 11);
                break;
            }
            case 32: {
                result = ImageNew.Integer((int)dv.SizeX, (int)dv.SizeZ, (int)1);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
        DvConverter.DvXZtoBufferedImage(dv, channel, xz, result);
        return result;
    }

    public static void DvXZtoBufferedImage(DV dv, int channel, int xz, BufferedImage result) {
        if (dv.SizeX != result.getWidth() || dv.SizeZ != result.getHeight()) {
            throw new IllegalArgumentException("DV and image dimensions do not match.");
        }
        switch (dv.Type) {
            case 8: {
                if (result.getType() != 10) {
                    throw new IllegalArgumentException("DV and image type do not match.");
                }
                byte[] bbim = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                byte[] bbdv = dv.getDataBufferByte(channel);
                int pos2 = 0;
                int z = 0;
                int pos = xz * dv.SizeX;
                while (z < dv.SizeZ) {
                    System.arraycopy(bbdv, pos, bbim, pos2, dv.SizeX);
                    ++z;
                    pos += dv.LayerSize;
                    pos2 += dv.SizeX;
                }
                bbdv = null;
                bbim = null;
                break;
            }
            case 16: {
                if (result.getType() != 11) {
                    throw new IllegalArgumentException("DV and image type do not match.");
                }
                short[] sbim = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                short[] sbdv = dv.getDataBufferShort(channel);
                int pos2 = 0;
                int z = 0;
                int pos = xz * dv.SizeX;
                while (z < dv.SizeZ) {
                    System.arraycopy(sbdv, pos, sbim, pos2, dv.SizeX);
                    ++z;
                    pos += dv.LayerSize;
                    pos2 += dv.SizeX;
                }
                sbdv = null;
                sbim = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
    }

    public static BufferedImage DvYZtoBufferedImage(DV dv, int channel, int yz) {
        BufferedImage result = null;
        switch (dv.Type) {
            case 8: {
                result = new BufferedImage(dv.SizeY, dv.SizeZ, 10);
                break;
            }
            case 16: {
                result = new BufferedImage(dv.SizeY, dv.SizeZ, 11);
                break;
            }
            case 32: {
                result = ImageNew.Integer((int)dv.SizeY, (int)dv.SizeZ, (int)1);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
        DvConverter.DvYZtoBufferedImage(dv, channel, yz, result);
        return result;
    }

    public static void DvYZtoBufferedImage(DV dv, int channel, int yz, BufferedImage result) {
        if (dv.SizeY != result.getWidth() || dv.SizeZ != result.getHeight()) {
            throw new IllegalArgumentException("DV and image dimensions do not match.");
        }
        switch (dv.Type) {
            case 8: {
                if (result.getType() != 10) {
                    throw new IllegalArgumentException("DV and image type do not match.");
                }
                byte[] bbim = ((DataBufferByte)result.getRaster().getDataBuffer()).getData();
                byte[] bbdv = dv.getDataBufferByte(channel);
                int pos2 = 0;
                int pos = yz;
                for (int z = 0; z < dv.SizeZ; ++z) {
                    int y = 0;
                    while (y < dv.SizeY) {
                        bbim[pos2] = bbdv[pos];
                        ++y;
                        pos += dv.SizeX;
                        ++pos2;
                    }
                }
                bbdv = null;
                bbim = null;
                break;
            }
            case 16: {
                if (result.getType() != 11) {
                    throw new IllegalArgumentException("DV and image type do not match.");
                }
                short[] sbim = ((DataBufferUShort)result.getRaster().getDataBuffer()).getData();
                short[] sbdv = dv.getDataBufferShort(channel);
                int pos2 = 0;
                int pos = yz;
                for (int z = 0; z < dv.SizeZ; ++z) {
                    int y = 0;
                    while (y < dv.SizeY) {
                        sbim[pos2] = sbdv[pos];
                        ++y;
                        pos += dv.SizeX;
                        ++pos2;
                    }
                }
                sbdv = null;
                sbim = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
    }

    public static void BufferedImageToDV(BufferedImage image, DV dv, int channel, int slice) {
        if (image.getWidth() != dv.SizeX || image.getHeight() != dv.SizeY) {
            throw new IllegalArgumentException("Image and DV have different dimensions.");
        }
        if (image.getRaster().getNumBands() != dv.Channel) {
            throw new IllegalArgumentException("Image and DV have different number of bands/channels.");
        }
        if (dv.Channel != 1) {
            throw new IllegalArgumentException("Only mono-channel DV are supported (so far).");
        }
        switch (dv.Type) {
            case 8: {
                if (image.getRaster().getDataBuffer().getDataType() != 0) {
                    throw new IllegalArgumentException("Image and DV have different DataBuffer type.");
                }
                byte[] bbim = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                byte[] bbdv = dv.getDataBufferByte(channel);
                System.arraycopy(bbim, 0, bbdv, slice * dv.LayerSize, dv.LayerSize);
                bbdv = null;
                bbim = null;
                break;
            }
            case 16: {
                if (image.getRaster().getDataBuffer().getDataType() != 1) {
                    throw new IllegalArgumentException("Image and DV have different DataBuffer type.");
                }
                short[] sbim = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                short[] sbdv = dv.getDataBufferShort(channel);
                System.arraycopy(sbim, 0, sbdv, slice * dv.LayerSize, dv.LayerSize);
                sbdv = null;
                sbim = null;
                break;
            }
            case 32: {
                if (image.getRaster().getDataBuffer().getDataType() != 3) {
                    throw new IllegalArgumentException("Image and DV have different DataBuffer type.");
                }
                int[] ibim = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                int[] ibdv = dv.getDataBufferInt(channel);
                System.arraycopy(ibim, 0, ibdv, slice * dv.LayerSize, dv.LayerSize);
                ibdv = null;
                ibim = null;
                break;
            }
            case -32: {
                if (image.getRaster().getDataBuffer().getDataType() != 4) {
                    throw new IllegalArgumentException("Image and DV have different DataBuffer type.");
                }
                float[] fbim = ((DataBufferFloat)image.getRaster().getDataBuffer()).getData();
                float[] fbdv = dv.getDataBufferFloat(channel);
                System.arraycopy(fbim, 0, fbdv, slice * dv.LayerSize, dv.LayerSize);
                fbdv = null;
                fbim = null;
                break;
            }
            case 64: {
                if (image.getRaster().getDataBuffer().getDataType() != 5) {
                    throw new IllegalArgumentException("Image and DV have different DataBuffer type.");
                }
                double[] dbim = ((DataBufferDouble)image.getRaster().getDataBuffer()).getData();
                double[] dbdv = dv.getDataBufferDouble(channel);
                System.arraycopy(dbim, 0, dbdv, slice * dv.LayerSize, dv.LayerSize);
                dbdv = null;
                dbim = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown DV type.");
            }
        }
    }

    public static void BufferedImageToDV(BufferedImage[] images, int imstartx, int imstarty, int lengthx, int lengthy, int imstart, int nbimages, DV dv, int dvstartx, int dvstarty, int dvstartz) {
        for (int i2 = 0; i2 < nbimages; ++i2) {
            DvConverter.BufferedImageToDV(images[imstart + i2], imstartx, imstarty, lengthx, lengthy, dv, dvstartx, dvstarty, dvstartz + i2);
        }
    }

    public static void BufferedImageToDV(BufferedImage image, int imstartx, int imstarty, int lengthx, int lengthy, DV dv, int dvstartx, int dvstarty, int dvstartz) {
        if (image.getRaster().getNumBands() != dv.Channel) {
            throw new IllegalArgumentException("Image and DV have different number of bands/channels.");
        }
        if (dv.Channel != 1) {
            throw new IllegalArgumentException("Only mono-channel DV are supported (so far).");
        }
        int imwidth = image.getWidth();
        int dvwidth = dv.SizeX;
        int impos = imstarty * imwidth + imstartx;
        int dvpos = dv.Position(dvstartx, dvstarty, dvstartz);
        switch (dv.Type) {
            case 8: {
                if (image.getRaster().getDataBuffer().getDataType() != 0) {
                    throw new IllegalArgumentException("Image and DV have different DataBuffer type.");
                }
                byte[] bbim = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
                byte[] bbdv = dv.getDataBufferByte(0);
                int y = 0;
                while (y < lengthy) {
                    System.arraycopy(bbim, impos, bbdv, dvpos, lengthx);
                    ++y;
                    impos += imwidth;
                    dvpos += dvwidth;
                }
                bbdv = null;
                bbim = null;
                break;
            }
            case 16: {
                if (image.getRaster().getDataBuffer().getDataType() != 1) {
                    throw new IllegalArgumentException("Image and DV have different DataBuffer type.");
                }
                short[] sbim = ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                short[] sbdv = dv.getDataBufferShort(0);
                int y = 0;
                while (y < lengthy) {
                    System.arraycopy(sbim, impos, sbdv, dvpos, lengthx);
                    ++y;
                    impos += imwidth;
                    dvpos += dvwidth;
                }
                sbdv = null;
                sbim = null;
                break;
            }
            case 32: {
                if (image.getRaster().getDataBuffer().getDataType() != 3) {
                    throw new IllegalArgumentException("Image and DV have different DataBuffer type.");
                }
                int[] ibim = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
                int[] ibdv = dv.getDataBufferInt(0);
                int y = 0;
                while (y < lengthy) {
                    System.arraycopy(ibim, impos, ibdv, dvpos, lengthx);
                    ++y;
                    impos += imwidth;
                    dvpos += dvwidth;
                }
                ibdv = null;
                ibim = null;
                break;
            }
            case -32: {
                if (image.getRaster().getDataBuffer().getDataType() != 4) {
                    throw new IllegalArgumentException("Image and DV have different DataBuffer type.");
                }
                float[] fbim = ((DataBufferFloat)image.getRaster().getDataBuffer()).getData();
                float[] fbdv = dv.getDataBufferFloat(0);
                int y = 0;
                while (y < lengthy) {
                    System.arraycopy(fbim, impos, fbdv, dvpos, lengthx);
                    ++y;
                    impos += imwidth;
                    dvpos += dvwidth;
                }
                fbdv = null;
                fbim = null;
                break;
            }
            case 64: {
                if (image.getRaster().getDataBuffer().getDataType() != 5) {
                    throw new IllegalArgumentException("Image and DV have different DataBuffer type.");
                }
                double[] dbim = ((DataBufferDouble)image.getRaster().getDataBuffer()).getData();
                double[] dbdv = dv.getDataBufferDouble(0);
                int y = 0;
                while (y < lengthy) {
                    System.arraycopy(dbim, impos, dbdv, dvpos, lengthx);
                    ++y;
                    impos += imwidth;
                    dvpos += dvwidth;
                }
                dbdv = null;
                dbim = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown DV type.");
            }
        }
    }

    public static BufferedImage[] DVtoStack(DV dv, int channel) {
        BufferedImage[] results = new BufferedImage[dv.SizeZ];
        switch (dv.Type) {
            case 8: {
                for (int z = 0; z < dv.SizeZ; ++z) {
                    results[z] = new BufferedImage(dv.SizeX, dv.SizeY, 10);
                }
                break;
            }
            case 16: {
                for (int z = 0; z < dv.SizeZ; ++z) {
                    results[z] = new BufferedImage(dv.SizeX, dv.SizeY, 11);
                }
                break;
            }
            case 32: {
                for (int z = 0; z < dv.SizeZ; ++z) {
                    results[z] = ImageNew.Integer((int)dv.SizeX, (int)dv.SizeY, (int)1);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
        DvConverter.DVtoStack(dv, channel, results);
        return results;
    }

    public static void DVtoStack(DV dv, int channel, BufferedImage[] results) {
        for (int z = 0; z < dv.SizeZ; ++z) {
            DvConverter.DVtoBufferedImage(dv, channel, z, results[z]);
        }
    }
}

