/*
 * Decompiled with CFR 0.152.
 */
package dv;

import arrayTiTi.ArrayArithmetic;
import dv.DV;
import dv.DvNew;
import dv.DvTools;
import utils.strings.StringToolsImageDV;

public class DvArithmetic {
    private static String MessageError(DV src1, Object src2, DV res) {
        StringBuilder message = new StringBuilder(1111);
        message.append("Configuration not supported: Add/Sub(");
        message.append(StringToolsImageDV.NameOfType((int)src1.Type)).append(", ");
        if (src2 instanceof DV) {
            message.append(StringToolsImageDV.NameOfType((int)((DV)src2).Type)).append(", ");
        } else if (src2 instanceof Integer) {
            message.append("int, ");
        } else if (src2 instanceof Float) {
            message.append("float, ");
        } else if (src2 instanceof Double) {
            message.append("double, ");
        } else {
            throw new Error("Bug: must not occured.");
        }
        message.append(StringToolsImageDV.NameOfType((int)res.Type)).append(", ");
        message.append("int, int)");
        return message.toString();
    }

    public static DV Add(DV src1, DV src2) {
        DV result = DvNew.Same((DV)src2);
        DvArithmetic.Add(src1, src2, result);
        return result;
    }

    public static void Add(DV src1, DV src2, DV Result) {
        if (!DvTools.areDimensionsEqual((DV)src1, (DV)src2) || !DvTools.areDimensionsEqual((DV)src1, (DV)Result)) {
            throw new IllegalArgumentException("Different DV dimensions.");
        }
        block12: for (int c = 0; c < src1.Channel; ++c) {
            switch (src2.Type) {
                case 8: {
                    switch (src1.Type) {
                        case 8: {
                            if (Result.Type != 8) {
                                throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                            }
                            ArrayArithmetic.AddUnsigned((byte[])src1.getDataBufferByte(c), (byte[])src2.getDataBufferByte(c), (byte[])Result.getDataBufferByte(c));
                            continue block12;
                        }
                        case 16: {
                            if (Result.Type != 16) {
                                throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                            }
                            ArrayArithmetic.AddUnsigned((short[])src1.getDataBufferShort(c), (byte[])src2.getDataBufferByte(c), (short[])Result.getDataBufferShort(c));
                            continue block12;
                        }
                        case -32: {
                            if (Result.Type != -32) {
                                throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                            }
                            ArrayArithmetic.Add((float[])src1.getDataBufferFloat(c), (byte[])src2.getDataBufferByte(c), (float[])Result.getDataBufferFloat(c));
                            continue block12;
                        }
                    }
                    throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                }
                case 16: {
                    if (src1.Type != 16 || Result.Type != 16) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.AddUnsigned((short[])src1.getDataBufferShort(c), (short[])src2.getDataBufferShort(c), (short[])Result.getDataBufferShort(c));
                    continue block12;
                }
                case 64: {
                    if (src1.Type != 64 || Result.Type != 64) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.Add((double[])src1.getDataBufferDouble(c), (double[])src2.getDataBufferDouble(c), (double[])Result.getDataBufferDouble(c));
                    continue block12;
                }
                case -32: {
                    if (src1.Type != -32 || Result.Type != -32) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.Add((float[])src1.getDataBufferFloat(c), (float[])src2.getDataBufferFloat(c), (float[])Result.getDataBufferFloat(c));
                    continue block12;
                }
                case 32: {
                    if (src1.Type != 32 || Result.Type != 32) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.Add((int[])src1.getDataBufferInt(c), (int[])src2.getDataBufferInt(c), (int[])Result.getDataBufferInt(c));
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                }
            }
        }
    }

    public static DV Add(DV src1, DV src2, int Threshold, int SafeValue) {
        DV result = DvNew.Same((DV)src2);
        DvArithmetic.Add(src1, src2, result, Threshold, SafeValue);
        return result;
    }

    public static void Add(DV src1, DV src2, DV Result, int Threshold, int SafeValue) {
        if (!DvTools.areDimensionsEqual((DV)src1, (DV)src2) || !DvTools.areDimensionsEqual((DV)src1, (DV)Result)) {
            throw new IllegalArgumentException("Differents DV dimensions.");
        }
        block15: for (int c = 0; c < src1.Channel; ++c) {
            switch (src1.Type) {
                case 8: {
                    switch (src2.Type) {
                        case 8: {
                            switch (Result.Type) {
                                case 8: {
                                    ArrayArithmetic.AddUnsigned((byte[])src1.getDataBufferByte(c), (byte[])src2.getDataBufferByte(c), (byte[])Result.getDataBufferByte(c), (byte)((byte)Threshold), (byte)((byte)SafeValue));
                                    continue block15;
                                }
                                case 16: {
                                    ArrayArithmetic.AddUnsigned((byte[])src1.getDataBufferByte(c), (byte[])src2.getDataBufferByte(c), (short[])Result.getDataBufferShort(c), (int)Threshold, (int)SafeValue);
                                    continue block15;
                                }
                            }
                            throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                        }
                        case 16: {
                            if (Result.Type != 16) {
                                throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                            }
                            ArrayArithmetic.AddUnsigned((byte[])src1.getDataBufferByte(c), (short[])src2.getDataBufferShort(c), (short[])Result.getDataBufferShort(c), (int)Threshold, (int)SafeValue);
                            continue block15;
                        }
                    }
                    throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                }
                case 16: {
                    if (src2.Type != 16 || Result.Type != 16) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.AddUnsigned((short[])src1.getDataBufferShort(c), (short[])src2.getDataBufferShort(c), (short[])Result.getDataBufferShort(c), (short)((short)Threshold), (short)((short)SafeValue));
                    continue block15;
                }
                case 32: {
                    if (src2.Type != 32 || Result.Type != 32) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.Add((int[])src1.getDataBufferInt(c), (int[])src2.getDataBufferInt(c), (int[])Result.getDataBufferInt(c), (int)Threshold, (int)SafeValue);
                    continue block15;
                }
                case -32: {
                    if (src2.Type != -32 || Result.Type != -32) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.Add((float[])src1.getDataBufferFloat(c), (float[])src2.getDataBufferFloat(c), (float[])Result.getDataBufferFloat(c), (float)Threshold, (float)SafeValue);
                    continue block15;
                }
                case 64: {
                    if (src2.Type != 64 || Result.Type != 64) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.Add((double[])src1.getDataBufferDouble(c), (double[])src2.getDataBufferDouble(c), (double[])Result.getDataBufferDouble(c), (double)Threshold, (double)SafeValue);
                    continue block15;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                }
            }
        }
    }

    public static DV Add(DV Original, int Value, int Threshold, int SafeValue) {
        DV result = DvNew.Same((DV)Original);
        DvArithmetic.Add(Original, Value, result, Threshold, SafeValue);
        return result;
    }

    public static void Add(DV Source2, int Value, DV Result, int Threshold, int SafeValue) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)Source2, (DV)Result)) {
            throw new IllegalArgumentException("Differents DV types or dimensions.");
        }
        block7: for (int c = 0; c < Source2.Channel; ++c) {
            switch (Source2.Type) {
                case 8: {
                    ArrayArithmetic.AddUnsigned((byte[])Source2.getDataBufferByte(c), (byte)((byte)Value), (byte[])Result.getDataBufferByte(c), (byte)((byte)Threshold), (byte)((byte)SafeValue));
                    continue block7;
                }
                case 16: {
                    ArrayArithmetic.AddUnsigned((short[])Source2.getDataBufferShort(c), (short)((short)Value), (short[])Result.getDataBufferShort(c), (short)((short)Threshold), (short)((short)SafeValue));
                    continue block7;
                }
                case 32: {
                    ArrayArithmetic.Add((int[])Source2.getDataBufferInt(c), (int)Value, (int[])Result.getDataBufferInt(c), (int)Threshold, (int)SafeValue);
                    continue block7;
                }
                case -32: {
                    ArrayArithmetic.Add((float[])Source2.getDataBufferFloat(c), (float)Value, (float[])Result.getDataBufferFloat(c), (float)Threshold, (float)SafeValue);
                    continue block7;
                }
                case 64: {
                    ArrayArithmetic.Add((double[])Source2.getDataBufferDouble(c), (double)Value, (double[])Result.getDataBufferDouble(c), (double)Threshold, (double)SafeValue);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(Source2, Value, Result));
                }
            }
        }
    }

    public static DV Add(DV Original, double Value, int Threshold, int SafeValue) {
        DV result = DvNew.Same((DV)Original);
        DvArithmetic.Add(Original, Value, result, Threshold, SafeValue);
        return result;
    }

    public static void Add(DV Source2, double Value, DV Result, int Threshold, int SafeValue) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)Source2, (DV)Result)) {
            throw new IllegalArgumentException("Differents DV types or dimensions.");
        }
        block4: for (int c = 0; c < Source2.Channel; ++c) {
            switch (Source2.Type) {
                case -32: {
                    ArrayArithmetic.Add((float[])Source2.getDataBufferFloat(c), (float)((float)Value), (float[])Result.getDataBufferFloat(c), (float)Threshold, (float)SafeValue);
                    continue block4;
                }
                case 64: {
                    ArrayArithmetic.Add((double[])Source2.getDataBufferDouble(c), (double)Value, (double[])Result.getDataBufferDouble(c), (double)Threshold, (double)SafeValue);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(Source2, Value, Result));
                }
            }
        }
    }

    public static DV Add(DV Original, double Value) {
        DV result = DvNew.Same((DV)Original);
        DvArithmetic.Add(Original, Value, result);
        return result;
    }

    public static void Add(DV Source2, double Value, DV Result) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)Source2, (DV)Result)) {
            throw new IllegalArgumentException("Differents DV types or dimensions.");
        }
        block4: for (int c = 0; c < Source2.Channel; ++c) {
            switch (Source2.Type) {
                case -32: {
                    ArrayArithmetic.Add((float[])Source2.getDataBufferFloat(c), (float)((float)Value), (float[])Result.getDataBufferFloat(c));
                    continue block4;
                }
                case 64: {
                    ArrayArithmetic.Add((double[])Source2.getDataBufferDouble(c), (double)Value, (double[])Result.getDataBufferDouble(c));
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(Source2, Value, Result));
                }
            }
        }
    }

    public static DV Subtract(DV src1, DV src2) {
        DV result = DvNew.Same((DV)src2);
        DvArithmetic.Subtract(src1, src2, result);
        return result;
    }

    public static void Subtract(DV src1, DV src2, DV Result) {
        if (!DvTools.areDimensionsEqual((DV)src1, (DV)src2) || !DvTools.areDimensionsEqual((DV)src1, (DV)Result)) {
            throw new IllegalArgumentException("Different DV dimensions.");
        }
        block11: for (int c = 0; c < src1.Channel; ++c) {
            switch (src2.Type) {
                case 8: {
                    switch (src1.Type) {
                        case 8: {
                            if (Result.Type != 8) {
                                throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                            }
                            ArrayArithmetic.SubtractUnsigned((byte[])src1.getDataBufferByte(c), (byte[])src2.getDataBufferByte(c), (byte[])Result.getDataBufferByte(c));
                            continue block11;
                        }
                        case 16: {
                            if (Result.Type != 16) {
                                throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                            }
                            ArrayArithmetic.SubtractUnsigned((short[])src1.getDataBufferShort(c), (byte[])src2.getDataBufferByte(c), (short[])Result.getDataBufferShort(c));
                            continue block11;
                        }
                    }
                    throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                }
                case 16: {
                    if (src1.Type != 16 || Result.Type != 16) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.SubtractUnsigned((short[])src1.getDataBufferShort(c), (short[])src2.getDataBufferShort(c), (short[])Result.getDataBufferShort(c));
                    continue block11;
                }
                case 64: {
                    if (src1.Type != 64 || Result.Type != 64) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.Subtract((double[])src1.getDataBufferDouble(c), (double[])src2.getDataBufferDouble(c), (double[])Result.getDataBufferDouble(c));
                    continue block11;
                }
                case -32: {
                    if (src1.Type != -32 || Result.Type != -32) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.Subtract((float[])src1.getDataBufferFloat(c), (float[])src2.getDataBufferFloat(c), (float[])Result.getDataBufferFloat(c));
                    continue block11;
                }
                case 32: {
                    if (src1.Type != 32 || Result.Type != 32) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.Subtract((int[])src1.getDataBufferInt(c), (int[])src2.getDataBufferInt(c), (int[])Result.getDataBufferInt(c));
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                }
            }
        }
    }

    public static DV Subtract(DV src1, DV src2, int Threshold, int SafeValue) {
        DV result = DvNew.Same((DV)src2);
        DvArithmetic.Subtract(src1, src2, result, Threshold, SafeValue);
        return result;
    }

    public static void Subtract(DV src1, DV src2, DV Result, int Threshold, int SafeValue) {
        if (!DvTools.areDimensionsEqual((DV)src1, (DV)src2) || !DvTools.areDimensionsEqual((DV)src1, (DV)Result)) {
            throw new IllegalArgumentException("Differents DV dimensions.");
        }
        block7: for (int c = 0; c < src1.Channel; ++c) {
            switch (src1.Type) {
                case 8: {
                    if (src2.Type != 8 || Result.Type != 8) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.SubtractUnsigned((byte[])src1.getDataBufferByte(c), (byte[])src2.getDataBufferByte(c), (byte[])Result.getDataBufferByte(c), (byte)((byte)Threshold), (byte)((byte)SafeValue));
                    continue block7;
                }
                case 16: {
                    if (src2.Type != 16 || Result.Type != 16) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.SubtractUnsigned((short[])src1.getDataBufferShort(c), (short[])src2.getDataBufferShort(c), (short[])Result.getDataBufferShort(c), (short)((short)Threshold), (short)((short)SafeValue));
                    continue block7;
                }
                case 32: {
                    if (src2.Type != 32 || Result.Type != 32) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.Subtract((int[])src1.getDataBufferInt(c), (int[])src2.getDataBufferInt(c), (int[])Result.getDataBufferInt(c), (int)Threshold, (int)SafeValue);
                    continue block7;
                }
                case -32: {
                    if (src2.Type != -32 || Result.Type != -32) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.Subtract((float[])src1.getDataBufferFloat(c), (float[])src2.getDataBufferFloat(c), (float[])Result.getDataBufferFloat(c), (float)Threshold, (float)SafeValue);
                    continue block7;
                }
                case 64: {
                    if (src2.Type != 64 || Result.Type != 64) {
                        throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                    }
                    ArrayArithmetic.Subtract((double[])src1.getDataBufferDouble(c), (double[])src2.getDataBufferDouble(c), (double[])Result.getDataBufferDouble(c), (double)Threshold, (double)SafeValue);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(src1, src2, Result));
                }
            }
        }
    }

    public static DV Subtract(DV Original, int Value) {
        DV result = DvNew.Same((DV)Original);
        DvArithmetic.Subtract(Original, Value, result);
        return result;
    }

    public static void Subtract(DV Source2, int Value, DV Result) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)Source2, (DV)Result)) {
            throw new IllegalArgumentException("Differents DV types or dimensions.");
        }
        block7: for (int c = 0; c < Source2.Channel; ++c) {
            switch (Source2.Type) {
                case 8: {
                    ArrayArithmetic.SubtractUnsigned((byte[])Source2.getDataBufferByte(c), (byte)((byte)Value), (byte[])Result.getDataBufferByte(c));
                    continue block7;
                }
                case 16: {
                    ArrayArithmetic.SubtractUnsigned((short[])Source2.getDataBufferShort(c), (short)((short)Value), (short[])Result.getDataBufferShort(c));
                    continue block7;
                }
                case 32: {
                    ArrayArithmetic.Subtract((int[])Source2.getDataBufferInt(c), (int)Value, (int[])Result.getDataBufferInt(c));
                    continue block7;
                }
                case -32: {
                    ArrayArithmetic.Subtract((float[])Source2.getDataBufferFloat(c), (float)Value, (float[])Result.getDataBufferFloat(c));
                    continue block7;
                }
                case 64: {
                    ArrayArithmetic.Subtract((double[])Source2.getDataBufferDouble(c), (double)Value, (double[])Result.getDataBufferDouble(c));
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(Source2, Value, Result));
                }
            }
        }
    }

    public static DV Subtract(DV Original, int Value, int Threshold, int SafeValue) {
        DV result = DvNew.Same((DV)Original);
        DvArithmetic.Subtract(Original, Value, result, Threshold, SafeValue);
        return result;
    }

    public static void Subtract(DV Source2, int Value, DV Result, int Threshold, int SafeValue) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)Source2, (DV)Result)) {
            throw new IllegalArgumentException("Differents DV types or dimensions.");
        }
        block7: for (int c = 0; c < Source2.Channel; ++c) {
            switch (Source2.Type) {
                case 8: {
                    ArrayArithmetic.SubtractUnsigned((byte[])Source2.getDataBufferByte(c), (byte)((byte)Value), (byte[])Result.getDataBufferByte(c), (byte)((byte)Threshold), (byte)((byte)SafeValue));
                    continue block7;
                }
                case 16: {
                    ArrayArithmetic.SubtractUnsigned((short[])Source2.getDataBufferShort(c), (short)((short)Value), (short[])Result.getDataBufferShort(c), (short)((short)Threshold), (short)((short)SafeValue));
                    continue block7;
                }
                case 32: {
                    ArrayArithmetic.Subtract((int[])Source2.getDataBufferInt(c), (int)Value, (int[])Result.getDataBufferInt(c), (int)Threshold, (int)SafeValue);
                    continue block7;
                }
                case -32: {
                    ArrayArithmetic.Subtract((float[])Source2.getDataBufferFloat(c), (float)Value, (float[])Result.getDataBufferFloat(c), (float)Threshold, (float)SafeValue);
                    continue block7;
                }
                case 64: {
                    ArrayArithmetic.Subtract((double[])Source2.getDataBufferDouble(c), (double)Value, (double[])Result.getDataBufferDouble(c), (double)Threshold, (double)SafeValue);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(Source2, Value, Result));
                }
            }
        }
    }

    public static DV Subtract(DV Original, double Value, double Threshold, double SafeValue) {
        DV result = DvNew.Same((DV)Original);
        DvArithmetic.Subtract(Original, Value, result, Threshold, SafeValue);
        return result;
    }

    public static void Subtract(DV Source2, double Value, DV Result, double Threshold, double SafeValue) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)Source2, (DV)Result)) {
            throw new IllegalArgumentException("Differents DV types or dimensions.");
        }
        block4: for (int c = 0; c < Source2.Channel; ++c) {
            switch (Source2.Type) {
                case -32: {
                    ArrayArithmetic.Subtract((float[])Source2.getDataBufferFloat(c), (float)((float)Value), (float[])Result.getDataBufferFloat(c), (float)((float)Threshold), (float)((float)SafeValue));
                    continue block4;
                }
                case 64: {
                    ArrayArithmetic.Subtract((double[])Source2.getDataBufferDouble(c), (double)Value, (double[])Result.getDataBufferDouble(c), (double)Threshold, (double)SafeValue);
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(Source2, Value, Result));
                }
            }
        }
    }

    public static DV Subtract(DV Original, double Value) {
        DV result = DvNew.Same((DV)Original);
        DvArithmetic.Subtract(Original, Value, result);
        return result;
    }

    public static void Subtract(DV Source2, double Value, DV Result) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)Source2, (DV)Result)) {
            throw new IllegalArgumentException("Differents DV types or dimensions.");
        }
        block4: for (int c = 0; c < Source2.Channel; ++c) {
            switch (Source2.Type) {
                case -32: {
                    ArrayArithmetic.Subtract((float[])Source2.getDataBufferFloat(c), (float)((float)Value), (float[])Result.getDataBufferFloat(c));
                    continue block4;
                }
                case 64: {
                    ArrayArithmetic.Subtract((double[])Source2.getDataBufferDouble(c), (double)Value, (double[])Result.getDataBufferDouble(c));
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(Source2, Value, Result));
                }
            }
        }
    }

    public static DV Multiply(DV Original, double Value, int minvalue, int safetymin, int maxvalue, int safetymax) {
        DV result = DvNew.Same((DV)Original);
        DvArithmetic.Multiply(Original, Value, result, minvalue, safetymin, maxvalue, safetymax);
        return result;
    }

    public static void Multiply(DV Source2, double Value, DV Result, int minvalue, int safetymin, int maxvalue, int safetymax) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)Source2, (DV)Result)) {
            throw new IllegalArgumentException("Differents DV types or dimensions.");
        }
        block7: for (int c = 0; c < Source2.Channel; ++c) {
            switch (Source2.Type) {
                case 8: {
                    ArrayArithmetic.MultiplyUnsigned((byte[])Source2.getDataBufferByte(c), (double)Value, (byte[])Result.getDataBufferByte(c), (int)minvalue, (int)safetymin, (int)maxvalue, (int)safetymax);
                    continue block7;
                }
                case 16: {
                    ArrayArithmetic.MultiplyUnsigned((short[])Source2.getDataBufferShort(c), (double)Value, (short[])Result.getDataBufferShort(c), (int)minvalue, (int)safetymin, (int)maxvalue, (int)safetymax);
                    continue block7;
                }
                case 32: {
                    ArrayArithmetic.Multiply((int[])Source2.getDataBufferInt(c), (double)Value, (int[])Result.getDataBufferInt(c), (int)minvalue, (int)safetymin, (int)maxvalue, (int)safetymax);
                    continue block7;
                }
                case -32: {
                    ArrayArithmetic.Multiply((float[])Source2.getDataBufferFloat(c), (float)((float)Value), (float[])Result.getDataBufferFloat(c), (float)minvalue, (float)safetymin, (float)maxvalue, (float)safetymax);
                    continue block7;
                }
                case 64: {
                    ArrayArithmetic.Multiply((double[])Source2.getDataBufferDouble(c), (double)Value, (double[])Result.getDataBufferDouble(c), (double)minvalue, (double)safetymin, (double)maxvalue, (double)safetymax);
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(Source2, Value, Result));
                }
            }
        }
    }

    public static DV Multiply(DV Original, double Value) {
        DV result = DvNew.Same((DV)Original);
        DvArithmetic.Multiply(Original, Value, result);
        return result;
    }

    public static void Multiply(DV Source2, double Value, DV Result) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)Source2, (DV)Result)) {
            throw new IllegalArgumentException("Differents DV types or dimensions.");
        }
        block7: for (int c = 0; c < Source2.Channel; ++c) {
            switch (Source2.Type) {
                case 8: {
                    ArrayArithmetic.MultiplyUnsigned((byte[])Source2.getDataBufferByte(c), (double)Value, (byte[])Result.getDataBufferByte(c));
                    continue block7;
                }
                case 16: {
                    ArrayArithmetic.MultiplyUnsigned((short[])Source2.getDataBufferShort(c), (double)Value, (short[])Result.getDataBufferShort(c));
                    continue block7;
                }
                case 32: {
                    ArrayArithmetic.Multiply((int[])Source2.getDataBufferInt(c), (double)Value, (int[])Result.getDataBufferInt(c));
                    continue block7;
                }
                case -32: {
                    ArrayArithmetic.Multiply((float[])Source2.getDataBufferFloat(c), (float)((float)Value), (float[])Result.getDataBufferFloat(c));
                    continue block7;
                }
                case 64: {
                    ArrayArithmetic.Multiply((double[])Source2.getDataBufferDouble(c), (double)Value, (double[])Result.getDataBufferDouble(c));
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException(DvArithmetic.MessageError(Source2, Value, Result));
                }
            }
        }
    }

    public static DV Modulo(DV Original, int Modulo) {
        DV result = DvNew.Same((DV)Original);
        DvArithmetic.Modulo(Original, Modulo, result);
        return result;
    }

    public static void Modulo(DV Source2, int Modulo, DV Result) {
        if (!DvTools.areDimensionsAndTypeEqual((DV)Source2, (DV)Result)) {
            throw new IllegalArgumentException("Differents DV types or dimensions.");
        }
        block5: for (int c = 0; c < Source2.Channel; ++c) {
            switch (Source2.Type) {
                case 8: {
                    ArrayArithmetic.Modulo((byte[])Source2.getDataBufferByte(c), (byte)((byte)Modulo), (byte[])Result.getDataBufferByte(c));
                    continue block5;
                }
                case 16: {
                    ArrayArithmetic.Modulo((short[])Source2.getDataBufferShort(c), (short)((short)Modulo), (short[])Result.getDataBufferShort(c));
                    continue block5;
                }
                case 32: {
                    ArrayArithmetic.Modulo((int[])Source2.getDataBufferInt(c), (int)Modulo, (int[])Result.getDataBufferInt(c));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("DV type not supported.");
                }
            }
        }
    }
}

