/*
 * Decompiled with CFR 0.152.
 */
package displays;

import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;

public class Window_Organizer
implements PlugIn {
    private NonBlockingGenericDialog nbgd = new NonBlockingGenericDialog("Window Organizer");
    private double Epsilon = 0.001;
    public final double[] zoomvalues = new double[]{0.031, 0.042, 0.062, 0.083, 0.125, 0.167, 0.25, 0.333, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 6.0, 8.0, 12.0, 16.0, 32.0};

    public void run(String arg0) {
        Box box = Box.createVerticalBox();
        Button buttonZoom = new Button("Same zoom location");
        buttonZoom.setEnabled(true);
        buttonZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window_Organizer.this.SameZoom();
                Window_Organizer.this.SameZoom();
            }
        });
        Button buttonPos = new Button("Same window position");
        buttonPos.setEnabled(true);
        buttonPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window_Organizer.this.SamePosition();
            }
        });
        Button buttonDim = new Button("Same window dimensions");
        buttonDim.setEnabled(true);
        buttonDim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window_Organizer.this.SameDimensions();
            }
        });
        Button buttonroi = new Button("Same ROI <=> Shift+e");
        buttonroi.setEnabled(true);
        buttonroi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window_Organizer.this.SameROI();
            }
        });
        box.add(buttonZoom);
        box.add(buttonPos);
        box.add(buttonDim);
        box.add(buttonroi);
        this.nbgd.add((Component)box);
        this.nbgd.addMessage(" ");
        this.nbgd.addMessage(" ");
        this.nbgd.setSize(200, 100);
        this.nbgd.addNotify();
        this.nbgd.showDialog();
    }

    public void Zoom(double zoom, String windowtitle) {
        List<ImageWindow> windows = Window_Organizer.FindWindows();
        for (int i2 = 0; i2 < windows.size(); ++i2) {
            if (!windows.get(i2).getTitle().equalsIgnoreCase(windowtitle)) continue;
            ImagePlus imp = windows.get(i2).getImagePlus();
            this.Zoom(windows.get(i2), zoom, imp.getWidth() >> 1, imp.getHeight() >> 1);
            return;
        }
    }

    public void Zoom(double zoom, int x, int y, String windowtitle) {
        List<ImageWindow> windows = Window_Organizer.FindWindows();
        for (int i2 = 0; i2 < windows.size(); ++i2) {
            if (!windows.get(i2).getTitle().equalsIgnoreCase(windowtitle)) continue;
            this.Zoom(windows.get(i2), zoom, x, y);
            return;
        }
    }

    public void Zoom(ImageWindow window, double zoom, int imx, int imy) {
        zoom = this.CheckZoom(zoom);
        ImagePlus imp = window.getImagePlus();
        ImageCanvas ic = imp.getCanvas();
        boolean worked = false;
        while (Math.abs(ic.getMagnification() - zoom) > this.Epsilon) {
            if (ic.getMagnification() < zoom) {
                ic.zoomIn(ic.screenX(imx), ic.screenY(imy));
            } else {
                ic.zoomOut(window.getWidth() >> 1, window.getHeight() >> 1);
            }
            worked = true;
        }
        if (!worked) {
            Rectangle srcRect = ic.getSrcRect();
            int x = srcRect.x + (srcRect.width >> 1);
            int y = srcRect.y + (srcRect.height >> 1);
            if (x != imx || y != imy) {
                srcRect.x = imx - (srcRect.width >> 1);
                srcRect.y = imy - (srcRect.height >> 1);
            }
        }
        imp.repaintWindow();
    }

    public void SameZoom() {
        List<ImageWindow> windows = Window_Organizer.FindWindows();
        if (WindowManager.getCurrentWindow() == null) {
            return;
        }
        String title = WindowManager.getCurrentWindow().getTitle();
        ImagePlus imp = WindowManager.getCurrentWindow().getImagePlus();
        ImageCanvas ic = imp.getCanvas();
        Rectangle srcRect = ic.getSrcRect();
        for (int i2 = 0; i2 < windows.size(); ++i2) {
            if (windows.get(i2).getTitle().equalsIgnoreCase(title)) continue;
            this.Zoom(windows.get(i2), ic.getMagnification(), srcRect.x + (srcRect.width >> 1), srcRect.y + (srcRect.height >> 1));
        }
    }

    public void SameZoom(double zoom) {
        if (WindowManager.getCurrentWindow() == null) {
            return;
        }
        this.SameZoom(WindowManager.getCurrentWindow().getImagePlus().getBufferedImage().getWidth() >> 1, WindowManager.getCurrentWindow().getImagePlus().getBufferedImage().getHeight() >> 1, zoom);
    }

    public void SameZoom(int x, int y, double zoom) {
        List<ImageWindow> windows = Window_Organizer.FindWindows();
        for (int i2 = 0; i2 < windows.size(); ++i2) {
            this.Zoom(windows.get(i2), zoom, x, y);
        }
    }

    private double CheckZoom(double zoom) {
        if (Math.abs(zoom - 0.031) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 0.042) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 0.062) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 0.083) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 0.125) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 0.167) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 0.25) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 0.333) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 0.5) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 0.75) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 1.0) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 1.5) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 2.0) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 3.0) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 4.0) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 6.0) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 8.0) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 12.0) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 16.0) < this.Epsilon) {
            return zoom;
        }
        if (Math.abs(zoom - 32.0) < this.Epsilon) {
            return zoom;
        }
        if (zoom < 0.031) {
            return 0.031;
        }
        if (zoom < 0.042) {
            return 0.042;
        }
        if (zoom < 0.062) {
            return 0.062;
        }
        if (zoom < 0.083) {
            return 0.083;
        }
        if (zoom < 0.125) {
            return 0.125;
        }
        if (zoom < 0.167) {
            return 0.167;
        }
        if (zoom < 0.25) {
            return 0.25;
        }
        if (zoom < 0.333) {
            return 0.333;
        }
        if (zoom < 0.5) {
            return 0.5;
        }
        if (zoom < 0.75) {
            return 0.75;
        }
        if (zoom < 1.0) {
            return 1.0;
        }
        if (zoom < 1.5) {
            return 1.5;
        }
        if (zoom < 2.0) {
            return 2.0;
        }
        if (zoom < 3.0) {
            return 3.0;
        }
        if (zoom < 4.0) {
            return 4.0;
        }
        if (zoom < 6.0) {
            return 6.0;
        }
        if (zoom < 8.0) {
            return 8.0;
        }
        if (zoom < 12.0) {
            return 12.0;
        }
        if (zoom < 16.0) {
            return 16.0;
        }
        return 32.0;
    }

    public void SamePosition() {
        if (WindowManager.getCurrentWindow() == null) {
            return;
        }
        Point p = WindowManager.getCurrentWindow().getLocationOnScreen();
        this.SamePosition(p.x, p.y);
    }

    public void SamePosition(int x, int y) {
        List<ImageWindow> windows = Window_Organizer.FindWindows();
        for (int i2 = 0; i2 < windows.size(); ++i2) {
            windows.get(i2).setLocation(x, y);
        }
    }

    public void SameDimensions() {
        if (WindowManager.getCurrentWindow() == null) {
            return;
        }
        Dimension d = WindowManager.getCurrentWindow().getSize();
        this.SameDimensions(d);
    }

    public void SameDimensions(Dimension d) {
        this.SameDimensions((int)d.getWidth(), (int)d.getHeight());
    }

    public void SameDimensions(int width, int height) {
        List<ImageWindow> windows = Window_Organizer.FindWindows();
        for (int i2 = 0; i2 < windows.size(); ++i2) {
            windows.get(i2).setSize(width, height);
        }
    }

    public void SameROI(ImageWindow window, Roi roi) {
        if (roi == null) {
            return;
        }
        ImagePlus imp = window.getImagePlus();
        imp.killRoi();
        imp.deleteRoi();
        imp.setRoi((Roi)roi.clone(), true);
    }

    public void SameROI() {
        List<ImageWindow> windows = Window_Organizer.FindWindows();
        if (WindowManager.getCurrentWindow() == null) {
            return;
        }
        String title = WindowManager.getCurrentWindow().getTitle();
        ImagePlus imp = WindowManager.getCurrentWindow().getImagePlus();
        for (int i2 = 0; i2 < windows.size(); ++i2) {
            if (windows.get(i2).getTitle().equalsIgnoreCase(title)) continue;
            this.SameROI(windows.get(i2), imp.getRoi());
        }
    }

    public static List<ImageWindow> FindWindows() {
        int[] ids = WindowManager.getIDList();
        ArrayList<String> names = new ArrayList<String>(13);
        ArrayList<ImageWindow> windows = new ArrayList<ImageWindow>(13);
        for (int i2 = 0; i2 < ids.length; ++i2) {
            if (Window_Organizer.isInList(names, WindowManager.getImage((int)ids[i2]).getWindow().getTitle())) continue;
            names.add(WindowManager.getImage((int)ids[i2]).getWindow().getTitle());
            windows.add(WindowManager.getImage((int)ids[i2]).getWindow());
        }
        names.clear();
        names = null;
        ids = null;
        return windows;
    }

    private static boolean isInList(List<String> list, String val) {
        Iterator<String> iter = list.iterator();
        while (iter.hasNext()) {
            if (!val.equals(iter.next())) continue;
            return true;
        }
        return false;
    }
}

