/*
 * Decompiled with CFR 0.152.
 */
package displays;

import arrayTiTi.ArrayConverter;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayNew;
import displays.Window_Organizer;
import dv.DV;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.HistogramWindow;
import ij.gui.ImageWindow;
import ij.gui.Plot;
import ij.gui.StackWindow;
import ij.process.BinaryProcessor;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.StackStatistics;
import imageJ.IJInterfacor;
import imageTiTi.ImageConverter;
import imageTiTi.ImageFeatures;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;
import stackTiTi.StackFeatures;

public class Display {
    private static ImageJ ij = null;
    public Window_Organizer winorg = new Window_Organizer();
    private final ArrayFeatures AF = new ArrayFeatures();
    private final ImageFeatures IF = new ImageFeatures();
    private final StackFeatures SF = new StackFeatures();

    public Display() {
        WindowManager.checkForDuplicateName = true;
    }

    public void StartImageJ() {
        ij = new ImageJ();
        ij.exitWhenQuitting(true);
    }

    public void StartWindowOrganizer() {
        this.winorg.run("");
    }

    public void Image(BufferedImage image, String title, double zoom) {
        if (image.getType() == 0 && image.getRaster().getNumBands() != 1) {
            for (int c = 0; c < image.getRaster().getNumBands(); ++c) {
                this.Image(ImageConverter.Channel((BufferedImage)image, (int)c), title + " - channel " + c, zoom);
            }
            return;
        }
        ImagePlus im = IJInterfacor.BufferedImageToImagePlus(image);
        im.setTitle(title);
        new ImageWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ImageChannels(BufferedImage image, String name, double zoom) {
        this.Image(image, name, zoom);
        for (int c = 0; c < image.getRaster().getNumBands(); ++c) {
            this.Image(ImageConverter.Channel((BufferedImage)image, (int)c), name + " - channel " + c, zoom);
        }
    }

    public void Image(ImageProcessor image, String title, double zoom) {
        ImagePlus im = IJInterfacor.ImageProcessorToImagePlus(image, title);
        im.setTitle(title);
        new ImageWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayImage(int[] image, int width, int height, String title, double zoom) {
        FloatProcessor ip = null;
        int min = this.AF.Minimum(image);
        int max = this.AF.Maximum(image);
        if (width * height != image.length) {
            throw new IllegalArgumentException("width*height != image.length.");
        }
        if (min < 0 || 65535 < max) {
            ip = new FloatProcessor(width, height, image);
        } else if (0 <= min && max <= 255) {
            ip = new ByteProcessor(width, height, ArrayConverter.IntToByte((int[])image));
        } else if (0 <= min && max <= 65535) {
            ip = new ShortProcessor(width, height, ArrayConverter.IntToShort((int[])image), null);
        } else {
            throw new Error("Must not occured.");
        }
        ImagePlus imp = IJInterfacor.ImageProcessorToImagePlus((ImageProcessor)ip, title);
        imp.setTitle(title);
        new ImageWindow(imp);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayImage(double[] image, int width, int height, String title, double zoom) {
        FloatProcessor ip = new FloatProcessor(width, height, image);
        ImagePlus im = IJInterfacor.ImageProcessorToImagePlus((ImageProcessor)ip, title);
        im.setTitle(title);
        new ImageWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayImage(float[] image, int width, int height, String title, double zoom) {
        FloatProcessor ip = new FloatProcessor(width, height, image);
        ImagePlus im = IJInterfacor.ImageProcessorToImagePlus((ImageProcessor)ip, title);
        im.setTitle(title);
        new ImageWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayDV(float[] dv, int width, int height, int depth, String title, double zoom) {
        ImageStack stack = new ImageStack(width, height);
        int layer = width * height;
        int z = 0;
        int pos = 0;
        while (z < depth) {
            float[] buffer = new float[layer];
            System.arraycopy(dv, pos, buffer, 0, layer);
            stack.addSlice((ImageProcessor)new FloatProcessor(width, height, buffer));
            buffer = null;
            ++z;
            pos += layer;
        }
        ImagePlus im = new ImagePlus(title, stack);
        im.setDisplayRange(this.AF.Minimum(dv), this.AF.Maximum(dv));
        im.setTitle(title);
        new StackWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayDV(double[] dv, int width, int height, int depth, String title, double zoom) {
        ImageStack stack = new ImageStack(width, height);
        int layer = width * height;
        int z = 0;
        int pos = 0;
        while (z < depth) {
            double[] buffer = new double[layer];
            System.arraycopy(dv, pos, buffer, 0, layer);
            stack.addSlice((ImageProcessor)new FloatProcessor(width, height, buffer));
            buffer = null;
            ++z;
            pos += layer;
        }
        ImagePlus im = new ImagePlus(title, stack);
        im.setDisplayRange(this.AF.Minimum(dv), this.AF.Maximum(dv));
        im.setTitle(title);
        new StackWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayDV(byte[] dv, int width, int height, int depth, String title, double zoom) {
        ImageStack stack = new ImageStack(width, height);
        int layer = width * height;
        int z = 0;
        int pos = 0;
        while (z < depth) {
            byte[] buffer = new byte[layer];
            System.arraycopy(dv, pos, buffer, 0, layer);
            stack.addSlice((ImageProcessor)new ByteProcessor(width, height, buffer));
            buffer = null;
            ++z;
            pos += layer;
        }
        ImagePlus im = new ImagePlus(title, stack);
        im.setDisplayRange((double)this.AF.Minimum(dv), (double)this.AF.Maximum(dv));
        im.setTitle(title);
        new StackWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayDV(short[] dv, int width, int height, int depth, String title, double zoom) {
        ImageStack stack = new ImageStack(width, height);
        int layer = width * height;
        int z = 0;
        int pos = 0;
        while (z < depth) {
            short[] buffer = new short[layer];
            System.arraycopy(dv, pos, buffer, 0, layer);
            stack.addSlice((ImageProcessor)new ShortProcessor(width, height, buffer, null));
            buffer = null;
            ++z;
            pos += layer;
        }
        ImagePlus im = new ImagePlus(title, stack);
        im.setDisplayRange((double)this.AF.Minimum(dv), (double)this.AF.Maximum(dv));
        im.setTitle(title);
        new StackWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayDV(int[] dv, int width, int height, int depth, String title, double zoom) {
        ImageStack stack = new ImageStack(width, height);
        int layer = width * height;
        int z = 0;
        int pos = 0;
        while (z < depth) {
            int[] buffer = new int[layer];
            System.arraycopy(dv, pos, buffer, 0, layer);
            stack.addSlice((ImageProcessor)new FloatProcessor(width, height, buffer));
            buffer = null;
            ++z;
            pos += layer;
        }
        ImagePlus im = new ImagePlus(title, stack);
        im.setDisplayRange((double)this.AF.Minimum(dv), (double)this.AF.Maximum(dv));
        im.setTitle(title);
        new StackWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void DV(DV dv, String title, double zoom) {
        if (dv.Channel != 1) {
            throw new IllegalArgumentException("DV with only 1 channel are supported.");
        }
        switch (dv.Type) {
            case 8: {
                this.ArrayDV(dv.getDataBufferByte(0), dv.SizeX, dv.SizeY, dv.SizeZ, title, zoom);
                break;
            }
            case 16: {
                this.ArrayDV(dv.getDataBufferShort(0), dv.SizeX, dv.SizeY, dv.SizeZ, title, zoom);
                break;
            }
            case 32: {
                this.ArrayDV(dv.getDataBufferInt(0), dv.SizeX, dv.SizeY, dv.SizeZ, title, zoom);
                break;
            }
            case -32: {
                this.ArrayDV(dv.getDataBufferFloat(0), dv.SizeX, dv.SizeY, dv.SizeZ, title, zoom);
                break;
            }
            case 64: {
                this.ArrayDV(dv.getDataBufferDouble(0), dv.SizeX, dv.SizeY, dv.SizeZ, title, zoom);
                break;
            }
            default: {
                throw new IllegalArgumentException("DV type not supported.");
            }
        }
    }

    public void Stack(BufferedImage[] stack, String title, double zoom) {
        int width = stack[0].getWidth();
        int height = stack[0].getHeight();
        ImageStack is = new ImageStack(width, height);
        switch (stack[0].getType()) {
            case 10: {
                for (BufferedImage stack1 : stack) {
                    is.addSlice((ImageProcessor)new ByteProcessor(width, height, ((DataBufferByte)stack1.getRaster().getDataBuffer()).getData(), null));
                }
                break;
            }
            case 11: {
                for (BufferedImage stack1 : stack) {
                    is.addSlice((ImageProcessor)new ShortProcessor(width, height, ((DataBufferUShort)stack1.getRaster().getDataBuffer()).getData(), null));
                }
                break;
            }
            case 5: {
                for (BufferedImage stack1 : stack) {
                    ColorProcessor cp = new ColorProcessor(width, height);
                    byte[] bb = ((DataBufferByte)stack1.getRaster().getDataBuffer()).getData();
                    int x = 0;
                    int pos = 0;
                    while (x < bb.length) {
                        cp.set(pos, ((bb[x + 2] & 0xFF) << 16) + ((bb[x + 1] & 0xFF) << 8) + (bb[x] & 0xFF));
                        x += 3;
                        ++pos;
                    }
                    bb = null;
                    is.addSlice((ImageProcessor)cp);
                    cp = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Stack type not supported.");
            }
        }
        ImagePlus im = new ImagePlus(title, is);
        im.setDisplayRange(this.SF.Minimum(stack), this.SF.Maximum(stack));
        im.setTitle(title);
        new StackWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayImage(boolean[][] image, String title, double zoom) {
        BufferedImage im = new BufferedImage(image.length, image[0].length, 10);
        for (int y = 0; y < im.getHeight(); ++y) {
            for (int x = 0; x < im.getWidth(); ++x) {
                im.getRaster().setSample(x, y, 0, image[x][y] ? 255 : 0);
            }
        }
        BinaryProcessor ip = new BinaryProcessor(new ByteProcessor(im));
        ImagePlus imp = IJInterfacor.ImageProcessorToImagePlus((ImageProcessor)ip, title);
        imp.setTitle(title);
        new ImageWindow(imp);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayImage(short[][] image, String title, double zoom) {
        BufferedImage im = new BufferedImage(image.length, image[0].length, 11);
        for (int y = 0; y < im.getHeight(); ++y) {
            for (int x = 0; x < im.getWidth(); ++x) {
                im.getRaster().setSample(x, y, 0, image[x][y]);
            }
        }
        ShortProcessor ip = new ShortProcessor(im);
        ImagePlus imp = IJInterfacor.ImageProcessorToImagePlus((ImageProcessor)ip, title);
        imp.setTitle(title);
        new ImageWindow(imp);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayImage(int[][] image, String title, double zoom) {
        int y;
        BufferedImage im = null;
        FloatProcessor ip = null;
        int min = this.AF.Minimum(image);
        int max = this.AF.Maximum(image);
        if (min < 0 || 65535 < max) {
            ip = new FloatProcessor(ArrayConverter.Transpose((float[][])ArrayConverter.IntToFloat((int[][])image)));
        } else if (0 <= min && max <= 255) {
            im = new BufferedImage(image[0].length, image.length, 10);
            for (y = 0; y < im.getHeight(); ++y) {
                for (int x = 0; x < im.getWidth(); ++x) {
                    im.getRaster().setSample(x, y, 0, image[y][x]);
                }
            }
            ip = new ByteProcessor(im);
        } else if (0 <= min && max <= 65535) {
            im = new BufferedImage(image[0].length, image.length, 11);
            for (y = 0; y < im.getHeight(); ++y) {
                for (int x = 0; x < im.getWidth(); ++x) {
                    im.getRaster().setSample(x, y, 0, image[y][x]);
                }
            }
            ip = new ShortProcessor(im);
        } else {
            throw new Error("Must not occured.");
        }
        ImagePlus imp = IJInterfacor.ImageProcessorToImagePlus((ImageProcessor)ip, title);
        imp.setTitle(title);
        new ImageWindow(imp);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayImage(float[][] image, String title, double zoom) {
        FloatProcessor ip = new FloatProcessor(ArrayConverter.Transpose((float[][])image));
        ImagePlus im = IJInterfacor.ImageProcessorToImagePlus((ImageProcessor)ip, title);
        im.setTitle(title);
        new ImageWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayImage(double[][] image, String title, double zoom) {
        FloatProcessor ip = new FloatProcessor(ArrayConverter.Transpose((float[][])ArrayConverter.DoubleToFloat((double[][])image)));
        ImagePlus im = IJInterfacor.ImageProcessorToImagePlus((ImageProcessor)ip, title);
        im.setTitle(title);
        new ImageWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayDV(double[][][] dv, String title, double zoom) {
        int width = dv[0][0].length;
        int height = dv[0].length;
        int depth = dv.length;
        ImageStack stack = new ImageStack(width, height);
        for (int z = 0; z < depth; ++z) {
            stack.addSlice((ImageProcessor)new FloatProcessor(width, height, ArrayConverter.to1D((double[][])dv[z])));
        }
        ImagePlus im = new ImagePlus(title, stack);
        im.setDisplayRange(this.AF.Minimum(dv), this.AF.Maximum(dv));
        im.setTitle(title);
        new StackWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayDV(float[][][] dv, String title, double zoom) {
        int width = dv[0][0].length;
        int height = dv[0].length;
        int depth = dv.length;
        ImageStack stack = new ImageStack(width, height);
        for (int z = 0; z < depth; ++z) {
            stack.addSlice((ImageProcessor)new FloatProcessor(width, height, ArrayConverter.to1D((float[][])dv[z])));
        }
        ImagePlus im = new ImagePlus(title, stack);
        im.setDisplayRange((double)this.AF.Minimum(dv), (double)this.AF.Maximum(dv));
        im.setTitle(title);
        new StackWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void ArrayDV(int[][][] dv, String title, double zoom) {
        int width = dv[0][0].length;
        int height = dv[0].length;
        int depth = dv.length;
        ImageStack stack = new ImageStack(width, height);
        for (int z = 0; z < depth; ++z) {
            stack.addSlice((ImageProcessor)new FloatProcessor(width, height, ArrayConverter.to1D((int[][])dv[z])));
        }
        ImagePlus im = new ImagePlus(title, stack);
        im.setDisplayRange((double)this.AF.Minimum(dv), (double)this.AF.Maximum(dv));
        im.setTitle(title);
        new StackWindow(im);
        this.winorg.Zoom(zoom, title);
    }

    public void Histogram(BufferedImage image, String title) {
        ImagePlus imp = null;
        switch (image.getType()) {
            case 10: {
                imp = IJInterfacor.BufferedImageToImagePlus(image);
                new HistogramWindow("Histogram of " + title, imp, (ImageStatistics)new StackStatistics(imp, 256, 0.0, this.IF.Maximum(image)));
                break;
            }
            case 11: {
                imp = IJInterfacor.BufferedImageToImagePlus(image);
                new HistogramWindow("Histogram of " + title, imp, (ImageStatistics)new StackStatistics(imp, 256, 0.0, this.IF.Maximum(image)));
                break;
            }
            case 5: {
                imp = IJInterfacor.BufferedImageToImagePlus(ImageConverter.Channel((BufferedImage)image, (int)0));
                new HistogramWindow("Histogram of " + title + " - Blue", imp, (ImageStatistics)new StackStatistics(imp, 256, 0.0, 256.0));
                imp = IJInterfacor.BufferedImageToImagePlus(ImageConverter.Channel((BufferedImage)image, (int)1));
                new HistogramWindow("Histogram of " + title + " - Green", imp, (ImageStatistics)new StackStatistics(imp, 256, 0.0, 256.0));
                imp = IJInterfacor.BufferedImageToImagePlus(ImageConverter.Channel((BufferedImage)image, (int)2));
                new HistogramWindow("Histogram of " + title + " - Red", imp, (ImageStatistics)new StackStatistics(imp, 256, 0.0, 256.0));
                break;
            }
            case 6: {
                imp = IJInterfacor.BufferedImageToImagePlus(ImageConverter.Channel((BufferedImage)image, (int)0));
                new HistogramWindow("Histogram of " + title + " - Alpha", imp, (ImageStatistics)new StackStatistics(imp, 256, 0.0, 256.0));
                imp = IJInterfacor.BufferedImageToImagePlus(ImageConverter.Channel((BufferedImage)image, (int)1));
                new HistogramWindow("Histogram of " + title + " - Blue", imp, (ImageStatistics)new StackStatistics(imp, 256, 0.0, 256.0));
                imp = IJInterfacor.BufferedImageToImagePlus(ImageConverter.Channel((BufferedImage)image, (int)2));
                new HistogramWindow("Histogram of " + title + " - Green", imp, (ImageStatistics)new StackStatistics(imp, 256, 0.0, 256.0));
                imp = IJInterfacor.BufferedImageToImagePlus(ImageConverter.Channel((BufferedImage)image, (int)3));
                new HistogramWindow("Histogram of " + title + " - Red", imp, (ImageStatistics)new StackStatistics(imp, 256, 0.0, 256.0));
                break;
            }
            default: {
                throw new IllegalArgumentException("Image type not supported (yet).");
            }
        }
    }

    public void Histogram(int[] hist, String title) {
        BufferedImage imhist = null;
        int nb = 0;
        int sum = (int)this.AF.Integral(hist);
        if (hist.length <= 256) {
            imhist = new BufferedImage(sum, 1, 10);
            byte[] bb = ((DataBufferByte)imhist.getRaster().getDataBuffer()).getData();
            for (int i2 = 0; i2 < hist.length; ++i2) {
                Arrays.fill(bb, nb, nb + hist[i2], (byte)i2);
                nb += hist[i2];
            }
        } else if (hist.length <= 65536) {
            imhist = new BufferedImage(sum, 1, 11);
            short[] sb = ((DataBufferUShort)imhist.getRaster().getDataBuffer()).getData();
            for (int i3 = 0; i3 < hist.length; ++i3) {
                Arrays.fill(sb, nb, nb + hist[i3], (short)i3);
                nb += hist[i3];
            }
        } else {
            throw new IllegalArgumentException("Histogram dimensions not supported.");
        }
        this.Histogram(imhist, title);
    }

    public void Histogram(double[] hist, String title) {
        BufferedImage imhist = null;
        int nb = 0;
        int sum = (int)this.AF.Integral(hist);
        if (hist.length <= 256) {
            imhist = new BufferedImage(sum, 1, 10);
            byte[] bb = ((DataBufferByte)imhist.getRaster().getDataBuffer()).getData();
            for (int i2 = 0; i2 < hist.length; ++i2) {
                Arrays.fill(bb, nb, nb + (int)hist[i2], (byte)i2);
                nb += (int)hist[i2];
            }
        } else if (hist.length <= 65536) {
            imhist = new BufferedImage(sum, 1, 11);
            short[] sb = ((DataBufferUShort)imhist.getRaster().getDataBuffer()).getData();
            for (int i3 = 0; i3 < hist.length; ++i3) {
                Arrays.fill(sb, nb, nb + (int)hist[i3], (short)i3);
                nb += (int)hist[i3];
            }
        } else {
            throw new IllegalArgumentException("Histogram dimensions not supported.");
        }
        this.Histogram(imhist, title);
    }

    public void Function(int[] values, String title, String xLabel, String yLabel, double magnification) {
        float[] xValues = new float[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            xValues[i2] = i2;
        }
        float[] yValues = ArrayNew.Same((float[])xValues);
        for (int i3 = 0; i3 < values.length; ++i3) {
            yValues[i3] = values[i3];
        }
        this.Function(xValues, yValues, title, xLabel, yLabel, magnification);
    }

    public void Function(double[] values, String title, String xLabel, String yLabel, double magnification) {
        float[] xValues = new float[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            xValues[i2] = i2;
        }
        float[] yValues = ArrayNew.Same((float[])xValues);
        ArrayConverter.DoubleToFloat((double[])values, (float[])yValues);
        this.Function(xValues, yValues, title, xLabel, yLabel, magnification);
    }

    public void Function(double[] xValues, double[] yValues, String title, String xLabel, String yLabel, double magnification) {
        float[] xvalues = new float[xValues.length];
        ArrayConverter.DoubleToFloat((double[])xValues, (float[])xvalues);
        float[] yvalues = new float[yValues.length];
        ArrayConverter.DoubleToFloat((double[])yValues, (float[])yvalues);
        this.Function(xvalues, yvalues, title, xLabel, yLabel, magnification);
    }

    public void Function(float[] xValues, float[] yValues, String title, String xLabel, String yLabel, double magnification) {
        float xmin = (float)this.AF.Minimum(xValues);
        float xmax = (float)this.AF.Maximum(xValues);
        float ymin = (float)this.AF.Minimum(yValues);
        float ymax = (float)this.AF.Maximum(yValues);
        Dimension d = this.getPlotDimensions((int)(xmax - xmin) + 1, (int)(ymax - ymin) + 1, magnification);
        Plot plot = new Plot(title, xLabel, yLabel, xValues, yValues);
        plot.setSize(d.width, d.height);
        plot.setLimits((double)xmin, (double)xmax, (double)ymin, (double)ymax);
        plot.show();
    }

    private Dimension getPlotDimensions(int xRange, int yRange, double magnification) {
        Dimension screen = IJ.getScreenSize();
        int width = Math.max(600, Math.min(screen.width - 200, (int)((double)xRange * magnification)));
        int height = Math.max(450, Math.min(screen.height - 200, (int)((double)yRange * magnification)));
        return new Dimension(width, height);
    }
}

