/*
 * Decompiled with CFR 0.152.
 */
package dataMining.variables.selections;

import dataMining.classifiers.Classification;
import dataMining.classifiers.parameters.ClassifierParameterFunction;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import java.util.Arrays;
import metaheuristics.EvaluationFunctionBinary;
import metaheuristics.taboo.Taboo;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class TabooSearch
implements EvaluationFunctionBinary {
    public static final int SPLIT = 0;
    public static final int KFCV = 1;
    public static final int BSCV = 2;
    public Taboo Tabou = new Taboo();
    protected int Target = -1;
    protected Classifier classifieur = null;
    protected ClassifierParameterFunction paramfunc = null;
    protected Classification classification = new Classification();
    protected FichierTabule file = null;
    protected FichierTabule Resultat = null;
    protected Instances instances = null;
    protected int ModeleValidation = -1;
    protected int Nb = -1;
    private double[] Importance = null;

    public void StartResearch(Classifier classifieur, ClassifierParameterFunction paramfunc, FichierTabule file, int ModeleValidation, int Nb, boolean[] SolutionInitiale, int nbCPU) {
        this.ChecksFile(classifieur, paramfunc, file, file.Target());
        this.ChecksClassification(ModeleValidation, Nb);
        EvaluationFunctionBinary[] thiss = new TabooSearch[nbCPU];
        for (int i2 = 0; i2 < nbCPU; ++i2) {
            try {
                thiss[i2] = new TabooSearch();
                thiss[i2].ChecksFile(classifieur, paramfunc, file, file.Target());
                ((TabooSearch)thiss[i2]).ChecksClassification(ModeleValidation, nbCPU);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.Tabou.Launch(file.Width() - 1, SolutionInitiale, thiss, true, nbCPU);
        Taboo.MoveTaboo sol = null;
        for (int i3 = 0; i3 < this.Resultat.Height(); ++i3) {
            int j;
            sol = this.Tabou.getSolutions()[i3];
            for (j = 0; j < this.Resultat.Width() - 1; ++j) {
                this.Resultat.setValue(i3, j, sol.Result[j] ? 1 : 0);
            }
            this.Resultat.setValue(i3, j, sol.Cost);
            sol = null;
        }
    }

    protected void ChecksFile(Classifier classifieur, ClassifierParameterFunction paramfunc, FichierTabule file, int Target) {
        int x;
        int[] Type2 = null;
        if (Target < 0 || Target >= file.Width()) {
            throw new IllegalArgumentException("Bad number of target column: " + Target);
        }
        for (x = 0; x < file.Width(); ++x) {
            if (!file.isExcludedColumn(x)) continue;
            throw new IllegalArgumentException("File must contains only valid columns => column " + x + " not valid.");
        }
        for (x = 0; x < file.Width(); ++x) {
            if (!file.isNominal(x) || x == Target) continue;
            throw new Error("File contains a nominal column different from target => column " + x + " nominal.");
        }
        for (x = 0; x < file.Width(); ++x) {
            if (file.ColumnType(x) != 2 || file.isNominal(x)) continue;
            throw new IllegalArgumentException("File must not contain STRING column(except target) => " + x);
        }
        this.classifieur = classifieur;
        this.paramfunc = paramfunc;
        this.Target = Target;
        this.file = file;
        file.setExcludedColumn(Target, false);
        file.setNominal(Target, true);
        this.Importance = new double[file.Width() - 1];
        Arrays.fill(this.Importance, 1.0);
        Type2 = new int[file.Width()];
        for (x = 0; x < file.Width() - 1; ++x) {
            Type2[x] = 0;
        }
        Type2[file.Width() - 1] = 1;
        this.Resultat = new FichierTabule(file.Width(), Type2, "TabooSearchResult");
        int nb = 0;
        for (x = 0; x < file.Width(); ++x) {
            if (x == Target) continue;
            this.Resultat.setColumnName(nb++, file.getColumnName(x));
        }
        this.Resultat.setColumnName(this.Resultat.Width() - 1, "Validation");
    }

    protected void ChecksClassification(int ModeleValidation, int Nb) {
        switch (ModeleValidation) {
            case 0: 
            case 1: 
            case 2: {
                this.ModeleValidation = ModeleValidation;
                break;
            }
            default: {
                throw new Error("Modele de validation incorrect : " + ModeleValidation + " (voir les constantes.");
            }
        }
        if (Nb < 0) {
            throw new Error("Nb incorrect : " + Nb);
        }
        this.Nb = Nb;
    }

    @Override
    public double Evaluate(boolean[] variables) {
        boolean PlaceCible = false;
        int nb = 0;
        for (int i2 = 0; i2 < this.file.Width(); ++i2) {
            if (i2 == this.Target) continue;
            this.file.setExcludedColumn(i2, !variables[nb]);
        }
        this.instances = FichierTabuleConverter.FichierTabuleToWekaInstances(this.file, "MonInstancesTabooSearch");
        try {
            this.classification.Classify(this.instances, this.classifieur, this.paramfunc, this.ModeleValidation, this.Nb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.instances = null;
        switch (this.ModeleValidation) {
            case 0: 
            case 1: 
            case 2: {
                return this.classification.Prediction();
            }
        }
        throw new Error("Default dans Evaluer.");
    }

    @Override
    public double[] getImportanceVariable() {
        return this.Importance;
    }

    @Override
    public double getCost() {
        switch (this.ModeleValidation) {
            case 0: 
            case 1: 
            case 2: {
                return this.classification.Prediction();
            }
        }
        throw new Error("Default dans Evaluer.");
    }

    public FichierTabule getResultat() {
        return this.Resultat;
    }
}

