/*
 * Decompiled with CFR 0.152.
 */
package dataMining.variables.selections;

import dataMining.classifiers.Classification;
import dataMining.classifiers.parameters.ClassifierParameterFunction;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class SystematicResearchBQ {
    public static final int SPLIT = 0;
    public static final int KFCV = 1;
    public static final int BSCV = 2;
    private SysResThread[] threads = null;
    private BlockingQueue<SysResThread> threadsfree = null;
    private List<bestresult> bestresults = new Vector<bestresult>(100);
    private FichierTabule file = null;
    private int Target = -1;
    private DataOutputStream Out = null;
    private boolean[] excluded = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Start(Classifier classifier, ClassifierParameterFunction paramfunc, FichierTabule file, String sortie, int ModeleValidation, int Nb, int nbCPU) throws Exception {
        int i2;
        this.CheckFile(file, sortie);
        this.CheckModel(ModeleValidation, Nb);
        file.setExcludedColumn(this.Target, false);
        if (this.threads == null || this.threads.length != nbCPU) {
            this.threadsfree = new ArrayBlockingQueue<SysResThread>(nbCPU);
            this.threads = null;
            this.threads = new SysResThread[nbCPU];
            for (i2 = 0; i2 < nbCPU; ++i2) {
                this.threads[i2] = new SysResThread();
                this.threads[i2].start();
            }
        }
        for (i2 = 0; i2 < nbCPU; ++i2) {
            this.threads[i2].FileThread(file);
            this.threads[i2].Target = this.Target;
            this.threads[i2].Nb = Nb;
            this.threads[i2].ModeleValidation = ModeleValidation;
            this.threads[i2].classifier = AbstractClassifier.makeCopy((Classifier)classifier);
            this.threads[i2].paramfunc = paramfunc;
        }
        this.Compute(0);
        SystematicResearchBQ systematicResearchBQ = this;
        synchronized (systematicResearchBQ) {
            while (this.threadsfree.size() != nbCPU) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            this.Out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void CheckFile(FichierTabule file, String sortie) {
        int x;
        this.Target = file.Target();
        if (this.Target < 0) {
            throw new IllegalArgumentException("Unable to find the target column in the file (zero or more than one nominal columns).");
        }
        for (x = 0; x < file.Width(); ++x) {
            if (!file.isExcludedColumn(x)) continue;
            throw new IllegalArgumentException("File contains excluded column => column " + x + " excluded.");
        }
        for (x = 0; x < file.Width(); ++x) {
            if (file.ColumnType(x) != 2 || file.isNominal(x)) continue;
            throw new IllegalArgumentException("File contains STRING column, different of target column => colonne " + x + ".");
        }
        file.setNominal(this.Target, true);
        this.file = file;
        this.excluded = file.getExcludedColumn();
        try {
            this.Out = new DataOutputStream(new FileOutputStream(sortie));
        }
        catch (Exception E) {
            E.printStackTrace();
            throw new Error();
        }
    }

    private void CheckModel(int ModeleValidation, int Nb) {
        switch (ModeleValidation) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Default: bad value of validation model: " + ModeleValidation + ".");
            }
        }
        if (Nb < 0) {
            throw new IllegalArgumentException("Bad value of Nb: " + Nb);
        }
        try {
            for (int i2 = 0; i2 < this.file.Width(); ++i2) {
                if (i2 == this.Target) continue;
                this.Out.write(("\"" + this.file.getColumnName(i2) + "\" ").getBytes("ISO-8859-1"));
            }
            switch (ModeleValidation) {
                case 0: {
                    this.Out.write("ValidationSPLIT ".getBytes("ISO-8859-1"));
                    break;
                }
                case 2: {
                    this.Out.write("ValidationBSCV ".getBytes("ISO-8859-1"));
                    break;
                }
                case 1: {
                    this.Out.write("ValidationKFCV ".getBytes("ISO-8859-1"));
                }
            }
            this.Out.write("\n".getBytes("ISO-8859-1"));
        }
        catch (Exception E) {
            E.printStackTrace();
            throw new Error();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void Compute(int column) throws InterruptedException {
        if (column == this.excluded.length) {
            SysResThread free = this.getFreeThread();
            Object object = free.lock;
            synchronized (object) {
                free.Excluded(this.excluded);
                free.lock.notify();
            }
            return;
        }
        if (column == this.Target) {
            this.Compute(column + 1);
        } else {
            this.excluded[column] = true;
            this.Compute(column + 1);
            this.excluded[column] = false;
            this.Compute(column + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addFreeThread(SysResThread thread) {
        BlockingQueue<SysResThread> blockingQueue = this.threadsfree;
        synchronized (blockingQueue) {
            try {
                this.threadsfree.put(thread);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.notify();
    }

    private SysResThread getFreeThread() throws InterruptedException {
        return this.threadsfree.take();
    }

    private double Insert(String file, int row, double value, int N) {
        int i2 = 0;
        int size = this.bestresults.size();
        if (size == N) {
            this.bestresults.remove(--size);
        }
        while (i2 < size && value < this.bestresults.get((int)i2).value) {
            ++i2;
        }
        this.bestresults.add(i2, new bestresult(file, row, value));
        return this.bestresults.get((int)(this.bestresults.size() - 1)).value;
    }

    public void BestResults(String Folder, String Extension2, int N, String Column, String Result) {
        int y;
        int nbErrors = 0;
        int colVal = -1;
        double max = 0.0;
        File[] list = new File(Folder).listFiles();
        FichierTabule tmpfile = null;
        this.bestresults.clear();
        for (int f = 0; f < list.length; ++f) {
            if (!list[f].getName().contains(Extension2)) continue;
            try {
                tmpfile = new FichierTabule(list[f].getAbsolutePath(), true);
                colVal = tmpfile.ColumnNumber(Column);
            }
            catch (Exception e) {
                System.err.println("Exception " + nbErrors++ + " - " + e.getMessage());
                continue;
            }
            int height = tmpfile.Height();
            for (y = 0; y < height; ++y) {
                if (this.bestresults.size() >= N && !(max < tmpfile.getValueDouble(y, colVal))) continue;
                max = this.Insert(list[f].getName(), y, tmpfile.getValueDouble(y, colVal), N);
            }
            tmpfile = null;
        }
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream(Folder + "/" + Result));
            for (y = 0; y < N; ++y) {
                out.write(String.valueOf(this.bestresults.get((int)y).value + " " + this.bestresults.get((int)y).file + " " + this.bestresults.get((int)y).row + "\n").getBytes("ASCII"));
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void BestResults(String Folder, String Extension2, int N, String Column) {
        int nbErrors = 0;
        int colVal = -1;
        double max = 0.0;
        File[] list = new File(Folder).listFiles();
        FichierTabule tmpfile = null;
        DataOutputStream out = null;
        for (int f = 0; f < list.length; ++f) {
            int y;
            if (!list[f].getName().contains(Extension2)) continue;
            try {
                tmpfile = new FichierTabule(list[f].getAbsolutePath(), true);
                colVal = tmpfile.ColumnNumber(Column);
            }
            catch (Exception e) {
                System.err.println("Exception " + nbErrors++ + " - " + e.getMessage());
                continue;
            }
            this.bestresults.clear();
            int height = tmpfile.Height();
            for (y = 0; y < height; ++y) {
                if (this.bestresults.size() >= N && !(max < tmpfile.getValueDouble(y, colVal))) continue;
                max = this.Insert(list[f].getName(), y, tmpfile.getValueDouble(y, colVal), N);
            }
            try {
                out = new DataOutputStream(new FileOutputStream(Folder + "/Best_" + list[f].getName()));
                for (y = 0; y < N; ++y) {
                    out.write(String.valueOf(this.bestresults.get((int)y).value + " " + this.bestresults.get((int)y).file + " " + this.bestresults.get((int)y).row + "\n").getBytes("ASCII"));
                }
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tmpfile = null;
            out = null;
        }
    }

    public FichierTabule BestResults(FichierTabule file, int N) {
        int y;
        int height = file.Height();
        int colVal = file.Width() - 1;
        double max = 0.0;
        int[] types = file.ColumnType();
        for (y = 0; y < types.length - 1; ++y) {
            if (types[y] == 0) continue;
            throw new IllegalArgumentException("Column " + y + " is not FichierTabule.INTEGER.");
        }
        if (types[y] != 1) {
            throw new IllegalArgumentException("Last column is not FichierTabule.DOUBLE.");
        }
        this.bestresults.clear();
        for (y = 0; y < height; ++y) {
            if (this.bestresults.size() >= N && !(max < file.getValueDouble(y, colVal))) continue;
            max = this.Insert("", y, file.getValueDouble(y, colVal), N);
        }
        FichierTabule result = new FichierTabule(N, types, "Best Results");
        result.setColumnsNames(file.getColumnsNames());
        for (y = 0; y < N; ++y) {
            FichierTabuleTools.CopyInstance(file, this.bestresults.get((int)y).row, result, y);
        }
        return result;
    }

    private class SysResThread
    extends Thread {
        private int width = -1;
        public int Target = -1;
        private FichierTabule filethread = null;
        private Instances instances = null;
        private Classification classification = new Classification();
        public Classifier classifier = null;
        public ClassifierParameterFunction paramfunc = null;
        public int ModeleValidation = -1;
        public int Nb = -1;
        public Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void Excluded(boolean[] excluded) {
            SysResThread sysResThread = this;
            synchronized (sysResThread) {
                this.filethread.setExcludedColumn(excluded);
            }
        }

        public void FileThread(FichierTabule file) {
            this.filethread = FichierTabuleTools.Clone(file);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object = this.lock;
                synchronized (object) {
                    try {
                        SystematicResearchBQ.this.addFreeThread(this);
                        this.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.width = this.filethread.Width();
                if (1 >= this.width - this.filethread.nbExcludedColumn()) continue;
                this.instances = FichierTabuleConverter.FichierTabuleToWekaInstances(this.filethread, "MonInstances");
                try {
                    this.classification.Classify(this.instances, this.classifier, this.paramfunc, this.ModeleValidation, this.Nb);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new Error("");
                }
                object = SystematicResearchBQ.this.Out;
                synchronized (object) {
                    try {
                        for (int i2 = 0; i2 < this.width; ++i2) {
                            if (i2 == this.Target) continue;
                            if (!this.filethread.isExcludedColumn(i2)) {
                                SystematicResearchBQ.this.Out.write("1 ".getBytes("ISO-8859-1"));
                                continue;
                            }
                            SystematicResearchBQ.this.Out.write("0 ".getBytes("ISO-8859-1"));
                        }
                        SystematicResearchBQ.this.Out.write(String.valueOf(this.classification.Prediction() + "\n").getBytes("ISO-8859-1"));
                    }
                    catch (Exception E) {
                        E.printStackTrace();
                        throw new Error();
                    }
                }
                this.instances = null;
            }
        }
    }

    private class bestresult {
        public String file = null;
        public int row = -1;
        public double value;

        public bestresult(String file, int row, double value) {
            this.file = file.substring(0);
            this.row = row;
            this.value = value;
        }
    }
}

