/*
 * Decompiled with CFR 0.152.
 */
package dataMining.variables.reductions;

import dataMining.pca.PCA;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import listTiTi.ListTools;
import mathematics.statistics.Correlations;
import utils.LogFile;

public class CorrelatedDataPCA {
    public final double limit = 0.99;
    private int[] Lut = null;
    private double[][] correlations = null;
    private List<List<Integer>> lists = null;
    private List<Integer> toexclude = new LinkedList<Integer>();
    private PCA pca = new PCA();

    public FichierTabule Reduce(FichierTabule file, double CorrelationThreshold) throws IOException {
        int x;
        int y;
        this.correlations = Correlations.Pearson(file);
        int dim = this.correlations.length;
        LogFile log = new LogFile();
        log.StartNewLog(this, "./");
        if (this.lists == null) {
            this.lists = new ArrayList<List<Integer>>(dim);
        } else {
            this.lists.clear();
        }
        boolean[] excluded = new boolean[dim];
        this.Exclude1s(this.correlations, excluded);
        log.addComment("Excluded -----------------------------------");
        for (y = 0; y < dim; ++y) {
            if (!excluded[y]) continue;
            log.addComment(file.getColumnName(y));
        }
        log.addComment("\n\n\n");
        for (y = 0; y < dim; ++y) {
            int i2;
            if (excluded[y]) continue;
            List<Integer> ylist = this.FindCorrelated(y, this.correlations, CorrelationThreshold, excluded);
            if (1 < ylist.size()) {
                log.addComment("New Group From " + file.getColumnName(y) + " -----------------------------------");
                for (i2 = 0; i2 < ylist.size(); ++i2) {
                    log.addComment(file.getColumnName(ylist.get(i2)));
                }
                log.addComment("\n");
            }
            if (ylist.isEmpty()) continue;
            ylist.add(0, y);
            int pos = 1;
            int size = 0;
            do {
                this.ToExclude(ylist, excluded);
                size = ylist.size();
                i2 = pos;
                pos = size;
                while (i2 < size) {
                    List<Integer> newlist = this.FindCorrelated(ylist.get(i2), this.correlations, CorrelationThreshold, excluded);
                    for (x = 0; x < newlist.size(); ++x) {
                        if (ListTools.isInList(ylist, (int)newlist.get(x))) continue;
                        ylist.add(newlist.get(x));
                    }
                    newlist.clear();
                    newlist = null;
                    ++i2;
                }
            } while (size < ylist.size());
            this.lists.add(ylist);
        }
        if (!this.isValid(this.lists)) {
            throw new IllegalStateException("Lists are not valid! Must not occur!!!");
        }
        this.FillLut(file);
        boolean[] exclusions = new boolean[file.Width()];
        System.arraycopy(file.getExcludedColumn(), 0, exclusions, 0, exclusions.length);
        int[] types = new int[this.lists.size()];
        Arrays.fill(types, 1);
        FichierTabule annex = new FichierTabule(file.Height() - file.nbExcluded(), types, "Annex");
        for (x = 0; x < this.lists.size(); ++x) {
            List<Integer> list = this.lists.get(x);
            file.ClearExcludedColumns();
            for (int i3 = 0; i3 < list.size(); ++i3) {
                file.setExcludedColumn(this.Lut[list.get(i3)], true);
            }
            file.InverseExclusionColumns();
            FichierTabule toprocess = FichierTabuleTools.DeleteExcluded(file);
            this.pca.Compute(toprocess, false);
            FichierTabule res = this.pca.ComputeNewCoordinates(toprocess);
            annex.setColumn(x, res.getColumnDouble(0));
            annex.setColumnName(x, "Combo" + x);
            toprocess.Kill();
            toprocess = null;
        }
        file.setExcludedColumn(exclusions);
        Iterator<Integer> iter = this.toexclude.iterator();
        while (iter.hasNext()) {
            file.setExcludedColumn(iter.next(), true);
        }
        iter = null;
        exclusions = null;
        excluded = null;
        return FichierTabuleTools.MergeSideBySide(file, annex);
    }

    private List<Integer> FindCorrelated(int target, double[][] correlations, double CorrelationThreshold, boolean[] excluded) {
        int dim = correlations.length;
        ArrayList<Integer> list = new ArrayList<Integer>(dim >> 2);
        for (int x = target + 1; x < dim; ++x) {
            if (excluded[x] || !(CorrelationThreshold <= Math.abs(correlations[target][x]))) continue;
            list.add(x);
        }
        return list;
    }

    private void ToExclude(List<Integer> list, boolean[] excluded) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            excluded[list.get((int)i2).intValue()] = true;
        }
    }

    private void Exclude1s(double[][] correlations, boolean[] excluded) {
        int dim = correlations.length;
        for (int y = 0; y < dim; ++y) {
            if (excluded[y]) continue;
            for (int x = y + 1; x < dim; ++x) {
                if (excluded[x] || !(0.99 <= Math.abs(correlations[y][x]))) continue;
                excluded[x] = true;
            }
        }
    }

    private boolean isValid(List<List<Integer>> lists) {
        this.toexclude.clear();
        for (int y = 0; y < lists.size(); ++y) {
            List<Integer> list = lists.get(y);
            for (int x = 0; x < list.size(); ++x) {
                if (ListTools.isInList(this.toexclude, (int)list.get(x))) {
                    return false;
                }
                this.toexclude.add(list.get(x));
            }
            Object var3_3 = null;
        }
        return true;
    }

    private void FillLut(FichierTabule file) {
        this.Lut = new int[this.correlations.length];
        boolean[] exs = file.getExcludedColumn();
        int[] types = file.ColumnType();
        int pos = 0;
        for (int x = 0; x < file.Width(); ++x) {
            if (exs[x]) continue;
            switch (types[x]) {
                case 0: 
                case 1: {
                    this.Lut[pos++] = x;
                }
            }
        }
        if (pos != this.Lut.length) {
            throw new IllegalStateException("pos != Lut.length");
        }
        types = null;
        exs = null;
    }

    public int[] Lut() {
        return this.Lut;
    }

    public double[][] Correlations() {
        return this.correlations;
    }

    public List<List<Integer>> Lists() {
        return this.lists;
    }

    public List<Integer> ToExclude() {
        return this.toexclude;
    }
}

