/*
 * Decompiled with CFR 0.152.
 */
package dataMining.validate;

import dataMining.classifiers.Classification;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import java.util.Arrays;
import utils.times.Chronometer;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class ModelProbability {
    public static final int SPLIT = 0;
    public static final int KFCV = 1;
    public static final int BSCV = 2;
    protected int nbIterations = 0;
    protected double[] Predictions = null;
    protected int Cible = -1;
    protected Classifier classifieur = null;
    protected Classification classification = null;
    protected int ModeleValidation = -1;
    protected int Nb = -1;
    protected FichierTabule Fichier = null;
    protected FichierTabule Resultat = null;

    public void Compute(Classifier classifieur, FichierTabule Fichier, int ModeleValidation, int Nb, int nbIterations, Chronometer Chrono) {
        this.Compute(classifieur, Fichier, Fichier.Width() - 1, ModeleValidation, Nb, nbIterations, Chrono);
    }

    public void Compute(Classifier classifieur, FichierTabule Fichier, int Cible, int ModeleValidation, int Nb, int nbIterations, Chronometer Chrono) {
        int i2;
        int nb = 0;
        int marker = 0;
        int[] Repartition = null;
        double PourcentageValidation = 0.0;
        Instances TrainingSet = null;
        Instances ValSet = null;
        FichierTabule TrainingFile = null;
        FichierTabule ValFile = null;
        if (Chrono != null) {
            System.out.print("Computing model's probability (with respect of null hypothesis of null probability: ");
            marker = Chrono.NewMarker();
        }
        this.AllocationsVerifications(classifieur, Fichier, Cible, ModeleValidation, Nb, nbIterations);
        while (nb < nbIterations) {
            int nbPrediction = 0;
            Repartition = null;
            try {
                switch (ModeleValidation) {
                    case 1: {
                        Repartition = this.TirageAleatoireKFCV(Fichier.Height(), Nb);
                        for (i2 = 0; i2 < Nb; ++i2) {
                            int j;
                            int nbVal = 0;
                            int nbTraining = 0;
                            for (j = 0; j < Repartition.length; ++j) {
                                if (i2 == Repartition[j]) {
                                    ++nbVal;
                                    continue;
                                }
                                ++nbTraining;
                            }
                            TrainingFile = null;
                            TrainingFile = new FichierTabule(nbTraining, Fichier.ColumnType(), "");
                            ValFile = null;
                            ValFile = new FichierTabule(nbVal, Fichier.ColumnType(), "");
                            TrainingFile.setNominal(Cible, true);
                            ValFile.setNominal(Cible, true);
                            this.RepartirKFold(Repartition, i2, Fichier, TrainingFile, ValFile);
                            this.PermuteLabels(TrainingFile);
                            TrainingSet = null;
                            ValSet = null;
                            TrainingSet = FichierTabuleConverter.FichierTabuleToWekaInstances(TrainingFile, "TrainingFile");
                            ValSet = FichierTabuleConverter.FichierTabuleToWekaInstances(ValFile, "ValidationFile");
                            TrainingSet.setClassIndex(Cible);
                            ValSet.setClassIndex(Cible);
                            classifieur.buildClassifier(TrainingSet);
                            for (j = 0; j < ValFile.Height(); ++j) {
                                if (!TrainingSet.attribute(TrainingSet.classIndex()).value((int)classifieur.classifyInstance(ValSet.instance(j))).equalsIgnoreCase(ValSet.instance(j).stringValue(TrainingSet.classIndex()))) continue;
                                ++nbPrediction;
                            }
                        }
                        PourcentageValidation = (double)nbPrediction / (double)Fichier.Height() * 100.0;
                        break;
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        throw new Error("Type de prediction incorrecte : " + ModeleValidation);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.Resultat.setValue(nb++, 0, PourcentageValidation);
        }
        for (i2 = 0; i2 < nbIterations; ++i2) {
            this.Predictions[i2] = this.Resultat.getValueDouble(i2, 0);
        }
        Arrays.sort(this.Predictions, 0, this.Predictions.length - 1);
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
    }

    protected void AllocationsVerifications(Classifier classifieur, FichierTabule Fichier, int Cible, int ModeleValidation, int Nb, int nbIterations) {
        int x;
        if (Fichier == null) {
            throw new Error("fichier = null.");
        }
        if (Cible < 0 || Cible >= Fichier.Width()) {
            throw new Error("Numero de colonne cible incorrecte : " + Cible);
        }
        if (Fichier.nbExcluded() > 0) {
            throw new IllegalArgumentException("Excluded instances in file.");
        }
        for (x = 0; x < Fichier.Width(); ++x) {
            if (!Fichier.isNominal(x) || x == Cible) continue;
            throw new IllegalArgumentException("Le fichier comporte une classe nominale autre que la cible.");
        }
        for (x = 0; x < Fichier.Width(); ++x) {
            if (Fichier.ColumnType(x) != 2 || Fichier.isNominal(x)) continue;
            throw new IllegalArgumentException("Not nominal string column in file.");
        }
        switch (ModeleValidation) {
            case 0: 
            case 1: {
                this.ModeleValidation = ModeleValidation;
                break;
            }
            default: {
                throw new Error("Modele de validation incorrect : " + ModeleValidation + " (voir les constantes.");
            }
        }
        if (Nb < 0) {
            throw new IllegalArgumentException("Nb incorrect : " + Nb);
        }
        if (nbIterations < 1) {
            throw new IllegalArgumentException("Nombre d'iterations errone : " + nbIterations);
        }
        this.classifieur = classifieur;
        this.Nb = Nb;
        this.Cible = Cible;
        this.nbIterations = nbIterations;
        this.Fichier = null;
        this.Fichier = Fichier;
        Fichier.setNominal(Cible, true);
        this.Resultat = null;
        this.Predictions = null;
        this.Resultat = new FichierTabule(nbIterations, new int[]{1}, "ModelProbabilityResults");
        this.Predictions = new double[nbIterations];
    }

    protected void RepartirKFold(int[] Repartition, int N, FichierTabule Source2, FichierTabule Training, FichierTabule Validation) {
        int nbVal = 0;
        int nbTraining = 0;
        for (int y = 0; y < Repartition.length; ++y) {
            int x;
            if (Repartition[y] == N) {
                block11: for (x = 0; x < Source2.Width(); ++x) {
                    switch (Source2.ColumnType(x)) {
                        case 1: {
                            Validation.setValue(nbVal, x, Source2.getValueDouble(y, x));
                            continue block11;
                        }
                        case 0: {
                            Validation.setValue(nbVal, x, Source2.getValueInt(y, x));
                            continue block11;
                        }
                        case 2: {
                            Validation.setValue(nbVal, x, Source2.getValueString(y, x).substring(0));
                        }
                    }
                }
                ++nbVal;
                continue;
            }
            block12: for (x = 0; x < Source2.Width(); ++x) {
                switch (Source2.ColumnType(x)) {
                    case 1: {
                        Training.setValue(nbTraining, x, Source2.getValueDouble(y, x));
                        continue block12;
                    }
                    case 0: {
                        Training.setValue(nbTraining, x, Source2.getValueInt(y, x));
                        continue block12;
                    }
                    case 2: {
                        Training.setValue(nbTraining, x, Source2.getValueString(y, x).substring(0));
                    }
                }
            }
            ++nbTraining;
        }
    }

    protected void RepartirCV(boolean[] Repartition, FichierTabule Source2, FichierTabule Training, FichierTabule Validation) {
        int nbVal = 0;
        int nbTraining = 0;
        for (int y = 0; y < Repartition.length; ++y) {
            int x;
            if (!Repartition[y]) {
                block11: for (x = 0; x < Source2.Width(); ++x) {
                    switch (Source2.ColumnType(x)) {
                        case 1: {
                            Validation.setValue(nbVal, x, Source2.getValueDouble(y, x));
                            continue block11;
                        }
                        case 0: {
                            Validation.setValue(nbVal, x, Source2.getValueInt(y, x));
                            continue block11;
                        }
                        case 2: {
                            Validation.setValue(nbVal, x, Source2.getValueString(y, x).substring(0));
                        }
                    }
                }
                ++nbVal;
                continue;
            }
            block12: for (x = 0; x < Source2.Width(); ++x) {
                switch (Source2.ColumnType(x)) {
                    case 1: {
                        Training.setValue(nbTraining, x, Source2.getValueDouble(y, x));
                        continue block12;
                    }
                    case 0: {
                        Training.setValue(nbTraining, x, Source2.getValueInt(y, x));
                        continue block12;
                    }
                    case 2: {
                        Training.setValue(nbTraining, x, Source2.getValueString(y, x).substring(0));
                    }
                }
            }
            ++nbTraining;
        }
    }

    protected void PermuteLabels(FichierTabule Fichier) {
        int Hauteur = Fichier.Height();
        switch (Fichier.ColumnType(this.Cible)) {
            case 1: {
                for (int y = 0; y < Hauteur; ++y) {
                    int Tirage = (int)(Math.random() * (double)Hauteur);
                    double TamponD = Fichier.getValueDouble(y, this.Cible);
                    Fichier.setValue(y, this.Cible, Fichier.getValueDouble(Tirage, this.Cible));
                    Fichier.setValue(Tirage, this.Cible, TamponD);
                }
                break;
            }
            case 0: {
                for (int y = 0; y < Hauteur; ++y) {
                    int Tirage = (int)(Math.random() * (double)Hauteur);
                    int TamponI = Fichier.getValueInt(y, this.Cible);
                    Fichier.setValue(y, this.Cible, Fichier.getValueInt(Tirage, this.Cible));
                    Fichier.setValue(Tirage, this.Cible, TamponI);
                }
                break;
            }
            case 2: {
                for (int y = 0; y < Hauteur; ++y) {
                    int Tirage = (int)(Math.random() * (double)Hauteur);
                    String TamponS = Fichier.getValueString(y, this.Cible).substring(0);
                    Fichier.setValue(y, this.Cible, Fichier.getValueString(Tirage, this.Cible).substring(0));
                    Fichier.setValue(Tirage, this.Cible, TamponS);
                }
                break;
            }
        }
    }

    public double Probability(double value) {
        return (double)(this.Predictions.length - this.Position(value)) / (double)this.nbIterations;
    }

    public int Position(double value) {
        for (int x = 0; x < this.nbIterations; ++x) {
            if (!(value < this.Predictions[x])) continue;
            return x;
        }
        return this.Predictions.length;
    }

    protected boolean[] TirageAleatoireCV(int Total, int nbApp) {
        int i2;
        boolean[] Tableau = new boolean[Total];
        for (i2 = 0; i2 < nbApp; ++i2) {
            Tableau[i2] = true;
        }
        for (i2 = nbApp; i2 < Total; ++i2) {
            Tableau[i2] = false;
        }
        for (i2 = 0; i2 < nbApp; ++i2) {
            int x = (int)(Math.random() * (double)Total);
            int y = (int)(Math.random() * (double)Total);
            boolean Tampon = Tableau[x];
            Tableau[x] = Tableau[y];
            Tableau[y] = Tampon;
        }
        return Tableau;
    }

    protected int[] TirageAleatoireLOOCV(int Total) {
        int i2;
        int[] Tableau = new int[Total];
        for (i2 = 0; i2 < Total; ++i2) {
            Tableau[i2] = i2;
        }
        for (i2 = 0; i2 < Total; ++i2) {
            int x = (int)(Math.random() * (double)Total);
            int y = (int)(Math.random() * (double)Total);
            int Tampon = Tableau[x];
            Tableau[x] = Tableau[y];
            Tableau[y] = Tampon;
        }
        return Tableau;
    }

    protected int[] TirageAleatoireKFCV(int Total, int nbClusters) {
        int i2;
        int nb = (int)Math.round((double)Total / (double)nbClusters);
        int[] Tableau = new int[Total];
        boolean Fin = false;
        int y = 0;
        int x = 0;
        for (i2 = 0; i2 < Total; ++i2) {
            Tableau[i2] = x++;
            ++y;
            if (Fin) {
                // empty if block
            }
            if (y != nb || Fin) continue;
            if (++x == nbClusters) {
                Fin = true;
                x = 0;
            }
            y = 0;
        }
        for (i2 = 0; i2 < Total; ++i2) {
            x = (int)(Math.random() * (double)Total);
            y = (int)(Math.random() * (double)Total);
            int Tampon = Tableau[x];
            Tableau[x] = Tableau[y];
            Tableau[y] = Tampon;
        }
        return Tableau;
    }

    public FichierTabule getResultat() {
        return this.Resultat;
    }

    public double[] getPredictions() {
        return this.Predictions;
    }

    public int getnbIterations() {
        return this.nbIterations;
    }
}

