/*
 * Decompiled with CFR 0.152.
 */
package dataMining.validate;

import dataMining.InstancesTools;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import utils.times.Chronometer;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class ConfidenceInterval {
    public static final int SPLIT = 0;
    public static final int KFCV = 1;
    protected int ModeleValidation = -1;
    protected int Nb = -1;
    protected int NbBootStrap = -1;
    protected double[][] PourcentagePrediction = null;
    protected double[] Distributions = null;
    protected Instances instances = null;
    protected Classifier classifieur = null;
    protected double Average = -1.0;
    protected double StandardDeviation = -1.0;

    public ConfidenceInterval(Classifier classifieur, Instances instances, int Cible) {
        this.Initialiser(classifieur, instances, Cible);
    }

    public ConfidenceInterval(Classifier classifieur, Instances instances) {
        this(classifieur, instances, instances.numAttributes() - 1);
    }

    public ConfidenceInterval(Classifier classifieur, FichierTabule fichier, int Cible) {
        for (int i2 = 0; i2 < fichier.Width(); ++i2) {
            fichier.setNominal(i2, false);
        }
        fichier.setNominal(Cible, true);
        this.Initialiser(classifieur, FichierTabuleConverter.FichierTabuleToWekaInstances(fichier, "Nouvelle classification"), Cible);
    }

    public ConfidenceInterval(Classifier classifieur, FichierTabule fichier) {
        this(classifieur, FichierTabuleConverter.FichierTabuleToWekaInstances(fichier, "Nouvelle classification"));
    }

    protected void Initialiser(Classifier classifieur, Instances instances, int Cible) {
        if (instances == null) {
            throw new Error("instances = null");
        }
        if (classifieur == null) {
            throw new Error("classifieur = null");
        }
        if (Cible < 0 || Cible >= instances.numAttributes()) {
            throw new Error("Valeur de la Cible incorrecte : " + Cible);
        }
        this.instances = instances;
        this.classifieur = classifieur;
        this.instances.setClassIndex(Cible);
    }

    public void Compute(int ModeleValidation, int Nb, int NbBootStrap, Chronometer Chrono) {
        int marker = 0;
        Instances AppSet = null;
        Instances ValSet = null;
        boolean[] Used = null;
        this.ModeleValidation = ModeleValidation;
        this.Nb = Nb;
        this.NbBootStrap = NbBootStrap;
        this.Distributions = null;
        this.Distributions = new double[NbBootStrap];
        this.PourcentagePrediction = null;
        if (Chrono != null) {
            System.out.print("Computing confidence interval with ");
            marker = Chrono.NewMarker();
        }
        try {
            switch (ModeleValidation) {
                case 1: {
                    int bs;
                    int i2;
                    if (Chrono != null) {
                        System.out.print("\"K-fold Cross Validation\": ");
                    }
                    int[] RepartitionKFold = this.TirageAleatoireKFCV(this.instances.numInstances(), Nb);
                    this.PourcentagePrediction = new double[Nb][NbBootStrap];
                    for (i2 = 0; i2 < Nb; ++i2) {
                        int j;
                        ValSet = null;
                        ValSet = InstancesTools.CreateEmpty(this.instances, "Validation" + i2);
                        for (j = 0; j < this.instances.numInstances(); ++j) {
                            if (RepartitionKFold[j] != i2) continue;
                            ValSet.add(this.instances.instance(j));
                        }
                        ValSet.setClassIndex(this.instances.classIndex());
                        for (bs = 0; bs < NbBootStrap; ++bs) {
                            AppSet = null;
                            AppSet = InstancesTools.CreateEmpty(this.instances, "Apprentissage" + i2);
                            AppSet.setClassIndex(this.instances.classIndex());
                            Used = null;
                            Used = new boolean[this.instances.numInstances()];
                            while (AppSet.numInstances() < this.instances.numInstances() - ValSet.numInstances()) {
                                j = (int)(Math.random() * (double)this.instances.numInstances());
                                if (RepartitionKFold[j] == i2) continue;
                                AppSet.add(this.instances.instance(j));
                                if (Used[j]) continue;
                                Used[j] = true;
                            }
                            this.classifieur.buildClassifier(AppSet);
                            for (j = 0; j < ValSet.numInstances(); ++j) {
                                if (!this.instances.attribute(this.instances.classIndex()).value((int)this.classifieur.classifyInstance(ValSet.instance(j))).equalsIgnoreCase(ValSet.instance(j).stringValue(this.instances.classIndex()))) continue;
                                double[] dArray = this.PourcentagePrediction[i2];
                                int n = bs;
                                dArray[n] = dArray[n] + 1.0;
                            }
                            this.PourcentagePrediction[i2][bs] = this.PourcentagePrediction[i2][bs] / (double)ValSet.numInstances() * 100.0;
                        }
                    }
                    bs = 0;
                    while (bs < NbBootStrap) {
                        this.Distributions[bs] = 0.0;
                        for (i2 = 0; i2 < Nb; ++i2) {
                            int n = bs;
                            this.Distributions[n] = this.Distributions[n] + this.PourcentagePrediction[i2][bs];
                        }
                        int n = bs++;
                        this.Distributions[n] = this.Distributions[n] / (double)Nb;
                    }
                    RepartitionKFold = null;
                    break;
                }
                case 0: {
                    int bs;
                    int i3;
                    if (Chrono != null) {
                        System.out.print("\"Split Validation\" (Holdout) : ");
                    }
                    boolean[] ListeInstances = null;
                    this.PourcentagePrediction = new double[Nb][NbBootStrap];
                    for (i3 = 0; i3 < Nb; ++i3) {
                        int j;
                        ValSet = null;
                        ValSet = InstancesTools.CreateEmpty(this.instances, "Validation");
                        ValSet.setClassIndex(this.instances.classIndex());
                        ListeInstances = null;
                        ListeInstances = this.TirageAleatoireSPLITCV(this.instances.numInstances(), Nb);
                        for (j = 0; j < this.instances.numInstances(); ++j) {
                            if (ListeInstances[j]) continue;
                            ValSet.add(this.instances.instance(j));
                        }
                        for (bs = 0; bs < NbBootStrap; ++bs) {
                            AppSet = null;
                            AppSet = InstancesTools.CreateEmpty(this.instances, "Apprentissage" + i3);
                            AppSet.setClassIndex(this.instances.classIndex());
                            Used = null;
                            Used = new boolean[this.instances.numInstances()];
                            while (AppSet.numInstances() < this.instances.numInstances() - ValSet.numInstances()) {
                                j = (int)(Math.random() * (double)this.instances.numInstances());
                                if (!ListeInstances[j]) continue;
                                AppSet.add(this.instances.instance(j));
                                if (Used[j]) continue;
                                Used[j] = true;
                            }
                            this.classifieur.buildClassifier(AppSet);
                            for (j = 0; j < ValSet.numInstances(); ++j) {
                                if (!this.instances.attribute(this.instances.classIndex()).value((int)this.classifieur.classifyInstance(ValSet.instance(j))).equalsIgnoreCase(ValSet.instance(j).stringValue(this.instances.classIndex()))) continue;
                                double[] dArray = this.PourcentagePrediction[i3];
                                int n = bs;
                                dArray[n] = dArray[n] + 1.0;
                            }
                            this.PourcentagePrediction[i3][bs] = this.PourcentagePrediction[i3][bs] / (double)ValSet.numInstances() * 100.0;
                        }
                    }
                    bs = 0;
                    while (bs < NbBootStrap) {
                        this.Distributions[bs] = 0.0;
                        for (i3 = 0; i3 < Nb; ++i3) {
                            int n = bs;
                            this.Distributions[n] = this.Distributions[n] + this.PourcentagePrediction[i3][bs];
                        }
                        int n = bs++;
                        this.Distributions[n] = this.Distributions[n] / (double)Nb;
                    }
                    ListeInstances = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Prediction unknown: " + ModeleValidation);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ComputeProperties();
        AppSet = null;
        ValSet = null;
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
    }

    protected void ComputeProperties() {
        int i2;
        Arrays.sort(this.Distributions, 0, this.Distributions.length - 1);
        this.Average = 0.0;
        for (i2 = 0; i2 < this.Distributions.length; ++i2) {
            this.Average += this.Distributions[i2];
        }
        this.Average /= (double)this.Distributions.length;
        this.StandardDeviation = 0.0;
        for (i2 = 0; i2 < this.Distributions.length; ++i2) {
            this.StandardDeviation += Math.pow(this.Average - this.Distributions[i2], 2.0);
        }
        this.StandardDeviation = Math.sqrt(this.StandardDeviation / (double)this.Distributions.length);
    }

    protected int[] TirageAleatoireKFCV(int Total, int nbClusters) {
        int i2;
        int nb = (int)Math.round((double)Total / (double)nbClusters);
        int[] Tableau = new int[Total];
        boolean Fin = false;
        int y = 0;
        int x = 0;
        for (i2 = 0; i2 < Total; ++i2) {
            Tableau[i2] = x++;
            ++y;
            if (Fin) {
                // empty if block
            }
            if (y != nb || Fin) continue;
            if (++x == nbClusters) {
                Fin = true;
                x = 0;
            }
            y = 0;
        }
        for (i2 = 0; i2 < Total; ++i2) {
            x = (int)(Math.random() * (double)Total);
            y = (int)(Math.random() * (double)Total);
            int Tampon = Tableau[x];
            Tableau[x] = Tableau[y];
            Tableau[y] = Tampon;
        }
        return Tableau;
    }

    protected boolean[] TirageAleatoireSPLITCV(int Total, int nbApp) {
        int i2;
        boolean[] Tableau = new boolean[Total];
        for (i2 = 0; i2 < nbApp; ++i2) {
            Tableau[i2] = true;
        }
        for (i2 = nbApp; i2 < Total; ++i2) {
            Tableau[i2] = false;
        }
        for (i2 = 0; i2 < nbApp; ++i2) {
            int x = (int)(Math.random() * (double)Total);
            int y = (int)(Math.random() * (double)Total);
            boolean Tampon = Tableau[x];
            Tableau[x] = Tableau[y];
            Tableau[y] = Tampon;
        }
        return Tableau;
    }

    public double getLowerBound(int Percentage) {
        return this.Distributions[(int)((double)this.Distributions.length * ((1.0 - (double)Percentage / 100.0) / 2.0) + 0.5)];
    }

    public double getUpperBound(int Percentage) {
        return this.Distributions[(int)((double)this.Distributions.length * ((double)Percentage / 100.0 + (1.0 - (double)Percentage / 100.0) / 2.0))];
    }

    public double getLowerBoundForNormalDistribution() {
        return this.Average - 1.96 * this.StandardDeviation;
    }

    public double getUpperBoundForNormalDistribution() {
        return this.Average + 1.96 * this.StandardDeviation;
    }

    public double getAverage() {
        return this.Average;
    }

    public double getStandardDeviation() {
        return this.StandardDeviation;
    }

    public void Save(String Nom) {
        try {
            DataOutputStream Sortie = new DataOutputStream(new FileOutputStream(Nom));
            System.out.print("Ecriture du fichier : " + Nom);
            Sortie.write(this.toString().getBytes("ISO-8859-1"));
            Sortie.close();
            System.out.println(" terminee.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void appendTo(Appendable out) {
        try {
            out.append("Classifieur = ").append(this.classifieur.getClass().getSimpleName()).append("\n");
            out.append("Validation = ");
            switch (this.ModeleValidation) {
                case 0: {
                    out.append("Split Validation");
                    break;
                }
                case 1: {
                    out.append("K-Fold");
                    break;
                }
                default: {
                    throw new Error("Default : " + this.ModeleValidation);
                }
            }
            out.append("\n");
            out.append("Nb = ").append(String.valueOf(this.Nb)).append("\n");
            out.append("NbBootStrap = ").append(String.valueOf(this.NbBootStrap)).append("\n");
            for (int i2 = 0; i2 < this.NbBootStrap; ++i2) {
                out.append(String.valueOf(this.Distributions[i2])).append("\n");
            }
            out.append("Average = ").append(String.valueOf(this.Average)).append("\n");
            out.append("Standard Deviation = ").append(String.valueOf(this.StandardDeviation)).append("\n");
            out.append("Lower Bound (95%) = ").append(String.valueOf(this.getLowerBound(95))).append("\n");
            out.append("Upper Bound (95%) = ").append(String.valueOf(this.getUpperBound(95))).append("\n");
            out.append("Lower Bound For Normal Distribution = ").append(String.valueOf(this.getLowerBoundForNormalDistribution())).append("\n");
            out.append("Upper Bound For Normal Distribution = ").append(String.valueOf(this.getUpperBoundForNormalDistribution())).append("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new Error("Exception levee.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        this.appendTo(sb);
        return sb.toString();
    }
}

