/*
 * Decompiled with CFR 0.152.
 */
package dataMining.regressions;

import dataMining.InstancesTools;
import dataMining.classifiers.Classification;
import dataMining.classifiers.parameters.ClassifierParameterFunction;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import java.util.Arrays;
import java.util.Random;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.CostMatrix;
import weka.classifiers.Evaluation;
import weka.core.Debug;
import weka.core.Instances;

public class Regression {
    public static final int SPLIT = 0;
    public static final int KFCV = 1;
    public static final int BSCV = 2;
    private static int target = -1;
    private int RandomSeed = 1;
    private CostMatrix costmatrix = null;
    private Evaluation evaluation = null;
    private double[] Regressions = null;
    private double Correlation = 0.0;
    private double ErrorRate = 0.0;
    private double RelativeAbsolutError = 0.0;
    private double RootRelativeSquaredError = 0.0;
    private double RootMeanSquaredError = 0.0;
    private double MeanAbsoluteError;

    public void Compute(FichierTabule data, Classifier classifier, ClassifierParameterFunction paramfunc, int validation, int nb) throws Exception {
        Regression.CheckFile(data);
        Instances instances = FichierTabuleConverter.FichierTabuleToWekaInstances(data, data.Name() + "Instances");
        instances.setClassIndex(target);
        this.Compute(instances, classifier, paramfunc, validation, nb);
        instances = null;
    }

    public void Compute(Instances data, Classifier classifier, ClassifierParameterFunction paramfunc, int validation, int nb) throws Exception {
        Debug.Random random = new Debug.Random((long)this.RandomSeed);
        Classifier current = null;
        Instances train = null;
        Instances test = null;
        this.costmatrix = null;
        if (data.classAttribute().isNominal()) {
            this.costmatrix = new CostMatrix(data.attribute(data.classIndex()).numValues());
        }
        this.evaluation = null;
        this.evaluation = new Evaluation(data, this.costmatrix);
        switch (validation) {
            case 0: {
                data.randomize((Random)random);
                int trainSize = (int)Math.round((double)(data.numInstances() * nb) / 100.0);
                int testSize = data.numInstances() - trainSize;
                train = new Instances(data, 0, trainSize);
                test = new Instances(data, trainSize, testSize);
                current = AbstractClassifier.makeCopy((Classifier)classifier);
                if (paramfunc != null) {
                    paramfunc.Compute(current, train);
                }
                current.buildClassifier(train);
                this.evaluation.evaluateModel(current, test, new Object[0]);
                current = null;
                test = null;
                train = null;
                break;
            }
            case 1: {
                if (paramfunc != null) {
                    paramfunc.Compute(classifier, data);
                }
                this.evaluation.crossValidateModel(classifier, data, nb, (Random)random, new Object[0]);
                break;
            }
            case 2: {
                boolean[] used = new boolean[data.numInstances()];
                data.randomize((Random)random);
                for (int f = 0; f < nb; ++f) {
                    int t;
                    Arrays.fill(used, false);
                    train = InstancesTools.CreateEmpty(data, "TrainSet");
                    train.setClassIndex(data.classIndex());
                    test = InstancesTools.CreateEmpty(data, "TestSet");
                    test.setClassIndex(data.classIndex());
                    while (train.numInstances() < data.numInstances()) {
                        t = (int)(random.nextDouble() * (double)data.numInstances());
                        train.add(data.instance(t));
                        used[t] = true;
                    }
                    for (t = 0; t < used.length; ++t) {
                        if (used[t]) continue;
                        test.add(data.instance(t));
                    }
                    current = AbstractClassifier.makeCopy((Classifier)classifier);
                    if (paramfunc != null) {
                        paramfunc.Compute(current, train);
                    }
                    current.buildClassifier(train);
                    for (t = 0; t < test.numInstances(); ++t) {
                        this.evaluation.evaluateModelOnceAndRecordPrediction(current, test.instance(t));
                    }
                    current = null;
                    test = null;
                    train = null;
                }
                used = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Validation type unknown or not supported.");
            }
        }
        this.Correlation(this.evaluation.correlationCoefficient());
        this.ErrorRate = this.evaluation.errorRate();
        this.RelativeAbsolutError = this.evaluation.relativeAbsoluteError();
        this.RootRelativeSquaredError = this.evaluation.rootRelativeSquaredError();
        this.RootMeanSquaredError = this.evaluation.rootMeanSquaredError();
        this.MeanAbsoluteError = this.evaluation.meanAbsoluteError();
        random = null;
    }

    public void ComputeAndPredict(FichierTabule data, Classifier classifier, ClassifierParameterFunction paramfunc, int validation, int nb) throws Exception {
        int[] folds = new int[data.Height()];
        Classification.FillAndRandomize(folds, nb, true);
        Classifier currentclassifier = null;
        Instances instances = FichierTabuleConverter.FichierTabuleToWekaInstances(data, "instances");
        Instances train = InstancesTools.CreateEmpty(instances, "train");
        Instances test = InstancesTools.CreateEmpty(instances, "test");
        if (this.Regressions == null || this.Regressions.length != instances.numInstances()) {
            this.Regressions = null;
            this.Regressions = new double[instances.numInstances()];
        }
        this.costmatrix = null;
        if (instances.classAttribute().isNominal()) {
            this.costmatrix = new CostMatrix(instances.attribute(instances.classIndex()).numValues());
        }
        this.evaluation = null;
        this.evaluation = new Evaluation(instances, this.costmatrix);
        if (paramfunc != null) {
            paramfunc.Compute(classifier, train);
        }
        train.clear();
        switch (validation) {
            case 1: {
                for (int n = 0; n < nb; ++n) {
                    int i2;
                    data.ClearSelectionRows();
                    for (i2 = 0; i2 < folds.length; ++i2) {
                        if (folds[i2] == n) {
                            test.add(instances.instance(i2));
                            data.setSelected(i2, true);
                            continue;
                        }
                        train.add(instances.instance(i2));
                        data.setSelected(i2, false);
                    }
                    currentclassifier = AbstractClassifier.makeCopy((Classifier)classifier);
                    currentclassifier.buildClassifier(train);
                    for (int t = 0; t < test.numInstances(); ++t) {
                        i2 = data.NextSelected();
                        double[] res = currentclassifier.distributionForInstance(test.instance(t));
                        this.Regressions[i2] = res[0];
                        res = null;
                        this.evaluation.evaluateModelOnceAndRecordPrediction(currentclassifier, test.instance(t));
                    }
                    i2 = data.NextSelected();
                    if (i2 != -1) {
                        throw new Error("Souci: i != -1.");
                    }
                    train.clear();
                    test.clear();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Validation type unknown or not supported (yet).");
            }
        }
        this.Correlation(this.evaluation.correlationCoefficient());
        this.ErrorRate = this.evaluation.errorRate();
        this.RelativeAbsolutError = this.evaluation.relativeAbsoluteError();
        this.RootRelativeSquaredError = this.evaluation.rootRelativeSquaredError();
        this.RootMeanSquaredError = this.evaluation.rootMeanSquaredError();
        this.MeanAbsoluteError = this.evaluation.meanAbsoluteError();
    }

    public static void CheckFile(FichierTabule data) {
        target = -1;
        for (int x = 0; x < data.Width(); ++x) {
            if (data.isNominal(x)) {
                if (target != -1) {
                    throw new IllegalArgumentException("More than 1 nominal columns in data file.");
                }
                target = x;
            }
            if (data.ColumnType(x) != 2 || data.isNominal(x) || data.isExcludedColumn(x)) continue;
            throw new IllegalArgumentException("Column " + x + " is STRING, not nominal and not excluded.");
        }
        if (target == -1) {
            throw new IllegalArgumentException("Any nominal column in data file.");
        }
        if (data.nbColumn() - data.nbExcludedColumn() <= 1) {
            throw new Error("Number of column not excluded is less than 2.");
        }
        if (data.nbRows() == data.nbExcluded()) {
            throw new Error("Empty file or all rows excluded.");
        }
    }

    private void Correlation(double corre) {
        this.Correlation = corre;
        if (this.Correlation < -1.0) {
            this.Correlation = -1.0;
        }
        if (1.0 < this.Correlation) {
            this.Correlation = 1.0;
        }
    }

    public double Correlation() {
        return this.Correlation;
    }

    public double ErrorRate() {
        return this.ErrorRate;
    }

    public double RelativeAbsolutError() {
        return this.RelativeAbsolutError;
    }

    public double RootRelativeSquaredError() {
        return this.RootRelativeSquaredError;
    }

    public double RootMeanSquaredError() {
        return this.RootMeanSquaredError;
    }

    public double MeanAbsoluteError() {
        return this.MeanAbsoluteError;
    }

    public double[] Regressions() {
        return this.Regressions;
    }
}

