/*
 * Decompiled with CFR 0.152.
 */
package dataMining.regressions;

import arrayTiTi.ArrayStatistics;
import dataMining.InstancesTools;
import dataMining.classifiers.Classification;
import dataMining.classifiers.neuralnet.NeuralNetwork;
import dataMining.classifiers.neuralnet.layers.BasicLayer;
import dataMining.classifiers.parameters.ClassifierParameterFunction;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleConverter;
import java.util.LinkedList;
import java.util.List;
import jsat.classifiers.DataPoint;
import jsat.classifiers.DataPointPair;
import jsat.regression.RegressionDataSet;
import jsat.regression.Regressor;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Instance;
import weka.core.Instances;

public class GenericRegression {
    private final int WEKA = -1;
    private final int JSAT = -2;
    private final int NEURALNETWORK = -3;
    public static final int SPLIT = 0;
    public static final int KFCV = 1;
    public static final int BSCV = 2;
    private int type = 0;
    private Object regressor = null;
    private Object classifiercopy = null;
    private Object classifierparameters = null;
    private double[] theory = null;
    private double[] predictions = null;
    public final String[] checknames = new String[]{"Correlation", "Spearman", "Spearman Error", "Spearman Student", "Spearman z-score", "GoodmanKruskallGamma", "KendallA", "KendallB", "MeanAbsoluteError", "RootMeanSquaredError", "R2", "RootRelativeSquaredError"};
    private double[] checks = new double[this.checknames.length];

    public GenericRegression(Object regressor, Object ... parameters) {
        if (regressor instanceof Classifier) {
            this.regressor = regressor;
            this.type = -1;
        } else if (regressor instanceof Regressor) {
            this.regressor = regressor;
            this.type = -2;
        } else if (regressor instanceof NeuralNetwork) {
            this.regressor = regressor;
            this.type = -3;
        } else {
            throw new IllegalArgumentException("The object \"classifier\" is not a supported instance type.");
        }
        if (parameters != null && 0 < parameters.length && parameters[0] != null) {
            if (parameters.length != 1) {
                throw new IllegalArgumentException("Only 1 parameter supported.");
            }
            if (parameters[0] instanceof ClassifierParameterFunction) {
                if (!(regressor instanceof Classifier)) {
                    throw new IllegalArgumentException("The classifier and the parameter function don't match.");
                }
                this.classifierparameters = parameters[0];
            } else {
                throw new IllegalArgumentException("Optional parameter 0 type not supported.");
            }
        }
    }

    public void Train(FichierTabule dataset) throws Exception {
        switch (this.type) {
            case -2: {
                RegressionDataSet cds = FichierTabuleConverter.FichierTabuleToJsatRegressionDataSet(dataset);
                this.Train(cds);
                cds = null;
                break;
            }
            case -1: {
                Instances instances = FichierTabuleConverter.FichierTabuleToWekaInstances(dataset, "file");
                this.Train(instances);
                instances.clear();
                instances = null;
                break;
            }
            case -3: {
                float[][] data = FichierTabuleConverter.FichierTabuleToNeuralNetworkDataSet(dataset);
                float[][] targets = FichierTabuleConverter.FichierTabuleToNeuralNetworkTarget(dataset);
                float[] weights = FichierTabuleConverter.FichierTabuleToNeuralNetworkWeights(dataset);
                this.Train(data, targets, weights);
                targets = null;
                data = null;
                weights = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported/unknown classifier type: " + this.type + ". Must not occured!");
            }
        }
    }

    public void Train(Instances dataset) throws Exception {
        if (this.type != -1) {
            throw new IllegalArgumentException("The classifier is not a weka.classifiers.Classifier instance => Incompatible dataset.");
        }
        this.classifiercopy = null;
        this.classifiercopy = AbstractClassifier.makeCopy((Classifier)((Classifier)this.regressor));
        if (this.classifierparameters != null) {
            ((ClassifierParameterFunction)this.classifierparameters).Compute((Classifier)this.classifiercopy, dataset);
        }
        ((Classifier)this.classifiercopy).buildClassifier(dataset);
    }

    public void Train(RegressionDataSet dataset) {
        if (this.type != -2) {
            throw new IllegalArgumentException("The classifier used is not a jsat.classifiers.Classifier instance => Incompatible dataset.");
        }
        this.classifiercopy = ((Regressor)this.regressor).clone();
        ((Regressor)this.classifiercopy).train(dataset);
    }

    public void Train(float[][] dataset, float[][] target, float[] weights) throws Exception {
        if (this.type != -3) {
            throw new IllegalArgumentException("The classifier is not a NeuralNetwork from the FiReTiTiLiB => Incompatible dataset.");
        }
        this.classifiercopy = null;
        NeuralNetwork nn = (NeuralNetwork)this.regressor;
        List<BasicLayer> layers = nn.Layers();
        BasicLayer fl = layers.get(0);
        nn.Train(dataset, fl.nbFeaturesMaps(), fl.Width(), fl.Height(), target, weights, false);
        fl = null;
        layers = null;
        nn = null;
    }

    public void Regression(FichierTabule dataset) throws Exception {
        switch (this.type) {
            case -2: {
                RegressionDataSet sds = FichierTabuleConverter.FichierTabuleToJsatRegressionDataSet(dataset);
                this.Regression(sds);
                sds = null;
                break;
            }
            case -1: {
                Instances inst = FichierTabuleConverter.FichierTabuleToWekaInstances(dataset, "Instances");
                this.Regression(inst);
                inst.clear();
                inst = null;
                break;
            }
            case -3: {
                float[][] data = FichierTabuleConverter.FichierTabuleToNeuralNetworkDataSet(dataset);
                this.Regression(data);
                data = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported/unknown classifier type: " + this.type + ". Must not occured!");
            }
        }
    }

    public void Regression(Instances dataset) throws Exception {
        if (this.predictions == null || this.predictions.length != dataset.numInstances()) {
            this.predictions = null;
            this.predictions = new double[dataset.numInstances()];
        }
        for (int t = 0; t < dataset.numInstances(); ++t) {
            this.predictions[t] = this.Regression(dataset.instance(t));
        }
    }

    public double Regression(Instance instance) throws Exception {
        if (this.type != -1) {
            throw new IllegalArgumentException("The classifier used is not a weka.classifiers.Classifier instance => Incompatible dataset.");
        }
        double[] res = ((Classifier)this.classifiercopy).distributionForInstance(instance);
        double r = res[0];
        res = null;
        return r;
    }

    public void Regression(float[][] dataset) throws Exception {
        if (this.predictions == null || this.predictions.length != dataset.length) {
            this.predictions = null;
            this.predictions = new double[dataset.length];
        }
        NeuralNetwork nn = (NeuralNetwork)this.regressor;
        List<BasicLayer> layers = nn.Layers();
        BasicLayer layer = layers.get(0);
        for (int t = 0; t < dataset.length; ++t) {
            this.predictions[t] = this.Regression(dataset[t], layer.nbFeaturesMaps(), layer.Width(), layer.Height());
        }
        layer = null;
        layers = null;
        nn = null;
    }

    public float Regression(float[] instance, int nbFeaturesMap, int width, int height) throws Exception {
        if (this.type != -3) {
            throw new IllegalArgumentException("The classifier used is not a NeuralNetwork instance => Incompatible dataset.");
        }
        ((NeuralNetwork)this.regressor).Compute(instance, nbFeaturesMap, width, height);
        float[] res = ((NeuralNetwork)this.regressor).Predictions();
        float r = res[0];
        res = null;
        return r;
    }

    public void Regression(RegressionDataSet dataset) {
        if (this.type != -2) {
            throw new IllegalArgumentException("The classifier used is not a jsat.regression.Regressor instance => Incompatible dataset.");
        }
        if (this.predictions == null || this.predictions.length != dataset.getSampleSize()) {
            this.predictions = null;
            this.predictions = new double[dataset.getSampleSize()];
        }
        for (int t = 0; t < this.predictions.length; ++t) {
            this.predictions[t] = ((Regressor)this.classifiercopy).regress(dataset.getDataPoint(t));
        }
    }

    public double Regression(DataPoint data) {
        if (this.type != -2) {
            throw new IllegalArgumentException("The classifier used is not a jsat.regression.Regressor instance => Incompatible dataset.");
        }
        return ((Regressor)this.classifiercopy).regress(data);
    }

    public void LearnPredictEvaluate(FichierTabule dataset, int validation, int parameter) throws Exception {
        switch (this.type) {
            case -2: {
                RegressionDataSet sds = FichierTabuleConverter.FichierTabuleToJsatRegressionDataSet(dataset);
                this.LearnPredictEvaluate(sds, validation, parameter);
                sds = null;
                break;
            }
            case -1: {
                Instances inst = FichierTabuleConverter.FichierTabuleToWekaInstances(dataset, "Training Set");
                this.LearnPredictEvaluate(inst, validation, parameter);
                inst.clear();
                inst = null;
                break;
            }
            case -3: {
                float[][] data = FichierTabuleConverter.FichierTabuleToNeuralNetworkDataSet(dataset);
                float[][] targets = FichierTabuleConverter.FichierTabuleToNeuralNetworkTarget(dataset);
                float[] weights = FichierTabuleConverter.FichierTabuleToNeuralNetworkWeights(dataset);
                this.LearnPredictEvaluate(data, targets, weights, validation, parameter);
                targets = null;
                data = null;
                weights = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported/unknown classifier type: " + this.type + ". Must not occured!");
            }
        }
    }

    public void LearnPredictEvaluate(Instances dataset, int validation, int parameter) throws Exception {
        int t;
        if (this.type != -1) {
            throw new IllegalArgumentException("The regressor used is not a weka.classifiers.Classifier instance => Incompatible dataset.");
        }
        if (this.predictions == null || this.predictions.length != dataset.numInstances()) {
            this.predictions = null;
            this.predictions = new double[dataset.numInstances()];
            this.theory = null;
            this.theory = new double[dataset.numInstances()];
        }
        int i2 = dataset.classIndex();
        for (t = 0; t < this.theory.length; ++t) {
            this.theory[t] = dataset.instance(t).value(i2);
        }
        int[] folds = new int[dataset.numInstances()];
        Classification.FillAndRandomize(folds, parameter, true);
        Instances train = InstancesTools.CreateEmpty(dataset, "train");
        Instances test = InstancesTools.CreateEmpty(dataset, "test");
        Classifier classif = (Classifier)this.regressor;
        Evaluation evaluation = new Evaluation(dataset, null);
        if (this.classifierparameters != null) {
            ((ClassifierParameterFunction)this.classifierparameters).Compute(classif, train);
        }
        switch (validation) {
            case 1: {
                for (int n = 0; n < parameter; ++n) {
                    for (i2 = 0; i2 < folds.length; ++i2) {
                        if (folds[i2] == n) {
                            test.add(dataset.instance(i2));
                            continue;
                        }
                        train.add(dataset.instance(i2));
                    }
                    Classifier currentclassifier = AbstractClassifier.makeCopy((Classifier)classif);
                    currentclassifier.buildClassifier(train);
                    int p = 0;
                    for (t = 0; t < test.numInstances(); ++t) {
                        while (folds[p] != n) {
                            ++p;
                        }
                        double[] res = currentclassifier.distributionForInstance(test.instance(t));
                        this.predictions[p++] = res[0];
                        res = null;
                        evaluation.evaluateModelOnceAndRecordPrediction(currentclassifier, test.instance(t));
                    }
                    train.clear();
                    test.clear();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Validation type unknown or not supported (yet).");
            }
        }
        this.checks[0] = ArrayStatistics.Correlation(this.theory, this.predictions);
        this.checks[1] = ArrayStatistics.Spearman(this.theory, this.predictions);
        this.checks[2] = ArrayStatistics.SpearmanError;
        this.checks[3] = ArrayStatistics.SpearmanStudent;
        this.checks[4] = ArrayStatistics.SpearmanZScore;
        this.checks[5] = ArrayStatistics.GoodmanKruskalGamma(this.theory, this.predictions);
        this.checks[6] = ArrayStatistics.Kendall(this.theory, this.predictions);
        this.checks[7] = ArrayStatistics.KendallB(this.theory, this.predictions);
        ArrayStatistics.Errors(this.theory, this.predictions);
        this.checks[8] = ArrayStatistics.MeanAbsoluteError;
        this.checks[9] = ArrayStatistics.RootMeanSquaredError;
        this.checks[10] = ArrayStatistics.R2;
        this.checks[11] = evaluation.rootRelativeSquaredError();
        folds = null;
        classif = null;
        test = null;
        train = null;
    }

    public void LearnPredictEvaluate(RegressionDataSet dataset, int validation, int parameter) throws Exception {
        if (this.type != -2) {
            throw new IllegalArgumentException("The regressor used is not a jsat.regression.Regressor instance => Incompatible dataset.");
        }
        if (this.predictions == null || this.predictions.length != dataset.getSampleSize()) {
            this.predictions = null;
            this.predictions = new double[dataset.getSampleSize()];
            this.theory = null;
            this.theory = new double[dataset.getSampleSize()];
        }
        for (int t = 0; t < this.theory.length; ++t) {
            this.theory[t] = dataset.getTargetValue(t);
        }
        int[] folds = new int[dataset.getSampleSize()];
        Classification.FillAndRandomize(folds, parameter, true);
        LinkedList<DataPointPair> train = new LinkedList<DataPointPair>();
        LinkedList<DataPointPair> test = new LinkedList<DataPointPair>();
        Regressor regress = (Regressor)this.regressor;
        switch (validation) {
            case 1: {
                for (int n = 0; n < parameter; ++n) {
                    for (int i2 = 0; i2 < folds.length; ++i2) {
                        if (folds[i2] == n) {
                            test.add(dataset.getDataPointPair(i2));
                            continue;
                        }
                        train.add(dataset.getDataPointPair(i2));
                    }
                    RegressionDataSet training = new RegressionDataSet(train);
                    Regressor currentregressor = regress.clone();
                    currentregressor.train(training);
                    int p = 0;
                    for (DataPointPair dpp : test) {
                        while (folds[p] != n) {
                            ++p;
                        }
                        this.predictions[p++] = currentregressor.regress(dpp.getDataPoint());
                    }
                    train.clear();
                    test.clear();
                    training = null;
                    currentregressor = null;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Validation type unknown or not supported (yet).");
            }
        }
        this.checks[0] = ArrayStatistics.Correlation(this.theory, this.predictions);
        this.checks[1] = ArrayStatistics.Spearman(this.theory, this.predictions);
        this.checks[2] = ArrayStatistics.SpearmanError;
        this.checks[3] = ArrayStatistics.SpearmanStudent;
        this.checks[4] = ArrayStatistics.SpearmanZScore;
        this.checks[5] = ArrayStatistics.GoodmanKruskalGamma(this.theory, this.predictions);
        this.checks[6] = ArrayStatistics.Kendall(this.theory, this.predictions);
        this.checks[7] = ArrayStatistics.KendallB(this.theory, this.predictions);
        ArrayStatistics.Errors(this.theory, this.predictions);
        this.checks[8] = ArrayStatistics.MeanAbsoluteError;
        this.checks[9] = ArrayStatistics.RootMeanSquaredError;
        this.checks[10] = ArrayStatistics.R2;
        this.checks[11] = -1.0;
        folds = null;
        test = null;
        train = null;
    }

    public void LearnPredictEvaluate(float[][] dataset, float[][] targets, float[] weights, int validation, int parameter) throws Exception {
        int t;
        if (this.type != -3) {
            throw new IllegalArgumentException("The regressor used is not a NeuralNetwork instance => Incompatible dataset.");
        }
        if (this.predictions == null || this.predictions.length != dataset.length) {
            this.predictions = null;
            this.predictions = new double[dataset.length];
            this.theory = null;
            this.theory = new double[dataset.length];
        }
        for (t = 0; t < this.theory.length; ++t) {
            this.theory[t] = targets[t][0];
        }
        int[] folds = new int[dataset.length];
        Classification.FillAndRandomize(folds, parameter, true);
        float[][] train = new float[dataset.length][];
        float[][] test = new float[dataset.length][];
        NeuralNetwork nn = (NeuralNetwork)this.regressor;
        List<BasicLayer> layers = nn.Layers();
        BasicLayer layer = layers.get(0);
        int nbfm = layer.nbFeaturesMaps();
        int width = layer.Width();
        int height = layer.Height();
        layer = null;
        layers = null;
        switch (validation) {
            case 1: {
                for (int n = 0; n < parameter; ++n) {
                    for (int i2 = 0; i2 < folds.length; ++i2) {
                        if (folds[i2] == n) {
                            test[i2] = dataset[i2];
                            train[i2] = null;
                            continue;
                        }
                        train[i2] = dataset[i2];
                        test[i2] = null;
                    }
                    nn.Train(train, nbfm, width, height, targets, weights, false);
                    for (t = 0; t < test.length; ++t) {
                        if (test[t] == null) continue;
                        nn.Compute(test[t], nbfm, width, height);
                        this.predictions[t] = nn.Prediction(0);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Validation type unknown or not supported (yet).");
            }
        }
        this.checks[0] = ArrayStatistics.Correlation(this.theory, this.predictions);
        this.checks[1] = ArrayStatistics.Spearman(this.theory, this.predictions);
        this.checks[2] = ArrayStatistics.SpearmanError;
        this.checks[3] = ArrayStatistics.SpearmanStudent;
        this.checks[4] = ArrayStatistics.SpearmanZScore;
        this.checks[5] = ArrayStatistics.GoodmanKruskalGamma(this.theory, this.predictions);
        this.checks[6] = ArrayStatistics.Kendall(this.theory, this.predictions);
        this.checks[7] = ArrayStatistics.KendallB(this.theory, this.predictions);
        ArrayStatistics.Errors(this.theory, this.predictions);
        this.checks[8] = ArrayStatistics.MeanAbsoluteError;
        this.checks[9] = ArrayStatistics.RootMeanSquaredError;
        this.checks[10] = ArrayStatistics.R2;
        this.checks[11] = -1.0;
        folds = null;
        nn = null;
        test = null;
        train = null;
    }

    public double[] Predictions() {
        return this.predictions;
    }

    public double[] Theory() {
        return this.theory;
    }

    public double[] Checks() {
        return this.checks;
    }

    public Object Regressor() {
        return this.regressor;
    }
}

