/*
 * Decompiled with CFR 0.152.
 */
package dataMining.pca;

import Jama.Matrix;
import dv.DV;
import filesAndFolders.fichiersTabules.FichierTabule;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import mathematics.Geometry;
import mathematics.matriciel.Jacobi;
import mathematics.matriciel.Vector;
import mathematics.matriciel.VectorDouble;
import mathematics.metrics.Euclidian;
import mathematics.metrics.Metric;
import mathematics.primitives.pointsTiTi.Coordinate;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.Point3DF;
import mathematics.primitives.pointsTiTi.PointND;
import mathematics.statistics.CoVarianceMatrix;
import mathematics.statistics.CorrelationMatrix;
import measures.BasicMeasures;

public class PCA {
    protected CorrelationMatrix CoRe = new CorrelationMatrix();
    protected CoVarianceMatrix CoVa = new CoVarianceMatrix();
    protected double[] EigenValues = null;
    protected Vector[] EigenVectors = null;
    protected Point Barycenter = null;
    protected Jacobi jacobi = new Jacobi();
    protected Metric distances = new Euclidian();

    public void Compute(FichierTabule file, boolean Reduce) {
        Matrix mat = null;
        Matrix vectors = null;
        this.Barycenter = null;
        if (Reduce) {
            mat = this.CoRe.Compute(file);
            this.Barycenter = new PointND(this.CoRe.getAverages());
        } else {
            mat = this.CoVa.Compute(file);
            this.Barycenter = new PointND(this.CoVa.getAverages());
        }
        int width = mat.getColumnDimension();
        this.EigenValues = null;
        this.EigenValues = new double[width];
        vectors = new Matrix(width, width);
        this.jacobi.Compute(mat, this.EigenValues, vectors);
        this.EigenVectors = new Vector[width];
        for (int x = 0; x < width; ++x) {
            this.EigenVectors[x] = new VectorDouble(mat.getRowDimension());
            for (int y = 0; y < mat.getRowDimension(); ++y) {
                this.EigenVectors[x].set(y, vectors.get(y, x));
            }
            this.EigenVectors[x].Standardize();
        }
        mat = null;
        vectors = null;
    }

    public FichierTabule ComputeNewCoordinates(FichierTabule fichier) {
        int x;
        if (this.Barycenter == null) {
            throw new UnsupportedOperationException("A PCA must be computed beforehand. Call method 'Compute' before this one.");
        }
        int height = fichier.Height();
        int width = fichier.Width();
        int Size = this.EigenValues.length;
        PointND P = new PointND(Size);
        int[] Types = new int[Size];
        Arrays.fill(Types, 1);
        FichierTabule result = new FichierTabule(fichier.Height(), Types, "ResultPCA");
        int y = 0;
        for (x = 0; x < width; ++x) {
            if (fichier.isExcludedColumn(x)) continue;
            ++y;
        }
        if (y != Size) {
            throw new IllegalArgumentException("Number of valid columns different from the file used to compute the PCA");
        }
        for (y = 0; y < height; ++y) {
            if (fichier.isExcluded(y)) continue;
            block6: for (x = 0; x < width; ++x) {
                if (fichier.isExcludedColumn(x)) continue;
                switch (fichier.ColumnType(x)) {
                    case 0: {
                        P.set(x, fichier.getValueInt(y, x));
                        continue block6;
                    }
                    case 1: {
                        P.set(x, fichier.getValueDouble(y, x));
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Only Integer or Double column type required.");
                    }
                }
            }
            for (x = 0; x < Size; ++x) {
                result.setValue(y, x, Geometry.IntersectionCoef(this.Barycenter, this.EigenVectors[x], P));
            }
        }
        Types = null;
        P = null;
        return result;
    }

    public void Compute(BufferedImage image) {
        BasicMeasures Bbcps = new BasicMeasures();
        Bbcps.Compute(image, true);
        this.Compute(image, Bbcps.Centroid);
    }

    public void Compute(BufferedImage image, Coordinate Centroid) {
        int x;
        int largeur = image.getWidth();
        int hauteur = image.getHeight();
        Matrix mat = null;
        Matrix vectors = null;
        this.Barycenter = null;
        this.Barycenter = new PointND(Centroid.X, Centroid.Y);
        double Bx = Centroid.X;
        double By = Centroid.Y;
        WritableRaster wr = image.getRaster();
        double MomIneXY = 0.0;
        double MomIneY = 0.0;
        double MomIneX = 0.0;
        for (int y = 0; y < hauteur; ++y) {
            for (x = 0; x < largeur; ++x) {
                if (wr.getSample(x, y, 0) <= 0) continue;
                MomIneX += Math.pow((double)x - Bx, 2.0);
                MomIneY += Math.pow((double)y - By, 2.0);
                MomIneXY += ((double)x - Bx) * ((double)y - By);
            }
        }
        mat = new Matrix((double[][])new double[][]{{MomIneX, MomIneXY}, {MomIneXY, MomIneY}});
        int width = mat.getColumnDimension();
        this.EigenValues = null;
        this.EigenValues = new double[width];
        vectors = new Matrix(width, width);
        this.jacobi.Compute(mat, this.EigenValues, vectors);
        this.EigenVectors = new Vector[width];
        for (x = 0; x < width; ++x) {
            this.EigenVectors[x] = new VectorDouble(mat.getRowDimension());
            for (int y = 0; y < mat.getRowDimension(); ++y) {
                this.EigenVectors[x].set(y, vectors.get(y, x));
            }
        }
        vectors = null;
        mat = null;
        wr = null;
    }

    public void Compute(DV dv, Coordinate Centroid) {
        this.Compute(dv, new Point3DF(Centroid.X, Centroid.Y, Centroid.Z));
    }

    public void Compute(DV dv, Point Centroid) {
        if (dv.Channel != 1) {
            throw new IllegalArgumentException("Only 1 channel required");
        }
        Matrix vectors = new Matrix(3, 3);
        Matrix mat = null;
        this.Barycenter = null;
        this.Barycenter = Centroid.Clone();
        double Bx = Centroid.getX();
        double By = Centroid.getY();
        double Bz = Centroid.getZ();
        double mXZ = 0.0;
        double mYZ = 0.0;
        double mXY = 0.0;
        double mZ = 0.0;
        double mY = 0.0;
        double mX = 0.0;
        switch (dv.Type) {
            case 8: {
                byte[] bb = dv.getDataBufferByte(0);
                int pos = 0;
                for (int z = 0; z < dv.SizeZ; ++z) {
                    for (int y = 0; y < dv.SizeY; ++y) {
                        int x = 0;
                        while (x < dv.SizeX) {
                            if (bb[pos] != 0) {
                                double X = (double)x - Bx;
                                double Y = (double)y - By;
                                double Z = (double)z - Bz;
                                mX += X * X;
                                mY += Y * Y;
                                mZ += Z * Z;
                                mXY += X * Y;
                                mYZ += Y * Z;
                                mXZ += Z * X;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                bb = null;
                break;
            }
            case 16: {
                short[] sb = dv.getDataBufferShort(0);
                int pos = 0;
                for (int z = 0; z < dv.SizeZ; ++z) {
                    for (int y = 0; y < dv.SizeY; ++y) {
                        int x = 0;
                        while (x < dv.SizeX) {
                            if (sb[pos] != 0) {
                                double X = (double)x - Bx;
                                double Y = (double)y - By;
                                double Z = (double)z - Bz;
                                mX += X * X;
                                mY += Y * Y;
                                mZ += Z * Z;
                                mXY += X * Y;
                                mYZ += Y * Z;
                                mXZ += Z * X;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                sb = null;
                break;
            }
            case 32: {
                int[] ib = dv.getDataBufferInt(0);
                int pos = 0;
                for (int z = 0; z < dv.SizeZ; ++z) {
                    for (int y = 0; y < dv.SizeY; ++y) {
                        int x = 0;
                        while (x < dv.SizeX) {
                            if (ib[pos] != 0) {
                                double X = (double)x - Bx;
                                double Y = (double)y - By;
                                double Z = (double)z - Bz;
                                mX += X * X;
                                mY += Y * Y;
                                mZ += Z * Z;
                                mXY += X * Y;
                                mYZ += Y * Z;
                                mXZ += Z * X;
                            }
                            ++x;
                            ++pos;
                        }
                    }
                }
                ib = null;
            }
        }
        mat = new Matrix((double[][])new double[][]{{mX, mXY, mXZ}, {mXY, mY, mYZ}, {mXZ, mYZ, mZ}});
        int width = mat.getColumnDimension();
        this.EigenValues = null;
        this.EigenValues = new double[width];
        vectors = new Matrix(width, width);
        this.jacobi.Compute(mat, this.EigenValues, vectors);
        this.EigenVectors = new Vector[width];
        for (int x = 0; x < width; ++x) {
            this.EigenVectors[x] = new VectorDouble(mat.getRowDimension());
            for (int y = 0; y < mat.getRowDimension(); ++y) {
                this.EigenVectors[x].set(y, vectors.get(y, x));
            }
        }
        mat = null;
        vectors = null;
    }

    public int getNbColumn(int proba) {
        if (proba < 0 || 100 < proba) {
            throw new IllegalArgumentException("Bad value of proba ([0,100] wished).");
        }
        return this.getNbColumn((double)proba / 100.0);
    }

    public int getNbColumn(double proba) {
        int i2;
        if (proba < 0.0 || 1.0 < proba) {
            throw new IllegalArgumentException("Bad value of proba ([0,1] wished).");
        }
        int nb = this.EigenValues.length;
        double s = 0.0;
        double sum = 0.0;
        for (i2 = 0; i2 < nb; ++i2) {
            sum += (double)nb;
        }
        for (i2 = 0; i2 < nb; ++i2) {
            if (!((s += this.EigenValues[i2]) / sum >= proba)) continue;
            return i2 + 1;
        }
        return nb;
    }

    public CorrelationMatrix getCorelationMatrix() {
        return this.CoRe;
    }

    public CoVarianceMatrix getCovarianceMatrix() {
        return this.CoVa;
    }

    public double[] getEigenValues() {
        return this.EigenValues;
    }

    public Vector[] getEigenVectors() {
        return this.EigenVectors;
    }

    public Point getBarycenter() {
        return this.Barycenter;
    }
}

