/*
 * Decompiled with CFR 0.152.
 */
package dataMining.imbalanceDataSet;

import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayFeatures;
import arrayTiTi.ArrayTools;
import dataMining.InstancesTools;
import dataMining.imbalanceDataSet.DataSetBalancer;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.util.ArrayList;
import java.util.List;
import listTiTi.ListTools;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Instance;
import weka.core.Instances;

public class WeightedSampling
implements DataSetBalancer {
    private final ArrayFeatures AF = new ArrayFeatures();

    @Override
    public Instances Balance(Instances instances) {
        int length = instances.numInstances();
        int target = instances.classIndex();
        String v = null;
        ArrayList<String> classes = new ArrayList<String>(7);
        if (instances.attribute(target).isNominal()) {
            for (int i2 = 0; i2 < length; ++i2) {
                v = instances.instance(i2).stringValue(target);
                if (ListTools.isInList(classes, (String)v)) continue;
                classes.add(v);
            }
        } else {
            throw new IllegalArgumentException("Target is not String, this type is not supported yet.");
        }
        return this.Balance(instances, classes);
    }

    @Override
    public Instances Balance(Instances instances, List<String> classes) {
        int i2;
        int length = instances.numInstances();
        int target = instances.classIndex();
        Instance inst = null;
        AttributeStats attstat = instances.attributeStats(target);
        Attribute att = instances.attribute(target);
        Instances resinst = InstancesTools.CreateEmpty(instances, "Balance_" + instances.relationName());
        Instances[] instclass = new Instances[attstat.distinctCount];
        for (i2 = 0; i2 < instclass.length; ++i2) {
            instclass[i2] = InstancesTools.CreateEmpty(instances, "Class" + i2);
        }
        for (i2 = 0; i2 < length; ++i2) {
            inst = instances.instance(i2);
            instclass[att.indexOfValue(inst.stringValue(target))].add(inst);
        }
        int max = 0;
        for (i2 = 0; i2 < instclass.length; ++i2) {
            if (max >= instclass[i2].numInstances()) continue;
            max = instclass[i2].numInstances();
        }
        double[] weights = new double[instclass.length];
        for (i2 = 0; i2 < weights.length; ++i2) {
            weights[i2] = (double)max / (double)instclass[i2].numInstances();
        }
        for (int j = 0; j < instances.numInstances(); ++j) {
            inst = instances.get(j);
            inst.setWeight(weights[(int)inst.value(att)]);
            resinst.add(inst);
        }
        resinst.setClassIndex(target);
        return resinst;
    }

    @Override
    public FichierTabule Balance(FichierTabule instances, boolean DeleteNaNIntinity) {
        int target = instances.Target();
        switch (instances.ColumnType(target)) {
            case 2: {
                return this.Balance(instances, ArrayTools.ListOfUniqueItems((String[])instances.getColumnString(target)), DeleteNaNIntinity);
            }
            case 0: {
                return this.BalanceInt(instances, ArrayTools.ListOfUniqueItems((int[])instances.getColumnInt(target)), DeleteNaNIntinity);
            }
        }
        throw new IllegalArgumentException("Target is not String or Int, this type is not supported (yet).");
    }

    @Override
    public FichierTabule Balance(FichierTabule instances, List<String> classes, boolean DeleteNaNIntinity) {
        int i2;
        int target = instances.Target();
        int[] count = new int[classes.size()];
        FichierTabule result = null;
        if (DeleteNaNIntinity) {
            instances.SelectNanInfinity();
            result = instances.nbSelected() == 0 ? FichierTabuleTools.Clone(instances) : FichierTabuleTools.DeleteSelectedRows(instances);
        } else {
            result = FichierTabuleTools.Clone(instances);
        }
        for (i2 = 0; i2 < count.length; ++i2) {
            result.ClearSelectionRows();
            result.SelectWhere(target, 0, classes.get(i2));
            count[i2] = result.nbSelected();
        }
        result.ClearSelectionRows();
        for (i2 = 0; i2 < count.length; ++i2) {
            result.ExtendSelectionWhere(target, 0, classes.get(i2));
        }
        result.InverseSelectionRows();
        int otherinst = result.nbSelected();
        ArrayComparator.Compare((boolean[])result.getSelected(), (String)"==", (boolean)false, (double[])result.Weights(), (double)1.0, (double[])result.Weights());
        int max = Math.max(this.AF.Maximum(count), otherinst);
        for (i2 = 0; i2 < count.length; ++i2) {
            result.ClearSelectionRows();
            result.SelectWhere(target, 0, classes.get(i2));
            ArrayComparator.Compare((boolean[])result.getSelected(), (String)"==", (boolean)false, (double[])result.Weights(), (double)((double)max / (double)count[i2]), (double[])result.Weights());
        }
        result.TargetNominal(target);
        count = null;
        return result;
    }

    public FichierTabule BalanceInt(FichierTabule instances, List<Integer> classes, boolean DeleteNaNIntinity) {
        int i2;
        int target = instances.Target();
        int[] count = new int[classes.size()];
        FichierTabule result = null;
        if (DeleteNaNIntinity) {
            instances.SelectNanInfinity();
            result = instances.nbSelected() == 0 ? FichierTabuleTools.Clone(instances) : FichierTabuleTools.DeleteSelectedRows(instances);
        } else {
            result = FichierTabuleTools.Clone(instances);
        }
        for (i2 = 0; i2 < count.length; ++i2) {
            result.ClearSelectionRows();
            result.SelectWhere(target, 0, (int)classes.get(i2));
            count[i2] = result.nbSelected();
        }
        result.ClearSelectionRows();
        for (i2 = 0; i2 < count.length; ++i2) {
            result.ExtendSelectionWhere(target, 0, (int)classes.get(i2));
        }
        result.InverseSelectionRows();
        int otherinst = result.nbSelected();
        ArrayComparator.Compare((boolean[])result.getSelected(), (String)"==", (boolean)false, (double[])result.Weights(), (double)1.0, (double[])result.Weights());
        int max = Math.max(this.AF.Maximum(count), otherinst);
        for (int i3 = 0; i3 < count.length; ++i3) {
            result.ClearSelectionRows();
            result.SelectWhere(target, 0, (int)classes.get(i3));
            ArrayComparator.Compare((boolean[])result.getSelected(), (String)"==", (boolean)false, (double[])result.Weights(), (double)((double)max / (double)count[i3]), (double[])result.Weights());
        }
        result.TargetNominal(target);
        count = null;
        return result;
    }
}

