/*
 * Decompiled with CFR 0.152.
 */
package dataMining.imbalanceDataSet;

import arrayTiTi.ArrayComparator;
import arrayTiTi.ArrayFeatures;
import dataMining.InstancesTools;
import dataMining.imbalanceDataSet.DataSetBalancer;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.util.ArrayList;
import java.util.List;
import listTiTi.ListTools;
import weka.core.Attribute;
import weka.core.AttributeStats;
import weka.core.Instance;
import weka.core.Instances;

public class OverSampling
implements DataSetBalancer {
    private final ArrayFeatures AF = new ArrayFeatures();

    @Override
    public Instances Balance(Instances instances) {
        int length = instances.numInstances();
        int target = instances.classIndex();
        ArrayList<String> classes = new ArrayList<String>(13);
        if (instances.attribute(target).isString()) {
            for (int i2 = 0; i2 < length; ++i2) {
                String v = instances.instance(i2).stringValue(target);
                if (ListTools.isInList(classes, (String)v)) continue;
                classes.add(v);
            }
        } else {
            throw new IllegalArgumentException("Target is not String, this type is not yet supported.");
        }
        return this.Balance(instances, classes);
    }

    @Override
    public Instances Balance(Instances instances, List<String> classes) {
        int i2;
        int length = instances.numInstances();
        int target = instances.classIndex();
        Instance inst = null;
        Instances insts = null;
        AttributeStats attstat = instances.attributeStats(target);
        Attribute att = instances.attribute(target);
        Instances resinst = InstancesTools.CreateEmpty(instances, "Balance_" + instances.relationName());
        Instances[] instclass = new Instances[attstat.distinctCount];
        for (i2 = 0; i2 < instclass.length; ++i2) {
            instclass[i2] = InstancesTools.CreateEmpty(instances, "Class" + i2);
        }
        for (i2 = 0; i2 < length; ++i2) {
            inst = instances.instance(i2);
            instclass[att.indexOfValue(inst.stringValue(target))].add(inst);
        }
        int max = 0;
        for (i2 = 0; i2 < instclass.length; ++i2) {
            if (max >= instclass[i2].numInstances()) continue;
            max = instclass[i2].numInstances();
        }
        for (i2 = 0; i2 < instclass.length; ++i2) {
            int j;
            insts = instclass[i2];
            if (ListTools.isInList(classes, (String)insts.firstInstance().stringValue(target)) && insts.numInstances() < max) {
                int n;
                int nb = max / insts.numInstances();
                for (n = 0; n < nb; ++n) {
                    for (j = 0; j < insts.numInstances(); ++j) {
                        resinst.add(insts.get(j));
                    }
                }
                nb = max - n * insts.numInstances();
                for (n = 0; n < nb; ++n) {
                    j = (int)(Math.random() * (double)insts.numInstances());
                    resinst.add(insts.get(j));
                    insts.remove(j);
                }
                continue;
            }
            for (j = 0; j < insts.numInstances(); ++j) {
                resinst.add(insts.get(j));
            }
        }
        return resinst;
    }

    @Override
    public FichierTabule Balance(FichierTabule instances, boolean DeleteNaNIntinity) {
        int length = instances.Height();
        int target = instances.Target();
        String v = null;
        ArrayList<String> classes = new ArrayList<String>(13);
        if (instances.isString(target)) {
            for (int i2 = 0; i2 < length; ++i2) {
                v = instances.getValueString(i2, target);
                if (ListTools.isInList(classes, (String)v)) continue;
                classes.add(v);
            }
        } else {
            throw new IllegalArgumentException("Target is not String, this type is not supported (yet).");
        }
        return this.Balance(instances, classes, DeleteNaNIntinity);
    }

    @Override
    public FichierTabule Balance(FichierTabule instances, List<String> classes, boolean DeleteNaNIntinity) {
        int i2;
        int length = instances.Height();
        int target = instances.Target();
        int[] occurrences = new int[length];
        int[] count = new int[classes.size()];
        FichierTabule tmp = null;
        if (DeleteNaNIntinity) {
            instances.SelectNanInfinity();
            tmp = instances.nbSelected() == 0 ? FichierTabuleTools.Clone(instances) : FichierTabuleTools.DeleteSelectedRows(instances);
        } else {
            tmp = FichierTabuleTools.Clone(instances);
        }
        for (i2 = 0; i2 < count.length; ++i2) {
            tmp.ClearSelectionRows();
            tmp.SelectWhere(target, 0, classes.get(i2));
            count[i2] = tmp.nbSelected();
        }
        tmp.ClearSelectionRows();
        for (i2 = 0; i2 < count.length; ++i2) {
            tmp.ExtendSelectionWhere(target, 0, classes.get(i2));
        }
        tmp.InverseSelectionRows();
        int otherinst = tmp.nbSelected();
        ArrayComparator.Compare((boolean[])tmp.getSelected(), (String)"==", (boolean)false, (int[])occurrences, (int)1, (int[])occurrences);
        int max = Math.max(this.AF.Maximum(count), otherinst);
        for (int i3 = 0; i3 < count.length; ++i3) {
            tmp.ClearSelectionRows();
            tmp.SelectWhere(target, 0, classes.get(i3));
            int nb = max / count[i3];
            ArrayComparator.Compare((boolean[])tmp.getSelected(), (String)"==", (boolean)false, (int[])occurrences, (int)nb, (int[])occurrences);
            int n = max - nb * count[i3];
            if (0 >= n) continue;
            tmp.SelectRandomlyFromSelection(n);
            ArrayComparator.Compare((boolean[])tmp.getSelected(), (String)"==", (boolean)false, (int[])occurrences, (int)(nb + 1), (int[])occurrences);
        }
        FichierTabule result = FichierTabuleTools.DuplicateInstances(tmp, occurrences);
        count = null;
        occurrences = null;
        return result;
    }
}

