/*
 * Decompiled with CFR 0.152.
 */
package dataMining.imbalanceDataSet;

import dataMining.imbalanceDataSet.DataSetBalancer;
import filesAndFolders.fichiersTabules.FichierTabule;
import filesAndFolders.fichiersTabules.FichierTabuleTools;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class BinarizeDataSet {
    public static void Process(String folderpath, String filter, List<String> classes, String target, DataSetBalancer balancer, boolean DeleteNaNIntinity) {
        File[] files = new File(folderpath).listFiles();
        for (int f = 0; f < files.length; ++f) {
            if (!files[f].isFile() || !files[f].getName().contains(filter)) continue;
            try {
                FichierTabule file = new FichierTabule(files[f].getAbsolutePath(), true);
                file = FichierTabuleTools.DeleteColumn(file, file.ColumnNumber("SZLGE"));
                file.setNominalAndTarget(target);
                BinarizeDataSet.Process(file, classes, balancer, DeleteNaNIntinity, folderpath + "/" + files[f].getName().replace(".txt", "") + "/", files[f].getName().replace(".txt", ""));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void Process(FichierTabule file, List<String> classes, DataSetBalancer balancer, boolean DeleteNaNIntinity, String output, String basicname) {
        ArrayList<String> sublist = new ArrayList<String>(1);
        File out = new File(output);
        if (!out.exists()) {
            out.mkdirs();
        }
        out = null;
        int target = file.Target();
        file.ClearSelection();
        FichierTabule clone = FichierTabuleTools.Clone(file);
        clone.TargetNominal(target);
        for (int c = 0; c < classes.size(); ++c) {
            clone.setColumn(target, file.getColumnString(target));
            clone.SelectWhere(target, 0, classes.get(c));
            clone.InverseSelectionRows();
            clone.setValueInSelection(target, "Other");
            sublist.add(classes.get(c));
            balancer.Balance(clone, sublist, DeleteNaNIntinity).Write(output + "/" + basicname + "_" + classes.get(c) + ".txt", true);
            sublist.clear();
        }
        clone = null;
        sublist = null;
    }
}

