/*
 * Decompiled with CFR 0.152.
 */
package dataMining.clustering;

import dataMining.clustering.ClusteringI;
import filesAndFolders.fichiersTabules.FichierTabule;
import java.util.Iterator;
import java.util.Vector;
import utils.sorts.QuickSort;
import utils.times.Chronometer;

public class StrongForms {
    protected ClusteringI clustering = null;
    protected int[][] ClusterResultat = null;
    protected int[] FormesFortes = null;
    protected double[][] Barycentres = null;
    protected double[][] Tableau = null;

    public void Compute(double[][] Tableau, ClusteringI clustering, int nbClustering, int nbClusters, double Epsilon, boolean UnIndividuParClusterMinimum, boolean CentrerReduire, Chronometer Chrono) {
        if (nbClustering <= 1) {
            throw new IllegalArgumentException("Nombre de KMeans incorrect : " + nbClustering + ", attendu [2..N].");
        }
        this.Tableau = Tableau;
        this.clustering = clustering;
        this.Compute(nbClustering, nbClusters, Epsilon, UnIndividuParClusterMinimum, CentrerReduire, Chrono);
    }

    public void Compute(FichierTabule fichier, ClusteringI clustering, int nbClustering, int nbClusters, double Epsilon, boolean UnIndividuParClusterMinimum, boolean CentrerReduire, Chronometer Chrono) {
        int i2;
        if (nbClustering <= 1) {
            throw new IllegalArgumentException("Nombre de KMeans incorrect : " + nbClustering + ", attendu [2..N].");
        }
        this.clustering = clustering;
        int Largeur = fichier.Width();
        int Hauteur = fichier.Height();
        int colonne = 0;
        int[] colonneint = null;
        double[] colonnedouble = null;
        Vector<Integer> NumColonnes = new Vector<Integer>(fichier.Width());
        for (i2 = 0; i2 < Largeur; ++i2) {
            if (fichier.isExcludedColumn(i2) || fichier.isNominal(i2) || fichier.ColumnType(i2) != 0 && fichier.ColumnType(i2) != 1) continue;
            NumColonnes.add(i2);
        }
        int largeur = NumColonnes.size();
        if (largeur == 0) {
            throw new Error("Aucune caracteristique exploitable dans ce fichier.");
        }
        int hauteur = 0;
        boolean[] Exclude = fichier.getExcluded();
        for (i2 = 0; i2 < Exclude.length; ++i2) {
            if (Exclude[i2]) continue;
            ++hauteur;
        }
        this.Tableau = null;
        this.Tableau = new double[hauteur][largeur];
        Iterator iter = NumColonnes.iterator();
        while (iter.hasNext()) {
            int num = (Integer)iter.next();
            int ligne = 0;
            switch (fichier.ColumnType(num)) {
                case 0: {
                    colonneint = fichier.getColumnInt(num);
                    for (i2 = 0; i2 < Hauteur; ++i2) {
                        if (Exclude[i2]) continue;
                        this.Tableau[ligne++][colonne] = colonneint[i2];
                    }
                    break;
                }
                case 1: {
                    colonnedouble = fichier.getColumnDouble(num);
                    for (i2 = 0; i2 < Hauteur; ++i2) {
                        if (Exclude[i2]) continue;
                        this.Tableau[ligne++][colonne] = colonnedouble[i2];
                    }
                    break;
                }
                default: {
                    throw new Error("Type de colonne incorrect.");
                }
            }
            ++colonne;
        }
        this.Compute(nbClustering, nbClusters, Epsilon, UnIndividuParClusterMinimum, CentrerReduire, Chrono);
    }

    private void Compute(int nbClustering, int nbClusters, double Epsilon, boolean UnIndividuParClusterMinimum, boolean CentrerReduire, Chronometer Chrono) {
        int k;
        int nb;
        int i2;
        int marker = 0;
        int nbDimensions = this.Tableau[0].length;
        int nbIndividus = this.Tableau.length;
        double taille = Math.pow(nbClusters, nbClustering);
        int[] clusters = null;
        if (Double.isInfinite(taille)) {
            throw new IllegalArgumentException("Nombre de composantes fortes trop grand : Math.pow(nbClusters, nbKMeans).");
        }
        if (taille > 2.147483646E9) {
            throw new IllegalArgumentException("Taille superieure au MAX_INT.");
        }
        if (Chrono != null) {
            System.out.println("Calcul des formes fortes par les k-means : ");
            marker = Chrono.NewMarker();
        }
        this.ClusterResultat = null;
        this.ClusterResultat = new int[nbClustering][];
        for (i2 = 0; i2 < nbClustering; ++i2) {
            if (Chrono != null) {
                System.out.print("\t");
            }
            this.clustering.Compute(this.Tableau, nbClusters, Epsilon, UnIndividuParClusterMinimum, CentrerReduire, null);
            this.ClusterResultat[i2] = this.clustering.getClustersNumbers();
        }
        int Taille = (int)taille;
        this.FormesFortes = null;
        this.FormesFortes = new int[Taille];
        for (i2 = 0; i2 < Taille; ++i2) {
            this.FormesFortes[i2] = 0;
        }
        for (i2 = 0; i2 < nbIndividus; ++i2) {
            nb = 0;
            for (k = 0; k < nbClustering; ++k) {
                nb = nb * nbClusters + this.ClusterResultat[k][i2];
            }
            int n = nb;
            this.FormesFortes[n] = this.FormesFortes[n] + 1;
        }
        nb = 0;
        for (i2 = 0; i2 < Taille; ++i2) {
            if (this.FormesFortes[i2] == 0) continue;
            ++nb;
        }
        if (nb < nbClusters) {
            throw new Error("Nombre de formes fortes inferieur au nombre de clusters.");
        }
        int[] FF = new int[nb];
        int[] Indices = new int[nb];
        nb = 0;
        for (i2 = 0; i2 < Taille; ++i2) {
            if (this.FormesFortes[i2] == 0) continue;
            FF[nb] = this.FormesFortes[i2];
            Indices[nb++] = i2;
        }
        QuickSort.Sort(FF, Indices, 0, nb - 1);
        boolean[] trouve = new boolean[nbIndividus];
        for (i2 = 0; i2 < nbIndividus; ++i2) {
            trouve[i2] = false;
        }
        this.Barycentres = null;
        this.Barycentres = new double[nbClusters][nbDimensions];
        int compteur = 0;
        for (k = nb - 1; k >= nb - nbClusters; --k) {
            int j;
            clusters = this.Decomposer(Indices[k], nbClustering, nbClusters);
            int nb2 = 0;
            for (i2 = 0; nb2 < FF[k] && i2 < nbIndividus; ++i2) {
                if (trouve[i2]) continue;
                boolean ok = true;
                for (j = 0; ok && j < nbClustering; ++j) {
                    if (this.ClusterResultat[j][i2] == clusters[j]) continue;
                    ok = false;
                }
                if (!ok) continue;
                for (j = 0; j < nbDimensions; ++j) {
                    double[] dArray = this.Barycentres[compteur];
                    int n = j;
                    dArray[n] = dArray[n] + this.Tableau[i2][j];
                }
                trouve[i2] = true;
                ++nb2;
            }
            if (nb2 != FF[k]) {
                throw new Error("nb2 != CF[k]");
            }
            j = 0;
            while (j < nbDimensions) {
                double[] dArray = this.Barycentres[compteur];
                int n = j++;
                dArray[n] = dArray[n] / (double)nb2;
            }
            ++compteur;
        }
        if (Chrono != null) {
            System.out.print("\tFormes fortes, ");
        }
        this.clustering.Compute(this.Tableau, nbClusters, Epsilon, UnIndividuParClusterMinimum, CentrerReduire, this.Barycentres);
        if (Chrono != null) {
            System.out.println(Chrono.getTimeSinceMarker(marker));
            Chrono.FreeMarker(marker);
        }
    }

    private int[] Decomposer(int num, int nbKMeans, int nbClusters) {
        int[] res = new int[nbKMeans];
        for (int nb = nbKMeans - 1; nb >= 0; --nb) {
            res[nb] = num % nbClusters;
            num = (num - res[nb]) / nbClusters;
        }
        return res;
    }

    public ClusteringI getResult() {
        return this.clustering;
    }
}

