/*
 * Decompiled with CFR 0.152.
 */
package dataMining.clustering;

import arrayTiTi.ArrayNew;
import dataMining.clustering.Cluster;
import dataMining.clustering.ClusteringI;
import displays.Color;
import filesAndFolders.fichiersTabules.FichierTabule;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mathematics.metrics.Metric;
import mathematics.primitives.pointsTiTi.Point;
import mathematics.primitives.pointsTiTi.PointI;
import mathematics.statistics.CenterReduce;

public class MobilesCenters
implements ClusteringI {
    protected int nbIterations = 0;
    protected double Epsilon = 1.0;
    protected double[][] Array = null;
    protected int nbClusters = 0;
    protected int nbIndividus = 0;
    protected int nbDimensions = 0;
    protected int[] ClusterResultat = null;
    protected double[] DistanceResultat = null;
    protected double InertieIntraClasse = -1.0;
    protected double InertieInterClasse = -1.0;
    protected Cluster[] Clusters = null;
    protected Metric metrique = null;
    protected int[] BestRepresentant = null;
    protected CenterReduce sd = null;
    protected int HauteurCadre;
    protected int Type;
    protected int ListeGL = -1;
    protected float Transparence;
    protected float Taille;
    protected boolean Visible = true;
    protected boolean affichable = true;
    protected Color couleur = null;
    protected String Nom = null;

    public MobilesCenters(Metric metrique) {
        if (metrique == null) {
            throw new Error("Metrique = null");
        }
        this.metrique = metrique;
        this.sd = new CenterReduce();
    }

    @Override
    public void Compute(double[][] Array, int nbClusters, double Epsilon, boolean AtLeastOneInstancePerCluster, boolean CenterReduce2, double[][] Barycentres) {
        if (Array == null) {
            throw new Error("Array = null.");
        }
        this.nbIndividus = Array.length;
        this.nbDimensions = Array[0].length;
        this.nbClusters = nbClusters;
        this.Epsilon = Epsilon;
        this.Array = null;
        this.Array = new double[Array.length][Array[0].length];
        ArrayNew.Copy((double[][])Array, (double[][])this.Array);
        this.Compute(nbClusters, Epsilon, AtLeastOneInstancePerCluster, CenterReduce2, Barycentres);
    }

    @Override
    public void Compute(FichierTabule file, int nbClusters, double Epsilon, boolean AtLeastOneInstancePerCluster, boolean CenterReduce2, double[][] Barycentres) {
        int i2;
        int Largeur = file.Width();
        int Hauteur = file.Height();
        int colonne = 0;
        int[] colonneint = null;
        double[] colonnedouble = null;
        ArrayList<Integer> NumColonnes = new ArrayList<Integer>(file.Width());
        for (i2 = 0; i2 < Largeur; ++i2) {
            if (file.isExcludedColumn(i2) || file.isNominal(i2) || file.ColumnType(i2) != 0 && file.ColumnType(i2) != 1) continue;
            NumColonnes.add(i2);
        }
        int largeur = NumColonnes.size();
        if (largeur == 0) {
            throw new Error("Aucune caracteristique exploitable dans ce fichier.");
        }
        int hauteur = 0;
        boolean[] Exclude = file.getExcluded();
        for (i2 = 0; i2 < Exclude.length; ++i2) {
            if (Exclude[i2]) continue;
            ++hauteur;
        }
        this.nbIndividus = hauteur;
        this.nbDimensions = largeur;
        this.nbClusters = nbClusters;
        this.Epsilon = Epsilon;
        this.Array = new double[hauteur][largeur];
        Iterator iter = NumColonnes.iterator();
        while (iter.hasNext()) {
            int num = (Integer)iter.next();
            int ligne = 0;
            switch (file.ColumnType(num)) {
                case 0: {
                    colonneint = file.getColumnInt(num);
                    for (i2 = 0; i2 < Hauteur; ++i2) {
                        if (Exclude[i2]) continue;
                        this.Array[ligne++][colonne] = colonneint[i2];
                    }
                    break;
                }
                case 1: {
                    colonnedouble = file.getColumnDouble(num);
                    for (i2 = 0; i2 < Hauteur; ++i2) {
                        if (Exclude[i2]) continue;
                        this.Array[ligne++][colonne] = colonnedouble[i2];
                    }
                    break;
                }
                default: {
                    throw new Error("Type de colonne incorrect.");
                }
            }
            ++colonne;
        }
        this.Compute(nbClusters, Epsilon, AtLeastOneInstancePerCluster, CenterReduce2, Barycentres);
    }

    @Override
    public void ComputePoint(List<Point> List2, int nbClusters, double Epsilon, boolean AtLeastOneInstancePerCluster, boolean CenterReduce2, double[][] Barycentres) {
        this.nbIndividus = List2.size();
        this.nbDimensions = List2.get(0).Dimension();
        this.nbClusters = nbClusters;
        this.Epsilon = Epsilon;
        this.Array = null;
        this.Array = new double[this.nbIndividus][this.nbDimensions];
        int nb = 0;
        Point point2 = null;
        for (Point point2 : List2) {
            for (int j = 0; j < this.nbDimensions; ++j) {
                this.Array[nb][j] = point2.get(j);
            }
            ++nb;
        }
        this.Compute(nbClusters, Epsilon, AtLeastOneInstancePerCluster, CenterReduce2, Barycentres);
    }

    @Override
    public void ComputePointI(List<PointI> List2, int nbClusters, double Epsilon, boolean AtLeastOneInstancePerCluster, boolean CenterReduce2, double[][] Barycentres) {
        this.Array = null;
        this.Array = new double[List2.size()][2];
        for (int i2 = 0; i2 < this.Array.length; ++i2) {
            this.Array[i2][0] = List2.get(i2).getX();
            this.Array[i2][1] = List2.get(i2).getY();
        }
        this.nbIndividus = this.Array.length;
        this.nbDimensions = 2;
        this.nbClusters = nbClusters;
        this.Epsilon = Epsilon;
        this.Compute(nbClusters, Epsilon, AtLeastOneInstancePerCluster, CenterReduce2, Barycentres);
    }

    @Override
    public void Compute(int nbClusters, double Epsilon, boolean AtLeastOneInstancePerCluster, boolean CenterReduce2, double[][] Barycentres) {
        throw new IllegalStateException("Too update.");
    }

    private void PlacerBarycentresAleatoirement() {
        int y;
        int x;
        double[] min = new double[this.nbDimensions];
        double[] max = new double[this.nbDimensions];
        double[] barycentre = new double[this.nbDimensions];
        for (x = 0; x < this.nbDimensions; ++x) {
            min[x] = max[x] = this.Array[0][x];
        }
        for (x = 0; x < this.nbDimensions; ++x) {
            if (!Double.isNaN(min[x])) continue;
            throw new Error("NaN, ligne 0, colonne " + x);
        }
        for (y = 1; y < this.nbIndividus; ++y) {
            for (x = 0; x < this.nbDimensions; ++x) {
                if (Double.isNaN(this.Array[y][x])) {
                    throw new Error("NaN, ligne " + y + ", colonne " + x);
                }
                if (min[x] > this.Array[y][x]) {
                    min[x] = this.Array[y][x];
                }
                if (!(max[x] < this.Array[y][x])) continue;
                max[x] = this.Array[y][x];
            }
        }
        for (y = 0; y < this.nbClusters; ++y) {
            for (x = 0; x < this.nbDimensions; ++x) {
                barycentre[x] = min[x] + Math.random() * (max[x] - min[x]);
            }
            this.Clusters[y].setBarycentre(barycentre);
        }
    }

    private double Converger(boolean AtLeastOneInstancePerCluster) {
        this.TrouverClusterPlusProche(AtLeastOneInstancePerCluster);
        return this.CalculerBarycentres();
    }

    private void TrouverClusterPlusProche(boolean AtLeastOneInstancePerCluster) {
        int c;
        int i2;
        for (i2 = 0; i2 < this.nbClusters; ++i2) {
            this.Clusters[i2].setNbInstance(0);
        }
        for (i2 = 0; i2 < this.nbIndividus; ++i2) {
            this.ClusterResultat[i2] = 0;
            this.DistanceResultat[i2] = this.metrique.Distance(this.Array[i2], this.Clusters[0].getBarycenter().get());
            if (Double.isNaN(this.DistanceResultat[i2])) {
                throw new Error("NaN trouve lors d'un calcul de distances => individu " + i2 + ", cluster 0.");
            }
            for (c = 1; c < this.nbClusters; ++c) {
                double Distance2 = this.metrique.Distance(this.Array[i2], this.Clusters[c].getBarycenter().get());
                if (Double.isNaN(Distance2)) {
                    throw new Error("NaN trouve lors d'un calcul de distances => individu " + i2 + ", cluster " + c + ".");
                }
                if (!(Distance2 < this.DistanceResultat[i2])) continue;
                this.DistanceResultat[i2] = Distance2;
                this.ClusterResultat[i2] = c;
            }
            this.Clusters[this.ClusterResultat[i2]].IncrementNbInstances(1);
        }
        if (AtLeastOneInstancePerCluster) {
            boolean Erreur = true;
            while (Erreur) {
                Erreur = false;
                for (c = 0; c < this.nbClusters; ++c) {
                    if (this.Clusters[c].getNbIndividus() != 0) continue;
                    int nummax = 0;
                    for (i2 = 1; i2 < this.nbIndividus; ++i2) {
                        if (!(this.DistanceResultat[i2] > this.DistanceResultat[nummax])) continue;
                        nummax = i2;
                    }
                    this.Clusters[c].setBarycentre(this.Array[nummax]);
                    this.Clusters[c].setNbInstance(1);
                    this.Clusters[this.ClusterResultat[nummax]].DecrementNbInstances(1);
                    if (this.Clusters[this.ClusterResultat[nummax]].getNbIndividus() == 0) {
                        Erreur = true;
                    }
                    this.ClusterResultat[nummax] = c;
                    this.DistanceResultat[nummax] = 0.0;
                }
            }
        }
    }

    private double CalculerBarycentres() {
        int j;
        int i2;
        double Distance2 = 0.0;
        double[][] Barycentres = new double[this.nbClusters][this.nbDimensions];
        for (i2 = 0; i2 < this.nbIndividus; ++i2) {
            for (j = 0; j < this.nbDimensions; ++j) {
                double[] dArray = Barycentres[this.ClusterResultat[i2]];
                int n = j;
                dArray[n] = dArray[n] + this.Array[i2][j];
            }
        }
        for (i2 = 0; i2 < this.nbClusters; ++i2) {
            j = 0;
            while (j < this.nbDimensions) {
                double[] dArray = Barycentres[i2];
                int n = j++;
                dArray[n] = dArray[n] / (double)this.Clusters[i2].getNbIndividus();
            }
        }
        for (i2 = 0; i2 < this.nbClusters; ++i2) {
            Distance2 += this.metrique.Distance(this.Clusters[i2].getBarycenter().get(), Barycentres[i2]);
        }
        for (i2 = 0; i2 < this.nbClusters; ++i2) {
            this.Clusters[i2].setBarycentre(Barycentres[i2]);
        }
        Barycentres = null;
        return Distance2;
    }

    private void CalculerInertieIntraClasse() {
        int i2;
        double[] TabInertieIntraClasse = new double[this.nbClusters];
        for (i2 = 0; i2 < this.nbClusters; ++i2) {
            TabInertieIntraClasse[i2] = 0.0;
            this.Clusters[i2].setNbInstance(0);
        }
        for (i2 = 0; i2 < this.nbIndividus; ++i2) {
            int n = this.ClusterResultat[i2];
            TabInertieIntraClasse[n] = TabInertieIntraClasse[n] + Math.pow(this.metrique.Distance(this.Clusters[this.ClusterResultat[i2]].getBarycenter().get(), this.Array[i2]), 2.0);
            this.Clusters[this.ClusterResultat[i2]].IncrementNbInstances(1);
        }
        this.InertieIntraClasse = 0.0;
        for (i2 = 0; i2 < this.nbClusters; ++i2) {
            int n = i2;
            TabInertieIntraClasse[n] = TabInertieIntraClasse[n] / (double)this.Clusters[i2].getNbIndividus();
            this.InertieIntraClasse += TabInertieIntraClasse[i2];
            this.Clusters[i2].setInertiaIntraClasse(TabInertieIntraClasse[i2]);
        }
        TabInertieIntraClasse = null;
    }

    private void CalculerErreurInterClasse() {
        int i2;
        double[] Barycentre = new double[this.nbDimensions];
        for (i2 = 0; i2 < this.nbIndividus; ++i2) {
            for (int j = 0; j < this.nbDimensions; ++j) {
                int n = j;
                Barycentre[n] = Barycentre[n] + this.Array[i2][j];
            }
        }
        this.InertieInterClasse = 0.0;
        for (i2 = 0; i2 < this.nbClusters; ++i2) {
            this.InertieInterClasse += (double)this.Clusters[i2].getNbIndividus() * Math.pow(this.metrique.Distance(Barycentre, this.Clusters[i2].getBarycenter().get()), 2.0);
        }
        this.InertieInterClasse /= (double)this.nbIndividus;
        Barycentre = null;
    }

    @Override
    public void ComputeParangons() {
        int i2;
        this.BestRepresentant = new int[this.nbClusters];
        for (i2 = 0; i2 < this.nbIndividus; ++i2) {
            this.BestRepresentant[this.ClusterResultat[i2]] = i2;
        }
        for (i2 = 0; i2 < this.nbIndividus; ++i2) {
            if (!(this.DistanceResultat[i2] < this.DistanceResultat[this.BestRepresentant[this.ClusterResultat[i2]]])) continue;
            this.BestRepresentant[this.ClusterResultat[i2]] = i2;
        }
    }

    public FichierTabule ComputeAndReturnParangons(FichierTabule fichier) {
        int i2;
        if (fichier == null) {
            throw new Error("Le calcul n'a pas ete effectue e partir d'un fichier tabule, donc impossible d'en renvoyer un en resultat.");
        }
        int[] Types = null;
        FichierTabule Resultat = null;
        boolean[] Excluded = fichier.getExcluded();
        for (i2 = 0; i2 < Excluded.length; ++i2) {
            if (!Excluded[i2]) continue;
            throw new Error("Le fichier contient des instances exclues (invalides), on ne peut effectuer le calcul.");
        }
        Types = fichier.ColumnType();
        Resultat = new FichierTabule(this.nbClusters, Types, "Result_MC");
        this.ComputeParangons();
        for (i2 = 0; i2 < this.nbClusters; ++i2) {
            int best = this.BestRepresentant[i2];
            block8: for (int j = 0; j < fichier.Width(); ++j) {
                switch (Types[j]) {
                    case 0: {
                        Resultat.setValue(i2, j, fichier.getValueInt(best, j));
                        continue block8;
                    }
                    case 1: {
                        Resultat.setValue(i2, j, fichier.getValueDouble(best, j));
                        continue block8;
                    }
                    case 2: {
                        Resultat.setValue(i2, j, fichier.getValueString(best, j));
                        continue block8;
                    }
                    case -1: {
                        continue block8;
                    }
                    default: {
                        throw new Error("Type de colonne invalide : " + Types[j]);
                    }
                }
            }
        }
        return Resultat;
    }

    public double[][] ComputeAndReturnParagons() {
        double[][] Resultat = new double[this.nbClusters][this.nbDimensions];
        this.ComputeParangons();
        for (int i2 = 0; i2 < this.nbClusters; ++i2) {
            int best = this.BestRepresentant[i2];
            for (int j = 0; j < this.Array[i2].length; ++j) {
                Resultat[i2][j] = this.Array[best][j];
            }
        }
        return Resultat;
    }

    @Override
    public int[] getParangons() {
        return this.BestRepresentant;
    }

    @Override
    public int[] getClustersNumbers() {
        return this.ClusterResultat;
    }

    @Override
    public Cluster[] getClusters() {
        return this.Clusters;
    }

    @Override
    public double[] getDistances() {
        return this.DistanceResultat;
    }

    @Override
    public double getEpsilon() {
        return this.Epsilon;
    }

    @Override
    public int getDimensions() {
        return this.nbDimensions;
    }

    @Override
    public int getInstances() {
        return this.nbIndividus;
    }

    @Override
    public double getInertieInterClasses() {
        return this.InertieInterClasse;
    }

    @Override
    public double getInertieIntraClasses() {
        return this.InertieIntraClasse;
    }

    @Override
    public int getIterations() {
        return this.nbIterations;
    }

    public double[][] getArray() {
        return this.Array;
    }

    public String toString() {
        return this.Nom;
    }
}

