/*
 * Decompiled with CFR 0.152.
 */
package dataMining.classifiers.parameters;

import dataMining.classifiers.parameters.ClassifierParameterFunction;
import mathematics.functions.Discrete;
import weka.classifiers.Classifier;
import weka.classifiers.trees.RandomForest;
import weka.core.Instances;

public class RandomForestParameters
implements ClassifierParameterFunction {
    private Discrete funcnbtree = new Discrete(){

        @Override
        public int Compute(int[] parameters) {
            if (parameters[0] == 1) {
                return 1;
            }
            return (int)(5.0 * (double)parameters[0]);
        }

        @Override
        public short Compute(short[] parameters) {
            if (parameters[0] == 1) {
                return 1;
            }
            return (short)(5.0 * (double)parameters[0]);
        }
    };
    private Discrete funcsizetree = new Discrete(){

        @Override
        public int Compute(int[] parameters) {
            return (int)(Math.sqrt(parameters[0]) + 0.5);
        }

        @Override
        public short Compute(short[] parameters) {
            return (short)(Math.sqrt(parameters[0]) + 0.5);
        }
    };
    private int[] attributes = new int[1];

    @Override
    public synchronized void Compute(Classifier classifier, Instances instances) throws Exception {
        String[] options = ((RandomForest)classifier).getOptions();
        this.attributes[0] = instances.numAttributes() - 1;
        options[1] = String.valueOf(this.funcnbtree.Compute(this.attributes));
        options[3] = String.valueOf(this.funcsizetree.Compute(this.attributes));
        ((RandomForest)classifier).setOptions(options);
    }

    @Override
    public boolean isCompatible(Classifier classifier) {
        return classifier instanceof RandomForest;
    }

    @Override
    public void Parameters(Object ... parameters) {
        if (parameters.length != 2) {
            throw new IllegalArgumentException("Exactly 2 parameters required.");
        }
        this.funcnbtree = (Discrete)parameters[0];
        this.funcsizetree = (Discrete)parameters[1];
    }
}

